/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRSKilledWhenInitializing {
    private static final Log LOG = LogFactory.getLog(TestRSKilledWhenInitializing.class);
    @Rule
    public TestName testName = new TestName();
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static AtomicBoolean masterActive = new AtomicBoolean(false);
    private static final AtomicReference<ServerName> killedRS = new AtomicReference();
    private static final int NUM_MASTERS = 1;
    private static final int NUM_RS = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRSTerminationAfterRegisteringToMasterBeforeCreatingEphemeralNode() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniDFSCluster(3);
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.createRootDir();
        LocalHBaseCluster cluster = new LocalHBaseCluster(conf, 1, 2, HMaster.class, RegisterAndDieRegionServer.class);
        JVMClusterUtil.MasterThread master = this.startMaster((JVMClusterUtil.MasterThread)cluster.getMasters().get(0));
        try {
            for (int i = 0; i < 2; ++i) {
                ((JVMClusterUtil.RegionServerThread)cluster.getRegionServers().get(i)).start();
            }
            int expectedTotalRegionServers = 2 + (LoadBalancer.isTablesOnMaster((Configuration)conf) ? 1 : 0);
            List onlineServersList = null;
            while ((onlineServersList = master.getMaster().getServerManager().getOnlineServersList()).size() < expectedTotalRegionServers) {
            }
            while (killedRS.get() == null) {
                Threads.sleep((long)1L);
            }
            while (cluster.getLiveRegionServers().size() >= expectedTotalRegionServers) {
                Threads.sleep((long)1L);
            }
            while (!master.getMaster().isInitialized()) {
                Threads.sleep((long)1L);
            }
            Assert.assertTrue((boolean)master.getMaster().getServerManager().isServerOnline(killedRS.get()));
            Map assignments = null;
            while ((assignments = master.getMaster().getAssignmentManager().getRegionStates().getRegionAssignments()) == null || assignments.size() < 2) {
            }
            RegionInfo hri = null;
            for (Map.Entry e : assignments.entrySet()) {
                if (((RegionInfo)e.getKey()).isMetaRegion()) continue;
                hri = (RegionInfo)e.getKey();
                break;
            }
            Assert.assertEquals((long)expectedTotalRegionServers, (long)master.getMaster().getServerManager().getOnlineServersList().size());
            LOG.info((Object)("Move " + hri.getEncodedName() + " to " + killedRS.get()));
            master.getMaster().move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)killedRS.get().toString()));
            while (onlineServersList.size() > 3) {
                Thread.sleep(100L);
                onlineServersList = master.getMaster().getServerManager().getOnlineServersList();
            }
        }
        finally {
            cluster.shutdown();
            cluster.join();
            TEST_UTIL.shutdownMiniDFSCluster();
            TEST_UTIL.shutdownMiniZKCluster();
            TEST_UTIL.cleanupTestDir();
        }
    }

    private JVMClusterUtil.MasterThread startMaster(JVMClusterUtil.MasterThread master) {
        master.start();
        while (master.getMaster().getServerManager() == null) {
        }
        final AtomicBoolean waiting = new AtomicBoolean(false);
        if (master.getMaster().getServerManager() == null) {
            throw new NullPointerException("SM");
        }
        master.getMaster().getServerManager().registerListener(new ServerListener(){

            public void waiting() {
                waiting.set(true);
            }
        });
        while (!waiting.get()) {
        }
        masterActive.set(true);
        return master;
    }

    static class RegisterAndDieRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public RegisterAndDieRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        @Override
        protected void handleReportForDutyResponse(RegionServerStatusProtos.RegionServerStartupResponse c) throws IOException {
            if (killedRS.compareAndSet(null, this.getServerName())) {
                while (!masterActive.get()) {
                    Threads.sleep((long)100L);
                }
                super.kill();
            } else {
                super.handleReportForDutyResponse(c);
            }
        }
    }
}

