/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerOnlineConfigChange {
    private static final Log LOG = LogFactory.getLog((String)TestRegionServerOnlineConfigChange.class.getName());
    private static HBaseTestingUtility hbaseTestingUtility = new HBaseTestingUtility();
    private static Configuration conf = null;
    private static Table t1 = null;
    private static HRegionServer rs1 = null;
    private static byte[] r1name = null;
    private static Region r1 = null;
    private static final String table1Str = "table1";
    private static final String columnFamily1Str = "columnFamily1";
    private static final TableName TABLE1 = TableName.valueOf((String)"table1");
    private static final byte[] COLUMN_FAMILY1 = Bytes.toBytes((String)"columnFamily1");

    @BeforeClass
    public static void setUp() throws Exception {
        conf = hbaseTestingUtility.getConfiguration();
        hbaseTestingUtility.startMiniCluster(1, 1);
        t1 = hbaseTestingUtility.createTable(TABLE1, COLUMN_FAMILY1);
        try (RegionLocator locator = hbaseTestingUtility.getConnection().getRegionLocator(TABLE1);){
            HRegionInfo firstHRI = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegionInfo();
            r1name = firstHRI.getRegionName();
            rs1 = hbaseTestingUtility.getHBaseCluster().getRegionServer(hbaseTestingUtility.getHBaseCluster().getServerWith(r1name));
            r1 = rs1.getRegion(r1name);
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        hbaseTestingUtility.shutdownMiniCluster();
    }

    @Test
    public void testNumCompactionThreadsOnlineChange() throws IOException {
        Assert.assertTrue((TestRegionServerOnlineConfigChange.rs1.compactSplitThread != null ? 1 : 0) != 0);
        int newNumSmallThreads = TestRegionServerOnlineConfigChange.rs1.compactSplitThread.getSmallCompactionThreadNum() + 1;
        int newNumLargeThreads = TestRegionServerOnlineConfigChange.rs1.compactSplitThread.getLargeCompactionThreadNum() + 1;
        conf.setInt("hbase.regionserver.thread.compaction.small", newNumSmallThreads);
        conf.setInt("hbase.regionserver.thread.compaction.large", newNumLargeThreads);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertEquals((long)newNumSmallThreads, (long)TestRegionServerOnlineConfigChange.rs1.compactSplitThread.getSmallCompactionThreadNum());
        Assert.assertEquals((long)newNumLargeThreads, (long)TestRegionServerOnlineConfigChange.rs1.compactSplitThread.getLargeCompactionThreadNum());
    }

    @Test
    public void testCompactionConfigurationOnlineChange() throws IOException {
        String strPrefix = "hbase.hstore.compaction.";
        Store s = r1.getStore(COLUMN_FAMILY1);
        if (!(s instanceof HStore)) {
            LOG.error((Object)"Can't test the compaction configuration of HStore class. Got a different implementation other than HStore");
            return;
        }
        HStore hstore = (HStore)s;
        double newCompactionRatio = hstore.getStoreEngine().getCompactionPolicy().getConf().getCompactionRatio() + 0.1;
        conf.setFloat(strPrefix + "ratio", (float)newCompactionRatio);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertEquals((double)newCompactionRatio, (double)hstore.getStoreEngine().getCompactionPolicy().getConf().getCompactionRatio(), (double)1.0E-5);
        double newOffPeakCompactionRatio = hstore.getStoreEngine().getCompactionPolicy().getConf().getCompactionRatioOffPeak() + 0.1;
        conf.setFloat(strPrefix + "ratio.offpeak", (float)newOffPeakCompactionRatio);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertEquals((double)newOffPeakCompactionRatio, (double)hstore.getStoreEngine().getCompactionPolicy().getConf().getCompactionRatioOffPeak(), (double)1.0E-5);
        long newThrottlePoint = hstore.getStoreEngine().getCompactionPolicy().getConf().getThrottlePoint() + 10L;
        conf.setLong("hbase.regionserver.thread.compaction.throttle", newThrottlePoint);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertEquals((long)newThrottlePoint, (long)hstore.getStoreEngine().getCompactionPolicy().getConf().getThrottlePoint());
        int newMinFilesToCompact = hstore.getStoreEngine().getCompactionPolicy().getConf().getMinFilesToCompact() + 1;
        conf.setLong(strPrefix + "min", (long)newMinFilesToCompact);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertEquals((long)newMinFilesToCompact, (long)hstore.getStoreEngine().getCompactionPolicy().getConf().getMinFilesToCompact());
        int newMaxFilesToCompact = hstore.getStoreEngine().getCompactionPolicy().getConf().getMaxFilesToCompact() + 1;
        conf.setLong(strPrefix + "max", (long)newMaxFilesToCompact);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertEquals((long)newMaxFilesToCompact, (long)hstore.getStoreEngine().getCompactionPolicy().getConf().getMaxFilesToCompact());
        conf.setLong("hbase.offpeak.start.hour", 6L);
        conf.setLong("hbase.offpeak.end.hour", 7L);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertFalse((boolean)hstore.getOffPeakHours().isOffPeakHour(4));
        long newMinCompactSize = hstore.getStoreEngine().getCompactionPolicy().getConf().getMinCompactSize() + 1L;
        conf.setLong(strPrefix + "min.size", newMinCompactSize);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertEquals((long)newMinCompactSize, (long)hstore.getStoreEngine().getCompactionPolicy().getConf().getMinCompactSize());
        long newMaxCompactSize = hstore.getStoreEngine().getCompactionPolicy().getConf().getMaxCompactSize() - 1L;
        conf.setLong(strPrefix + "max.size", newMaxCompactSize);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertEquals((long)newMaxCompactSize, (long)hstore.getStoreEngine().getCompactionPolicy().getConf().getMaxCompactSize());
        long newOffpeakMaxCompactSize = hstore.getStoreEngine().getCompactionPolicy().getConf().getOffPeakMaxCompactSize() - 1L;
        conf.setLong("hbase.hstore.compaction.max.size.offpeak", newOffpeakMaxCompactSize);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertEquals((long)newOffpeakMaxCompactSize, (long)hstore.getStoreEngine().getCompactionPolicy().getConf().getOffPeakMaxCompactSize());
        long newMajorCompactionPeriod = hstore.getStoreEngine().getCompactionPolicy().getConf().getMajorCompactionPeriod() + 10L;
        conf.setLong("hbase.hregion.majorcompaction", newMajorCompactionPeriod);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertEquals((long)newMajorCompactionPeriod, (long)hstore.getStoreEngine().getCompactionPolicy().getConf().getMajorCompactionPeriod());
        float newMajorCompactionJitter = hstore.getStoreEngine().getCompactionPolicy().getConf().getMajorCompactionJitter() + 0.02f;
        conf.setFloat("hbase.hregion.majorcompaction.jitter", newMajorCompactionJitter);
        rs1.getConfigurationManager().notifyAllObservers(conf);
        Assert.assertEquals((double)newMajorCompactionJitter, (double)hstore.getStoreEngine().getCompactionPolicy().getConf().getMajorCompactionJitter(), (double)1.0E-5);
    }
}

