/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerReadRequestMetrics {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final byte[] CF1 = "c1".getBytes();
    private static final byte[] CF2 = "c2".getBytes();
    private static final byte[] ROW1 = "a".getBytes();
    private static final byte[] ROW2 = "b".getBytes();
    private static final byte[] ROW3 = "c".getBytes();
    private static final byte[] COL1 = "q1".getBytes();
    private static final byte[] COL2 = "q2".getBytes();
    private static final byte[] COL3 = "q3".getBytes();
    private static final byte[] VAL1 = "v1".getBytes();
    private static final byte[] VAL2 = "v2".getBytes();
    private static final byte[] VAL3 = Bytes.toBytes((long)0L);
    private static final int MAX_TRY = 20;
    private static final int SLEEP_MS = 100;
    private static final int TTL = 1;
    private static Admin admin;
    private static Collection<ServerName> serverNames;
    private static Table table;
    private static List<HRegionInfo> tableRegions;
    private static Map<Metric, Long> requestsMap;
    private static Map<Metric, Long> requestsMapPrev;

    @BeforeClass
    public static void setUpOnce() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.balancer.tablesOnMaster", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.balancer.tablesOnMaster.systemTablesOnly", true);
        TEST_UTIL.startMiniCluster();
        admin = TEST_UTIL.getAdmin();
        serverNames = admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS)).getServers();
        table = TestRegionServerReadRequestMetrics.createTable();
        TestRegionServerReadRequestMetrics.putData();
        tableRegions = admin.getTableRegions(TABLE_NAME);
        for (Metric metric : Metric.values()) {
            requestsMap.put(metric, 0L);
            requestsMapPrev.put(metric, 0L);
        }
    }

    private static Table createTable() throws IOException {
        HTableDescriptor td = new HTableDescriptor(TABLE_NAME);
        HColumnDescriptor cd1 = new HColumnDescriptor(CF1);
        td.addFamily(cd1);
        HColumnDescriptor cd2 = new HColumnDescriptor(CF2);
        cd2.setTimeToLive(1);
        td.addFamily(cd2);
        admin.createTable((TableDescriptor)td);
        return TEST_UTIL.getConnection().getTable(TABLE_NAME);
    }

    private static void testReadRequests(long resultCount, long expectedReadRequests, long expectedFilteredReadRequests) throws IOException, InterruptedException {
        TestRegionServerReadRequestMetrics.updateMetricsMap();
        System.out.println("requestsMapPrev = " + requestsMapPrev);
        System.out.println("requestsMap = " + requestsMap);
        Assert.assertEquals((long)expectedReadRequests, (long)(requestsMap.get((Object)Metric.REGION_READ) - requestsMapPrev.get((Object)Metric.REGION_READ)));
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)TEST_UTIL.getConfiguration());
        if (tablesOnMaster) {
            Assert.assertEquals((long)expectedReadRequests, (long)(requestsMap.get((Object)Metric.SERVER_READ) - requestsMapPrev.get((Object)Metric.SERVER_READ)));
        }
        Assert.assertEquals((long)expectedFilteredReadRequests, (long)(requestsMap.get((Object)Metric.FILTERED_REGION_READ) - requestsMapPrev.get((Object)Metric.FILTERED_REGION_READ)));
        Assert.assertEquals((long)expectedFilteredReadRequests, (long)(requestsMap.get((Object)Metric.FILTERED_SERVER_READ) - requestsMapPrev.get((Object)Metric.FILTERED_SERVER_READ)));
        Assert.assertEquals((long)expectedReadRequests, (long)resultCount);
    }

    private static void updateMetricsMap() throws IOException, InterruptedException {
        for (Metric metric : Metric.values()) {
            requestsMapPrev.put(metric, requestsMap.get((Object)metric));
        }
        ServerLoad serverLoad = null;
        RegionLoad regionLoadOuter = null;
        boolean metricsUpdated = false;
        for (int i = 0; i < 20; ++i) {
            for (ServerName serverName : serverNames) {
                serverLoad = admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS)).getLoad(serverName);
                Map regionsLoad = serverLoad.getRegionsLoad();
                block3: for (HRegionInfo tableRegion : tableRegions) {
                    RegionLoad regionLoad = (RegionLoad)regionsLoad.get(tableRegion.getRegionName());
                    if (regionLoad == null) continue;
                    regionLoadOuter = regionLoad;
                    for (Metric metric : Metric.values()) {
                        if (TestRegionServerReadRequestMetrics.getReadRequest(serverLoad, regionLoad, metric) <= requestsMapPrev.get((Object)metric)) continue;
                        for (Metric metricInner : Metric.values()) {
                            requestsMap.put(metricInner, TestRegionServerReadRequestMetrics.getReadRequest(serverLoad, regionLoad, metricInner));
                        }
                        metricsUpdated = true;
                        continue block3;
                    }
                }
            }
            if (metricsUpdated) break;
            Thread.sleep(100L);
        }
        if (!metricsUpdated) {
            for (Metric metric : Metric.values()) {
                requestsMap.put(metric, TestRegionServerReadRequestMetrics.getReadRequest(serverLoad, regionLoadOuter, metric));
            }
        }
    }

    private static long getReadRequest(ServerLoad serverLoad, RegionLoad regionLoad, Metric metric) {
        switch (metric) {
            case REGION_READ: {
                return regionLoad.getReadRequestsCount();
            }
            case SERVER_READ: {
                return serverLoad.getReadRequestsCount();
            }
            case FILTERED_REGION_READ: {
                return regionLoad.getFilteredReadRequestsCount();
            }
            case FILTERED_SERVER_READ: {
                return serverLoad.getFilteredReadRequestsCount();
            }
        }
        throw new IllegalStateException();
    }

    private static void putData() throws IOException {
        Put put = new Put(ROW1);
        put.addColumn(CF1, COL1, VAL1);
        put.addColumn(CF1, COL2, VAL2);
        put.addColumn(CF1, COL3, VAL3);
        table.put(put);
        put = new Put(ROW2);
        put.addColumn(CF1, COL1, VAL2);
        put.addColumn(CF1, COL2, VAL2);
        table.put(put);
        put = new Put(ROW3);
        put.addColumn(CF1, COL1, VAL1);
        put.addColumn(CF1, COL2, VAL2);
        table.put(put);
    }

    private static void putTTLExpiredData() throws IOException, InterruptedException {
        Put put = new Put(ROW1);
        put.addColumn(CF2, COL1, VAL1);
        put.addColumn(CF2, COL2, VAL2);
        table.put(put);
        Thread.sleep(1000L);
        put = new Put(ROW2);
        put.addColumn(CF2, COL1, VAL1);
        put.addColumn(CF2, COL2, VAL2);
        table.put(put);
        put = new Put(ROW3);
        put.addColumn(CF2, COL1, VAL1);
        put.addColumn(CF2, COL2, VAL2);
        table.put(put);
    }

    @AfterClass
    public static void tearDownOnce() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testReadRequestsCountNotFiltered() throws Exception {
        int resultCount;
        Scan scan = new Scan();
        try (ResultScanner scanner = table.getScanner(scan);){
            resultCount = 0;
            for (Result ignore : scanner) {
                ++resultCount;
            }
            TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 3L, 0L);
        }
        scan = new Scan(ROW2, ROW3);
        scanner = table.getScanner(scan);
        var8_3 = null;
        try {
            resultCount = 0;
            for (Result ignore : scanner) {
                ++resultCount;
            }
            TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 1L, 0L);
        }
        catch (Throwable throwable) {
            var8_3 = throwable;
            throw throwable;
        }
        finally {
            if (scanner != null) {
                if (var8_3 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        var8_3.addSuppressed(throwable);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        Get get = new Get(ROW2);
        Result result = table.get(get);
        resultCount = result.isEmpty() ? 0 : 1;
        TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 1L, 0L);
        Increment increment = new Increment(ROW1);
        increment.addColumn(CF1, COL3, 1L);
        result = table.increment(increment);
        resultCount = result.isEmpty() ? 0 : 1;
        TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 1L, 0L);
        Put put = new Put(ROW1);
        put.addColumn(CF1, COL2, VAL2);
        boolean checkAndPut = table.checkAndPut(ROW1, CF1, COL2, CompareFilter.CompareOp.EQUAL, VAL2, put);
        resultCount = checkAndPut ? 1 : 0;
        TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 1L, 0L);
        Append append = new Append(ROW1);
        append.addColumn(CF1, COL2, VAL2);
        result = table.append(append);
        resultCount = result.isEmpty() ? 0 : 1;
        TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 1L, 0L);
        put = new Put(ROW1);
        put.addColumn(CF1, COL1, VAL1);
        RowMutations rm = new RowMutations(ROW1);
        rm.add(put);
        boolean checkAndMutate = table.checkAndMutate(ROW1, CF1, COL1, CompareFilter.CompareOp.EQUAL, VAL1, rm);
        resultCount = checkAndMutate ? 1 : 0;
        TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 1L, 0L);
    }

    @Test
    public void testReadRequestsCountWithFilter() throws Exception {
        int resultCount;
        Scan scan = new Scan();
        scan.setFilter((Filter)new SingleColumnValueFilter(CF1, COL1, CompareFilter.CompareOp.EQUAL, VAL1));
        try (ResultScanner scanner = table.getScanner(scan);){
            resultCount = 0;
            for (Result ignore : scanner) {
                ++resultCount;
            }
            TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 2L, 1L);
        }
        scan = new Scan();
        scan.setFilter((Filter)new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(ROW1)));
        scanner = table.getScanner(scan);
        var4_3 = null;
        try {
            resultCount = 0;
            for (Result ignore : scanner) {
                ++resultCount;
            }
            TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 1L, 2L);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (scanner != null) {
                if (var4_3 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        scan = new Scan(ROW2, ROW3);
        scan.setFilter((Filter)new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(ROW1)));
        scanner = table.getScanner(scan);
        var4_3 = null;
        try {
            resultCount = 0;
            for (Result ignore : scanner) {
                ++resultCount;
            }
            TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 0L, 1L);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (scanner != null) {
                if (var4_3 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    scanner.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadRequestsCountWithDeletedRow() throws Exception {
        try {
            Delete delete = new Delete(ROW3);
            table.delete(delete);
            Scan scan = new Scan();
            try (ResultScanner scanner = table.getScanner(scan);){
                int resultCount = 0;
                for (Result ignore : scanner) {
                    ++resultCount;
                }
                TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 2L, 1L);
            }
        }
        finally {
            Put put = new Put(ROW3);
            put.addColumn(CF1, COL1, VAL1);
            put.addColumn(CF1, COL2, VAL2);
            table.put(put);
        }
    }

    @Test
    public void testReadRequestsCountWithTTLExpiration() throws Exception {
        TestRegionServerReadRequestMetrics.putTTLExpiredData();
        Scan scan = new Scan();
        scan.addFamily(CF2);
        try (ResultScanner scanner = table.getScanner(scan);){
            int resultCount = 0;
            for (Result ignore : scanner) {
                ++resultCount;
            }
            TestRegionServerReadRequestMetrics.testReadRequests(resultCount, 2L, 1L);
        }
    }

    static {
        requestsMap = new HashMap<Metric, Long>();
        requestsMapPrev = new HashMap<Metric, Long>();
    }

    private static enum Metric {
        REGION_READ,
        SERVER_READ,
        FILTERED_REGION_READ,
        FILTERED_SERVER_READ;

    }
}

