/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;

public class FaultyProtobufLogReader
extends ProtobufLogReader {
    Queue<WAL.Entry> nextQueue = new LinkedList<WAL.Entry>();
    int numberOfFileEntries = 0;

    FailureType getFailureType() {
        return FailureType.valueOf(this.conf.get("faultyprotobuflogreader.failuretype", "NONE"));
    }

    public WAL.Entry next(WAL.Entry reuse) throws IOException {
        WAL.Entry e;
        if (this.nextQueue.isEmpty()) {
            boolean b;
            do {
                WAL.Entry e2 = new WAL.Entry(new WALKey(), new WALEdit());
                if (this.compressionContext != null) {
                    e2.setCompressionContext(this.compressionContext);
                }
                b = this.readNext(e2);
                this.nextQueue.offer(e2);
                ++this.numberOfFileEntries;
            } while (b);
        }
        if (this.nextQueue.size() == this.numberOfFileEntries && this.getFailureType() == FailureType.BEGINNING) {
            throw new IOException("fake Exception");
        }
        if (this.nextQueue.size() == this.numberOfFileEntries / 2 && this.getFailureType() == FailureType.MIDDLE) {
            throw new IOException("fake Exception");
        }
        if (this.nextQueue.size() == 1 && this.getFailureType() == FailureType.END) {
            throw new IOException("fake Exception");
        }
        if (this.nextQueue.peek() != null) {
            ++this.edit;
        }
        if ((e = this.nextQueue.poll()).getEdit().isEmpty()) {
            return null;
        }
        return e;
    }

    public static enum FailureType {
        BEGINNING,
        MIDDLE,
        END,
        NONE;

    }
}

