/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestWALCellCodecWithCompression {
    @Test
    public void testEncodeDecodeKVsWithTags() throws Exception {
        this.doTest(false, false);
    }

    @Test
    public void testEncodeDecodeKVsWithTagsWithTagsCompression() throws Exception {
        this.doTest(true, false);
    }

    @Test
    public void testEncodeDecodeOffKVsWithTagsWithTagsCompression() throws Exception {
        this.doTest(true, true);
    }

    private void doTest(boolean compressTags, boolean offheapKV) throws Exception {
        Configuration conf = new Configuration(false);
        conf.setBoolean("hbase.regionserver.wal.tags.enablecompression", compressTags);
        WALCellCodec codec = new WALCellCodec(conf, new CompressionContext(LRUDictionary.class, false, compressTags));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        Codec.Encoder encoder = codec.getEncoder((OutputStream)bos);
        if (offheapKV) {
            encoder.write((Cell)this.createOffheapKV(1));
            encoder.write((Cell)this.createOffheapKV(0));
            encoder.write((Cell)this.createOffheapKV(2));
        } else {
            encoder.write((Cell)this.createKV(1));
            encoder.write((Cell)this.createKV(0));
            encoder.write((Cell)this.createKV(2));
        }
        ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
        Codec.Decoder decoder = codec.getDecoder((InputStream)is);
        decoder.advance();
        KeyValue kv = (KeyValue)decoder.current();
        List tags = kv.getTags();
        Assert.assertEquals((long)1L, (long)tags.size());
        Assert.assertEquals((Object)"tagValue1", (Object)Bytes.toString((byte[])TagUtil.cloneValue((Tag)((Tag)tags.get(0)))));
        decoder.advance();
        kv = (KeyValue)decoder.current();
        tags = kv.getTags();
        Assert.assertEquals((long)0L, (long)tags.size());
        decoder.advance();
        kv = (KeyValue)decoder.current();
        tags = kv.getTags();
        Assert.assertEquals((long)2L, (long)tags.size());
        Assert.assertEquals((Object)"tagValue1", (Object)Bytes.toString((byte[])TagUtil.cloneValue((Tag)((Tag)tags.get(0)))));
        Assert.assertEquals((Object)"tagValue2", (Object)Bytes.toString((byte[])TagUtil.cloneValue((Tag)((Tag)tags.get(1)))));
    }

    private KeyValue createKV(int noOfTags) {
        byte[] row = Bytes.toBytes((String)"myRow");
        byte[] cf = Bytes.toBytes((String)"myCF");
        byte[] q = Bytes.toBytes((String)"myQualifier");
        byte[] value = Bytes.toBytes((String)"myValue");
        ArrayList<ArrayBackedTag> tags = new ArrayList<ArrayBackedTag>(noOfTags);
        for (int i = 1; i <= noOfTags; ++i) {
            tags.add(new ArrayBackedTag((byte)i, Bytes.toBytes((String)("tagValue" + i))));
        }
        return new KeyValue(row, cf, q, Long.MAX_VALUE, value, tags);
    }

    private ByteBufferKeyValue createOffheapKV(int noOfTags) {
        byte[] row = Bytes.toBytes((String)"myRow");
        byte[] cf = Bytes.toBytes((String)"myCF");
        byte[] q = Bytes.toBytes((String)"myQualifier");
        byte[] value = Bytes.toBytes((String)"myValue");
        ArrayList<ArrayBackedTag> tags = new ArrayList<ArrayBackedTag>(noOfTags);
        for (int i = 1; i <= noOfTags; ++i) {
            tags.add(new ArrayBackedTag((byte)i, Bytes.toBytes((String)("tagValue" + i))));
        }
        KeyValue kv = new KeyValue(row, cf, q, Long.MAX_VALUE, value, tags);
        ByteBuffer dbb = ByteBuffer.allocateDirect(kv.getBuffer().length);
        dbb.put(kv.getBuffer());
        return new ByteBufferKeyValue(dbb, 0, kv.getBuffer().length);
    }
}

