/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestSerialReplication {
    private static final Log LOG = LogFactory.getLog(TestSerialReplication.class);
    private static Configuration conf1;
    private static Configuration conf2;
    private static HBaseTestingUtility utility1;
    private static HBaseTestingUtility utility2;
    private static final byte[] famName;
    private static final byte[] VALUE;
    private static final byte[] ROW;
    private static final byte[][] ROWS;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1 = HBaseConfiguration.create();
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("hbase.regionserver.hlog.blocksize", 20480);
        conf1.setInt("replication.source.size.capacity", 1024);
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("hbase.regionserver.maxlogs", 10);
        conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        conf1.setBoolean("dfs.support.append", true);
        conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{"org.apache.hadoop.hbase.replication.TestMasterReplication$CoprocessorCounter"});
        conf1.setLong("replication.source.per.peer.node.bandwidth", 100L);
        conf1.setLong("replication.source.size.capacity", 1L);
        conf1.setLong("hbase.serial.replication.waitingMs", 1000L);
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        new ZooKeeperWatcher(conf1, "cluster1", null, true);
        conf2 = new Configuration(conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        utility2 = new HBaseTestingUtility(conf2);
        utility2.setZkCluster(miniZK);
        new ZooKeeperWatcher(conf2, "cluster2", null, true);
        utility1.startMiniCluster(1, 10);
        utility2.startMiniCluster(1, 1);
        ReplicationAdmin admin1 = new ReplicationAdmin(conf1);
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(utility2.getClusterKey());
        admin1.addPeer("1", rpc, null);
        utility1.getAdmin().setBalancerRunning(false, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testRegionMoveAndFailover() throws Exception {
        tableName = TableName.valueOf((String)this.name.getMethodName());
        table = new HTableDescriptor(tableName);
        fam = new HColumnDescriptor(TestSerialReplication.famName);
        fam.setScope(2);
        table.addFamily(fam);
        TestSerialReplication.utility1.getAdmin().createTable((TableDescriptor)table);
        TestSerialReplication.utility2.getAdmin().createTable((TableDescriptor)table);
        t1 = TestSerialReplication.utility1.getConnection().getTable(tableName);
        var5_5 = null;
        try {
            t2 = TestSerialReplication.utility2.getConnection().getTable(tableName);
            var7_8 = null;
            TestSerialReplication.LOG.info((Object)"move to 1");
            this.moveRegion(t1, 1);
            TestSerialReplication.LOG.info((Object)"move to 0");
            this.moveRegion(t1, 0);
            for (i = 10; i < 20; ++i) {
                put = new Put(TestSerialReplication.ROWS[i]);
                put.addColumn(TestSerialReplication.famName, TestSerialReplication.VALUE, TestSerialReplication.VALUE);
                t1.put(put);
            }
            TestSerialReplication.LOG.info((Object)"move to 2");
            this.moveRegion(t1, 2);
            for (i = 20; i < 30; ++i) {
                put = new Put(TestSerialReplication.ROWS[i]);
                put.addColumn(TestSerialReplication.famName, TestSerialReplication.VALUE, TestSerialReplication.VALUE);
                t1.put(put);
            }
            TestSerialReplication.utility1.getHBaseCluster().abortRegionServer(2);
            for (i = 30; i < 40; ++i) {
                put = new Put(TestSerialReplication.ROWS[i]);
                put.addColumn(TestSerialReplication.famName, TestSerialReplication.VALUE, TestSerialReplication.VALUE);
                t1.put(put);
            }
            start = EnvironmentEdgeManager.currentTime();
            while (EnvironmentEdgeManager.currentTime() - start < 180000L) {
                scan = new Scan();
                scan.setCaching(100);
                list = new ArrayList<Cell>();
                results = t2.getScanner(scan);
                var13_16 = null;
                try {
                    for (Result result : results) {
                        Assert.assertEquals((long)1L, (long)result.rawCells().length);
                        list.add(result.rawCells()[0]);
                    }
                }
                catch (Throwable var14_21) {
                    var13_16 = var14_21;
                    throw var14_21;
                }
                finally {
                    if (results != null) {
                        if (var13_16 != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable var14_20) {
                                var13_16.addSuppressed(var14_20);
                            }
                        } else {
                            results.close();
                        }
                    }
                }
                listOfNumbers = this.getRowNumbers(list);
                TestSerialReplication.LOG.info((Object)Arrays.toString(listOfNumbers.toArray()));
                this.assertIntegerList(listOfNumbers, 10, 1);
                if (listOfNumbers.size() != 30) {
                    TestSerialReplication.LOG.info((Object)("Waiting all logs pushed to slave. Expected 30 , actual " + list.size()));
                    Thread.sleep(200L);
                    continue;
                }
                if (t2 == null) return;
                if (var7_8 == null) ** GOTO lbl103
                ** GOTO lbl97
            }
            ** GOTO lbl105
            {
                catch (Throwable var8_11) {
                    var7_8 = var8_11;
                    throw var8_11;
                }
                catch (Throwable var18_25) {
                    if (t2 == null) throw var18_25;
                    if (var7_8 == null) {
                        t2.close();
                        throw var18_25;
                    }
                    try {
                        t2.close();
                        throw var18_25;
                    }
                    catch (Throwable var19_26) {
                        var7_8.addSuppressed(var19_26);
                        throw var18_25;
                    }
                }
lbl97:
                // 1 sources

                try {
                    t2.close();
                    return;
                }
                catch (Throwable var13_17) {
                    var7_8.addSuppressed(var13_17);
                    return;
                }
lbl103:
                // 1 sources

                t2.close();
                return;
lbl105:
                // 1 sources

                ** try [egrp 9[TRYBLOCK] [13 : 712->775)] { 
lbl-1000:
                // 1 sources

                {
                    throw new Exception("Not all logs have been pushed");
                }
            }
        }
lbl107:
        // 2 sources

        catch (Throwable var6_7) {
            var5_5 = var6_7;
            throw var6_7;
        }
        finally {
            if (t1 != null) {
                if (var5_5 != null) {
                    try {
                        t1.close();
                    }
                    catch (Throwable var13_18) {
                        var5_5.addSuppressed(var13_18);
                    }
                } else {
                    t1.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void testRegionSplit() throws Exception {
        tableName = TableName.valueOf((String)this.name.getMethodName());
        table = new HTableDescriptor(tableName);
        fam = new HColumnDescriptor(TestSerialReplication.famName);
        fam.setScope(2);
        table.addFamily(fam);
        TestSerialReplication.utility1.getAdmin().createTable((TableDescriptor)table);
        TestSerialReplication.utility2.getAdmin().createTable((TableDescriptor)table);
        t1 = TestSerialReplication.utility1.getConnection().getTable(tableName);
        var5_5 = null;
        try {
            t2 = TestSerialReplication.utility2.getConnection().getTable(tableName);
            var7_8 = null;
            for (i = 10; i < 100; i += 10) {
                put = new Put(TestSerialReplication.ROWS[i]);
                put.addColumn(TestSerialReplication.famName, TestSerialReplication.VALUE, TestSerialReplication.VALUE);
                t1.put(put);
            }
            TestSerialReplication.utility1.getAdmin().split(tableName, TestSerialReplication.ROWS[50]);
            this.waitTableHasRightNumberOfRegions(tableName, 2);
            for (i = 11; i < 100; i += 10) {
                put = new Put(TestSerialReplication.ROWS[i]);
                put.addColumn(TestSerialReplication.famName, TestSerialReplication.VALUE, TestSerialReplication.VALUE);
                t1.put(put);
            }
            start = EnvironmentEdgeManager.currentTime();
lbl31:
            // 2 sources

            while (true) {
                if (EnvironmentEdgeManager.currentTime() - start >= 180000L) throw new Exception("Not all logs have been pushed");
                scan = new Scan();
                scan.setCaching(100);
                list = new ArrayList<Cell>();
                results = t2.getScanner(scan);
                var13_16 = null;
                try {
                    for (Result result : results) {
                        Assert.assertEquals((long)1L, (long)result.rawCells().length);
                        list.add(result.rawCells()[0]);
                    }
                }
                catch (Throwable var14_19) {
                    var13_16 = var14_19;
                    throw var14_19;
                }
                finally {
                    if (results != null) {
                        if (var13_16 != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable var14_18) {
                                var13_16.addSuppressed(var14_18);
                            }
                        } else {
                            results.close();
                        }
                    }
                }
                listOfNumbers = this.getRowNumbers(list);
                list1 = new ArrayList<Integer>();
                list21 = new ArrayList<Integer>();
                list22 = new ArrayList<Integer>();
                for (int num : listOfNumbers) {
                    if (num % 10 == 0) {
                        list1.add(num);
                        continue;
                    }
                    if (num < 50) {
                        list21.add(num);
                        continue;
                    }
                    list22.add(num);
                }
                TestSerialReplication.LOG.info((Object)Arrays.toString(list1.toArray()));
                TestSerialReplication.LOG.info((Object)Arrays.toString(list21.toArray()));
                TestSerialReplication.LOG.info((Object)Arrays.toString(list22.toArray()));
                this.assertIntegerList(list1, 10, 10);
                this.assertIntegerList(list21, 11, 10);
                this.assertIntegerList(list22, 51, 10);
                if (!list21.isEmpty() || !list22.isEmpty()) {
                    Assert.assertEquals((long)9L, (long)list1.size());
                }
                if (list.size() != 18) ** GOTO lbl112
                if (t2 == null) return;
                if (var7_8 != null) {
                }
                ** GOTO lbl110
                break;
            }
            {
                catch (Throwable var8_11) {
                    var7_8 = var8_11;
                    throw var8_11;
                }
                catch (Throwable var18_27) {
                    if (t2 == null) throw var18_27;
                    if (var7_8 == null) {
                        t2.close();
                        throw var18_27;
                    }
                    try {
                        t2.close();
                        throw var18_27;
                    }
                    catch (Throwable var19_28) {
                        var7_8.addSuppressed(var19_28);
                        throw var18_27;
                    }
                }
                try {
                    t2.close();
                    return;
                }
                catch (Throwable var16_23) {
                    var7_8.addSuppressed(var16_23);
                    return;
                }
lbl110:
                // 1 sources

                t2.close();
                return;
lbl112:
                // 1 sources

                ** try [egrp 9[TRYBLOCK] [13 : 791->896)] { 
lbl-1000:
                // 1 sources

                {
                    TestSerialReplication.LOG.info((Object)("Waiting all logs pushed to slave. Expected 27 , actual " + list.size()));
                    Thread.sleep(200L);
                    ** continue;
                }
            }
        }
lbl116:
        // 2 sources

        catch (Throwable var6_7) {
            var5_5 = var6_7;
            throw var6_7;
        }
        finally {
            if (t1 != null) {
                if (var5_5 != null) {
                    try {
                        t1.close();
                    }
                    catch (Throwable var16_24) {
                        var5_5.addSuppressed(var16_24);
                    }
                } else {
                    t1.close();
                }
            }
        }
    }

    @Test
    public void testRegionMerge() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor table = new HTableDescriptor(tableName);
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(2);
        table.addFamily(fam);
        utility1.getAdmin().createTable((TableDescriptor)table);
        utility2.getAdmin().createTable((TableDescriptor)table);
        Threads.sleep((long)5000L);
        utility1.getAdmin().split(tableName, ROWS[50]);
        this.waitTableHasRightNumberOfRegions(tableName, 2);
        try (Table t1 = utility1.getConnection().getTable(tableName);
             Table t2 = utility2.getConnection().getTable(tableName);){
            for (int i = 10; i < 100; i += 10) {
                Put put = new Put(ROWS[i]);
                put.addColumn(famName, VALUE, VALUE);
                t1.put(put);
            }
            List regions = MetaTableAccessor.getTableRegionsAndLocations((Connection)utility1.getConnection(), (TableName)tableName);
            utility1.getAdmin().mergeRegionsAsync(((RegionInfo)((Pair)regions.get(0)).getFirst()).getRegionName(), ((RegionInfo)((Pair)regions.get(1)).getFirst()).getRegionName(), true);
            this.waitTableHasRightNumberOfRegions(tableName, 1);
            for (int i = 11; i < 100; i += 10) {
                Put put = new Put(ROWS[i]);
                put.addColumn(famName, VALUE, VALUE);
                t1.put(put);
            }
            long start = EnvironmentEdgeManager.currentTime();
            while (true) {
                if (EnvironmentEdgeManager.currentTime() - start >= 180000L) break;
                Scan scan = new Scan();
                scan.setCaching(100);
                ArrayList<Cell> list = new ArrayList<Cell>();
                try (ResultScanner results = t2.getScanner(scan);){
                    for (Result result : results) {
                        Assert.assertEquals((long)1L, (long)result.rawCells().length);
                        list.add(result.rawCells()[0]);
                    }
                }
                List<Integer> listOfNumbers = this.getRowNumbers(list);
                ArrayList<Integer> list0 = new ArrayList<Integer>();
                ArrayList<Integer> list1 = new ArrayList<Integer>();
                for (int num : listOfNumbers) {
                    if (num % 10 == 0) {
                        list0.add(num);
                        continue;
                    }
                    list1.add(num);
                }
                LOG.info((Object)Arrays.toString(list0.toArray()));
                LOG.info((Object)Arrays.toString(list1.toArray()));
                this.assertIntegerList(list1, 11, 10);
                if (!list1.isEmpty()) {
                    Assert.assertEquals((long)9L, (long)list0.size());
                }
                if (list.size() == 18) {
                    return;
                }
                LOG.info((Object)("Waiting all logs pushed to slave. Expected 18 , actual " + list.size()));
                Thread.sleep(200L);
            }
        }
    }

    private List<Integer> getRowNumbers(List<Cell> cells) {
        ArrayList<Integer> listOfRowNumbers = new ArrayList<Integer>(cells.size());
        for (Cell c : cells) {
            listOfRowNumbers.add(Integer.parseInt(Bytes.toString((byte[])c.getRowArray(), (int)(c.getRowOffset() + ROW.length), (int)(c.getRowLength() - ROW.length))));
        }
        return listOfRowNumbers;
    }

    @AfterClass
    public static void setUpAfterClass() throws Exception {
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    private void moveRegion(Table table, int index) throws IOException {
        List regions = MetaTableAccessor.getTableRegionsAndLocations((Connection)utility1.getConnection(), (TableName)table.getName());
        Assert.assertEquals((long)1L, (long)regions.size());
        RegionInfo regionInfo = (RegionInfo)((Pair)regions.get(0)).getFirst();
        ServerName name = utility1.getHBaseCluster().getRegionServer(index).getServerName();
        utility1.getAdmin().move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)name.getServerName()));
        while (!((ServerName)((Pair)(regions = MetaTableAccessor.getTableRegionsAndLocations((Connection)utility1.getConnection(), (TableName)table.getName())).get(0)).getSecond()).equals((Object)name)) {
            Threads.sleep((long)100L);
        }
    }

    private void balanceTwoRegions(Table table) throws Exception {
        List regions = MetaTableAccessor.getTableRegionsAndLocations((Connection)utility1.getConnection(), (TableName)table.getName());
        Assert.assertEquals((long)2L, (long)regions.size());
        RegionInfo regionInfo1 = (RegionInfo)((Pair)regions.get(0)).getFirst();
        ServerName name1 = utility1.getHBaseCluster().getRegionServer(0).getServerName();
        RegionInfo regionInfo2 = (RegionInfo)((Pair)regions.get(1)).getFirst();
        ServerName name2 = utility1.getHBaseCluster().getRegionServer(1).getServerName();
        utility1.getAdmin().move(regionInfo1.getEncodedNameAsBytes(), Bytes.toBytes((String)name1.getServerName()));
        utility1.getAdmin().move(regionInfo2.getEncodedNameAsBytes(), Bytes.toBytes((String)name2.getServerName()));
        while (!((ServerName)((Pair)(regions = MetaTableAccessor.getTableRegionsAndLocations((Connection)utility1.getConnection(), (TableName)table.getName())).get(0)).getSecond()).equals((Object)name1) || !((ServerName)((Pair)regions.get(1)).getSecond()).equals((Object)name2)) {
            Threads.sleep((long)100L);
        }
    }

    private void waitTableHasRightNumberOfRegions(TableName tableName, int num) throws IOException {
        List regions;
        while ((regions = MetaTableAccessor.getTableRegionsAndLocations((Connection)utility1.getConnection(), (TableName)tableName)).size() != num) {
            Threads.sleep((long)100L);
        }
        return;
    }

    private void assertIntegerList(List<Integer> list, int start, int step) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)(start + step * i), (long)list.get(i).intValue());
        }
    }

    static {
        famName = Bytes.toBytes((String)"f");
        VALUE = Bytes.toBytes((String)"v");
        ROW = Bytes.toBytes((String)"r");
        ROWS = HTestConst.makeNAscii(ROW, 100);
    }
}

