/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.replication.ReplicationSerDeHelper;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.master.TableCFsUpdater;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestTableCFsUpdater
extends TableCFsUpdater {
    private static final Log LOG = LogFactory.getLog(TestTableCFsUpdater.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static ZooKeeperWatcher zkw = null;
    private static Abortable abortable = null;
    @Rule
    public TestName name = new TestName();

    public TestTableCFsUpdater() {
        super(zkw, TEST_UTIL.getConfiguration(), abortable);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        abortable = new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
            }

            public boolean isAborted() {
                return false;
            }
        };
        zkw = new ZooKeeperWatcher(conf, "TableCFs", abortable, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testUpgrade() throws KeeperException, InterruptedException, DeserializationException {
        String peerId = "1";
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        TableName tableName3 = TableName.valueOf((String)(this.name.getMethodName() + "3"));
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(zkw.getQuorum());
        String peerNode = this.getPeerNode(peerId);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)peerNode, (byte[])ReplicationSerDeHelper.toByteArray((ReplicationPeerConfig)rpc));
        String tableCFs = tableName1 + ":cf1,cf2;" + tableName2 + ":cf3;" + tableName3;
        String tableCFsNode = this.getTableCFsNode(peerId);
        LOG.info((Object)("create tableCFs :" + tableCFsNode + " for peerId=" + peerId));
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)tableCFsNode, (byte[])Bytes.toBytes((String)tableCFs));
        ReplicationPeerConfig actualRpc = ReplicationSerDeHelper.parsePeerFrom((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)peerNode));
        String actualTableCfs = Bytes.toString((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)tableCFsNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        Assert.assertNull((Object)actualRpc.getTableCFsMap());
        Assert.assertEquals((Object)tableCFs, (Object)actualTableCfs);
        peerId = "2";
        rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(zkw.getQuorum());
        peerNode = this.getPeerNode(peerId);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)peerNode, (byte[])ReplicationSerDeHelper.toByteArray((ReplicationPeerConfig)rpc));
        tableCFs = tableName1 + ":cf1,cf3;" + tableName2 + ":cf2";
        tableCFsNode = this.getTableCFsNode(peerId);
        LOG.info((Object)("create tableCFs :" + tableCFsNode + " for peerId=" + peerId));
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)tableCFsNode, (byte[])Bytes.toBytes((String)tableCFs));
        actualRpc = ReplicationSerDeHelper.parsePeerFrom((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)peerNode));
        actualTableCfs = Bytes.toString((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)tableCFsNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        Assert.assertNull((Object)actualRpc.getTableCFsMap());
        Assert.assertEquals((Object)tableCFs, (Object)actualTableCfs);
        peerId = "3";
        rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(zkw.getQuorum());
        peerNode = this.getPeerNode(peerId);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)peerNode, (byte[])ReplicationSerDeHelper.toByteArray((ReplicationPeerConfig)rpc));
        tableCFs = "";
        tableCFsNode = this.getTableCFsNode(peerId);
        LOG.info((Object)("create tableCFs :" + tableCFsNode + " for peerId=" + peerId));
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)tableCFsNode, (byte[])Bytes.toBytes((String)tableCFs));
        actualRpc = ReplicationSerDeHelper.parsePeerFrom((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)peerNode));
        actualTableCfs = Bytes.toString((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)tableCFsNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        Assert.assertNull((Object)actualRpc.getTableCFsMap());
        Assert.assertEquals((Object)tableCFs, (Object)actualTableCfs);
        peerId = "4";
        rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(zkw.getQuorum());
        peerNode = this.getPeerNode(peerId);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)peerNode, (byte[])ReplicationSerDeHelper.toByteArray((ReplicationPeerConfig)rpc));
        tableCFsNode = this.getTableCFsNode(peerId);
        actualRpc = ReplicationSerDeHelper.parsePeerFrom((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)peerNode));
        actualTableCfs = Bytes.toString((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)tableCFsNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        Assert.assertNull((Object)actualRpc.getTableCFsMap());
        Assert.assertNull((Object)actualTableCfs);
        this.update();
        peerId = "1";
        peerNode = this.getPeerNode(peerId);
        actualRpc = ReplicationSerDeHelper.parsePeerFrom((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)peerNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        Map tableNameListMap = actualRpc.getTableCFsMap();
        Assert.assertEquals((long)3L, (long)tableNameListMap.size());
        Assert.assertTrue((boolean)tableNameListMap.containsKey(tableName1));
        Assert.assertTrue((boolean)tableNameListMap.containsKey(tableName2));
        Assert.assertTrue((boolean)tableNameListMap.containsKey(tableName3));
        Assert.assertEquals((long)2L, (long)((List)tableNameListMap.get(tableName1)).size());
        Assert.assertEquals((Object)"cf1", ((List)tableNameListMap.get(tableName1)).get(0));
        Assert.assertEquals((Object)"cf2", ((List)tableNameListMap.get(tableName1)).get(1));
        Assert.assertEquals((long)1L, (long)((List)tableNameListMap.get(tableName2)).size());
        Assert.assertEquals((Object)"cf3", ((List)tableNameListMap.get(tableName2)).get(0));
        Assert.assertNull(tableNameListMap.get(tableName3));
        peerId = "2";
        peerNode = this.getPeerNode(peerId);
        actualRpc = ReplicationSerDeHelper.parsePeerFrom((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)peerNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        tableNameListMap = actualRpc.getTableCFsMap();
        Assert.assertEquals((long)2L, (long)tableNameListMap.size());
        Assert.assertTrue((boolean)tableNameListMap.containsKey(tableName1));
        Assert.assertTrue((boolean)tableNameListMap.containsKey(tableName2));
        Assert.assertEquals((long)2L, (long)((List)tableNameListMap.get(tableName1)).size());
        Assert.assertEquals((Object)"cf1", ((List)tableNameListMap.get(tableName1)).get(0));
        Assert.assertEquals((Object)"cf3", ((List)tableNameListMap.get(tableName1)).get(1));
        Assert.assertEquals((long)1L, (long)((List)tableNameListMap.get(tableName2)).size());
        Assert.assertEquals((Object)"cf2", ((List)tableNameListMap.get(tableName2)).get(0));
        peerId = "3";
        peerNode = this.getPeerNode(peerId);
        actualRpc = ReplicationSerDeHelper.parsePeerFrom((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)peerNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        tableNameListMap = actualRpc.getTableCFsMap();
        Assert.assertNull((Object)tableNameListMap);
        peerId = "4";
        peerNode = this.getPeerNode(peerId);
        actualRpc = ReplicationSerDeHelper.parsePeerFrom((byte[])ZKUtil.getData((ZooKeeperWatcher)zkw, (String)peerNode));
        Assert.assertEquals((Object)rpc.getClusterKey(), (Object)actualRpc.getClusterKey());
        tableNameListMap = actualRpc.getTableCFsMap();
        Assert.assertNull((Object)tableNameListMap);
    }
}

