/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Strings;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HBaseKerberosUtils {
    private static final Log LOG = LogFactory.getLog(HBaseKerberosUtils.class);
    public static final String KRB_PRINCIPAL = "hbase.regionserver.kerberos.principal";
    public static final String MASTER_KRB_PRINCIPAL = "hbase.master.kerberos.principal";
    public static final String KRB_KEYTAB_FILE = "hbase.regionserver.keytab.file";

    public static boolean isKerberosPropertySetted() {
        String krbPrincipal = System.getProperty(KRB_PRINCIPAL);
        String krbKeytab = System.getProperty(KRB_KEYTAB_FILE);
        return !Strings.isNullOrEmpty((String)krbPrincipal) && !Strings.isNullOrEmpty((String)krbKeytab);
    }

    public static void setPrincipalForTesting(String principal) {
        HBaseKerberosUtils.setSystemProperty(KRB_PRINCIPAL, principal);
    }

    public static void setKeytabFileForTesting(String keytabFile) {
        HBaseKerberosUtils.setSystemProperty(KRB_KEYTAB_FILE, keytabFile);
    }

    public static void setSystemProperty(String propertyName, String propertyValue) {
        System.setProperty(propertyName, propertyValue);
    }

    public static String getKeytabFileForTesting() {
        return System.getProperty(KRB_KEYTAB_FILE);
    }

    public static String getPrincipalForTesting() {
        return System.getProperty(KRB_PRINCIPAL);
    }

    public static Configuration getConfigurationWoPrincipal() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        conf.setBoolean("hbase.security.authorization", true);
        return conf;
    }

    public static Configuration getSecuredConfiguration() {
        Configuration conf = HBaseConfiguration.create();
        HBaseKerberosUtils.setSecuredConfiguration(conf);
        return conf;
    }

    public static void setSecuredConfiguration(Configuration conf) {
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        conf.setBoolean("hbase.security.authorization", true);
        conf.set(KRB_KEYTAB_FILE, System.getProperty(KRB_KEYTAB_FILE));
        conf.set(KRB_PRINCIPAL, System.getProperty(KRB_PRINCIPAL));
        conf.set(MASTER_KRB_PRINCIPAL, System.getProperty(KRB_PRINCIPAL));
    }

    public static UserGroupInformation loginAndReturnUGI(Configuration conf, String username) throws IOException {
        String hostname = InetAddress.getLocalHost().getHostName();
        String keyTabFileConfKey = "hbase." + username + ".keytab.file";
        String keyTabFileLocation = conf.get(keyTabFileConfKey);
        String principalConfKey = "hbase." + username + ".kerberos.principal";
        String principal = SecurityUtil.getServerPrincipal((String)conf.get(principalConfKey), (String)hostname);
        if (keyTabFileLocation == null || principal == null) {
            LOG.warn((Object)("Principal or key tab file null for : " + principalConfKey + ", " + keyTabFileConfKey));
        }
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keyTabFileLocation);
        return ugi;
    }
}

