/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContextImpl;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.PingProtos;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.locking.LockProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessControlUtil;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SecurityTests.class, LargeTests.class})
public class TestAccessController
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestAccessController.class);
    private static TableName TEST_TABLE;
    private static final HBaseTestingUtility TEST_UTIL;
    private static Configuration conf;
    private static Connection systemUserConnection;
    private static User SUPERUSER;
    private static User USER_ADMIN;
    private static User USER_RW;
    private static User USER_RO;
    private static User USER_OWNER;
    private static User USER_CREATE;
    private static User USER_NONE;
    private static User USER_ADMIN_CF;
    private static final String GROUP_ADMIN = "group_admin";
    private static final String GROUP_CREATE = "group_create";
    private static final String GROUP_READ = "group_read";
    private static final String GROUP_WRITE = "group_write";
    private static User USER_GROUP_ADMIN;
    private static User USER_GROUP_CREATE;
    private static User USER_GROUP_READ;
    private static User USER_GROUP_WRITE;
    private static TableName TEST_TABLE2;
    private static byte[] TEST_FAMILY;
    private static byte[] TEST_QUALIFIER;
    private static byte[] TEST_ROW;
    private static MasterCoprocessorEnvironment CP_ENV;
    private static AccessController ACCESS_CONTROLLER;
    private static RegionServerCoprocessorEnvironment RSCP_ENV;
    private static RegionCoprocessorEnvironment RCP_ENV;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.metahandler.count", 10);
        TestAccessController.enableSecurity(conf);
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName());
        TestAccessController.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.exec.permission.checks", true);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        ACCESS_CONTROLLER = (AccessController)cpHost.findCoprocessor(AccessController.class);
        CP_ENV = cpHost.createEnvironment((MasterCoprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost();
        RSCP_ENV = rsHost.createEnvironment((RegionServerCoprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        TEST_UTIL.waitUntilAllRegionsAssigned(AccessControlLists.ACL_TABLE_NAME);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_ADMIN = User.createUserForTesting((Configuration)conf, (String)"admin2", (String[])new String[0]);
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rwuser", (String[])new String[0]);
        USER_RO = User.createUserForTesting((Configuration)conf, (String)"rouser", (String[])new String[0]);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_CREATE = User.createUserForTesting((Configuration)conf, (String)"tbl_create", (String[])new String[0]);
        USER_NONE = User.createUserForTesting((Configuration)conf, (String)"nouser", (String[])new String[0]);
        USER_ADMIN_CF = User.createUserForTesting((Configuration)conf, (String)"col_family_admin", (String[])new String[0]);
        USER_GROUP_ADMIN = User.createUserForTesting((Configuration)conf, (String)"user_group_admin", (String[])new String[]{GROUP_ADMIN});
        USER_GROUP_CREATE = User.createUserForTesting((Configuration)conf, (String)"user_group_create", (String[])new String[]{GROUP_CREATE});
        USER_GROUP_READ = User.createUserForTesting((Configuration)conf, (String)"user_group_read", (String[])new String[]{GROUP_READ});
        USER_GROUP_WRITE = User.createUserForTesting((Configuration)conf, (String)"user_group_write", (String[])new String[]{GROUP_WRITE});
        systemUserConnection = TEST_UTIL.getConnection();
        TestAccessController.setUpTableAndUserPermissions();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestAccessController.cleanUp();
        TEST_UTIL.shutdownMiniCluster();
        int total = TableAuthManager.getTotalRefCount();
        Assert.assertTrue((String)("Unexpected reference count: " + total), (total == 0 ? 1 : 0) != 0);
    }

    private static void setUpTableAndUserPermissions() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(100);
        htd.addFamily(hcd);
        htd.setOwner(USER_OWNER);
        TestAccessController.createTable(TEST_UTIL, (TableDescriptor)htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(TEST_TABLE).get(0);
        RegionCoprocessorHost rcpHost = region.getCoprocessorHost();
        RCP_ENV = rcpHost.createEnvironment((RegionCoprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        TestAccessController.grantGlobal(TEST_UTIL, USER_ADMIN.getShortName(), Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController.grantOnTable(TEST_UTIL, USER_RW.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController.grantOnTable(TEST_UTIL, USER_CREATE.getShortName(), TEST_TABLE, null, null, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestAccessController.grantOnTable(TEST_UTIL, USER_RO.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
        TestAccessController.grantOnTable(TEST_UTIL, USER_ADMIN_CF.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        TestAccessController.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_ADMIN), Permission.Action.ADMIN);
        TestAccessController.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_CREATE), Permission.Action.CREATE);
        TestAccessController.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_READ), Permission.Action.READ);
        TestAccessController.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_WRITE), Permission.Action.WRITE);
        Assert.assertEquals((long)5L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE).size());
        try {
            Assert.assertEquals((long)5L, (long)AccessControlClient.getUserPermissions((Connection)systemUserConnection, (String)TEST_TABLE.toString()).size());
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.getUserPermissions. ", e);
        }
    }

    private static void cleanUp() throws Exception {
        try {
            TestAccessController.deleteTable(TEST_UTIL, TEST_TABLE);
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)("Test deleted table " + TEST_TABLE));
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)TEST_TABLE).size());
        Assert.assertEquals((long)0L, (long)AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TEST_TABLE.getNamespaceAsString()).size());
    }

    @Test(timeout=180000L)
    public void testUnauthorizedShutdown() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
                master.shutdown();
                return null;
            }
        };
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testUnauthorizedStopMaster() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
                master.stopMaster();
                return null;
            }
        };
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testSecurityCapabilities() throws Exception {
        List capabilities = TEST_UTIL.getConnection().getAdmin().getSecurityCapabilities();
        Assert.assertTrue((String)"AUTHORIZATION capability is missing", (boolean)capabilities.contains(SecurityCapability.AUTHORIZATION));
        Assert.assertTrue((String)"CELL_AUTHORIZATION capability is missing", (boolean)capabilities.contains(SecurityCapability.CELL_AUTHORIZATION));
    }

    @Test(timeout=180000L)
    public void testTableCreate() throws Exception {
        SecureTestUtil.AccessTestAction createTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)TestAccessController.this.name.getMethodName()));
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                ACCESS_CONTROLLER.preCreateTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (TableDescriptor)htd, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(createTable, SUPERUSER, USER_ADMIN, USER_GROUP_CREATE);
        TestAccessController.verifyDenied(createTable, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_ADMIN, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test(timeout=180000L)
    public void testTableModify() throws Exception {
        SecureTestUtil.AccessTestAction modifyTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                htd.addFamily(new HColumnDescriptor("fam_" + User.getCurrent().getShortName()));
                ACCESS_CONTROLLER.preModifyTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TEST_TABLE, (TableDescriptor)htd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(modifyTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(modifyTable, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test(timeout=180000L)
    public void testTableDelete() throws Exception {
        SecureTestUtil.AccessTestAction deleteTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TEST_TABLE);
                return null;
            }
        };
        TestAccessController.verifyAllowed(deleteTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(deleteTable, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test(timeout=180000L)
    public void testTableTruncate() throws Exception {
        SecureTestUtil.AccessTestAction truncateTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preTruncateTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TEST_TABLE);
                return null;
            }
        };
        TestAccessController.verifyAllowed(truncateTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(truncateTable, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test(timeout=180000L)
    public void testTableDisable() throws Exception {
        SecureTestUtil.AccessTestAction disableTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDisableTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TEST_TABLE);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction disableAclTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDisableTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), AccessControlLists.ACL_TABLE_NAME);
                return null;
            }
        };
        TestAccessController.verifyAllowed(disableTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(disableTable, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
        TestAccessController.verifyDenied(disableAclTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_GROUP_CREATE, USER_GROUP_ADMIN, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test(timeout=180000L)
    public void testTableEnable() throws Exception {
        SecureTestUtil.AccessTestAction enableTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preEnableTable(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TEST_TABLE);
                return null;
            }
        };
        TestAccessController.verifyAllowed(enableTable, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(enableTable, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test
    public void testAbortProcedure() throws Exception {
        final long procId = 1L;
        SecureTestUtil.AccessTestAction abortProcedureAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAbortProcedure(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), procId);
                return null;
            }
        };
        TestAccessController.verifyAllowed(abortProcedureAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
    }

    @Test
    public void testGetProcedures() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor procExec = TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
        TestTableDDLProcedure proc = new TestTableDDLProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName);
        proc.setOwner(USER_OWNER);
        procExec.submitProcedure((Procedure)proc);
        List procList = procExec.getProcedures();
        SecureTestUtil.AccessTestAction getProceduresAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.postGetProcedures(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV));
                return null;
            }
        };
        TestAccessController.verifyAllowed(getProceduresAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyAllowed(getProceduresAction, USER_OWNER);
        TestAccessController.verifyIfNull(getProceduresAction, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test(timeout=180000L)
    public void testGetLocks() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preGetLocks(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testMove() throws Exception {
        List regions;
        try (RegionLocator locator = systemUserConnection.getRegionLocator(TEST_TABLE);){
            regions = locator.getAllRegionLocations();
        }
        HRegionLocation location = (HRegionLocation)regions.get(0);
        final HRegionInfo hri = location.getRegionInfo();
        final ServerName server = location.getServerName();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preMove(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (RegionInfo)hri, server, server);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testAssign() throws Exception {
        List regions;
        try (RegionLocator locator = systemUserConnection.getRegionLocator(TEST_TABLE);){
            regions = locator.getAllRegionLocations();
        }
        HRegionLocation location = (HRegionLocation)regions.get(0);
        final HRegionInfo hri = location.getRegionInfo();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAssign(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (RegionInfo)hri);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testUnassign() throws Exception {
        List regions;
        try (RegionLocator locator = systemUserConnection.getRegionLocator(TEST_TABLE);){
            regions = locator.getAllRegionLocations();
        }
        HRegionLocation location = (HRegionLocation)regions.get(0);
        final HRegionInfo hri = location.getRegionInfo();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preUnassign(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (RegionInfo)hri, false);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testRegionOffline() throws Exception {
        List regions;
        try (RegionLocator locator = systemUserConnection.getRegionLocator(TEST_TABLE);){
            regions = locator.getAllRegionLocations();
        }
        HRegionLocation location = (HRegionLocation)regions.get(0);
        final HRegionInfo hri = location.getRegionInfo();
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRegionOffline(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), (RegionInfo)hri);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testSetSplitOrMergeEnabled() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetSplitOrMergeEnabled(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), true, MasterSwitchType.MERGE);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testBalance() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalance(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testBalanceSwitch() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalanceSwitch(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), true);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testShutdown() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preShutdown(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testStopMaster() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preStopMaster(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    private void verifyWrite(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_GROUP_WRITE);
        TestAccessController.verifyDenied(action, USER_NONE, USER_RO, USER_GROUP_ADMIN, USER_GROUP_READ, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testSplitWithSplitRow() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTestTable(tableName);
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSplitRegion(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), tableName, TEST_ROW);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testFlush() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preFlush(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RCP_ENV), FlushLifeCycleTracker.DUMMY);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test(timeout=180000L)
    public void testCompact() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCompact(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RCP_ENV), null, null, ScanType.COMPACT_RETAIN_DELETES, null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_GROUP_CREATE, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    private void verifyRead(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_RO, USER_GROUP_READ);
        TestAccessController.verifyDenied(action, USER_NONE, USER_GROUP_CREATE, USER_GROUP_ADMIN, USER_GROUP_WRITE);
    }

    private void verifyReadWrite(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        TestAccessController.verifyDenied(action, USER_NONE, USER_RO, USER_GROUP_ADMIN, USER_GROUP_CREATE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test(timeout=180000L)
    public void testRead() throws Exception {
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Get g = new Get(TEST_ROW);
                g.addFamily(TEST_FAMILY);
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.get(g);
                }
                return null;
            }
        };
        this.verifyRead(getAction);
        SecureTestUtil.AccessTestAction scanAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Scan s = new Scan();
                s.addFamily(TEST_FAMILY);
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table table = conn.getTable(TEST_TABLE);
                     ResultScanner scanner = table.getScanner(s);){
                    Result r = scanner.next();
                    while (r != null) {
                        r = scanner.next();
                    }
                }
                return null;
            }
        };
        this.verifyRead(scanAction);
    }

    @Test(timeout=180000L)
    public void testWrite() throws Exception {
        SecureTestUtil.AccessTestAction putAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Put p = new Put(TEST_ROW);
                p.addColumn(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((int)1));
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.put(p);
                }
                return null;
            }
        };
        this.verifyWrite(putAction);
        SecureTestUtil.AccessTestAction deleteAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Delete d = new Delete(TEST_ROW);
                d.addFamily(TEST_FAMILY);
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.delete(d);
                }
                return null;
            }
        };
        this.verifyWrite(deleteAction);
        SecureTestUtil.AccessTestAction incrementAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Increment inc = new Increment(TEST_ROW);
                inc.addColumn(TEST_FAMILY, TEST_QUALIFIER, 1L);
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.increment(inc);
                }
                return null;
            }
        };
        this.verifyWrite(incrementAction);
    }

    @Test(timeout=180000L)
    public void testReadWrite() throws Exception {
        SecureTestUtil.AccessTestAction checkAndDeleteAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Delete d = new Delete(TEST_ROW);
                d.addFamily(TEST_FAMILY);
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.checkAndDelete(TEST_ROW, TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((String)"test_value"), d);
                }
                return null;
            }
        };
        this.verifyReadWrite(checkAndDeleteAction);
        SecureTestUtil.AccessTestAction checkAndPut = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Put p = new Put(TEST_ROW);
                p.addColumn(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((int)1));
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.checkAndPut(TEST_ROW, TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((String)"test_value"), p);
                }
                return null;
            }
        };
        this.verifyReadWrite(checkAndPut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testBulkLoad() throws Exception {
        try {
            FileSystem fs = TEST_UTIL.getTestFileSystem();
            final Path dir = TEST_UTIL.getDataTestDirOnTestFS("testBulkLoad");
            fs.mkdirs(dir);
            fs.setPermission(dir, FsPermission.valueOf((String)"-rwxrwxrwx"));
            SecureTestUtil.AccessTestAction bulkLoadAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    int numRows = 3;
                    byte[][][] hfileRanges = new byte[][][]{new byte[][]{{0}, {9}}};
                    Path bulkLoadBasePath = new Path(dir, new Path(User.getCurrent().getName()));
                    new BulkLoadHelper(bulkLoadBasePath).bulkLoadHFile(TEST_TABLE, TEST_FAMILY, TEST_QUALIFIER, hfileRanges, numRows);
                    return null;
                }
            };
            TestAccessController.verifyAllowed(bulkLoadAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_GROUP_CREATE);
            TestAccessController.verifyDenied(bulkLoadAction, USER_RW, USER_NONE, USER_RO, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_ADMIN);
        }
        finally {
            TEST_UTIL.getAdmin().disableTable(TEST_TABLE);
            TEST_UTIL.getAdmin().enableTable(TEST_TABLE);
        }
    }

    @Test(timeout=180000L)
    public void testAppend() throws Exception {
        SecureTestUtil.AccessTestAction appendAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                byte[] row = TEST_ROW;
                byte[] qualifier = TEST_QUALIFIER;
                Put put = new Put(row);
                put.addColumn(TEST_FAMILY, qualifier, Bytes.toBytes((int)1));
                Append append = new Append(row);
                append.addColumn(TEST_FAMILY, qualifier, Bytes.toBytes((int)2));
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = conn.getTable(TEST_TABLE);){
                    t.put(put);
                    t.append(append);
                }
                return null;
            }
        };
        TestAccessController.verifyAllowed(appendAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_GROUP_WRITE);
        TestAccessController.verifyDenied(appendAction, USER_RO, USER_NONE, USER_GROUP_CREATE, USER_GROUP_READ, USER_GROUP_ADMIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testGrantRevoke() throws Exception {
        SecureTestUtil.AccessTestAction grantAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(TEST_TABLE.getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    AccessControlUtil.grant(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)USER_RO.getShortName(), (TableName)TEST_TABLE, (byte[])TEST_FAMILY, null, (boolean)false, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction revokeAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(TEST_TABLE.getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    AccessControlUtil.revoke(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)USER_RO.getShortName(), (TableName)TEST_TABLE, (byte[])TEST_FAMILY, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction getTablePermissionsAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(TEST_TABLE.getName());
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    AccessControlUtil.getUserPermissions(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (TableName)TEST_TABLE);
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction getGlobalPermissionsAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    AccessControlUtil.getUserPermissions(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol);
                }
                return null;
            }
        };
        TestAccessController.verifyAllowed(grantAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(grantAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        try {
            TestAccessController.verifyAllowed(revokeAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
            TestAccessController.verifyDenied(revokeAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
            TestAccessController.verifyAllowed(getTablePermissionsAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
            TestAccessController.verifyDenied(getTablePermissionsAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
            TestAccessController.verifyAllowed(getGlobalPermissionsAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
            TestAccessController.verifyDenied(getGlobalPermissionsAction, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        }
        catch (Throwable throwable) {
            TestAccessController.grantOnTable(TEST_UTIL, USER_RO.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
            throw throwable;
        }
        TestAccessController.grantOnTable(TEST_UTIL, USER_RO.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testPostGrantRevoke() throws Exception {
        final TableName tableName = TableName.valueOf((String)"TempTable");
        final byte[] family1 = Bytes.toBytes((String)"f1");
        final byte[] family2 = Bytes.toBytes((String)"f2");
        final byte[] qualifier = Bytes.toBytes((String)"q");
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(tableName)) {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        TestAccessController.createTable(TEST_UTIL, (TableDescriptor)htd);
        try {
            User tblUser = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"tbluser", (String[])new String[0]);
            User gblUser = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"gbluser", (String[])new String[0]);
            SecureTestUtil.AccessTestAction putActionAll = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Put p = new Put(Bytes.toBytes((String)"a"));
                    p.addColumn(family1, qualifier, Bytes.toBytes((String)"v1"));
                    p.addColumn(family2, qualifier, Bytes.toBytes((String)"v2"));
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.put(p);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction putAction1 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Put p = new Put(Bytes.toBytes((String)"a"));
                    p.addColumn(family1, qualifier, Bytes.toBytes((String)"v1"));
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.put(p);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction putAction2 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Put p = new Put(Bytes.toBytes((String)"a"));
                    p.addColumn(family2, qualifier, Bytes.toBytes((String)"v2"));
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.put(p);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction getActionAll = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Get g = new Get(TEST_ROW);
                    g.addFamily(family1);
                    g.addFamily(family2);
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.get(g);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction getAction1 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Get g = new Get(TEST_ROW);
                    g.addFamily(family1);
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.get(g);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction getAction2 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Get g = new Get(TEST_ROW);
                    g.addFamily(family2);
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.get(g);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction deleteActionAll = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Delete d = new Delete(TEST_ROW);
                    d.addFamily(family1);
                    d.addFamily(family2);
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.delete(d);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction deleteAction1 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Delete d = new Delete(TEST_ROW);
                    d.addFamily(family1);
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.delete(d);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction deleteAction2 = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Delete d = new Delete(TEST_ROW);
                    d.addFamily(family2);
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.delete(d);
                    }
                    return null;
                }
            };
            TestAccessController.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.READ);
            TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, null, null, Permission.Action.READ);
            TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyAllowed(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.WRITE);
            TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, null, null, Permission.Action.WRITE);
            TestAccessController.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyAllowed(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyAllowed(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyAllowed(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyAllowed(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.revokeGlobal(TEST_UTIL, gblUser.getShortName(), new Permission.Action[0]);
            TestAccessController.revokeFromTable(TEST_UTIL, tblUser.getShortName(), tableName, null, null, new Permission.Action[0]);
            TestAccessController.verifyDenied(tblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.READ);
            TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, family1, null, Permission.Action.READ);
            TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1);
            TestAccessController.verifyDenied(tblUser, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyAllowed(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.grantGlobal(TEST_UTIL, gblUser.getShortName(), Permission.Action.WRITE);
            TestAccessController.grantOnTable(TEST_UTIL, tblUser.getShortName(), tableName, family2, null, Permission.Action.WRITE);
            TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1);
            TestAccessController.verifyAllowed(tblUser, putAction2, deleteAction2);
            TestAccessController.verifyDenied(tblUser, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1);
            TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyAllowed(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyAllowed(gblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.revokeGlobal(TEST_UTIL, gblUser.getShortName(), new Permission.Action[0]);
            TestAccessController.revokeFromTable(TEST_UTIL, tblUser.getShortName(), tableName, family2, null, new Permission.Action[0]);
            TestAccessController.verifyAllowed(tblUser, getActionAll, getAction1);
            TestAccessController.verifyDenied(tblUser, getAction2);
            TestAccessController.verifyDenied(tblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(tblUser, deleteActionAll, deleteAction1, deleteAction2);
            TestAccessController.verifyDenied(gblUser, getActionAll, getAction1, getAction2);
            TestAccessController.verifyDenied(gblUser, putActionAll, putAction1, putAction2);
            TestAccessController.verifyDenied(gblUser, deleteActionAll, deleteAction1, deleteAction2);
        }
        finally {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
    }

    private boolean hasFoundUserPermission(List<UserPermission> userPermissions, List<UserPermission> perms) {
        return perms.containsAll(userPermissions);
    }

    private boolean hasFoundUserPermission(UserPermission userPermission, List<UserPermission> perms) {
        return perms.contains(userPermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testPostGrantRevokeAtQualifierLevel() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        final byte[] family1 = Bytes.toBytes((String)"f1");
        byte[] family2 = Bytes.toBytes((String)"f2");
        final byte[] qualifier = Bytes.toBytes((String)"q");
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(tableName)) {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        TestAccessController.createTable(TEST_UTIL, (TableDescriptor)htd);
        try {
            User user = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"user", (String[])new String[0]);
            SecureTestUtil.AccessTestAction getQualifierAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Get g = new Get(TEST_ROW);
                    g.addColumn(family1, qualifier);
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.get(g);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction putQualifierAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Put p = new Put(TEST_ROW);
                    p.addColumn(family1, qualifier, Bytes.toBytes((String)"v1"));
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.put(p);
                    }
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction deleteQualifierAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Delete d = new Delete(TEST_ROW);
                    d.addColumn(family1, qualifier);
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(tableName);){
                        t.delete(d);
                    }
                    return null;
                }
            };
            TestAccessController.revokeFromTable(TEST_UTIL, user.getShortName(), tableName, family1, null, new Permission.Action[0]);
            TestAccessController.verifyDenied(user, getQualifierAction);
            TestAccessController.verifyDenied(user, putQualifierAction);
            TestAccessController.verifyDenied(user, deleteQualifierAction);
            TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.READ);
            TestAccessController.verifyAllowed(user, getQualifierAction);
            TestAccessController.verifyDenied(user, putQualifierAction);
            TestAccessController.verifyDenied(user, deleteQualifierAction);
            TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.WRITE);
            TestAccessController.verifyDenied(user, getQualifierAction);
            TestAccessController.verifyAllowed(user, putQualifierAction);
            TestAccessController.verifyAllowed(user, deleteQualifierAction);
            TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.READ, Permission.Action.WRITE);
            TestAccessController.verifyAllowed(user, getQualifierAction);
            TestAccessController.verifyAllowed(user, putQualifierAction);
            TestAccessController.verifyAllowed(user, deleteQualifierAction);
            TestAccessController.revokeFromTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, new Permission.Action[0]);
            TestAccessController.verifyDenied(user, getQualifierAction);
            TestAccessController.verifyDenied(user, putQualifierAction);
            TestAccessController.verifyDenied(user, deleteQualifierAction);
        }
        finally {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testPermissionList() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] family1 = Bytes.toBytes((String)"f1");
        byte[] family2 = Bytes.toBytes((String)"f2");
        byte[] qualifier = Bytes.toBytes((String)"q");
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(tableName)) {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family1));
        htd.addFamily(new HColumnDescriptor(family2));
        htd.setOwner(USER_OWNER);
        TestAccessController.createTable(TEST_UTIL, (TableDescriptor)htd);
        try {
            AccessControlProtos.AccessControlService.BlockingInterface protocol;
            CoprocessorRpcChannel service;
            List perms;
            try (Table acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                CoprocessorRpcChannel service2 = acl.coprocessorService(tableName.getName());
                AccessControlProtos.AccessControlService.BlockingInterface protocol2 = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service2);
                perms = AccessControlUtil.getUserPermissions(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol2, (TableName)tableName);
            }
            UserPermission ownerperm = new UserPermission(Bytes.toBytes((String)USER_OWNER.getName()), tableName, null, Permission.Action.values());
            Assert.assertTrue((String)"Owner should have all permissions on table", (boolean)this.hasFoundUserPermission(ownerperm, (List<UserPermission>)perms));
            User user = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"user", (String[])new String[0]);
            byte[] userName = Bytes.toBytes((String)user.getShortName());
            UserPermission up = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.READ});
            Assert.assertFalse((String)("User should not be granted permission: " + up.toString()), (boolean)this.hasFoundUserPermission(up, (List<UserPermission>)perms));
            TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.READ);
            acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);
            try {
                CoprocessorRpcChannel service3 = acl.coprocessorService(tableName.getName());
                AccessControlProtos.AccessControlService.BlockingInterface protocol3 = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service3);
                perms = AccessControlUtil.getUserPermissions(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol3, (TableName)tableName);
            }
            finally {
                acl.close();
            }
            UserPermission upToVerify = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.READ});
            Assert.assertTrue((String)("User should be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, (List<UserPermission>)perms));
            upToVerify = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.WRITE});
            Assert.assertFalse((String)("User should not be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, (List<UserPermission>)perms));
            TestAccessController.grantOnTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.WRITE, Permission.Action.READ);
            acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);
            try {
                service = acl.coprocessorService(tableName.getName());
                protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                perms = AccessControlUtil.getUserPermissions(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (TableName)tableName);
            }
            finally {
                acl.close();
            }
            upToVerify = new UserPermission(userName, tableName, family1, qualifier, new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ});
            Assert.assertTrue((String)("User should be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, (List<UserPermission>)perms));
            TestAccessController.revokeFromTable(TEST_UTIL, user.getShortName(), tableName, family1, qualifier, Permission.Action.WRITE, Permission.Action.READ);
            acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);
            try {
                service = acl.coprocessorService(tableName.getName());
                protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                perms = AccessControlUtil.getUserPermissions(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (TableName)tableName);
            }
            finally {
                acl.close();
            }
            Assert.assertFalse((String)("User should not be granted permission: " + upToVerify.toString()), (boolean)this.hasFoundUserPermission(upToVerify, (List<UserPermission>)perms));
            admin.disableTable(tableName);
            User newOwner = User.createUserForTesting((Configuration)conf, (String)"new_owner", (String[])new String[0]);
            htd.setOwner(newOwner);
            admin.modifyTable(tableName, (TableDescriptor)htd);
            acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);
            try {
                CoprocessorRpcChannel service4 = acl.coprocessorService(tableName.getName());
                AccessControlProtos.AccessControlService.BlockingInterface protocol4 = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service4);
                perms = AccessControlUtil.getUserPermissions(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol4, (TableName)tableName);
            }
            finally {
                acl.close();
            }
            UserPermission newOwnerperm = new UserPermission(Bytes.toBytes((String)newOwner.getName()), tableName, null, Permission.Action.values());
            Assert.assertTrue((String)"New owner should have all permissions on table", (boolean)this.hasFoundUserPermission(newOwnerperm, (List<UserPermission>)perms));
        }
        finally {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testGlobalPermissionList() throws Exception {
        List perms;
        try (Table acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);){
            CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            perms = AccessControlUtil.getUserPermissions(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol);
        }
        List superUsers = Superusers.getSuperUsers();
        ArrayList<UserPermission> adminPerms = new ArrayList<UserPermission>(superUsers.size() + 1);
        adminPerms.add(new UserPermission(Bytes.toBytes((String)USER_ADMIN.getShortName()), AccessControlLists.ACL_TABLE_NAME, null, null, Bytes.toBytes((String)"ACRW")));
        for (String user : superUsers) {
            adminPerms.add(new UserPermission(Bytes.toBytes((String)user), AccessControlLists.ACL_TABLE_NAME, null, null, Permission.Action.values()));
        }
        Assert.assertTrue((String)"Only super users, global users and user admin has permission on table hbase:acl per setup", (perms.size() == 5 + superUsers.size() && this.hasFoundUserPermission(adminPerms, (List<UserPermission>)perms) ? 1 : 0) != 0);
    }

    private void verifyGlobal(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_NONE, USER_RO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testCheckPermissions() throws Exception {
        SecureTestUtil.AccessTestAction globalAdmin = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkGlobalPerms(TEST_UTIL, Permission.Action.ADMIN);
                return null;
            }
        };
        this.verifyGlobal(globalAdmin);
        SecureTestUtil.AccessTestAction globalReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                SecureTestUtil.checkGlobalPerms(TEST_UTIL, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        this.verifyGlobal(globalReadWrite);
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        User userTable = User.createUserForTesting((Configuration)conf, (String)"user_check_perms_table", (String[])new String[0]);
        User userColumn = User.createUserForTesting((Configuration)conf, (String)"user_check_perms_family", (String[])new String[0]);
        User userQualifier = User.createUserForTesting((Configuration)conf, (String)"user_check_perms_q", (String[])new String[0]);
        TestAccessController.grantOnTable(TEST_UTIL, userTable.getShortName(), TEST_TABLE, null, null, Permission.Action.READ);
        TestAccessController.grantOnTable(TEST_UTIL, userColumn.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
        TestAccessController.grantOnTable(TEST_UTIL, userQualifier.getShortName(), TEST_TABLE, TEST_FAMILY, TEST_Q1, Permission.Action.READ);
        try {
            SecureTestUtil.AccessTestAction tableRead = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, null, null, Permission.Action.READ);
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction columnRead = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction qualifierRead = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, TEST_FAMILY, TEST_Q1, Permission.Action.READ);
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction multiQualifierRead = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, new Permission[]{new TablePermission(TEST_TABLE, TEST_FAMILY, TEST_Q1, new Permission.Action[]{Permission.Action.READ}), new TablePermission(TEST_TABLE, TEST_FAMILY, TEST_Q2, new Permission.Action[]{Permission.Action.READ})});
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction globalAndTableRead = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, new Permission[]{new Permission(new Permission.Action[]{Permission.Action.READ}), new TablePermission(TEST_TABLE, null, (byte[])null, new Permission.Action[]{Permission.Action.READ})});
                    return null;
                }
            };
            SecureTestUtil.AccessTestAction noCheck = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, new Permission[0]);
                    return null;
                }
            };
            TestAccessController.verifyAllowed(tableRead, SUPERUSER, userTable);
            TestAccessController.verifyDenied(tableRead, userColumn, userQualifier);
            TestAccessController.verifyAllowed(columnRead, SUPERUSER, userTable, userColumn);
            TestAccessController.verifyDenied(columnRead, userQualifier);
            TestAccessController.verifyAllowed(qualifierRead, SUPERUSER, userTable, userColumn, userQualifier);
            TestAccessController.verifyAllowed(multiQualifierRead, SUPERUSER, userTable, userColumn);
            TestAccessController.verifyDenied(multiQualifierRead, userQualifier);
            TestAccessController.verifyAllowed(globalAndTableRead, SUPERUSER);
            TestAccessController.verifyDenied(globalAndTableRead, userTable, userColumn, userQualifier);
            TestAccessController.verifyAllowed(noCheck, SUPERUSER, userTable, userColumn, userQualifier);
            SecureTestUtil.AccessTestAction familyReadWrite = new SecureTestUtil.AccessTestAction(){

                @Override
                public Void run() throws Exception {
                    SecureTestUtil.checkTablePerms(TEST_UTIL, TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
                    return null;
                }
            };
            TestAccessController.verifyAllowed(familyReadWrite, SUPERUSER, USER_OWNER, USER_CREATE, USER_RW);
            TestAccessController.verifyDenied(familyReadWrite, USER_NONE, USER_RO);
            AccessControlProtos.CheckPermissionsRequest checkRequest = AccessControlProtos.CheckPermissionsRequest.newBuilder().addPermission(AccessControlProtos.Permission.newBuilder().setType(AccessControlProtos.Permission.Type.Table).setTablePermission(AccessControlProtos.TablePermission.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)TEST_TABLE)).addAction(AccessControlProtos.Permission.Action.CREATE))).build();
            try (Table acl = systemUserConnection.getTable(AccessControlLists.ACL_TABLE_NAME);){
                CoprocessorRpcChannel channel = acl.coprocessorService(new byte[0]);
                AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)channel);
                try {
                    protocol.checkPermissions(null, checkRequest);
                    Assert.fail((String)"this should have thrown CoprocessorException");
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            TestAccessController.revokeFromTable(TEST_UTIL, userTable.getShortName(), TEST_TABLE, null, null, Permission.Action.READ);
            TestAccessController.revokeFromTable(TEST_UTIL, userColumn.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
            TestAccessController.revokeFromTable(TEST_UTIL, userQualifier.getShortName(), TEST_TABLE, TEST_FAMILY, TEST_Q1, Permission.Action.READ);
            throw throwable;
        }
        TestAccessController.revokeFromTable(TEST_UTIL, userTable.getShortName(), TEST_TABLE, null, null, Permission.Action.READ);
        TestAccessController.revokeFromTable(TEST_UTIL, userColumn.getShortName(), TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
        TestAccessController.revokeFromTable(TEST_UTIL, userQualifier.getShortName(), TEST_TABLE, TEST_FAMILY, TEST_Q1, Permission.Action.READ);
    }

    @Test(timeout=180000L)
    public void testStopRegionServer() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preStopRegionServer(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RSCP_ENV));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testRollWALWriterRequest() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRollWALWriterRequest(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RSCP_ENV));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testOpenRegion() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preOpen(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RCP_ENV));
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test(timeout=180000L)
    public void testCloseRegion() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preClose(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RCP_ENV), false);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_CREATE, USER_GROUP_READ, USER_GROUP_WRITE);
    }

    @Test(timeout=180000L)
    public void testSnapshot() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        final HTableDescriptor htd = admin.getTableDescriptor(TEST_TABLE);
        final SnapshotDescription snapshot = new SnapshotDescription(TEST_TABLE.getNameAsString() + "-snapshot", TEST_TABLE);
        SecureTestUtil.AccessTestAction snapshotAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot, (TableDescriptor)htd);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction deleteAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction restoreAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRestoreSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot, (TableDescriptor)htd);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction cloneAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCloneSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(snapshotAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(snapshotAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestAccessController.verifyAllowed(cloneAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(deleteAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestAccessController.verifyAllowed(restoreAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(restoreAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestAccessController.verifyAllowed(deleteAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(cloneAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testSnapshotWithOwner() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        final HTableDescriptor htd = admin.getTableDescriptor(TEST_TABLE);
        final SnapshotDescription snapshot = new SnapshotDescription(TEST_TABLE.getNameAsString() + "-snapshot", TEST_TABLE, null, USER_OWNER.getName());
        SecureTestUtil.AccessTestAction snapshotAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot, (TableDescriptor)htd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(snapshotAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(snapshotAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        SecureTestUtil.AccessTestAction deleteAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot);
                return null;
            }
        };
        TestAccessController.verifyAllowed(deleteAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(deleteAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        SecureTestUtil.AccessTestAction restoreAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRestoreSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot, (TableDescriptor)htd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(restoreAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(restoreAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        SecureTestUtil.AccessTestAction cloneAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCloneSnapshot(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), snapshot, (TableDescriptor)htd);
                return null;
            }
        };
        TestAccessController.verifyAllowed(cloneAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN, USER_OWNER);
        TestAccessController.verifyDenied(cloneAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testGlobalAuthorizationForNewRegisteredRS() throws Exception {
        List regions;
        LOG.debug((Object)"Test for global authorization for a new registered RegionServer.");
        MiniHBaseCluster hbaseCluster = TEST_UTIL.getHBaseCluster();
        final Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE2);
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        TestAccessController.createTable(TEST_UTIL, (TableDescriptor)htd);
        JVMClusterUtil.RegionServerThread newRsThread = hbaseCluster.startRegionServer();
        final HRegionServer newRs = newRsThread.getRegionServer();
        try (RegionLocator locator = systemUserConnection.getRegionLocator(TEST_TABLE2);){
            regions = locator.getAllRegionLocations();
        }
        HRegionLocation location = (HRegionLocation)regions.get(0);
        final HRegionInfo hri = location.getRegionInfo();
        ServerName server = location.getServerName();
        try (final Table table = systemUserConnection.getTable(TEST_TABLE2);){
            SecureTestUtil.AccessTestAction moveAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    admin.move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)newRs.getServerName().getServerName()));
                    return null;
                }
            };
            SUPERUSER.runAs((PrivilegedExceptionAction)moveAction);
            int RETRIES_LIMIT = 10;
            int retries = 0;
            while (newRs.getRegions(TEST_TABLE2).size() < 1 && retries < 10) {
                LOG.debug((Object)("Waiting for region to be opened. Already retried " + retries + " times."));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++retries != 9) continue;
                Assert.fail((String)"Retry exhaust for waiting region to be opened.");
            }
            SecureTestUtil.AccessTestAction putAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    Put put = new Put(Bytes.toBytes((String)"test"));
                    put.addColumn(TEST_FAMILY, Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"value"));
                    table.put(put);
                    return null;
                }
            };
            USER_ADMIN.runAs((PrivilegedExceptionAction)putAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testTableDescriptorsEnumeration() throws Exception {
        User TABLE_ADMIN = User.createUserForTesting((Configuration)conf, (String)"UserA", (String[])new String[0]);
        TestAccessController.grantOnTable(TEST_UTIL, TABLE_ADMIN.getShortName(), TEST_TABLE, null, null, Permission.Action.ADMIN);
        try {
            SecureTestUtil.AccessTestAction listTablesAction = new SecureTestUtil.AccessTestAction(){

                /*
                 * Exception decompiling
                 */
                @Override
                public Object run() throws Exception {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            SecureTestUtil.AccessTestAction getTableDescAction = new SecureTestUtil.AccessTestAction(){

                /*
                 * Exception decompiling
                 */
                @Override
                public Object run() throws Exception {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            TestAccessController.verifyAllowed(listTablesAction, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, TABLE_ADMIN, USER_GROUP_CREATE, USER_GROUP_ADMIN);
            TestAccessController.verifyIfEmptyList(listTablesAction, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
            TestAccessController.verifyAllowed(getTableDescAction, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, TABLE_ADMIN, USER_GROUP_CREATE, USER_GROUP_ADMIN);
            TestAccessController.verifyDenied(getTableDescAction, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
        }
        catch (Throwable throwable) {
            TestAccessController.revokeFromTable(TEST_UTIL, TABLE_ADMIN.getShortName(), TEST_TABLE, null, null, Permission.Action.ADMIN);
            throw throwable;
        }
        TestAccessController.revokeFromTable(TEST_UTIL, TABLE_ADMIN.getShortName(), TEST_TABLE, null, null, Permission.Action.ADMIN);
    }

    @Test(timeout=180000L)
    public void testTableNameEnumeration() throws Exception {
        SecureTestUtil.AccessTestAction listTablesAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Connection unmanagedConnection = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
                Admin admin = unmanagedConnection.getAdmin();
                try {
                    List<TableName> list = Arrays.asList(admin.listTableNames());
                    return list;
                }
                finally {
                    admin.close();
                    unmanagedConnection.close();
                }
            }
        };
        TestAccessController.verifyAllowed(listTablesAction, SUPERUSER, USER_ADMIN, USER_CREATE, USER_OWNER, USER_RW, USER_RO, USER_GROUP_CREATE, USER_GROUP_ADMIN, USER_GROUP_READ, USER_GROUP_WRITE);
        TestAccessController.verifyIfEmptyList(listTablesAction, USER_NONE);
    }

    @Test(timeout=180000L)
    public void testTableDeletion() throws Exception {
        User TABLE_ADMIN = User.createUserForTesting((Configuration)conf, (String)"TestUser", (String[])new String[0]);
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTestTable(tableName);
        TestAccessController.grantOnTable(TEST_UTIL, TABLE_ADMIN.getShortName(), tableName, null, null, Permission.Action.ADMIN);
        SecureTestUtil.AccessTestAction deleteTableAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Connection unmanagedConnection = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
                Admin admin = unmanagedConnection.getAdmin();
                try {
                    SecureTestUtil.deleteTable(TEST_UTIL, admin, tableName);
                }
                finally {
                    admin.close();
                    unmanagedConnection.close();
                }
                return null;
            }
        };
        TestAccessController.verifyDenied(deleteTableAction, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE);
        TestAccessController.verifyAllowed(deleteTableAction, TABLE_ADMIN);
    }

    private void createTestTable(TableName tname) throws Exception {
        HTableDescriptor htd = new HTableDescriptor(tname);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(100);
        htd.addFamily(hcd);
        htd.setOwner(USER_OWNER);
        TestAccessController.createTable(TEST_UTIL, (TableDescriptor)htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
    }

    @Test(timeout=180000L)
    public void testNamespaceUserGrant() throws Exception {
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        String namespace = TEST_TABLE.getNamespaceAsString();
        TestAccessController.grantOnNamespace(TEST_UTIL, USER_NONE.getShortName(), namespace, Permission.Action.READ);
        TestAccessController.verifyAllowed(getAction, USER_NONE);
        TestAccessController.revokeFromNamespace(TEST_UTIL, USER_NONE.getShortName(), namespace, Permission.Action.READ);
        TestAccessController.verifyDenied(getAction, USER_NONE);
    }

    @Test(timeout=180000L)
    public void testAccessControlClientGrantRevoke() throws Exception {
        User testGrantRevoke = User.createUserForTesting((Configuration)conf, (String)"testGrantRevoke", (String[])new String[0]);
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        TestAccessController.verifyDenied(getAction, testGrantRevoke);
        try {
            TestAccessController.grantOnTableUsingAccessControlClient(TEST_UTIL, systemUserConnection, testGrantRevoke.getShortName(), TEST_TABLE, null, null, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        TestAccessController.verifyAllowed(getAction, testGrantRevoke);
        try {
            TestAccessController.revokeFromTableUsingAccessControlClient(TEST_UTIL, systemUserConnection, testGrantRevoke.getShortName(), TEST_TABLE, null, null, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.revoke ", e);
        }
        TestAccessController.verifyDenied(getAction, testGrantRevoke);
    }

    @Test(timeout=180000L)
    public void testAccessControlClientGlobalGrantRevoke() throws Exception {
        User testGlobalGrantRevoke = User.createUserForTesting((Configuration)conf, (String)"testGlobalGrantRevoke", (String[])new String[0]);
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        TestAccessController.verifyDenied(getAction, testGlobalGrantRevoke);
        String userName = testGlobalGrantRevoke.getShortName();
        try {
            TestAccessController.grantGlobalUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        try {
            TestAccessController.verifyAllowed(getAction, testGlobalGrantRevoke);
        }
        catch (Exception e) {
            TestAccessController.revokeGlobal(TEST_UTIL, userName, Permission.Action.READ);
            throw e;
        }
        try {
            TestAccessController.revokeGlobalUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.revoke ", e);
        }
        TestAccessController.verifyDenied(getAction, testGlobalGrantRevoke);
    }

    @Test(timeout=180000L)
    public void testAccessControlClientMultiGrantRevoke() throws Exception {
        User testGrantRevoke = User.createUserForTesting((Configuration)conf, (String)"testGrantRevoke", (String[])new String[0]);
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        SecureTestUtil.AccessTestAction putAction = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        TestAccessController.verifyDenied(getAction, testGrantRevoke);
        TestAccessController.verifyDenied(putAction, testGrantRevoke);
        String userName = testGrantRevoke.getShortName();
        try {
            TestAccessController.grantGlobalUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        TestAccessController.verifyAllowed(getAction, testGrantRevoke);
        TestAccessController.verifyDenied(putAction, testGrantRevoke);
        try {
            TestAccessController.grantGlobalUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, Permission.Action.WRITE);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        TestAccessController.verifyAllowed(getAction, testGrantRevoke);
        TestAccessController.verifyAllowed(putAction, testGrantRevoke);
        try {
            TestAccessController.revokeGlobalUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, Permission.Action.READ, Permission.Action.WRITE);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.revoke ", e);
        }
        TestAccessController.verifyDenied(getAction, testGrantRevoke);
        TestAccessController.verifyDenied(putAction, testGrantRevoke);
        try {
            TestAccessController.grantOnTableUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, TEST_TABLE, null, null, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        TestAccessController.verifyAllowed(getAction, testGrantRevoke);
        TestAccessController.verifyDenied(putAction, testGrantRevoke);
        try {
            TestAccessController.grantOnTableUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, TEST_TABLE, null, null, Permission.Action.WRITE);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        TestAccessController.verifyAllowed(getAction, testGrantRevoke);
        TestAccessController.verifyAllowed(putAction, testGrantRevoke);
        try {
            TestAccessController.revokeFromTableUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, TEST_TABLE, null, null, Permission.Action.READ, Permission.Action.WRITE);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.revoke ", e);
        }
        TestAccessController.verifyDenied(getAction, testGrantRevoke);
        TestAccessController.verifyDenied(putAction, testGrantRevoke);
        String namespace = TEST_TABLE.getNamespaceAsString();
        try {
            TestAccessController.grantOnNamespaceUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, namespace, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        TestAccessController.verifyAllowed(getAction, testGrantRevoke);
        TestAccessController.verifyDenied(putAction, testGrantRevoke);
        try {
            TestAccessController.grantOnNamespaceUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, namespace, Permission.Action.WRITE);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        TestAccessController.verifyAllowed(getAction, testGrantRevoke);
        TestAccessController.verifyAllowed(putAction, testGrantRevoke);
        try {
            TestAccessController.revokeFromNamespaceUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, TEST_TABLE.getNamespaceAsString(), Permission.Action.READ, Permission.Action.WRITE);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.revoke ", e);
        }
        TestAccessController.verifyDenied(getAction, testGrantRevoke);
        TestAccessController.verifyDenied(putAction, testGrantRevoke);
    }

    @Test(timeout=180000L)
    public void testAccessControlClientGrantRevokeOnNamespace() throws Exception {
        User testNS = User.createUserForTesting((Configuration)conf, (String)"testNS", (String[])new String[0]);
        SecureTestUtil.AccessTestAction getAction = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        TestAccessController.verifyDenied(getAction, testNS);
        String userName = testNS.getShortName();
        String namespace = TEST_TABLE.getNamespaceAsString();
        try {
            TestAccessController.grantOnNamespaceUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, namespace, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.grant. ", e);
        }
        try {
            TestAccessController.verifyAllowed(getAction, testNS);
        }
        catch (Exception e) {
            TestAccessController.revokeFromNamespace(TEST_UTIL, userName, namespace, Permission.Action.READ);
            throw e;
        }
        try {
            TestAccessController.revokeFromNamespaceUsingAccessControlClient(TEST_UTIL, systemUserConnection, userName, namespace, Permission.Action.READ);
        }
        catch (Throwable e) {
            LOG.error((Object)"error during call of AccessControlClient.revoke ", e);
        }
        TestAccessController.verifyDenied(getAction, testNS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testCoprocessorExec() throws Exception {
        for (JVMClusterUtil.RegionServerThread thread : TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            HRegionServer rs = thread.getRegionServer();
            for (HRegion region : rs.getRegions(TEST_TABLE)) {
                region.getCoprocessorHost().load(PingCoprocessor.class, 0x3FFFFFFF, conf);
            }
        }
        User userA = User.createUserForTesting((Configuration)conf, (String)"UserA", (String[])new String[0]);
        User userB = User.createUserForTesting((Configuration)conf, (String)"UserB", (String[])new String[0]);
        TestAccessController.grantOnTable(TEST_UTIL, userA.getShortName(), TEST_TABLE, null, null, Permission.Action.EXEC);
        try {
            SecureTestUtil.AccessTestAction execEndpointAction = new SecureTestUtil.AccessTestAction(){

                @Override
                public Object run() throws Exception {
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Table t = conn.getTable(TEST_TABLE);){
                        CoprocessorRpcChannel service = t.coprocessorService(HConstants.EMPTY_BYTE_ARRAY);
                        PingCoprocessor.newBlockingStub((BlockingRpcChannel)service).noop(null, PingProtos.NoopRequest.newBuilder().build());
                    }
                    return null;
                }
            };
            String namespace = TEST_TABLE.getNamespaceAsString();
            TestAccessController.grantOnNamespace(TEST_UTIL, userB.getShortName(), namespace, Permission.Action.EXEC);
            TestAccessController.verifyAllowed(execEndpointAction, userA, userB);
            TestAccessController.revokeFromNamespace(TEST_UTIL, userB.getShortName(), namespace, Permission.Action.EXEC);
            TestAccessController.verifyDenied(execEndpointAction, userB);
            TestAccessController.verifyAllowed(execEndpointAction, userA);
        }
        catch (Throwable throwable) {
            TestAccessController.revokeFromTable(TEST_UTIL, userA.getShortName(), TEST_TABLE, null, null, Permission.Action.EXEC);
            throw throwable;
        }
        TestAccessController.revokeFromTable(TEST_UTIL, userA.getShortName(), TEST_TABLE, null, null, Permission.Action.EXEC);
    }

    @Test(timeout=180000L)
    public void testSetQuota() throws Exception {
        SecureTestUtil.AccessTestAction setUserQuotaAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetUserQuota(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), null, null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction setUserTableQuotaAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetUserQuota(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), null, TEST_TABLE, null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction setUserNamespaceQuotaAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetUserQuota(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), null, (String)null, null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction setTableQuotaAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetTableQuota(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), TEST_TABLE, null);
                return null;
            }
        };
        SecureTestUtil.AccessTestAction setNamespaceQuotaAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSetNamespaceQuota(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(setUserQuotaAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(setUserQuotaAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestAccessController.verifyAllowed(setUserTableQuotaAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(setUserTableQuotaAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestAccessController.verifyAllowed(setUserNamespaceQuotaAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(setUserNamespaceQuotaAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestAccessController.verifyAllowed(setTableQuotaAction, SUPERUSER, USER_ADMIN, USER_OWNER, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(setTableQuotaAction, USER_CREATE, USER_RW, USER_RO, USER_NONE);
        TestAccessController.verifyAllowed(setNamespaceQuotaAction, SUPERUSER, USER_ADMIN, USER_GROUP_ADMIN);
        TestAccessController.verifyDenied(setNamespaceQuotaAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test(timeout=180000L)
    public void testGetNamespacePermission() throws Exception {
        String namespace = "testGetNamespacePermission";
        NamespaceDescriptor desc = NamespaceDescriptor.create((String)namespace).build();
        TestAccessController.createNamespace(TEST_UTIL, desc);
        TestAccessController.grantOnNamespace(TEST_UTIL, USER_NONE.getShortName(), namespace, Permission.Action.READ);
        this.getNamespacePermissionsAndVerify(namespace, 1, namespace);
        this.getNamespacePermissionsAndVerify(".*", 1, namespace);
        this.getNamespacePermissionsAndVerify("^test[a-zA-Z]*", 1, namespace);
        TestAccessController.deleteNamespace(TEST_UTIL, namespace);
    }

    private void getNamespacePermissionsAndVerify(String namespaceRegexWithoutPrefix, int expectedAmount, String expectedNamespace) throws HBaseException {
        try {
            List namespacePermissions = AccessControlClient.getUserPermissions((Connection)systemUserConnection, (String)AccessControlLists.toNamespaceEntry((String)namespaceRegexWithoutPrefix));
            Assert.assertTrue((namespacePermissions != null ? 1 : 0) != 0);
            Assert.assertEquals((long)expectedAmount, (long)namespacePermissions.size());
            for (UserPermission namespacePermission : namespacePermissions) {
                Assert.assertFalse((boolean)namespacePermission.isGlobal());
                Assert.assertEquals((Object)expectedNamespace, (Object)namespacePermission.getNamespace());
            }
        }
        catch (Throwable thw) {
            throw new HBaseException(thw);
        }
    }

    @Test(timeout=180000L)
    public void testTruncatePerms() throws Exception {
        try {
            List existingPerms = AccessControlClient.getUserPermissions((Connection)systemUserConnection, (String)TEST_TABLE.getNameAsString());
            Assert.assertTrue((existingPerms != null ? 1 : 0) != 0);
            Assert.assertTrue((existingPerms.size() > 1 ? 1 : 0) != 0);
            TEST_UTIL.getAdmin().disableTable(TEST_TABLE);
            TEST_UTIL.truncateTable(TEST_TABLE);
            TEST_UTIL.waitTableAvailable(TEST_TABLE);
            List perms = AccessControlClient.getUserPermissions((Connection)systemUserConnection, (String)TEST_TABLE.getNameAsString());
            Assert.assertTrue((perms != null ? 1 : 0) != 0);
            Assert.assertEquals((long)existingPerms.size(), (long)perms.size());
        }
        catch (Throwable e) {
            throw new HBaseIOException(e);
        }
    }

    private PrivilegedAction<List<UserPermission>> getPrivilegedAction(final String regex) {
        return new PrivilegedAction<List<UserPermission>>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<UserPermission> run() {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    List list = AccessControlClient.getUserPermissions((Connection)conn, (String)regex);
                    return list;
                }
                catch (Throwable e) {
                    LOG.error((Object)"error during call of AccessControlClient.getUserPermissions.", e);
                    return null;
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testAccessControlClientUserPerms() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTestTable(tableName);
        try {
            String regex = tableName.getNameWithNamespaceInclAsString();
            User testUserPerms = User.createUserForTesting((Configuration)conf, (String)"testUserPerms", (String[])new String[0]);
            Assert.assertEquals((long)0L, (long)((List)testUserPerms.runAs(this.getPrivilegedAction(regex))).size());
            TestAccessController.grantOnTable(TEST_UTIL, testUserPerms.getShortName(), tableName, null, null, Permission.Action.ADMIN);
            List perms = (List)testUserPerms.runAs(this.getPrivilegedAction(regex));
            Assert.assertNotNull((Object)perms);
            Assert.assertEquals((long)2L, (long)perms.size());
        }
        finally {
            TestAccessController.deleteTable(TEST_UTIL, tableName);
        }
    }

    @Test(timeout=180000L)
    public void testAccessControllerUserPermsRegexHandling() throws Exception {
        User testRegexHandler = User.createUserForTesting((Configuration)conf, (String)"testRegexHandling", (String[])new String[0]);
        String REGEX_ALL_TABLES = ".*";
        String tableName = this.name.getMethodName();
        TableName table1 = TableName.valueOf((String)tableName);
        byte[] family = Bytes.toBytes((String)"f1");
        Admin admin = TEST_UTIL.getAdmin();
        HTableDescriptor htd = new HTableDescriptor(table1);
        htd.addFamily(new HColumnDescriptor(family));
        TestAccessController.createTable(TEST_UTIL, (TableDescriptor)htd);
        String ns = "testNamespace";
        NamespaceDescriptor desc = NamespaceDescriptor.create((String)ns).build();
        TableName table2 = TableName.valueOf((String)ns, (String)tableName);
        TestAccessController.createNamespace(TEST_UTIL, desc);
        htd = new HTableDescriptor(table2);
        htd.addFamily(new HColumnDescriptor(family));
        TestAccessController.createTable(TEST_UTIL, (TableDescriptor)htd);
        String aclTableName = AccessControlLists.ACL_TABLE_NAME.getNameAsString();
        Assert.assertEquals((long)5L, (long)((List)SUPERUSER.runAs(this.getPrivilegedAction(aclTableName))).size());
        Assert.assertEquals((long)0L, (long)((List)testRegexHandler.runAs(this.getPrivilegedAction(aclTableName))).size());
        Assert.assertEquals((long)0L, (long)((List)testRegexHandler.runAs(this.getPrivilegedAction(".*"))).size());
        TestAccessController.grantOnTable(TEST_UTIL, testRegexHandler.getShortName(), table1, null, null, Permission.Action.ADMIN);
        Assert.assertEquals((long)2L, (long)((List)testRegexHandler.runAs(this.getPrivilegedAction(".*"))).size());
        TestAccessController.grantOnTable(TEST_UTIL, testRegexHandler.getShortName(), table2, null, null, Permission.Action.ADMIN);
        Assert.assertEquals((long)4L, (long)((List)testRegexHandler.runAs(this.getPrivilegedAction(".*"))).size());
        Assert.assertEquals((long)2L, (long)((List)testRegexHandler.runAs(this.getPrivilegedAction(tableName))).size());
        Assert.assertEquals((long)2L, (long)((List)testRegexHandler.runAs(this.getPrivilegedAction(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + ':' + tableName))).size());
        Assert.assertEquals((long)2L, (long)((List)testRegexHandler.runAs(this.getPrivilegedAction(ns + ':' + tableName))).size());
        Assert.assertEquals((long)0L, (long)((List)testRegexHandler.runAs(this.getPrivilegedAction("notMatchingAny"))).size());
        TestAccessController.deleteTable(TEST_UTIL, table1);
        TestAccessController.deleteTable(TEST_UTIL, table2);
        TestAccessController.deleteNamespace(TEST_UTIL, ns);
    }

    private void verifyAnyCreate(SecureTestUtil.AccessTestAction action) throws Exception {
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_ADMIN_CF, USER_GROUP_CREATE);
        TestAccessController.verifyDenied(action, USER_NONE, USER_RO, USER_RW, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_ADMIN);
    }

    @Test(timeout=180000L)
    public void testPrepareAndCleanBulkLoad() throws Exception {
        SecureTestUtil.AccessTestAction prepareBulkLoadAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.prePrepareBulkLoad(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RCP_ENV));
                return null;
            }
        };
        SecureTestUtil.AccessTestAction cleanupBulkLoadAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCleanupBulkLoad(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RCP_ENV));
                return null;
            }
        };
        this.verifyAnyCreate(prepareBulkLoadAction);
        this.verifyAnyCreate(cleanupBulkLoadAction);
    }

    @Test(timeout=180000L)
    public void testReplicateLogEntries() throws Exception {
        SecureTestUtil.AccessTestAction replicateLogEntriesAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preReplicateLogEntries(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RSCP_ENV));
                ACCESS_CONTROLLER.postReplicateLogEntries(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)RSCP_ENV));
                return null;
            }
        };
        TestAccessController.verifyAllowed(replicateLogEntriesAction, SUPERUSER, USER_ADMIN, USER_GROUP_WRITE);
        TestAccessController.verifyDenied(replicateLogEntriesAction, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER, USER_GROUP_READ, USER_GROUP_ADMIN, USER_GROUP_CREATE);
    }

    @Test
    public void testMoveServers() throws Exception {
        SecureTestUtil.AccessTestAction action1 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preMoveServers(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action1, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action1, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testMoveTables() throws Exception {
        SecureTestUtil.AccessTestAction action1 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preMoveTables(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action1, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action1, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testAddGroup() throws Exception {
        SecureTestUtil.AccessTestAction action1 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAddRSGroup(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action1, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action1, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testRemoveGroup() throws Exception {
        SecureTestUtil.AccessTestAction action1 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRemoveRSGroup(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action1, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action1, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testBalanceGroup() throws Exception {
        SecureTestUtil.AccessTestAction action1 = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalanceRSGroup(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action1, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action1, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testAddReplicationPeer() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAddReplicationPeer(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), "test", null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testRemoveReplicationPeer() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRemoveReplicationPeer(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), "test");
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testEnableReplicationPeer() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preEnableReplicationPeer(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), "test");
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testDisableReplicationPeer() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDisableReplicationPeer(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), "test");
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testGetReplicationPeerConfig() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preGetReplicationPeerConfig(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), "test");
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testUpdateReplicationPeerConfig() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preUpdateReplicationPeerConfig(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), "test", new ReplicationPeerConfig());
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testListReplicationPeers() throws Exception {
        SecureTestUtil.AccessTestAction action = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preListReplicationPeers(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), "test");
                return null;
            }
        };
        TestAccessController.verifyAllowed(action, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(action, USER_CREATE, USER_RW, USER_RO, USER_NONE, USER_OWNER);
    }

    @Test
    public void testRemoteLocks() throws Exception {
        final String namespace = "preQueueNs";
        final TableName tableName = TableName.valueOf((String)namespace, (String)this.name.getMethodName());
        final HRegionInfo[] regionInfos = new HRegionInfo[]{new HRegionInfo(tableName)};
        User namespaceUser = User.createUserForTesting((Configuration)conf, (String)"qLNSUser", (String[])new String[0]);
        User tableACUser = User.createUserForTesting((Configuration)conf, (String)"qLTableACUser", (String[])new String[0]);
        User tableRWXUser = User.createUserForTesting((Configuration)conf, (String)"qLTableRWXUser", (String[])new String[0]);
        TestAccessController.grantOnTable(TEST_UTIL, tableRWXUser.getShortName(), tableName, null, null, Permission.Action.READ, Permission.Action.WRITE, Permission.Action.EXEC);
        User globalRWXUser = User.createUserForTesting((Configuration)conf, (String)"qLGlobalRWXUser", (String[])new String[0]);
        TestAccessController.grantGlobal(TEST_UTIL, globalRWXUser.getShortName(), Permission.Action.READ, Permission.Action.WRITE, Permission.Action.EXEC);
        SecureTestUtil.AccessTestAction namespaceLockAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRequestLock(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), namespace, null, null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(namespaceLockAction, SUPERUSER, USER_ADMIN);
        TestAccessController.verifyDenied(namespaceLockAction, globalRWXUser, tableACUser, namespaceUser, tableRWXUser);
        TestAccessController.grantOnNamespace(TEST_UTIL, namespaceUser.getShortName(), namespace, Permission.Action.ADMIN);
        Threads.sleep((long)1000L);
        TestAccessController.verifyAllowed(namespaceLockAction, namespaceUser);
        SecureTestUtil.AccessTestAction tableLockAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRequestLock(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), null, tableName, null, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(tableLockAction, SUPERUSER, USER_ADMIN, namespaceUser);
        TestAccessController.verifyDenied(tableLockAction, globalRWXUser, tableACUser, tableRWXUser);
        TestAccessController.grantOnTable(TEST_UTIL, tableACUser.getShortName(), tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        TestAccessController.verifyAllowed(tableLockAction, tableACUser);
        SecureTestUtil.AccessTestAction regionsLockAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRequestLock(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), null, null, (RegionInfo[])regionInfos, null);
                return null;
            }
        };
        TestAccessController.verifyAllowed(regionsLockAction, SUPERUSER, USER_ADMIN, namespaceUser, tableACUser);
        TestAccessController.verifyDenied(regionsLockAction, globalRWXUser, tableRWXUser);
        final LockProcedure proc = new LockProcedure(conf, tableName, LockType.EXCLUSIVE, "test", null);
        SecureTestUtil.AccessTestAction regionLockHeartbeatAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preLockHeartbeat(ObserverContextImpl.createAndPrepare((CoprocessorEnvironment)CP_ENV), proc.getTableName(), proc.getDescription());
                return null;
            }
        };
        TestAccessController.verifyAllowed(regionLockHeartbeatAction, SUPERUSER, USER_ADMIN, namespaceUser, tableACUser);
        TestAccessController.verifyDenied(regionLockHeartbeatAction, globalRWXUser, tableRWXUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessControlRevokeOnlyFewPermission() throws Throwable {
        TableName tname = TableName.valueOf((String)"revoke");
        try {
            TEST_UTIL.createTable(tname, TEST_FAMILY);
            User testUserPerms = User.createUserForTesting((Configuration)conf, (String)"revokePerms", (String[])new String[0]);
            Permission.Action[] actions = new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE};
            AccessControlClient.grant((Connection)TEST_UTIL.getConnection(), (TableName)tname, (String)testUserPerms.getShortName(), null, null, (Permission.Action[])actions);
            List userPermissions = AccessControlClient.getUserPermissions((Connection)TEST_UTIL.getConnection(), (String)tname.getNameAsString());
            Assert.assertEquals((long)2L, (long)userPermissions.size());
            AccessControlClient.revoke((Connection)TEST_UTIL.getConnection(), (TableName)tname, (String)testUserPerms.getShortName(), null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
            userPermissions = AccessControlClient.getUserPermissions((Connection)TEST_UTIL.getConnection(), (String)tname.getNameAsString());
            Assert.assertEquals((long)2L, (long)userPermissions.size());
            Object[] expectedAction = new Permission.Action[]{Permission.Action.READ};
            boolean userFound = false;
            for (UserPermission p : userPermissions) {
                if (!testUserPerms.getShortName().equals(Bytes.toString((byte[])p.getUser()))) continue;
                Assert.assertArrayEquals((Object[])expectedAction, (Object[])p.getActions());
                userFound = true;
                break;
            }
            Assert.assertTrue((boolean)userFound);
        }
        finally {
            TEST_UTIL.deleteTable(tname);
        }
    }

    static {
        Logger.getLogger(AccessController.class).setLevel(Level.TRACE);
        Logger.getLogger(AccessControlFilter.class).setLevel(Level.TRACE);
        Logger.getLogger(TableAuthManager.class).setLevel(Level.TRACE);
        TEST_TABLE = TableName.valueOf((String)"testtable1");
        TEST_UTIL = new HBaseTestingUtility();
        TEST_TABLE2 = TableName.valueOf((String)"testtable2");
        TEST_FAMILY = Bytes.toBytes((String)"f1");
        TEST_QUALIFIER = Bytes.toBytes((String)"q1");
        TEST_ROW = Bytes.toBytes((String)"r1");
    }

    public static class PingCoprocessor
    extends PingProtos.PingService
    implements RegionCoprocessor {
        public void start(CoprocessorEnvironment env) throws IOException {
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
        }

        public Iterable<Service> getServices() {
            return Collections.singleton(this);
        }

        public void ping(RpcController controller, PingProtos.PingRequest request, RpcCallback<PingProtos.PingResponse> callback) {
            callback.run((Object)PingProtos.PingResponse.newBuilder().setPong("Pong!").build());
        }

        public void count(RpcController controller, PingProtos.CountRequest request, RpcCallback<PingProtos.CountResponse> callback) {
            callback.run((Object)PingProtos.CountResponse.newBuilder().build());
        }

        public void increment(RpcController controller, PingProtos.IncrementCountRequest requet, RpcCallback<PingProtos.IncrementCountResponse> callback) {
            callback.run((Object)PingProtos.IncrementCountResponse.newBuilder().build());
        }

        public void hello(RpcController controller, PingProtos.HelloRequest request, RpcCallback<PingProtos.HelloResponse> callback) {
            callback.run((Object)PingProtos.HelloResponse.newBuilder().setResponse("Hello!").build());
        }

        public void noop(RpcController controller, PingProtos.NoopRequest request, RpcCallback<PingProtos.NoopResponse> callback) {
            callback.run((Object)PingProtos.NoopResponse.newBuilder().build());
        }
    }

    public class BulkLoadHelper {
        private final FileSystem fs = TestAccessController.access$000().getTestFileSystem();
        private final Path loadPath;
        private final Configuration conf = TestAccessController.access$000().getConfiguration();

        public BulkLoadHelper(Path loadPath) throws IOException {
            this.loadPath = loadPath = loadPath.makeQualified(this.fs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createHFile(Path path, byte[] family, byte[] qualifier, byte[] startKey, byte[] endKey, int numRows) throws IOException {
            long now = System.currentTimeMillis();
            try (HFile.Writer writer = null;){
                HFileContext context = new HFileContextBuilder().build();
                writer = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)new CacheConfig(this.conf)).withPath(this.fs, path).withFileContext(context).create();
                for (byte[] key : Bytes.iterateOnSplits((byte[])startKey, (byte[])endKey, (boolean)true, (int)(numRows - 2))) {
                    KeyValue kv = new KeyValue(key, family, qualifier, now, key);
                    writer.append((Cell)kv);
                }
            }
        }

        private void bulkLoadHFile(TableName tableName, byte[] family, byte[] qualifier, byte[][][] hfileRanges, int numRowsPerRange) throws Exception {
            Path familyDir = new Path(this.loadPath, Bytes.toString((byte[])family));
            this.fs.mkdirs(familyDir);
            int hfileIdx = 0;
            for (byte[][] range : hfileRanges) {
                byte[] from = range[0];
                byte[] to = range[1];
                this.createHFile(new Path(familyDir, "hfile_" + hfileIdx++), family, qualifier, from, to, numRowsPerRange);
            }
            this.setPermission(this.loadPath, FsPermission.valueOf((String)"-rwxrwxrwx"));
            try (Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);
                 Admin admin = conn.getAdmin();
                 RegionLocator locator = conn.getRegionLocator(tableName);
                 Table table = conn.getTable(tableName);){
                TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
                LoadIncrementalHFiles loader = new LoadIncrementalHFiles(this.conf);
                loader.doBulkLoad(this.loadPath, admin, table, locator);
            }
        }

        public void setPermission(Path dir, FsPermission perm) throws IOException {
            if (!this.fs.getFileStatus(dir).isDirectory()) {
                this.fs.setPermission(dir, perm);
            } else {
                for (FileStatus el : this.fs.listStatus(dir)) {
                    this.fs.setPermission(el.getPath(), perm);
                    this.setPermission(el.getPath(), perm);
                }
            }
        }
    }

    public static class TestTableDDLProcedure
    extends Procedure<MasterProcedureEnv>
    implements TableProcedureInterface {
        private TableName tableName;

        public TestTableDDLProcedure() {
        }

        public TestTableDDLProcedure(MasterProcedureEnv env, TableName tableName) throws IOException {
            this.tableName = tableName;
            this.setTimeout(180000);
            this.setOwner(env.getRequestUser());
        }

        public TableName getTableName() {
            return this.tableName;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.EDIT;
        }

        protected boolean abort(MasterProcedureEnv env) {
            return true;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
            TestProcedureProtos.TestTableDDLStateData.Builder testTableDDLMsg = TestProcedureProtos.TestTableDDLStateData.newBuilder().setTableName(this.tableName.getNameAsString());
            serializer.serialize((Message)testTableDDLMsg.build());
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
            TestProcedureProtos.TestTableDDLStateData testTableDDLMsg = (TestProcedureProtos.TestTableDDLStateData)serializer.deserialize(TestProcedureProtos.TestTableDDLStateData.class);
            this.tableName = TableName.valueOf((String)testTableDDLMsg.getTableName());
        }

        protected Procedure[] execute(MasterProcedureEnv env) throws ProcedureYieldException, InterruptedException {
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            return null;
        }

        protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        }
    }
}

