/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestFlushSnapshotFromClient {
    private static final Log LOG = LogFactory.getLog(TestFlushSnapshotFromClient.class);
    @ClassRule
    public static final TestRule timeout = CategoryBasedTimeout.forClass(TestFlushSnapshotFromClient.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected static final int NUM_RS = 2;
    protected static final byte[] TEST_FAM = Bytes.toBytes((String)"fam");
    protected static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    protected final int DEFAULT_NUM_ROWS = 100;
    protected Admin admin = null;

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestFlushSnapshotFromClient.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
    }

    protected static void setupConf(Configuration conf) {
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.compaction.min", 10);
        conf.setInt("hbase.hstore.compactionThreshold", 10);
        conf.setInt("hbase.hstore.blockingStoreFiles", 12);
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
    }

    @Before
    public void setup() throws Exception {
        this.createTable();
        this.admin = UTIL.getConnection().getAdmin();
    }

    protected void createTable() throws Exception {
        SnapshotTestingUtils.createTable(UTIL, TABLE_NAME, new byte[][]{TEST_FAM});
    }

    @After
    public void tearDown() throws Exception {
        UTIL.deleteTable(TABLE_NAME);
        SnapshotTestingUtils.deleteAllSnapshots(this.admin);
        this.admin.close();
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void testFlushTableSnapshot() throws Exception {
        SnapshotTestingUtils.assertNoSnapshots(this.admin);
        SnapshotTestingUtils.loadData(UTIL, TABLE_NAME, 100, (byte[][])new byte[][]{TEST_FAM});
        LOG.debug((Object)"FS state before snapshot:");
        UTIL.getHBaseCluster().getMaster().getMasterFileSystem().logFileSystemState(LOG);
        String snapshotString = "offlineTableSnapshot";
        byte[] snapshot = Bytes.toBytes((String)snapshotString);
        this.admin.snapshot(snapshotString, TABLE_NAME, SnapshotType.FLUSH);
        LOG.debug((Object)"Snapshot completed.");
        List<SnapshotDescription> snapshots = SnapshotTestingUtils.assertOneSnapshotThatMatches(this.admin, snapshot, TABLE_NAME);
        LOG.debug((Object)"FS state after snapshot:");
        UTIL.getHBaseCluster().getMaster().getMasterFileSystem().logFileSystemState(LOG);
        SnapshotTestingUtils.confirmSnapshotValid(UTIL, ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)snapshots.get(0)), TABLE_NAME, TEST_FAM);
    }

    @Test
    public void testSkipFlushTableSnapshot() throws Exception {
        SnapshotTestingUtils.assertNoSnapshots(this.admin);
        Table table = UTIL.getConnection().getTable(TABLE_NAME);
        UTIL.loadTable(table, TEST_FAM);
        UTIL.flush(TABLE_NAME);
        LOG.debug((Object)"FS state before snapshot:");
        UTIL.getHBaseCluster().getMaster().getMasterFileSystem().logFileSystemState(LOG);
        String snapshotString = "skipFlushTableSnapshot";
        byte[] snapshot = Bytes.toBytes((String)snapshotString);
        this.admin.snapshot(snapshotString, TABLE_NAME, SnapshotType.SKIPFLUSH);
        LOG.debug((Object)"Snapshot completed.");
        List snapshots = SnapshotTestingUtils.assertOneSnapshotThatMatches(this.admin, snapshot, TABLE_NAME);
        LOG.debug((Object)"FS state after snapshot:");
        UTIL.getHBaseCluster().getMaster().getMasterFileSystem().logFileSystemState(LOG);
        SnapshotTestingUtils.confirmSnapshotValid(UTIL, ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)snapshots.get(0)), TABLE_NAME, TEST_FAM);
        this.admin.deleteSnapshot(snapshot);
        snapshots = this.admin.listSnapshots();
        SnapshotTestingUtils.assertNoSnapshots(this.admin);
    }

    @Test
    public void testFlushTableSnapshotWithProcedure() throws Exception {
        SnapshotTestingUtils.assertNoSnapshots(this.admin);
        SnapshotTestingUtils.loadData(UTIL, TABLE_NAME, 100, (byte[][])new byte[][]{TEST_FAM});
        LOG.debug((Object)"FS state before snapshot:");
        UTIL.getHBaseCluster().getMaster().getMasterFileSystem().logFileSystemState(LOG);
        String snapshotString = "offlineTableSnapshot";
        byte[] snapshot = Bytes.toBytes((String)snapshotString);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("table", TABLE_NAME.getNameAsString());
        this.admin.execProcedure("online-snapshot", snapshotString, props);
        LOG.debug((Object)"Snapshot completed.");
        List<SnapshotDescription> snapshots = SnapshotTestingUtils.assertOneSnapshotThatMatches(this.admin, snapshot, TABLE_NAME);
        LOG.debug((Object)"FS state after snapshot:");
        UTIL.getHBaseCluster().getMaster().getMasterFileSystem().logFileSystemState(LOG);
        SnapshotTestingUtils.confirmSnapshotValid(UTIL, ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)snapshots.get(0)), TABLE_NAME, TEST_FAM);
    }

    @Test
    public void testSnapshotFailsOnNonExistantTable() throws Exception {
        SnapshotTestingUtils.assertNoSnapshots(this.admin);
        TableName tableName = TableName.valueOf((String)"_not_a_table");
        boolean fail = false;
        do {
            try {
                this.admin.getTableDescriptor(tableName);
                fail = true;
                LOG.error((Object)("Table:" + tableName + " already exists, checking a new name"));
                tableName = TableName.valueOf((String)(tableName + "!"));
            }
            catch (TableNotFoundException e) {
                fail = false;
            }
        } while (fail);
        try {
            this.admin.snapshot("fail", tableName, SnapshotType.FLUSH);
            Assert.fail((String)"Snapshot succeeded even though there is not table.");
        }
        catch (SnapshotCreationException e) {
            LOG.info((Object)("Correctly failed to snapshot a non-existant table:" + e.getMessage()));
        }
    }

    @Test
    public void testAsyncFlushSnapshot() throws Exception {
        SnapshotProtos.SnapshotDescription snapshot = SnapshotProtos.SnapshotDescription.newBuilder().setName("asyncSnapshot").setTable(TABLE_NAME.getNameAsString()).setType(SnapshotProtos.SnapshotDescription.Type.FLUSH).build();
        this.admin.takeSnapshotAsync(new SnapshotDescription("asyncSnapshot", TABLE_NAME, SnapshotType.FLUSH));
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        SnapshotTestingUtils.waitForSnapshotToComplete(master, snapshot, 200L);
        LOG.info((Object)" === Async Snapshot Completed ===");
        UTIL.getHBaseCluster().getMaster().getMasterFileSystem().logFileSystemState(LOG);
        SnapshotTestingUtils.assertOneSnapshotThatMatches(this.admin, snapshot);
    }

    @Test
    public void testSnapshotStateAfterMerge() throws Exception {
        int numRows = 100;
        SnapshotTestingUtils.assertNoSnapshots(this.admin);
        SnapshotTestingUtils.loadData(UTIL, TABLE_NAME, numRows, (byte[][])new byte[][]{TEST_FAM});
        String snapshotBeforeMergeName = "snapshotBeforeMerge";
        this.admin.snapshot(snapshotBeforeMergeName, TABLE_NAME, SnapshotType.FLUSH);
        TableName cloneBeforeMergeName = TableName.valueOf((String)"cloneBeforeMerge");
        this.admin.cloneSnapshot(snapshotBeforeMergeName, cloneBeforeMergeName);
        SnapshotTestingUtils.waitForTableToBeOnline(UTIL, cloneBeforeMergeName);
        List regions = this.admin.getTableRegions(TABLE_NAME);
        Collections.sort(regions, new Comparator<HRegionInfo>(){

            @Override
            public int compare(HRegionInfo r1, HRegionInfo r2) {
                return Bytes.compareTo((byte[])r1.getStartKey(), (byte[])r2.getStartKey());
            }
        });
        int numRegions = this.admin.getTableRegions(TABLE_NAME).size();
        int numRegionsAfterMerge = numRegions - 2;
        this.admin.mergeRegionsAsync(((HRegionInfo)regions.get(1)).getEncodedNameAsBytes(), ((HRegionInfo)regions.get(2)).getEncodedNameAsBytes(), true);
        this.admin.mergeRegionsAsync(((HRegionInfo)regions.get(4)).getEncodedNameAsBytes(), ((HRegionInfo)regions.get(5)).getEncodedNameAsBytes(), true);
        this.waitRegionsAfterMerge(numRegionsAfterMerge);
        Assert.assertEquals((long)numRegionsAfterMerge, (long)this.admin.getTableRegions(TABLE_NAME).size());
        TableName cloneAfterMergeName = TableName.valueOf((String)"cloneAfterMerge");
        this.admin.cloneSnapshot(snapshotBeforeMergeName, cloneAfterMergeName);
        SnapshotTestingUtils.waitForTableToBeOnline(UTIL, cloneAfterMergeName);
        this.verifyRowCount(UTIL, TABLE_NAME, numRows);
        this.verifyRowCount(UTIL, cloneBeforeMergeName, numRows);
        this.verifyRowCount(UTIL, cloneAfterMergeName, numRows);
        UTIL.deleteTable(cloneAfterMergeName);
        UTIL.deleteTable(cloneBeforeMergeName);
    }

    @Test
    public void testTakeSnapshotAfterMerge() throws Exception {
        int numRows = 100;
        SnapshotTestingUtils.assertNoSnapshots(this.admin);
        SnapshotTestingUtils.loadData(UTIL, TABLE_NAME, numRows, (byte[][])new byte[][]{TEST_FAM});
        List regions = this.admin.getTableRegions(TABLE_NAME);
        Collections.sort(regions, new Comparator<HRegionInfo>(){

            @Override
            public int compare(HRegionInfo r1, HRegionInfo r2) {
                return Bytes.compareTo((byte[])r1.getStartKey(), (byte[])r2.getStartKey());
            }
        });
        int numRegions = this.admin.getTableRegions(TABLE_NAME).size();
        int numRegionsAfterMerge = numRegions - 2;
        this.admin.mergeRegionsAsync(((HRegionInfo)regions.get(1)).getEncodedNameAsBytes(), ((HRegionInfo)regions.get(2)).getEncodedNameAsBytes(), true);
        this.admin.mergeRegionsAsync(((HRegionInfo)regions.get(4)).getEncodedNameAsBytes(), ((HRegionInfo)regions.get(5)).getEncodedNameAsBytes(), true);
        this.waitRegionsAfterMerge(numRegionsAfterMerge);
        Assert.assertEquals((long)numRegionsAfterMerge, (long)this.admin.getTableRegions(TABLE_NAME).size());
        String snapshotName = "snapshotAfterMerge";
        SnapshotTestingUtils.snapshot(this.admin, snapshotName, TABLE_NAME, SnapshotType.FLUSH, 3);
        TableName cloneName = TableName.valueOf((String)"cloneMerge");
        this.admin.cloneSnapshot(snapshotName, cloneName);
        SnapshotTestingUtils.waitForTableToBeOnline(UTIL, cloneName);
        this.verifyRowCount(UTIL, TABLE_NAME, numRows);
        this.verifyRowCount(UTIL, cloneName, numRows);
        UTIL.deleteTable(cloneName);
    }

    @Test
    public void testFlushCreateListDestroy() throws Exception {
        LOG.debug((Object)"------- Starting Snapshot test -------------");
        SnapshotTestingUtils.assertNoSnapshots(this.admin);
        SnapshotTestingUtils.loadData(UTIL, TABLE_NAME, 100, (byte[][])new byte[][]{TEST_FAM});
        String snapshotName = "flushSnapshotCreateListDestroy";
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        SnapshotTestingUtils.createSnapshotAndValidate(this.admin, TABLE_NAME, Bytes.toString((byte[])TEST_FAM), snapshotName, rootDir, fs, true);
    }

    @Test
    public void testConcurrentSnapshottingAttempts() throws IOException, InterruptedException {
        int i;
        TableName TABLE2_NAME = TableName.valueOf((String)(TABLE_NAME + "2"));
        int ssNum = 20;
        SnapshotTestingUtils.assertNoSnapshots(this.admin);
        SnapshotTestingUtils.createTable(UTIL, TABLE2_NAME, new byte[][]{TEST_FAM});
        SnapshotTestingUtils.loadData(UTIL, TABLE_NAME, 100, (byte[][])new byte[][]{TEST_FAM});
        SnapshotTestingUtils.loadData(UTIL, TABLE2_NAME, 100, (byte[][])new byte[][]{TEST_FAM});
        final CountDownLatch toBeSubmitted = new CountDownLatch(ssNum);
        SnapshotDescription[] descs = new SnapshotDescription[ssNum];
        for (i = 0; i < ssNum; ++i) {
            descs[i] = i % 2 == 0 ? new SnapshotDescription("ss" + i, TABLE_NAME, SnapshotType.FLUSH) : new SnapshotDescription("ss" + i, TABLE2_NAME, SnapshotType.FLUSH);
        }
        for (i = 0; i < ssNum; ++i) {
            class SSRunnable
            implements Runnable {
                SnapshotDescription ss;

                SSRunnable(SnapshotDescription ss) {
                    this.ss = ss;
                }

                @Override
                public void run() {
                    try {
                        LOG.info((Object)("Submitting snapshot request: " + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)this.ss))));
                        TestFlushSnapshotFromClient.this.admin.takeSnapshotAsync(this.ss);
                    }
                    catch (Exception e) {
                        LOG.info((Object)("Exception during snapshot request: " + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)this.ss)) + ".  This is ok, we expect some"), (Throwable)e);
                    }
                    LOG.info((Object)("Submitted snapshot request: " + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)this.ss))));
                    toBeSubmitted.countDown();
                }
            }
            new Thread(new SSRunnable(descs[i])).start();
        }
        toBeSubmitted.await();
        while (true) {
            int doneCount = 0;
            for (SnapshotDescription ss : descs) {
                try {
                    if (!this.admin.isSnapshotFinished(ss)) continue;
                    ++doneCount;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Got an exception when checking for snapshot " + ss.getName()), (Throwable)e);
                    ++doneCount;
                }
            }
            if (doneCount == descs.length) break;
            Thread.sleep(100L);
        }
        UTIL.getHBaseCluster().getMaster().getMasterFileSystem().logFileSystemState(LOG);
        List taken = this.admin.listSnapshots();
        int takenSize = taken.size();
        LOG.info((Object)("Taken " + takenSize + " snapshots:  " + taken));
        Assert.assertTrue((String)"We expect at least 1 request to be rejected because of we concurrently issued many requests", (takenSize < ssNum && takenSize > 0 ? 1 : 0) != 0);
        int t1SnapshotsCount = 0;
        int t2SnapshotsCount = 0;
        for (SnapshotDescription ss : taken) {
            if (ss.getTableName().equals((Object)TABLE_NAME)) {
                ++t1SnapshotsCount;
                continue;
            }
            if (!ss.getTableName().equals((Object)TABLE2_NAME)) continue;
            ++t2SnapshotsCount;
        }
        Assert.assertTrue((String)"We expect at least 1 snapshot of table1 ", (t1SnapshotsCount > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"We expect at least 1 snapshot of table2 ", (t2SnapshotsCount > 0 ? 1 : 0) != 0);
        UTIL.deleteTable(TABLE2_NAME);
    }

    private void waitRegionsAfterMerge(long numRegionsAfterMerge) throws IOException, InterruptedException {
        long startTime = System.currentTimeMillis();
        while ((long)this.admin.getTableRegions(TABLE_NAME).size() != numRegionsAfterMerge && System.currentTimeMillis() - startTime <= 15000L) {
            Thread.sleep(100L);
        }
        SnapshotTestingUtils.waitForTableToBeOnline(UTIL, TABLE_NAME);
    }

    protected void verifyRowCount(HBaseTestingUtility util, TableName tableName, long expectedRows) throws IOException {
        SnapshotTestingUtils.verifyRowCount(util, tableName, expectedRows);
    }

    protected int countRows(Table table, byte[] ... families) throws IOException {
        return UTIL.countRows(table, families);
    }
}

