/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MultiThreadedWriterBase;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.apache.hadoop.util.StringUtils;

public class MultiThreadedWriter
extends MultiThreadedWriterBase {
    private static final Log LOG = LogFactory.getLog(MultiThreadedWriter.class);
    protected Set<HBaseWriterThread> writers = new HashSet<HBaseWriterThread>();
    protected boolean isMultiPut = false;

    public MultiThreadedWriter(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName) throws IOException {
        super(dataGen, conf, tableName, "W");
    }

    public void setMultiPut(boolean isMultiPut) {
        this.isMultiPut = isMultiPut;
    }

    @Override
    public void start(long startKey, long endKey, int numThreads) throws IOException {
        super.start(startKey, endKey, numThreads);
        if (this.verbose) {
            LOG.debug((Object)("Inserting keys [" + startKey + ", " + endKey + ")"));
        }
        this.createWriterThreads(numThreads);
        this.startThreads(this.writers);
    }

    protected void createWriterThreads(int numThreads) throws IOException {
        for (int i = 0; i < numThreads; ++i) {
            HBaseWriterThread writer = new HBaseWriterThread(i);
            Threads.setLoggingUncaughtExceptionHandler((Thread)writer);
            this.writers.add(writer);
        }
    }

    @Override
    public void waitForFinish() {
        super.waitForFinish();
        System.out.println("Failed to write keys: " + this.failedKeySet.size());
        for (Long key : this.failedKeySet) {
            System.out.println("Failed to write key: " + key);
        }
    }

    public class HBaseWriterThread
    extends Thread {
        private final Table table;

        public HBaseWriterThread(int writerId) throws IOException {
            this.setName(this.getClass().getSimpleName() + "_" + writerId);
            this.table = this.createTable();
        }

        protected Table createTable() throws IOException {
            return MultiThreadedWriter.this.connection.getTable(MultiThreadedWriter.this.tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long rowKeyBase;
                byte[][] columnFamilies = MultiThreadedWriter.this.dataGenerator.getColumnFamilies();
                while ((rowKeyBase = MultiThreadedWriter.this.nextKeyToWrite.getAndIncrement()) < MultiThreadedWriter.this.endKey) {
                    byte[] rowKey = MultiThreadedWriter.this.dataGenerator.getDeterministicUniqueKey(rowKeyBase);
                    Put put = new Put(rowKey);
                    MultiThreadedWriter.this.numKeys.addAndGet(1L);
                    int columnCount = 0;
                    for (byte[] cf : columnFamilies) {
                        byte[][] columns;
                        for (byte[] column : columns = MultiThreadedWriter.this.dataGenerator.generateColumnsForCf(rowKey, cf)) {
                            byte[] value = MultiThreadedWriter.this.dataGenerator.generateValue(rowKey, cf, column);
                            put.addColumn(cf, column, value);
                            ++columnCount;
                            if (MultiThreadedWriter.this.isMultiPut) continue;
                            this.insert(this.table, put, rowKeyBase);
                            MultiThreadedWriter.this.numCols.addAndGet(1L);
                            put = new Put(rowKey);
                        }
                        long rowKeyHash = Arrays.hashCode(rowKey);
                        put.addColumn(cf, LoadTestDataGenerator.MUTATE_INFO, HConstants.EMPTY_BYTE_ARRAY);
                        put.addColumn(cf, LoadTestDataGenerator.INCREMENT, Bytes.toBytes((long)rowKeyHash));
                        if (MultiThreadedWriter.this.isMultiPut) continue;
                        this.insert(this.table, put, rowKeyBase);
                        MultiThreadedWriter.this.numCols.addAndGet(1L);
                        put = new Put(rowKey);
                    }
                    if (MultiThreadedWriter.this.isMultiPut) {
                        if (MultiThreadedWriter.this.verbose) {
                            LOG.debug((Object)("Preparing put for key = [" + rowKey + "], " + columnCount + " columns"));
                        }
                        this.insert(this.table, put, rowKeyBase);
                        MultiThreadedWriter.this.numCols.addAndGet(columnCount);
                    }
                    if (!MultiThreadedWriter.this.trackWroteKeys) continue;
                    MultiThreadedWriter.this.wroteKeys.add(rowKeyBase);
                }
            }
            finally {
                this.closeHTable();
                MultiThreadedWriter.this.numThreadsWorking.decrementAndGet();
            }
        }

        public void insert(Table table, Put put, long keyBase) {
            long start = System.currentTimeMillis();
            try {
                put = (Put)MultiThreadedWriter.this.dataGenerator.beforeMutate(keyBase, (Mutation)put);
                table.put(put);
                MultiThreadedWriter.this.totalOpTimeMs.addAndGet(System.currentTimeMillis() - start);
            }
            catch (IOException e) {
                String exceptionInfo;
                MultiThreadedWriter.this.failedKeySet.add(keyBase);
                if (e instanceof RetriesExhaustedWithDetailsException) {
                    RetriesExhaustedWithDetailsException aggEx = (RetriesExhaustedWithDetailsException)((Object)e);
                    exceptionInfo = aggEx.getExhaustiveDescription();
                } else {
                    StringWriter stackWriter = new StringWriter();
                    PrintWriter pw = new PrintWriter(stackWriter);
                    e.printStackTrace(pw);
                    pw.flush();
                    exceptionInfo = StringUtils.stringifyException((Throwable)e);
                }
                LOG.error((Object)("Failed to insert: " + keyBase + " after " + (System.currentTimeMillis() - start) + "ms; region information: " + MultiThreadedWriter.this.getRegionDebugInfoSafe(table, put.getRow()) + "; errors: " + exceptionInfo));
            }
        }

        protected void closeHTable() {
            try {
                if (this.table != null) {
                    this.table.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing table", (Throwable)e);
            }
        }
    }
}

