/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestCompressionTest {
    private static final Log LOG = LogFactory.getLog(TestCompressionTest.class);

    @Test
    public void testExceptionCaching() {
        try {
            CompressionTest.testCompression((Compression.Algorithm)Compression.Algorithm.LZO);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getCause());
        }
        try {
            CompressionTest.testCompression((Compression.Algorithm)Compression.Algorithm.LZO);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertNull((Object)e.getCause());
        }
        Assert.assertFalse((boolean)CompressionTest.testCompression((String)"LZO"));
    }

    @Test
    public void testTestCompression() {
        Assert.assertTrue((boolean)CompressionTest.testCompression((String)"NONE"));
        Assert.assertTrue((boolean)CompressionTest.testCompression((String)"GZ"));
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            this.nativeCodecTest("LZO", "lzo2", "com.hadoop.compression.lzo.LzoCodec");
            this.nativeCodecTest("LZ4", null, "org.apache.hadoop.io.compress.Lz4Codec");
            this.nativeCodecTest("SNAPPY", "snappy", "org.apache.hadoop.io.compress.SnappyCodec");
            this.nativeCodecTest("BZIP2", "bzip2", "org.apache.hadoop.io.compress.BZip2Codec");
            this.nativeCodecTest("ZSTD", "zstd", "org.apache.hadoop.io.compress.ZStandardCodec");
        } else {
            LOG.debug((Object)"Native code not loaded");
            Assert.assertFalse((boolean)CompressionTest.testCompression((String)"LZO"));
            Assert.assertFalse((boolean)CompressionTest.testCompression((String)"LZ4"));
            Assert.assertFalse((boolean)CompressionTest.testCompression((String)"SNAPPY"));
            Assert.assertFalse((boolean)CompressionTest.testCompression((String)"BZIP2"));
            Assert.assertFalse((boolean)CompressionTest.testCompression((String)"ZSTD"));
        }
    }

    private boolean isCompressionAvailable(String codecClassName) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(codecClassName);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void nativeCodecTest(String codecName, String libName, String codecClassName) {
        if (this.isCompressionAvailable(codecClassName)) {
            try {
                if (libName != null) {
                    System.loadLibrary(libName);
                }
                try {
                    Configuration conf = new Configuration();
                    CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName(codecClassName), (Configuration)conf);
                    DataOutputBuffer compressedDataBuffer = new DataOutputBuffer();
                    CompressionOutputStream deflateFilter = codec.createOutputStream((OutputStream)compressedDataBuffer);
                    byte[] data = new byte[1024];
                    DataOutputStream deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)deflateFilter));
                    deflateOut.write(data, 0, data.length);
                    deflateOut.flush();
                    deflateFilter.finish();
                    Assert.assertTrue((boolean)CompressionTest.testCompression((String)codecName));
                }
                catch (UnsatisfiedLinkError e) {
                    LOG.debug((Object)("No JNI for codec '" + codecName + "' " + e.getMessage()));
                }
                catch (Exception e) {
                    LOG.error((Object)codecName, (Throwable)e);
                }
            }
            catch (UnsatisfiedLinkError e) {
                LOG.debug((Object)("Native lib not available: " + codecName));
                Assert.assertFalse((boolean)CompressionTest.testCompression((String)codecName));
            }
        } else {
            LOG.debug((Object)("Codec class not available: " + codecName));
            Assert.assertFalse((boolean)CompressionTest.testCompression((String)codecName));
        }
    }
}

