/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSHDFSUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.util.VersionInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MiscTests.class, MediumTests.class})
public class TestFSHDFSUtils {
    private static final Log LOG = LogFactory.getLog(TestFSHDFSUtils.class);
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private FSHDFSUtils fsHDFSUtils = new FSHDFSUtils();
    private static Path FILE;
    long startTime = -1L;

    @Before
    public void setup() {
        this.startTime = EnvironmentEdgeManager.currentTime();
    }

    @Test(timeout=30000L)
    public void testRecoverLease() throws IOException {
        HTU.getConfiguration().setInt("hbase.lease.recovery.dfs.timeout", 1000);
        CancelableProgressable reporter = (CancelableProgressable)Mockito.mock(CancelableProgressable.class);
        Mockito.when((Object)reporter.progress()).thenReturn((Object)true);
        DistributedFileSystem dfs = (DistributedFileSystem)Mockito.mock(DistributedFileSystem.class);
        Mockito.when((Object)dfs.recoverLease(FILE)).thenReturn((Object)false).thenReturn((Object)false).thenReturn((Object)false).thenReturn((Object)false).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.fsHDFSUtils.recoverDFSFileLease(dfs, FILE, HTU.getConfiguration(), reporter));
        ((DistributedFileSystem)Mockito.verify((Object)dfs, (VerificationMode)Mockito.times((int)5))).recoverLease(FILE);
        Assert.assertTrue((EnvironmentEdgeManager.currentTime() - this.startTime > (long)(3 * HTU.getConfiguration().getInt("hbase.lease.recovery.dfs.timeout", 61000)) ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testIsFileClosed() throws IOException {
        HTU.getConfiguration().setInt("hbase.lease.recovery.dfs.timeout", 100000);
        CancelableProgressable reporter = (CancelableProgressable)Mockito.mock(CancelableProgressable.class);
        Mockito.when((Object)reporter.progress()).thenReturn((Object)true);
        IsFileClosedDistributedFileSystem dfs = (IsFileClosedDistributedFileSystem)((Object)Mockito.mock(IsFileClosedDistributedFileSystem.class));
        Mockito.when((Object)dfs.recoverLease(FILE)).thenReturn((Object)false).thenReturn((Object)false).thenReturn((Object)true);
        Mockito.when((Object)dfs.isFileClosed(FILE)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.fsHDFSUtils.recoverDFSFileLease((DistributedFileSystem)dfs, FILE, HTU.getConfiguration(), reporter));
        ((IsFileClosedDistributedFileSystem)((Object)Mockito.verify((Object)((Object)dfs), (VerificationMode)Mockito.times((int)2)))).recoverLease(FILE);
        ((IsFileClosedDistributedFileSystem)((Object)Mockito.verify((Object)((Object)dfs), (VerificationMode)Mockito.times((int)1)))).isFileClosed(FILE);
    }

    void testIsSameHdfs(int nnport) throws IOException {
        try {
            Class<?> dfsUtilClazz = Class.forName("org.apache.hadoop.hdfs.DFSUtil");
            dfsUtilClazz.getMethod("getNNServiceRpcAddresses", Configuration.class);
        }
        catch (Exception e) {
            LOG.info((Object)"Skip testIsSameHdfs test case because of the no-HA hadoop version.");
            return;
        }
        Configuration conf = HBaseConfiguration.create();
        Path srcPath = new Path("hdfs://localhost:" + nnport + "/");
        Path desPath = new Path("hdfs://127.0.0.1/");
        FileSystem srcFs = srcPath.getFileSystem(conf);
        FileSystem desFs = desPath.getFileSystem(conf);
        Assert.assertTrue((boolean)FSHDFSUtils.isSameHdfs((Configuration)conf, (FileSystem)srcFs, (FileSystem)desFs));
        desPath = new Path("hdfs://127.0.0.1:8070/");
        desFs = desPath.getFileSystem(conf);
        Assert.assertTrue((!FSHDFSUtils.isSameHdfs((Configuration)conf, (FileSystem)srcFs, (FileSystem)desFs) ? 1 : 0) != 0);
        desPath = new Path("hdfs://127.0.1.1:" + nnport + "/");
        desFs = desPath.getFileSystem(conf);
        Assert.assertTrue((!FSHDFSUtils.isSameHdfs((Configuration)conf, (FileSystem)srcFs, (FileSystem)desFs) ? 1 : 0) != 0);
        conf.set("fs.defaultFS", "hdfs://haosong-hadoop");
        conf.set("dfs.nameservices", "haosong-hadoop");
        conf.set("dfs.ha.namenodes.haosong-hadoop", "nn1,nn2");
        conf.set("dfs.client.failover.proxy.provider.haosong-hadoop", "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider");
        conf.set("dfs.namenode.rpc-address.haosong-hadoop.nn1", "127.0.0.1:" + nnport);
        conf.set("dfs.namenode.rpc-address.haosong-hadoop.nn2", "127.10.2.1:8000");
        desPath = new Path("/");
        desFs = desPath.getFileSystem(conf);
        Assert.assertTrue((boolean)FSHDFSUtils.isSameHdfs((Configuration)conf, (FileSystem)srcFs, (FileSystem)desFs));
        conf.set("dfs.namenode.rpc-address.haosong-hadoop.nn1", "127.10.2.1:" + nnport);
        conf.set("dfs.namenode.rpc-address.haosong-hadoop.nn2", "127.0.0.1:8000");
        desPath = new Path("/");
        desFs = desPath.getFileSystem(conf);
        Assert.assertTrue((!FSHDFSUtils.isSameHdfs((Configuration)conf, (FileSystem)srcFs, (FileSystem)desFs) ? 1 : 0) != 0);
    }

    @Test
    public void testIsSameHdfs() throws IOException {
        String hadoopVersion = VersionInfo.getVersion();
        LOG.info((Object)("hadoop version is: " + hadoopVersion));
        boolean isHadoop3 = hadoopVersion.startsWith("3.");
        if (isHadoop3) {
            this.testIsSameHdfs(9820);
        } else {
            this.testIsSameHdfs(8020);
        }
    }

    static {
        Configuration conf = HTU.getConfiguration();
        conf.setInt("hbase.lease.recovery.first.pause", 10);
        conf.setInt("hbase.lease.recovery.pause", 10);
        FILE = new Path(HTU.getDataTestDir(), "file.txt");
    }

    class IsFileClosedDistributedFileSystem
    extends DistributedFileSystem {
        IsFileClosedDistributedFileSystem() {
        }

        public boolean isFileClosed(Path f) throws IOException {
            return false;
        }
    }
}

