/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, MediumTests.class})
public class TestFSTableDescriptors {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestFSTableDescriptors.class);
    @Rule
    public TestName name = new TestName();

    @Test(expected=IllegalArgumentException.class)
    public void testRegexAgainstOldStyleTableInfo() {
        Path p = new Path("/tmp", ".tableinfo");
        int i = FSTableDescriptors.getTableInfoSequenceId((Path)p);
        Assert.assertEquals((long)0L, (long)i);
        p = new Path("/tmp", "abc");
        FSTableDescriptors.getTableInfoSequenceId((Path)p);
    }

    @Test
    public void testCreateAndUpdate() throws IOException {
        Path testdir = UTIL.getDataTestDir(this.name.getMethodName());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, testdir);
        Assert.assertTrue((boolean)fstd.createTableDescriptor(htd));
        Assert.assertFalse((boolean)fstd.createTableDescriptor(htd));
        FileStatus[] statuses = fs.listStatus(testdir);
        Assert.assertTrue((String)("statuses.length=" + statuses.length), (statuses.length == 1 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            fstd.updateTableDescriptor(htd);
        }
        statuses = fs.listStatus(testdir);
        Assert.assertTrue((statuses.length == 1 ? 1 : 0) != 0);
        Path tmpTableDir = new Path(FSUtils.getTableDir((Path)testdir, (TableName)htd.getTableName()), ".tmp");
        statuses = fs.listStatus(tmpTableDir);
        Assert.assertTrue((statuses.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSequenceIdAdvancesOnTableInfo() throws IOException {
        Path testdir = UTIL.getDataTestDir(this.name.getMethodName());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, testdir);
        Path p0 = fstd.updateTableDescriptor(htd);
        int i0 = FSTableDescriptors.getTableInfoSequenceId((Path)p0);
        Path p1 = fstd.updateTableDescriptor(htd);
        Assert.assertTrue((!fs.exists(p0) ? 1 : 0) != 0);
        int i1 = FSTableDescriptors.getTableInfoSequenceId((Path)p1);
        Assert.assertTrue((i1 == i0 + 1 ? 1 : 0) != 0);
        Path p2 = fstd.updateTableDescriptor(htd);
        Assert.assertTrue((!fs.exists(p1) ? 1 : 0) != 0);
        int i2 = FSTableDescriptors.getTableInfoSequenceId((Path)p2);
        Assert.assertTrue((i2 == i1 + 1 ? 1 : 0) != 0);
        Path p3 = fstd.updateTableDescriptor(htd);
        Assert.assertTrue((!fs.exists(p2) ? 1 : 0) != 0);
        int i3 = FSTableDescriptors.getTableInfoSequenceId((Path)p3);
        Assert.assertTrue((i3 == i2 + 1 ? 1 : 0) != 0);
        TableDescriptor descriptor = fstd.get(htd.getTableName());
        Assert.assertEquals((Object)descriptor, (Object)htd);
    }

    @Test
    public void testFormatTableInfoSequenceId() {
        Path p0 = this.assertWriteAndReadSequenceId(0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append("0");
        }
        Assert.assertEquals((Object)(".tableinfo." + sb.toString()), (Object)p0.getName());
        Path p2 = this.assertWriteAndReadSequenceId(2);
        Path p10000 = this.assertWriteAndReadSequenceId(10000);
        Path p = new Path(p0.getParent(), ".tableinfo");
        FileStatus fs = new FileStatus(0L, false, 0, 0L, 0L, p);
        FileStatus fs0 = new FileStatus(0L, false, 0, 0L, 0L, p0);
        FileStatus fs2 = new FileStatus(0L, false, 0, 0L, 0L, p2);
        FileStatus fs10000 = new FileStatus(0L, false, 0, 0L, 0L, p10000);
        Comparator comparator = FSTableDescriptors.TABLEINFO_FILESTATUS_COMPARATOR;
        Assert.assertTrue((comparator.compare(fs, fs0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(fs0, fs2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(fs2, fs10000) > 0 ? 1 : 0) != 0);
    }

    private Path assertWriteAndReadSequenceId(int i) {
        Path p = new Path("/tmp", FSTableDescriptors.getTableInfoFileName((int)i));
        int ii = FSTableDescriptors.getTableInfoSequenceId((Path)p);
        Assert.assertEquals((long)i, (long)ii);
        return p;
    }

    @Test
    public void testRemoves() throws IOException {
        String name = this.name.getMethodName();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), name);
        FSTableDescriptors htds = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)name)).build();
        htds.add(htd);
        Assert.assertNotNull((Object)htds.remove(htd.getTableName()));
        Assert.assertNull((Object)htds.remove(htd.getTableName()));
    }

    @Test
    public void testReadingHTDFromFS() throws IOException {
        String name = this.name.getMethodName();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)name)).build();
        Path rootdir = UTIL.getDataTestDir(name);
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        fstd.createTableDescriptor(htd);
        TableDescriptor td2 = FSTableDescriptors.getTableDescriptorFromFs((FileSystem)fs, (Path)rootdir, (TableName)htd.getTableName());
        Assert.assertTrue((boolean)htd.equals(td2));
    }

    @Test
    public void testReadingOldHTDFromFS() throws IOException, DeserializationException {
        String name = this.name.getMethodName();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = UTIL.getDataTestDir(name);
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)name)).build();
        Path descriptorFile = fstd.updateTableDescriptor(htd);
        try (FSDataOutputStream out = fs.create(descriptorFile, true);){
            out.write(TableDescriptorBuilder.toByteArray((TableDescriptor)htd));
        }
        FSTableDescriptors fstd2 = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        TableDescriptor td2 = fstd2.get(htd.getTableName());
        Assert.assertEquals((Object)htd, (Object)td2);
        FileStatus descriptorFile2 = FSTableDescriptors.getTableInfoPath((FileSystem)fs, (Path)fstd2.getTableDir(htd.getTableName()));
        byte[] buffer = TableDescriptorBuilder.toByteArray((TableDescriptor)htd);
        try (FSDataInputStream in = fs.open(descriptorFile2.getPath());){
            in.readFully(buffer);
        }
        TableDescriptor td3 = TableDescriptorBuilder.parseFrom((byte[])buffer);
        Assert.assertEquals((Object)htd, (Object)td3);
    }

    @Test
    public void testTableDescriptors() throws IOException, InterruptedException {
        int i;
        String name = this.name.getMethodName();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), name);
        FSTableDescriptors htds = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir){

            public TableDescriptor get(TableName tablename) throws TableExistsException, FileNotFoundException, IOException {
                LOG.info((Object)(tablename + ", cachehits=" + this.cachehits));
                return super.get(tablename);
            }
        };
        int count = 10;
        for (i = 0; i < 10; ++i) {
            htds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(name + i))).build());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf((String)(name + i))) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf((String)(name + i))) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(name + i)));
            builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((String)("" + i)));
            htds.updateTableDescriptor(builder.build());
        }
        Thread.sleep(100L);
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf((String)(name + i))) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((htds.get(TableName.valueOf((String)(name + i))) != null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)40L, (long)htds.invocations);
        Assert.assertTrue((String)("expected=20, actual=" + htds.cachehits), (htds.cachehits >= 20L ? 1 : 0) != 0);
    }

    @Test
    public void testTableDescriptorsNoCache() throws IOException, InterruptedException {
        int i;
        String name = this.name.getMethodName();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), name);
        FSTableDescriptorsTest htds = new FSTableDescriptorsTest(UTIL.getConfiguration(), fs, rootdir, false, false);
        int count = 10;
        for (i = 0; i < 10; ++i) {
            htds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(name + i))).build());
        }
        for (i = 0; i < 20; ++i) {
            Assert.assertNotNull((String)"Expected HTD, got null instead", (Object)htds.get(TableName.valueOf((String)(name + i % 2))));
        }
        for (i = 0; i < 10; ++i) {
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(name + i)));
            builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((String)("" + i)));
            htds.updateTableDescriptor(builder.build());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertNotNull((String)"Expected HTD, got null instead", (Object)htds.get(TableName.valueOf((String)(name + i))));
            Assert.assertTrue((String)("Column Family " + i + " missing"), (boolean)htds.get(TableName.valueOf((String)(name + i))).hasColumnFamily(Bytes.toBytes((String)("" + i))));
        }
        Assert.assertEquals((long)40L, (long)htds.invocations);
        Assert.assertEquals((String)("expected=0, actual=" + htds.cachehits), (long)0L, (long)htds.cachehits);
    }

    @Test
    public void testGetAll() throws IOException, InterruptedException {
        String name = "testGetAll";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testGetAll");
        FSTableDescriptorsTest htds = new FSTableDescriptorsTest(UTIL.getConfiguration(), fs, rootdir);
        int count = 4;
        for (int i = 0; i < 4; ++i) {
            htds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)("testGetAll" + i))).build());
        }
        htds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).build());
        Assert.assertEquals((String)("getAll() didn't return all TableDescriptors, expected: 5 got: " + htds.getAll().size()), (long)5L, (long)htds.getAll().size());
    }

    @Test
    public void testCacheConsistency() throws IOException, InterruptedException {
        int i;
        String name = this.name.getMethodName();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), name);
        FSTableDescriptorsTest chtds = new FSTableDescriptorsTest(UTIL.getConfiguration(), fs, rootdir);
        FSTableDescriptorsTest nonchtds = new FSTableDescriptorsTest(UTIL.getConfiguration(), fs, rootdir, false, false);
        int count = 10;
        for (i = 0; i < 10; ++i) {
            nonchtds.createTableDescriptor(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)(name + i))).build());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((chtds.get(TableName.valueOf((String)(name + i))) != null ? 1 : 0) != 0);
        }
        Assert.assertTrue((nonchtds.getAll().size() == chtds.getAll().size() ? 1 : 0) != 0);
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.META_TABLE_NAME).build();
        nonchtds.createTableDescriptor(htd);
        Assert.assertTrue((nonchtds.getAll().size() == chtds.getAll().size() ? 1 : 0) != 0);
        for (Map.Entry entry : nonchtds.getAll().entrySet()) {
            String t = (String)entry.getKey();
            TableDescriptor nchtd = (TableDescriptor)entry.getValue();
            Assert.assertTrue((String)("expected " + htd.toString() + " got: " + chtds.get(TableName.valueOf((String)t)).toString()), (boolean)nchtd.equals(chtds.get(TableName.valueOf((String)t))));
        }
    }

    @Test
    public void testNoSuchTable() throws IOException {
        String name = "testNoSuchTable";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testNoSuchTable");
        FSTableDescriptors htds = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        Assert.assertNull((String)"There shouldn't be any HTD for this table", (Object)htds.get(TableName.valueOf((String)"NoSuchTable")));
    }

    @Test
    public void testUpdates() throws IOException {
        String name = "testUpdates";
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        Path rootdir = new Path(UTIL.getDataTestDir(), "testUpdates");
        FSTableDescriptors htds = new FSTableDescriptors(UTIL.getConfiguration(), fs, rootdir);
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"testUpdates")).build();
        htds.add(htd);
        htds.add(htd);
        htds.add(htd);
    }

    @Test
    public void testTableInfoFileStatusComparator() {
        FileStatus bare = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp", ".tableinfo"));
        FileStatus future = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp/tablinfo." + System.currentTimeMillis()));
        FileStatus farFuture = new FileStatus(0L, false, 0, 0L, -1L, new Path("/tmp/tablinfo." + System.currentTimeMillis() + 1000));
        FileStatus[] alist = new FileStatus[]{bare, future, farFuture};
        FileStatus[] blist = new FileStatus[]{bare, farFuture, future};
        FileStatus[] clist = new FileStatus[]{farFuture, bare, future};
        Comparator c = FSTableDescriptors.TABLEINFO_FILESTATUS_COMPARATOR;
        Arrays.sort(alist, c);
        Arrays.sort(blist, c);
        Arrays.sort(clist, c);
        for (int i = 0; i < alist.length; ++i) {
            Assert.assertTrue((boolean)alist[i].equals((Object)blist[i]));
            Assert.assertTrue((boolean)blist[i].equals((Object)clist[i]));
            Assert.assertTrue((boolean)clist[i].equals((Object)(i == 0 ? farFuture : (i == 1 ? future : bare))));
        }
    }

    @Test
    public void testReadingInvalidDirectoryFromFS() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        try {
            new FSTableDescriptors(UTIL.getConfiguration(), fs, FSUtils.getRootDir((Configuration)UTIL.getConfiguration())).get(TableName.valueOf((String)".tmp"));
            Assert.fail((String)"Shouldn't be able to read a table descriptor for the archive directory.");
        }
        catch (Exception e) {
            LOG.debug((Object)("Correctly got error when reading a table descriptor from the archive directory: " + e.getMessage()));
        }
    }

    @Test
    public void testCreateTableDescriptorUpdatesIfExistsAlready() throws IOException {
        Path testdir = UTIL.getDataTestDir(this.name.getMethodName());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).build();
        FileSystem fs = FileSystem.get((Configuration)UTIL.getConfiguration());
        FSTableDescriptors fstd = new FSTableDescriptors(UTIL.getConfiguration(), fs, testdir);
        Assert.assertTrue((boolean)fstd.createTableDescriptor(htd));
        Assert.assertFalse((boolean)fstd.createTableDescriptor(htd));
        htd = TableDescriptorBuilder.newBuilder((TableDescriptor)htd).setValue(Bytes.toBytes((String)"mykey"), Bytes.toBytes((String)"myValue")).build();
        Assert.assertTrue((boolean)fstd.createTableDescriptor(htd));
        Path tableDir = fstd.getTableDir(htd.getTableName());
        Path tmpTableDir = new Path(tableDir, ".tmp");
        FileStatus[] statuses = fs.listStatus(tmpTableDir);
        Assert.assertTrue((statuses.length == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)htd, (Object)FSTableDescriptors.getTableDescriptorFromFs((FileSystem)fs, (Path)tableDir));
    }

    private static class FSTableDescriptorsTest
    extends FSTableDescriptors {
        public FSTableDescriptorsTest(Configuration conf, FileSystem fs, Path rootdir) throws IOException {
            this(conf, fs, rootdir, false, true);
        }

        public FSTableDescriptorsTest(Configuration conf, FileSystem fs, Path rootdir, boolean fsreadonly, boolean usecache) throws IOException {
            super(conf, fs, rootdir, fsreadonly, usecache);
        }

        public TableDescriptor get(TableName tablename) throws TableExistsException, FileNotFoundException, IOException {
            LOG.info((Object)((super.isUsecache() ? "Cached" : "Non-Cached") + " TableDescriptor.get() on " + tablename + ", cachehits=" + this.cachehits));
            return super.get(tablename);
        }
    }
}

