/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHBaseFsckComparator {
    TableName table = TableName.valueOf((String)"table1");
    TableName table2 = TableName.valueOf((String)"table2");
    byte[] keyStart = Bytes.toBytes((String)"");
    byte[] keyA = Bytes.toBytes((String)"A");
    byte[] keyB = Bytes.toBytes((String)"B");
    byte[] keyC = Bytes.toBytes((String)"C");
    byte[] keyEnd = Bytes.toBytes((String)"");

    static HBaseFsck.HbckInfo genHbckInfo(TableName table, byte[] start, byte[] end, int time) {
        return new HBaseFsck.HbckInfo(new HBaseFsck.MetaEntry((RegionInfo)new HRegionInfo(table, start, end), null, (long)time));
    }

    @Test
    public void testEquals() {
        HBaseFsck.HbckInfo hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyB, 0);
        HBaseFsck.HbckInfo hi2 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyB, 0);
        Assert.assertEquals((long)0L, (long)HBaseFsck.cmp.compare(hi1, hi2));
        Assert.assertEquals((long)0L, (long)HBaseFsck.cmp.compare(hi2, hi1));
    }

    @Test
    public void testEqualsInstance() {
        HBaseFsck.HbckInfo hi1;
        HBaseFsck.HbckInfo hi2 = hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyB, 0);
        Assert.assertEquals((long)0L, (long)HBaseFsck.cmp.compare(hi1, hi2));
        Assert.assertEquals((long)0L, (long)HBaseFsck.cmp.compare(hi2, hi1));
    }

    @Test
    public void testDiffTable() {
        HBaseFsck.HbckInfo hi2;
        HBaseFsck.HbckInfo hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyC, 0);
        Assert.assertTrue((HBaseFsck.cmp.compare(hi1, hi2 = TestHBaseFsckComparator.genHbckInfo(this.table2, this.keyA, this.keyC, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((HBaseFsck.cmp.compare(hi2, hi1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDiffStartKey() {
        HBaseFsck.HbckInfo hi2;
        HBaseFsck.HbckInfo hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyStart, this.keyC, 0);
        Assert.assertTrue((HBaseFsck.cmp.compare(hi1, hi2 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyC, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((HBaseFsck.cmp.compare(hi2, hi1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDiffEndKey() {
        HBaseFsck.HbckInfo hi2;
        HBaseFsck.HbckInfo hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyB, 0);
        Assert.assertTrue((HBaseFsck.cmp.compare(hi1, hi2 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyC, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((HBaseFsck.cmp.compare(hi2, hi1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAbsEndKey() {
        HBaseFsck.HbckInfo hi2;
        HBaseFsck.HbckInfo hi1 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyC, 0);
        Assert.assertTrue((HBaseFsck.cmp.compare(hi1, hi2 = TestHBaseFsckComparator.genHbckInfo(this.table, this.keyA, this.keyEnd, 0)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((HBaseFsck.cmp.compare(hi2, hi1) > 0 ? 1 : 0) != 0);
    }
}

