/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.io.hfile.TestHFile;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.TestEndToEndSplitTransaction;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesArguments;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.BaseTestHBaseFsck;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.hbck.HFileCorruptionChecker;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Ignore
@Category(value={MiscTests.class, LargeTests.class})
public class TestHBaseFsckOneRS
extends BaseTestHBaseFsck {
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", BaseTestHBaseFsck.MasterSyncCoprocessor.class.getName());
        conf.setInt("hbase.regionserver.handler.count", 2);
        conf.setInt("hbase.regionserver.metahandler.count", 30);
        conf.setInt("hbase.htable.threads.max", 7);
        conf.setInt("hbase.hconnection.threads.max", 14);
        conf.setInt("hbase.hbck.close.timeout", 1600);
        conf.setInt("hbase.rpc.timeout", 6400);
        TEST_UTIL.startMiniCluster(1);
        tableExecutorService = new ThreadPoolExecutor(1, 7, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"testhbck"));
        hbfsckExecutorService = new ScheduledThreadPoolExecutor(7);
        AssignmentManager assignmentManager = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        regionStates = assignmentManager.getRegionStates();
        connection = (ClusterConnection)TEST_UTIL.getConnection();
        admin = connection.getAdmin();
        admin.setBalancerRunning(false, true);
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.NAMESPACE_TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        tableExecutorService.shutdown();
        hbfsckExecutorService.shutdown();
        admin.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() {
        EnvironmentEdgeManager.reset();
    }

    @Test(timeout=180000L)
    public void testHBaseFsckClean() throws Exception {
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        TableName table = TableName.valueOf((String)"tableClean");
        try {
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    @Test(timeout=180000L)
    public void testHbckThreadpooling() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Configuration newconf = new Configuration(conf);
            newconf.setInt("hbasefsck.numthreads", 1);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(newconf, false));
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testTableWithNoRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            HTableDescriptor desc = new HTableDescriptor(tableName);
            HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toString((byte[])FAM));
            desc.addFamily(hcd);
            TestHBaseFsckOneRS.createTable(TEST_UTIL, desc, null);
            this.tbl = connection.getTable(tableName, tableExecutorService);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, false, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(timeout=180000L)
    public void testHbckFixOrphanTable() throws Exception {
        TableName tableName;
        block3: {
            tableName = TableName.valueOf((String)this.name.getMethodName());
            FileSystem fs = null;
            Path tableinfo = null;
            try {
                this.setupTable(tableName);
                Path hbaseTableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)tableName);
                fs = hbaseTableDir.getFileSystem(conf);
                FileStatus status = FSTableDescriptors.getTableInfoPath((FileSystem)fs, (Path)hbaseTableDir);
                tableinfo = status.getPath();
                fs.rename(tableinfo, new Path("/.tableinfo"));
                HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
                HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NO_TABLEINFO_FILE});
                hbck = HbckTestingUtil.doFsck(conf, true);
                HbckTestingUtil.assertNoErrors(hbck);
                status = null;
                status = FSTableDescriptors.getTableInfoPath((FileSystem)fs, (Path)hbaseTableDir);
                Assert.assertNotNull((Object)status);
                HTableDescriptor htd = new HTableDescriptor(admin.getTableDescriptor(tableName));
                htd.setValue("NOT_DEFAULT", "true");
                admin.disableTable(tableName);
                admin.modifyTable(tableName, (TableDescriptor)htd);
                admin.enableTable(tableName);
                fs.delete(status.getPath(), true);
                htd = admin.getTableDescriptor(tableName);
                hbck = HbckTestingUtil.doFsck(conf, true);
                HbckTestingUtil.assertNoErrors(hbck);
                status = FSTableDescriptors.getTableInfoPath((FileSystem)fs, (Path)hbaseTableDir);
                Assert.assertNotNull((Object)status);
                htd = admin.getTableDescriptor(tableName);
                Assert.assertEquals((Object)htd.getValue("NOT_DEFAULT"), (Object)"true");
                if (fs == null) break block3;
            }
            catch (Throwable throwable) {
                if (fs != null) {
                    fs.rename(new Path("/.tableinfo"), tableinfo);
                }
                this.cleanupTable(tableName);
                throw throwable;
            }
            fs.rename(new Path("/.tableinfo"), tableinfo);
        }
        this.cleanupTable(tableName);
    }

    @Test(timeout=180000L)
    public void testReadOnlyProperty() throws Exception {
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        Assert.assertEquals((String)"shouldIgnorePreCheckPermission", (Object)true, (Object)hbck.shouldIgnorePreCheckPermission());
        hbck = HbckTestingUtil.doFsck(conf, true);
        Assert.assertEquals((String)"shouldIgnorePreCheckPermission", (Object)false, (Object)hbck.shouldIgnorePreCheckPermission());
        hbck = HbckTestingUtil.doFsck(conf, true);
        hbck.setIgnorePreCheckPermission(true);
        Assert.assertEquals((String)"shouldIgnorePreCheckPermission", (Object)true, (Object)hbck.shouldIgnorePreCheckPermission());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testOverlapAndOrphan() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), true, true, false, true, 0);
            admin.enableTable(tableName);
            RegionInfo hriOverlap = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B"));
            TEST_UTIL.assignRegion(hriOverlap);
            ServerName server = regionStates.getRegionServerOfRegion(hriOverlap);
            TEST_UTIL.assertRegionOnServer(hriOverlap, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testCoveredStartKey() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            RegionInfo hriOverlap = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B2"));
            TEST_UTIL.assignRegion(hriOverlap);
            ServerName server = regionStates.getRegionServerOfRegion(hriOverlap);
            TEST_UTIL.assertRegionOnServer(hriOverlap, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN, HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)3L, (long)hbck.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck2, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=180000L)
    public void testRegionHole() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, true);
            admin.enableTable(tableName);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(tableName).size());
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)(ROWKEYS.length - 2), (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testRegionShouldNotBeDeployed() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            LOG.info((Object)"Starting testRegionShouldNotBeDeployed.");
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
            byte[][] SPLIT_KEYS = new byte[][]{new byte[0], Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd")};
            TableDescriptor htdDisabled = TableDescriptorBuilder.newBuilder((TableName)tableName).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAM)).build();
            FSTableDescriptors fstd = new FSTableDescriptors(conf);
            fstd.createTableDescriptor(htdDisabled);
            List<RegionInfo> disabledRegions = TEST_UTIL.createMultiRegionsInMeta(conf, htdDisabled, (byte[][])SPLIT_KEYS);
            HRegionServer hrs = cluster.getRegionServer(0);
            admin.disableTable(tableName);
            admin.enableTable(tableName);
            admin.disableTable(tableName);
            RegionInfo region = disabledRegions.remove(0);
            byte[] regionName = region.getRegionName();
            Assert.assertTrue((cluster.getServerWith(regionName) == -1 ? 1 : 0) != 0);
            HRegion r = HRegion.openHRegion((RegionInfo)region, (TableDescriptor)htdDisabled, (WAL)hrs.getWAL(region), (Configuration)conf);
            hrs.addRegion(r);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.SHOULD_NOT_BE_DEPLOYED});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            admin.enableTable(tableName);
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=180000L)
    public void testParallelHbck() throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(2);
        class RunHbck
        implements Callable<HBaseFsck> {
            boolean fail = true;

            RunHbck() {
            }

            @Override
            public HBaseFsck call() {
                Configuration c = new Configuration(BaseTestHBaseFsck.conf);
                c.setInt("hbase.hbck.lockfile.attempts", 1);
                c.setInt("hbase.hbck.lockfile.maxwaittime", 3);
                try {
                    return HbckTestingUtil.doFsck(c, true);
                }
                catch (Exception e) {
                    if (e.getMessage().contains("Duplicate hbck")) {
                        this.fail = false;
                    }
                    if (this.fail) {
                        Assert.fail();
                    }
                    return null;
                }
            }
        }
        Future<HBaseFsck> hbck1 = service.submit(new RunHbck());
        Future<HBaseFsck> hbck2 = service.submit(new RunHbck());
        service.shutdown();
        service.awaitTermination(15L, TimeUnit.SECONDS);
        HBaseFsck h1 = hbck1.get();
        HBaseFsck h2 = hbck2.get();
        assert (h1 == null || h2 == null);
        if (h1 != null) assert (h1.getRetCode() >= 0);
        if (h2 != null) assert (h2.getRetCode() >= 0);
    }

    @Test(timeout=180000L)
    public void testParallelWithRetriesHbck() throws Exception {
        int timeoutInSeconds = 80;
        int sleepIntervalInMilliseconds = 200;
        int maxSleepTimeInMilliseconds = 6000;
        int maxRetryAttempts = 15;
        ExecutorService service = Executors.newFixedThreadPool(2);
        class RunHbck
        implements Callable<HBaseFsck> {
            RunHbck() {
            }

            @Override
            public HBaseFsck call() throws Exception {
                Configuration c = new Configuration(BaseTestHBaseFsck.conf);
                c.setInt("hbase.hbck.lockfile.maxwaittime", 80);
                c.setInt("hbase.hbck.lockfile.attempt.sleep.interval", 200);
                c.setInt("hbase.hbck.lockfile.attempt.maxsleeptime", 6000);
                c.setInt("hbase.hbck.lockfile.attempts", 15);
                return HbckTestingUtil.doFsck(c, false);
            }
        }
        Future<HBaseFsck> hbck1 = service.submit(new RunHbck());
        Future<HBaseFsck> hbck2 = service.submit(new RunHbck());
        service.shutdown();
        service.awaitTermination(160L, TimeUnit.SECONDS);
        HBaseFsck h1 = hbck1.get();
        HBaseFsck h2 = hbck2.get();
        Assert.assertNotNull((Object)h1);
        Assert.assertNotNull((Object)h2);
        assert (h1.getRetCode() >= 0);
        assert (h2.getRetCode() >= 0);
    }

    @Test(timeout=180000L)
    public void testRegionBoundariesCheck() throws Exception {
        HbckTestingUtil.assertNoErrors(hbck);
        try (HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);){
            hbck.connect();
            hbck.checkRegionBoundaries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testRegionBoundariesCheckWithFlushTable() throws Exception {
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertNoErrors(hbck);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            admin.flush(tableName);
            hbck.connect();
            hbck.checkRegionBoundaries();
            HbckTestingUtil.assertNoErrors(hbck);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().endsWith("not a valid DFS filename.")) {
                Assert.fail((String)("Table directory path is not valid." + e.getMessage()));
            }
        }
        finally {
            hbck.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testHbckAfterRegionMerge() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Closeable meta = null;
        try {
            TEST_UTIL.getHBaseCluster().getMaster().setCatalogJanitorEnabled(false);
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            try (RegionLocator rl = connection.getRegionLocator(this.tbl.getName());){
                admin.flush(tableName);
                HRegionInfo region1 = rl.getRegionLocation(Bytes.toBytes((String)"A")).getRegionInfo();
                HRegionInfo region2 = rl.getRegionLocation(Bytes.toBytes((String)"B")).getRegionInfo();
                int regionCountBeforeMerge = rl.getAllRegionLocations().size();
                Assert.assertNotEquals((Object)region1, (Object)region2);
                admin.mergeRegionsAsync(region1.getEncodedNameAsBytes(), region2.getEncodedNameAsBytes(), false);
                long timeout = System.currentTimeMillis() + 30000L;
                while (rl.getAllRegionLocations().size() >= regionCountBeforeMerge) {
                    if (System.currentTimeMillis() > timeout) {
                        Assert.fail((String)("Time out waiting on region " + region1.getEncodedName() + " and " + region2.getEncodedName() + " be merged"));
                    }
                    Thread.sleep(10L);
                }
                Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
                HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
                HbckTestingUtil.assertNoErrors(hbck);
            }
        }
        finally {
            TEST_UTIL.getHBaseCluster().getMaster().setCatalogJanitorEnabled(true);
            this.cleanupTable(tableName);
            IOUtils.closeQuietly(meta);
        }
    }

    @Test(timeout=180000L)
    public void testNoHdfsTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.setupTable(tableName);
        Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        admin.flush(tableName);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)""), Bytes.toBytes((String)"A"), false, false, true);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), false, false, true);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"C"), Bytes.toBytes((String)""), false, false, true);
        this.deleteTableDir(tableName);
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.ORPHAN_TABLE_STATE});
        Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(tableName).size());
        HbckTestingUtil.doFsck(conf, true);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        Assert.assertFalse((String)("Table " + tableName + " should have been deleted"), (boolean)admin.tableExists(tableName));
    }

    @Test(timeout=180000L)
    public void testNoVersionFile() throws Exception {
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        Path versionFile = new Path(rootDir, "hbase.version");
        fs.delete(versionFile, true);
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NO_VERSION_FILE});
        HbckTestingUtil.doFsck(conf, true);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
    }

    @Test(timeout=180000L)
    public void testNoTableState() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            admin.flush(tableName);
            MetaTableAccessor.deleteTableState((Connection)TEST_UTIL.getConnection(), (TableName)tableName);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NO_TABLE_STATE});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertTrue((boolean)TEST_UTIL.getAdmin().isTableEnabled(tableName));
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testFixByTable() throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        try {
            this.setupTable(tableName1);
            admin.flush(tableName1);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
            this.setupTable(tableName2);
            admin.flush(tableName2);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            HbckTestingUtil.doFsck(conf, true, tableName1);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false, tableName1));
            HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, false, tableName2), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            HbckTestingUtil.doFsck(conf, true, tableName2);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)(ROWKEYS.length - 2), (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName1);
            this.cleanupTable(tableName2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testLingeringSplitParent() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table meta = null;
        try {
            HRegionLocation location;
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(tableName);
            try (RegionLocator rl = connection.getRegionLocator(this.tbl.getName());){
                location = rl.getRegionLocation(Bytes.toBytes((String)"B"));
            }
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, false);
            meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
            RegionInfo a = RegionInfoBuilder.newBuilder((TableName)this.tbl.getName()).setStartKey(Bytes.toBytes((String)"B")).setEndKey(Bytes.toBytes((String)"BM")).build();
            RegionInfo b = RegionInfoBuilder.newBuilder((TableName)this.tbl.getName()).setStartKey(Bytes.toBytes((String)"BM")).setEndKey(Bytes.toBytes((String)"C")).build();
            RegionInfo hri = RegionInfoBuilder.newBuilder((RegionInfo)location.getRegion()).setOffline(true).setSplit(true).build();
            MetaTableAccessor.addRegionToMeta((Table)meta, (RegionInfo)hri, (RegionInfo)a, (RegionInfo)b);
            meta.close();
            admin.flush(TableName.META_TABLE_NAME);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_SPLIT_PARENT, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            hbck = HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_SPLIT_PARENT, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertFalse((boolean)hbck.shouldRerun());
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_SPLIT_PARENT, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            hbck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            hbck.connect();
            HBaseFsck.setDisplayFullReport();
            hbck.setTimeLag(0L);
            hbck.setFixSplitParents(true);
            hbck.onlineHbck();
            Assert.assertTrue((boolean)hbck.shouldRerun());
            hbck.close();
            Get get = new Get(hri.getRegionName());
            Result result = meta.get(get);
            Assert.assertTrue((boolean)result.getColumnCells(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER).isEmpty());
            Assert.assertTrue((boolean)result.getColumnCells(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER).isEmpty());
            admin.flush(TableName.META_TABLE_NAME);
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        catch (Throwable throwable) {
            this.cleanupTable(tableName);
            IOUtils.closeQuietly(meta);
            throw throwable;
        }
        this.cleanupTable(tableName);
        IOUtils.closeQuietly((Closeable)meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testValidLingeringSplitParent() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table meta = null;
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(tableName);
            try (RegionLocator rl = connection.getRegionLocator(this.tbl.getName());){
                HRegionLocation location = rl.getRegionLocation(Bytes.toBytes((String)"B"));
                meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
                HRegionInfo hri = location.getRegionInfo();
                byte[] regionName = location.getRegionInfo().getRegionName();
                admin.splitRegion(location.getRegionInfo().getRegionName(), Bytes.toBytes((String)"BM"));
                TestEndToEndSplitTransaction.blockUntilRegionSplit(conf, 60000L, regionName, true);
                HBaseFsck hbck = HbckTestingUtil.doFsck(conf, true, true, false, false, false, true, true, true, true, false, false, false, null);
                HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
                Get get = new Get(hri.getRegionName());
                Result result = meta.get(get);
                Assert.assertNotNull((Object)result);
                Assert.assertNotNull((Object)MetaTableAccessor.getRegionInfo((Result)result));
                Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
                Assert.assertEquals((long)rl.getStartKeys().length, (long)(SPLITS.length + 1 + 1));
                HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            }
        }
        catch (Throwable throwable) {
            this.cleanupTable(tableName);
            IOUtils.closeQuietly(meta);
            throw throwable;
        }
        this.cleanupTable(tableName);
        IOUtils.closeQuietly((Closeable)meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=75000L)
    public void testSplitDaughtersNotInMeta() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(tableName);
            try (RegionLocator rl = connection.getRegionLocator(this.tbl.getName());){
                HRegionLocation location = rl.getRegionLocation(Bytes.toBytes((String)"B"));
                HRegionInfo hri = location.getRegionInfo();
                admin.enableCatalogJanitor(false);
                byte[] regionName = location.getRegionInfo().getRegionName();
                admin.splitRegion(location.getRegionInfo().getRegionName(), Bytes.toBytes((String)"BM"));
                TestEndToEndSplitTransaction.blockUntilRegionSplit(conf, 60000L, regionName, true);
                PairOfSameType daughters = MetaTableAccessor.getDaughterRegions((Result)meta.get(new Get(regionName)));
                ServerName firstSN = rl.getRegionLocation(((RegionInfo)daughters.getFirst()).getStartKey()).getServerName();
                ServerName secondSN = rl.getRegionLocation(((RegionInfo)daughters.getSecond()).getStartKey()).getServerName();
                this.undeployRegion((Connection)connection, firstSN, (RegionInfo)daughters.getFirst());
                this.undeployRegion((Connection)connection, secondSN, (RegionInfo)daughters.getSecond());
                ArrayList<Delete> deletes = new ArrayList<Delete>(2);
                deletes.add(new Delete(((RegionInfo)daughters.getFirst()).getRegionName()));
                deletes.add(new Delete(((RegionInfo)daughters.getSecond()).getRegionName()));
                meta.delete(deletes);
                RegionStates regionStates = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
                regionStates.deleteRegion((RegionInfo)daughters.getFirst());
                regionStates.deleteRegion((RegionInfo)daughters.getSecond());
                HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
                HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
                hbck = HbckTestingUtil.doFsck(conf, true, true, false, false, false, false, false, false, false, false, false, false, null);
                HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
                Get get = new Get(hri.getRegionName());
                Result result = meta.get(get);
                Assert.assertNotNull((Object)result);
                Assert.assertNotNull((Object)MetaTableAccessor.getRegionInfo((Result)result));
                Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
                Assert.assertEquals((long)rl.getStartKeys().length, (long)(SPLITS.length + 1 + 1));
                HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            }
        }
        finally {
            admin.enableCatalogJanitor(true);
            meta.close();
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=120000L)
    public void testMissingFirstRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)""), Bytes.toBytes((String)"A"), true, true, true);
            admin.enableTable(tableName);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.FIRST_REGION_STARTKEY_NOT_EMPTY});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=120000L)
    public void testRegionDeployedNotInHdfs() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            admin.flush(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"A"), false, false, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=120000L)
    public void testMissingLastRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"C"), Bytes.toBytes((String)""), true, true, true);
            admin.enableTable(tableName);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LAST_REGION_ENDKEY_NOT_EMPTY});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testFixAssignmentsAndNoHdfsChecking() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), true, false, false, false, 0);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HBaseFsck fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            HBaseFsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.onlineHbck();
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck.close();
            fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            HBaseFsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.setFixAssignments(true);
            fsck.onlineHbck();
            Assert.assertTrue((boolean)fsck.shouldRerun());
            fsck.onlineHbck();
            HbckTestingUtil.assertNoErrors(fsck);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            fsck.close();
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testFixMetaNotWorkingWithNoHdfsChecking() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), false, true, false, false, 0);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HBaseFsck fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            HBaseFsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.onlineHbck();
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck.close();
            fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            HBaseFsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.setFixAssignments(true);
            fsck.setFixMeta(true);
            fsck.onlineHbck();
            Assert.assertFalse((boolean)fsck.shouldRerun());
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck.close();
            fsck = HbckTestingUtil.doFsck(conf, true);
            Assert.assertTrue((boolean)fsck.shouldRerun());
            fsck = HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(fsck);
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testFixHdfsHolesNotWorkingWithNoHdfsChecking() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), true, true, false, true, 0);
            admin.enableTable(tableName);
            RegionInfo hriOverlap = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B"));
            TEST_UTIL.assignRegion(hriOverlap);
            ServerName server = regionStates.getRegionServerOfRegion(hriOverlap);
            TEST_UTIL.assertRegionOnServer(hriOverlap, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HBaseFsck fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            HBaseFsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.onlineHbck();
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck.close();
            fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            HBaseFsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.setFixHdfsHoles(true);
            fsck.setFixHdfsOverlaps(true);
            fsck.setFixHdfsOrphans(true);
            fsck.onlineHbck();
            Assert.assertFalse((boolean)fsck.shouldRerun());
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck.close();
        }
        finally {
            if (admin.isTableDisabled(tableName)) {
                admin.enableTable(tableName);
            }
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testQuarantineCorruptHFile() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(tableName);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path hfile = this.getFlushedHFile(fs, tableName);
            admin.disableTable(tableName);
            Path corrupt = new Path(hfile.getParent(), "deadbeef");
            TestHFile.truncateFile(fs, hfile, corrupt);
            LOG.info((Object)("Created corrupted file " + corrupt));
            HBaseFsck.debugLsr((Configuration)conf, (Path)FSUtils.getRootDir((Configuration)conf));
            HBaseFsck res = HbckTestingUtil.doHFileQuarantine(conf, tableName);
            Assert.assertEquals((long)res.getRetCode(), (long)0L);
            HFileCorruptionChecker hfcc = res.getHFilecorruptionChecker();
            Assert.assertEquals((long)hfcc.getHFilesChecked(), (long)5L);
            Assert.assertEquals((long)hfcc.getCorrupted().size(), (long)1L);
            Assert.assertEquals((long)hfcc.getFailures().size(), (long)0L);
            Assert.assertEquals((long)hfcc.getQuarantined().size(), (long)1L);
            Assert.assertEquals((long)hfcc.getMissing().size(), (long)0L);
            admin.enableTable(tableName);
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=180000L)
    public void testQuarantineMissingHFile() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        final FileSystem fs = FileSystem.get((Configuration)conf);
        HBaseFsck hbck = new HBaseFsck(conf, hbfsckExecutorService){

            public HFileCorruptionChecker createHFileCorruptionChecker(boolean sidelineCorruptHFiles) throws IOException {
                return new HFileCorruptionChecker(BaseTestHBaseFsck.conf, this.executor, sidelineCorruptHFiles){
                    AtomicBoolean attemptedFirstHFile;
                    {
                        this.attemptedFirstHFile = new AtomicBoolean(false);
                    }

                    protected void checkHFile(Path p) throws IOException {
                        if (this.attemptedFirstHFile.compareAndSet(false, true)) {
                            Assert.assertTrue((boolean)fs.delete(p, true));
                        }
                        super.checkHFile(p);
                    }
                };
            }
        };
        this.doQuarantineTest(tableName, hbck, 4, 0, 0, 0, 1);
        hbck.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testDegenerateRegions() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            RegionInfo hriDupe = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"B"));
            TEST_UTIL.assignRegion(hriDupe);
            ServerName server = regionStates.getRegionServerOfRegion(hriDupe);
            TEST_UTIL.assertRegionOnServer(hriDupe, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DEGENERATE_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testMissingRegionInfoQualifier() throws Exception {
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            final LinkedList deletes = new LinkedList();
            Table meta = connection.getTable(TableName.META_TABLE_NAME, (ExecutorService)hbfsckExecutorService);
            MetaTableAccessor.fullScanRegions((Connection)connection, (MetaTableAccessor.Visitor)new MetaTableAccessor.Visitor(){

                public boolean visit(Result rowResult) throws IOException {
                    RegionInfo hri = MetaTableAccessor.getRegionInfo((Result)rowResult);
                    if (hri != null && !hri.getTable().isSystemTable()) {
                        Delete delete = new Delete(rowResult.getRow());
                        delete.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                        deletes.add(delete);
                    }
                    return true;
                }
            });
            meta.delete(deletes);
            meta.put(new Put(Bytes.toBytes((String)(tableName + ",,1361911384013.810e28f59a57da91c66"))).addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)"node1:60020")));
            meta.put(new Put(Bytes.toBytes((String)(tableName + ",,1361911384013.810e28f59a57da91c66"))).addColumn(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)1362150791183L)));
            meta.close();
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            Assert.assertTrue((boolean)hbck.getErrors().getErrorList().contains(HBaseFsck.ErrorReporter.ERROR_CODE.EMPTY_META_CELL));
            hbck = HbckTestingUtil.doFsck(conf, true);
            Assert.assertFalse((boolean)hbck.getErrors().getErrorList().contains(HBaseFsck.ErrorReporter.ERROR_CODE.EMPTY_META_CELL));
        }
        finally {
            this.cleanupTable(tableName);
        }
        connection.close();
    }

    @Test(timeout=180000L)
    public void testErrorReporter() throws Exception {
        try {
            BaseTestHBaseFsck.MockErrorReporter.calledCount = 0;
            HbckTestingUtil.doFsck(conf, false);
            Assert.assertEquals((long)BaseTestHBaseFsck.MockErrorReporter.calledCount, (long)0L);
            conf.set("hbasefsck.errorreporter", BaseTestHBaseFsck.MockErrorReporter.class.getName());
            HbckTestingUtil.doFsck(conf, false);
            Assert.assertTrue((BaseTestHBaseFsck.MockErrorReporter.calledCount > 20 ? 1 : 0) != 0);
        }
        finally {
            conf.set("hbasefsck.errorreporter", HBaseFsck.PrintingErrorReporter.class.getName());
            BaseTestHBaseFsck.MockErrorReporter.calledCount = 0;
        }
    }

    @Test(timeout=180000L)
    public void testCheckReplication() throws Exception {
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertNoErrors(hbck);
        ReplicationAdmin replicationAdmin = new ReplicationAdmin(conf);
        Assert.assertEquals((long)0L, (long)replicationAdmin.getPeersCount());
        int zkPort = conf.getInt("hbase.zookeeper.property.clientPort", 2181);
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:" + zkPort + ":/hbase");
        replicationAdmin.addPeer("1", rpc, null);
        replicationAdmin.getPeersCount();
        Assert.assertEquals((long)1L, (long)replicationAdmin.getPeersCount());
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "Test Hbase Fsck", (Abortable)connection);
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(conf, (Abortable)connection, zkw));
        repQueues.init("server1");
        repQueues.addLog("1", "file1");
        repQueues.addLog("1-server2", "file1");
        Assert.assertEquals((long)2L, (long)repQueues.getAllQueues().size());
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertNoErrors(hbck);
        repQueues.addLog("2", "file1");
        repQueues.addLog("2-server2", "file1");
        Assert.assertEquals((long)4L, (long)repQueues.getAllQueues().size());
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE, HBaseFsck.ErrorReporter.ERROR_CODE.UNDELETED_REPLICATION_QUEUE});
        hbck = HbckTestingUtil.doFsck(conf, true);
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertNoErrors(hbck);
        Assert.assertEquals((long)2L, (long)repQueues.getAllQueues().size());
        Assert.assertNull((Object)repQueues.getLogsInQueue("2"));
        Assert.assertNull((Object)repQueues.getLogsInQueue("2-sever2"));
        replicationAdmin.removePeer("1");
        repQueues.removeAllQueues();
        zkw.close();
        replicationAdmin.close();
    }

    @Test(timeout=180000L)
    public void testHDFSRegioninfoMissing() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, false, true, 0);
            admin.enableTable(tableName);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(tableName).size());
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=180000L)
    public void testNotInMetaOrDeployedHole() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, false);
            admin.enableTable(tableName);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(tableName).size());
            HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, true), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=180000L)
    public void testNotInMetaHole() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, true, false);
            admin.enableTable(tableName);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(tableName).size());
            HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, true), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=180000L)
    public void testNotInHdfs() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(tableName).size());
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)(ROWKEYS.length - 2), (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    @Ignore
    @Test(timeout=180000L)
    public void testQuarantineMissingFamdir() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        final FileSystem fs = FileSystem.get((Configuration)conf);
        HBaseFsck hbck = new HBaseFsck(conf, hbfsckExecutorService){

            public HFileCorruptionChecker createHFileCorruptionChecker(boolean sidelineCorruptHFiles) throws IOException {
                return new HFileCorruptionChecker(BaseTestHBaseFsck.conf, this.executor, sidelineCorruptHFiles){
                    AtomicBoolean attemptedFirstHFile;
                    {
                        this.attemptedFirstHFile = new AtomicBoolean(false);
                    }

                    protected void checkColFamDir(Path p) throws IOException {
                        if (this.attemptedFirstHFile.compareAndSet(false, true)) {
                            Assert.assertTrue((boolean)fs.delete(p, true));
                        }
                        super.checkColFamDir(p);
                    }
                };
            }
        };
        this.doQuarantineTest(tableName, hbck, 3, 0, 0, 0, 1);
        hbck.close();
    }

    @Test(timeout=180000L)
    public void testQuarantineMissingRegionDir() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        final FileSystem fs = FileSystem.get((Configuration)conf);
        HBaseFsck hbck = new HBaseFsck(conf, hbfsckExecutorService){

            public HFileCorruptionChecker createHFileCorruptionChecker(boolean sidelineCorruptHFiles) throws IOException {
                return new HFileCorruptionChecker(BaseTestHBaseFsck.conf, this.executor, sidelineCorruptHFiles){
                    AtomicBoolean attemptedFirstHFile;
                    {
                        this.attemptedFirstHFile = new AtomicBoolean(false);
                    }

                    protected void checkRegionDir(Path p) throws IOException {
                        if (this.attemptedFirstHFile.compareAndSet(false, true)) {
                            Assert.assertTrue((boolean)fs.delete(p, true));
                        }
                        super.checkRegionDir(p);
                    }
                };
            }
        };
        this.doQuarantineTest(tableName, hbck, 3, 0, 0, 0, 1);
        hbck.close();
    }
}

