/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Multimap;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.BaseTestHBaseFsck;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.HBaseFsckRepair;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Ignore
@Category(value={MiscTests.class, LargeTests.class})
public class TestHBaseFsckTwoRS
extends BaseTestHBaseFsck {
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", BaseTestHBaseFsck.MasterSyncCoprocessor.class.getName());
        conf.setInt("hbase.regionserver.handler.count", 2);
        conf.setInt("hbase.regionserver.metahandler.count", 30);
        conf.setInt("hbase.htable.threads.max", 7);
        conf.setInt("hbase.hconnection.threads.max", 14);
        conf.setInt("hbase.hbck.close.timeout", 1600);
        conf.setInt("hbase.rpc.timeout", 6400);
        TEST_UTIL.startMiniCluster(2);
        tableExecutorService = new ThreadPoolExecutor(1, 7, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"testhbck"));
        hbfsckExecutorService = new ScheduledThreadPoolExecutor(7);
        assignmentManager = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        regionStates = assignmentManager.getRegionStates();
        connection = (ClusterConnection)TEST_UTIL.getConnection();
        admin = connection.getAdmin();
        admin.setBalancerRunning(false, true);
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.NAMESPACE_TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        tableExecutorService.shutdown();
        hbfsckExecutorService.shutdown();
        admin.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() {
        EnvironmentEdgeManager.reset();
    }

    @Test(timeout=180000L)
    public void testFixAssignmentsWhenMETAinTransition() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        admin.unassign(RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionName(), true);
        assignmentManager.offlineRegion(RegionInfoBuilder.FIRST_META_REGIONINFO);
        new MetaTableLocator().deleteMetaLocation(cluster.getMaster().getZooKeeper());
        Assert.assertFalse((boolean)regionStates.isRegionOnline(RegionInfoBuilder.FIRST_META_REGIONINFO));
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, true);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN, HBaseFsck.ErrorReporter.ERROR_CODE.NO_META_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NULL_META_REGION});
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testDupeStartKey() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            RegionInfo hriDupe = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"A2"));
            TEST_UTIL.assignRegion(hriDupe);
            ServerName server = regionStates.getRegionServerOfRegion(hriDupe);
            TEST_UTIL.assertRegionOnServer(hriDupe, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testDupeRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            RegionInfo hriDupe = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"));
            TEST_UTIL.assignRegion(hriDupe);
            ServerName server = regionStates.getRegionServerOfRegion(hriDupe);
            TEST_UTIL.assertRegionOnServer(hriDupe, server, 800L);
            while (this.findDeployedHSI(this.getDeployedHRIs(admin), hriDupe) == null) {
                Thread.sleep(250L);
            }
            LOG.debug((Object)"Finished assignment of dupe region");
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testContainedRegionOverlap() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            RegionInfo hriOverlap = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B"));
            TEST_UTIL.assignRegion(hriOverlap);
            ServerName server = regionStates.getRegionServerOfRegion(hriOverlap);
            TEST_UTIL.assertRegionOnServer(hriOverlap, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testLingeringReferenceFile() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path tableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)tableName);
            Path regionDir = (Path)FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir).get(0);
            Path famDir = new Path(regionDir, "fam");
            Path fakeReferenceFile = new Path(famDir, "fbce357483ceea.12144538");
            fs.create(fakeReferenceFile);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_REFERENCE_HFILE});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testLingeringHFileLinks() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path tableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)tableName);
            Path regionDir = (Path)FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir).get(0);
            String regionName = regionDir.getName();
            Path famDir = new Path(regionDir, "fam");
            String HFILE_NAME = "01234567abcd";
            Path hFilePath = new Path(famDir, HFILE_NAME);
            HFileContext context = new HFileContextBuilder().withIncludesTags(false).build();
            HFile.Writer w = HFile.getWriterFactoryNoCache((Configuration)conf).withPath(fs, hFilePath).withFileContext(context).create();
            w.close();
            HFileLink.create((Configuration)conf, (FileSystem)fs, (Path)famDir, (TableName)tableName, (String)regionName, (String)HFILE_NAME);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            fs.delete(hFilePath, true);
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_HFILELINK});
            hbck = HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_HFILELINK});
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testCorruptLinkDirectory() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path tableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)tableName);
            Path regionDir = (Path)FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir).get(0);
            Path famDir = new Path(regionDir, "fam");
            String regionName = regionDir.getName();
            String HFILE_NAME = "01234567abcd";
            String link = HFileLink.createHFileLinkName((TableName)tableName, (String)regionName, (String)HFILE_NAME);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            fs.mkdirs(new Path(famDir, link));
            fs.create(new Path(new Path(famDir, link), "somefile"));
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_HFILELINK});
            hbck = HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_HFILELINK});
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=180000L)
    public void testMetaOffline() throws Exception {
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertNoErrors(hbck);
        this.deleteMetaRegion(conf, true, false, false);
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NO_META_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN});
        hbck = HbckTestingUtil.doFsck(conf, true);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NO_META_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN});
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertNoErrors(hbck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSidelineOverlapRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            Object hbi2;
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            RegionInfo hriOverlap1 = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"AB"));
            TEST_UTIL.assignRegion(hriOverlap1);
            RegionInfo hriOverlap2 = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"AB"), Bytes.toBytes((String)"B"));
            TEST_UTIL.assignRegion(hriOverlap2);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)3L, (long)hbck.getOverlapGroups(tableName).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            Multimap overlapGroups = hbck.getOverlapGroups(tableName);
            ServerName serverName = null;
            byte[] regionName = null;
            for (Object hbi2 : overlapGroups.values()) {
                if (!"A".equals(Bytes.toString((byte[])hbi2.getStartKey())) || !"B".equals(Bytes.toString((byte[])hbi2.getEndKey()))) continue;
                regionName = hbi2.getRegionName();
                int k = cluster.getServerWith(regionName);
                for (int i = 0; i < 3; ++i) {
                    if (i == k) continue;
                    HRegionServer rs = cluster.getRegionServer(i);
                    serverName = rs.getServerName();
                    break;
                }
                HBaseFsckRepair.closeRegionSilentlyAndWait((Connection)connection, (ServerName)cluster.getRegionServer(k).getServerName(), (RegionInfo)hbi2.getHdfsHRI());
                admin.offline(regionName);
                break;
            }
            Assert.assertNotNull(regionName);
            Assert.assertNotNull(serverName);
            Table meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
            hbi2 = null;
            try {
                Put put = new Put(regionName);
                put.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)serverName.getAddress().toString()));
                meta.put(put);
            }
            catch (Throwable throwable) {
                hbi2 = throwable;
                throw throwable;
            }
            finally {
                if (meta != null) {
                    if (hbi2 != null) {
                        try {
                            meta.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)hbi2).addSuppressed(throwable);
                        }
                    } else {
                        meta.close();
                    }
                }
            }
            HBaseFsck fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            HBaseFsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setFixAssignments(true);
            fsck.setFixMeta(true);
            fsck.setFixHdfsHoles(true);
            fsck.setFixHdfsOverlaps(true);
            fsck.setFixHdfsOrphans(true);
            fsck.setFixVersionFile(true);
            fsck.setSidelineBigOverlaps(true);
            fsck.setMaxMerge(2);
            fsck.onlineHbck();
            fsck.close();
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(tableName).size());
            Assert.assertTrue((ROWKEYS.length > this.countRows() ? 1 : 0) != 0);
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=180000L)
    public void testHBaseFsck() throws Exception {
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toString((byte[])FAM));
        desc.addFamily(hcd);
        TestHBaseFsckTwoRS.createTable(TEST_UTIL, desc, null);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        Table meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
        Scan scan = new Scan();
        scan.setStartRow(Bytes.toBytes((String)(tableName + ",,")));
        ResultScanner scanner = meta.getScanner(scan);
        RegionInfo hri = null;
        Result res = scanner.next();
        ServerName currServer = ProtobufUtil.parseServerNameFrom((byte[])res.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER));
        long startCode = Bytes.toLong((byte[])res.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER));
        for (JVMClusterUtil.RegionServerThread rs : TEST_UTIL.getHBaseCluster().getRegionServerThreads()) {
            ServerName sn = rs.getRegionServer().getServerName();
            if (currServer.getHostAndPort().equals(sn.getHostAndPort()) && startCode == sn.getStartcode()) continue;
            Put put = new Put(res.getRow());
            put.setDurability(Durability.SKIP_WAL);
            put.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)sn.getHostAndPort()));
            put.addColumn(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)sn.getStartcode()));
            meta.put(put);
            hri = MetaTableAccessor.getRegionInfo((Result)res);
            break;
        }
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, true), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.SERVER_DOES_NOT_MATCH_META});
        TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hri);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        Table t = connection.getTable(tableName, tableExecutorService);
        ResultScanner s = t.getScanner(new Scan());
        s.close();
        t.close();
        scanner.close();
        meta.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testHDFSRegioninfoMissingAndCheckRegionBoundary() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(tableName);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, false, true, 0);
            admin.enableTable(tableName);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(tableName).size());
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            for (int i = 0; i < ROWKEYS.length; ++i) {
                if (i != ROWKEYS.length - 1) {
                    Assert.assertEquals((long)1L, (long)this.countRows(ROWKEYS[i], ROWKEYS[i + 1]));
                    continue;
                }
                Assert.assertEquals((long)1L, (long)this.countRows(ROWKEYS[i], null));
            }
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSplitAndDupeRegion() throws Exception {
        TableName table = TableName.valueOf((String)"testSplitAndDupeRegion");
        Table meta = null;
        try {
            this.setupTable(table);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.enableCatalogJanitor(false);
            meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
            HRegionLocation loc = connection.getRegionLocation(table, SPLITS[0], false);
            HRegionInfo hriParent = loc.getRegionInfo();
            connection.getAdmin().split(table, Bytes.toBytes((String)"A@"));
            Thread.sleep(1000L);
            regionStates.updateRegionState((RegionInfo)hriParent, RegionState.State.CLOSED);
            TEST_UTIL.assignRegion((RegionInfo)hriParent);
            MetaTableAccessor.addRegionToMeta((Table)meta, (RegionInfo)hriParent);
            ServerName server = regionStates.getRegionServerOfRegion((RegionInfo)hriParent);
            if (server != null) {
                TEST_UTIL.assertRegionOnServer((RegionInfo)hriParent, server, 800L);
            }
            while (this.findDeployedHSI(this.getDeployedHRIs((Admin)((HBaseAdmin)admin)), (RegionInfo)hriParent) == null) {
                Thread.sleep(250L);
            }
            LOG.debug((Object)"Finished assignment of parent region");
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)3L, (long)hbck.getOverlapGroups(table).size());
            hbck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            hbck.setDisplayFullReport();
            hbck.setTimeLag(0L);
            hbck.setFixHdfsOverlaps(true);
            hbck.setRemoveParents(true);
            hbck.setFixReferenceFiles(true);
            hbck.setFixHFileLinks(true);
            hbck.connect();
            hbck.onlineHbck();
            hbck.close();
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }
}

