/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.junit.Assert;

public class HbckTestingUtil {
    private static ExecutorService exec = new ScheduledThreadPoolExecutor(10);

    public static HBaseFsck doFsck(Configuration conf, boolean fix) throws Exception {
        return HbckTestingUtil.doFsck(conf, fix, null);
    }

    public static HBaseFsck doFsck(Configuration conf, boolean fix, TableName table) throws Exception {
        return HbckTestingUtil.doFsck(conf, fix, fix, fix, fix, fix, fix, fix, fix, fix, fix, fix, fix, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HBaseFsck doFsck(Configuration conf, boolean fixAssignments, boolean fixMeta, boolean fixHdfsHoles, boolean fixHdfsOverlaps, boolean fixHdfsOrphans, boolean fixTableOrphans, boolean fixVersionFile, boolean fixReferenceFiles, boolean fixHFileLinks, boolean fixEmptyMetaRegionInfo, boolean fixTableLocks, Boolean fixReplication, TableName table) throws Exception {
        try (HBaseFsck fsck = new HBaseFsck(conf, exec);){
            HBaseFsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setFixAssignments(fixAssignments);
            fsck.setFixMeta(fixMeta);
            fsck.setFixHdfsHoles(fixHdfsHoles);
            fsck.setFixHdfsOverlaps(fixHdfsOverlaps);
            fsck.setFixHdfsOrphans(fixHdfsOrphans);
            fsck.setFixTableOrphans(fixTableOrphans);
            fsck.setFixVersionFile(fixVersionFile);
            fsck.setFixReferenceFiles(fixReferenceFiles);
            fsck.setFixHFileLinks(fixHFileLinks);
            fsck.setFixEmptyMetaCells(fixEmptyMetaRegionInfo);
            fsck.setFixReplication(fixReplication.booleanValue());
            if (table != null) {
                fsck.includeTable(table);
            }
            fsck.connect();
            fsck.onlineHbck();
        }
        return fsck;
    }

    public static HBaseFsck doHFileQuarantine(Configuration conf, TableName table) throws Exception {
        String[] args = new String[]{"-sidelineCorruptHFiles", "-ignorePreCheckPermission", table.getNameAsString()};
        HBaseFsck hbck = new HBaseFsck(conf, exec);
        hbck.exec(exec, args);
        return hbck;
    }

    public static boolean inconsistencyFound(HBaseFsck fsck) throws Exception {
        ArrayList errs = fsck.getErrors().getErrorList();
        return errs != null && !errs.isEmpty();
    }

    public static void assertNoErrors(HBaseFsck fsck) throws Exception {
        ArrayList errs = fsck.getErrors().getErrorList();
        Assert.assertEquals(new ArrayList(), (Object)errs);
    }

    public static void assertErrors(HBaseFsck fsck, HBaseFsck.ErrorReporter.ERROR_CODE[] expectedErrors) {
        ArrayList errs = fsck.getErrors().getErrorList();
        Collections.sort(errs);
        ArrayList expErrs = Lists.newArrayList((Object[])expectedErrors);
        Collections.sort(expErrs);
        Assert.assertEquals((Object)expErrs, (Object)errs);
    }
}

