/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.FSHLogProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALPerformanceEvaluation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestFSHLogProvider {
    private static final Log LOG = LogFactory.getLog(TestFSHLogProvider.class);
    protected static Configuration conf;
    protected static FileSystem fs;
    protected static final HBaseTestingUtility TEST_UTIL;
    protected MultiVersionConcurrencyControl mvcc;
    @Rule
    public final TestName currentTest = new TestName();
    private static final byte[] UNSPECIFIED_REGION;

    @Before
    public void setUp() throws Exception {
        FileStatus[] entries;
        this.mvcc = new MultiVersionConcurrencyControl();
        for (FileStatus dir : entries = fs.listStatus(new Path("/"))) {
            fs.delete(dir.getPath(), true);
        }
    }

    @After
    public void tearDown() throws Exception {
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("dfs.blocksize", 0x100000);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.socket-timeout", 5000);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connect.max.retries", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.recovery.retries", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connection.maxidletime", 500);
        TEST_UTIL.startMiniDFSCluster(3);
        TEST_UTIL.createRootDir();
        conf = TEST_UTIL.getConfiguration();
        fs = TEST_UTIL.getDFSCluster().getFileSystem();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    static String getName() {
        return "TestDefaultWALProvider";
    }

    @Test
    public void testGetServerNameFromWALDirectoryName() throws IOException {
        ServerName sn = ServerName.valueOf((String)"hn", (int)450, (long)1398L);
        String hl = FSUtils.getRootDir((Configuration)conf) + "/" + AbstractFSWALProvider.getWALDirectoryName((String)sn.toString());
        Assert.assertNull((Object)AbstractFSWALProvider.getServerNameFromWALDirectoryName((Configuration)conf, null));
        Assert.assertNull((Object)AbstractFSWALProvider.getServerNameFromWALDirectoryName((Configuration)conf, (String)FSUtils.getRootDir((Configuration)conf).toUri().toString()));
        Assert.assertNull((Object)AbstractFSWALProvider.getServerNameFromWALDirectoryName((Configuration)conf, (String)""));
        Assert.assertNull((Object)AbstractFSWALProvider.getServerNameFromWALDirectoryName((Configuration)conf, (String)"                  "));
        Assert.assertNull((Object)AbstractFSWALProvider.getServerNameFromWALDirectoryName((Configuration)conf, (String)hl));
        Assert.assertNull((Object)AbstractFSWALProvider.getServerNameFromWALDirectoryName((Configuration)conf, (String)(hl + "qdf")));
        Assert.assertNull((Object)AbstractFSWALProvider.getServerNameFromWALDirectoryName((Configuration)conf, (String)("sfqf" + hl + "qdf")));
        String wals = "/WALs/";
        ServerName parsed = AbstractFSWALProvider.getServerNameFromWALDirectoryName((Configuration)conf, (String)(FSUtils.getRootDir((Configuration)conf).toUri().toString() + "/WALs/" + sn + "/localhost%2C32984%2C1343316388997.1343316390417"));
        Assert.assertEquals((String)"standard", (Object)sn, (Object)parsed);
        parsed = AbstractFSWALProvider.getServerNameFromWALDirectoryName((Configuration)conf, (String)(hl + "/qdf"));
        Assert.assertEquals((String)"subdir", (Object)sn, (Object)parsed);
        parsed = AbstractFSWALProvider.getServerNameFromWALDirectoryName((Configuration)conf, (String)(FSUtils.getRootDir((Configuration)conf).toUri().toString() + "/WALs/" + sn + "-splitting/localhost%3A57020.1340474893931"));
        Assert.assertEquals((String)"split", (Object)sn, (Object)parsed);
    }

    protected void addEdits(WAL log, HRegionInfo hri, HTableDescriptor htd, int times, NavigableMap<byte[], Integer> scopes) throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        for (int i = 0; i < times; ++i) {
            long timestamp = System.currentTimeMillis();
            WALEdit cols = new WALEdit();
            cols.add((Cell)new KeyValue(row, row, row, timestamp, row));
            log.append((RegionInfo)hri, this.getWalKey(hri.getEncodedNameAsBytes(), htd.getTableName(), timestamp, scopes), cols, true);
        }
        log.sync();
    }

    WALKey getWalKey(byte[] info, TableName tableName, long timestamp, NavigableMap<byte[], Integer> scopes) {
        return new WALKey(info, tableName, timestamp, this.mvcc, scopes);
    }

    protected void flushRegion(WAL wal, byte[] regionEncodedName, Set<byte[]> flushedFamilyNames) {
        wal.startCacheFlush(regionEncodedName, flushedFamilyNames);
        wal.completeCacheFlush(regionEncodedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogCleaning() throws Exception {
        Object fam2;
        LOG.info((Object)this.currentTest.getMethodName());
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.currentTest.getMethodName())).addFamily(new HColumnDescriptor("row"));
        HTableDescriptor htd2 = new HTableDescriptor(TableName.valueOf((String)(this.currentTest.getMethodName() + "2"))).addFamily(new HColumnDescriptor("row"));
        TreeMap<byte[], Integer> scopes1 = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (Object fam2 : htd.getFamiliesKeys()) {
            scopes1.put((byte[])fam2, 0);
        }
        TreeMap<byte[], Integer> scopes2 = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        fam2 = htd2.getFamiliesKeys().iterator();
        while (fam2.hasNext()) {
            byte[] fam3 = (byte[])fam2.next();
            scopes2.put(fam3, 0);
        }
        Configuration localConf = new Configuration(conf);
        localConf.set("hbase.wal.provider", FSHLogProvider.class.getName());
        try (WALFactory wals = new WALFactory(localConf, null, this.currentTest.getMethodName());){
            HRegionInfo hri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HRegionInfo hri2 = new HRegionInfo(htd2.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            WAL log = wals.getWAL(UNSPECIFIED_REGION, null);
            this.addEdits(log, hri, htd, 1, scopes1);
            log.rollWriter();
            Assert.assertEquals((long)1L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)log));
            this.addEdits(log, hri, htd, 2, scopes1);
            log.rollWriter();
            Assert.assertEquals((long)2L, (long)FSHLogProvider.getNumRolledLogFiles((WAL)log));
            this.addEdits(log, hri, htd, 1, scopes1);
            this.addEdits(log, hri2, htd2, 1, scopes2);
            this.addEdits(log, hri, htd, 1, scopes1);
            this.addEdits(log, hri2, htd2, 1, scopes2);
            log.rollWriter();
            Assert.assertEquals((long)3L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)log));
            this.addEdits(log, hri2, htd2, 1, scopes2);
            log.startCacheFlush(hri.getEncodedNameAsBytes(), htd.getFamiliesKeys());
            log.completeCacheFlush(hri.getEncodedNameAsBytes());
            log.rollWriter();
            Assert.assertEquals((long)2L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)log));
            this.addEdits(log, hri2, htd2, 1, scopes2);
            log.startCacheFlush(hri2.getEncodedNameAsBytes(), htd2.getFamiliesKeys());
            log.completeCacheFlush(hri2.getEncodedNameAsBytes());
            log.rollWriter();
            Assert.assertEquals((long)0L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)log));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWALArchiving() throws IOException {
        Object fam2;
        LOG.debug((Object)this.currentTest.getMethodName());
        HTableDescriptor table1 = new HTableDescriptor(TableName.valueOf((String)(this.currentTest.getMethodName() + "1"))).addFamily(new HColumnDescriptor("row"));
        HTableDescriptor table2 = new HTableDescriptor(TableName.valueOf((String)(this.currentTest.getMethodName() + "2"))).addFamily(new HColumnDescriptor("row"));
        TreeMap<byte[], Integer> scopes1 = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (Object fam2 : table1.getFamiliesKeys()) {
            scopes1.put((byte[])fam2, 0);
        }
        TreeMap<byte[], Integer> scopes2 = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        fam2 = table2.getFamiliesKeys().iterator();
        while (fam2.hasNext()) {
            byte[] fam3 = (byte[])fam2.next();
            scopes2.put(fam3, 0);
        }
        Configuration localConf = new Configuration(conf);
        localConf.set("hbase.wal.provider", FSHLogProvider.class.getName());
        try (WALFactory wals = new WALFactory(localConf, null, this.currentTest.getMethodName());){
            WAL wal = wals.getWAL(UNSPECIFIED_REGION, null);
            Assert.assertEquals((long)0L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)wal));
            HRegionInfo hri1 = new HRegionInfo(table1.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HRegionInfo hri2 = new HRegionInfo(table2.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            hri1.setSplit(false);
            hri2.setSplit(false);
            this.addEdits(wal, hri1, table1, 1, scopes1);
            wal.rollWriter();
            Assert.assertEquals((long)1L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)wal));
            this.addEdits(wal, hri1, table1, 1, scopes1);
            wal.rollWriter();
            Assert.assertEquals((long)2L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)wal));
            this.addEdits(wal, hri1, table1, 3, scopes1);
            this.flushRegion(wal, hri1.getEncodedNameAsBytes(), table1.getFamiliesKeys());
            wal.rollWriter();
            Assert.assertEquals((long)0L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)wal));
            this.addEdits(wal, hri2, table2, 1, scopes2);
            wal.rollWriter();
            Assert.assertEquals((long)1L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)wal));
            this.addEdits(wal, hri1, table1, 2, scopes1);
            wal.rollWriter();
            Assert.assertEquals((long)2L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)wal));
            this.addEdits(wal, hri2, table2, 2, scopes2);
            this.flushRegion(wal, hri1.getEncodedNameAsBytes(), table2.getFamiliesKeys());
            wal.rollWriter();
            Assert.assertEquals((long)2L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)wal));
            this.addEdits(wal, hri2, table2, 2, scopes2);
            this.flushRegion(wal, hri2.getEncodedNameAsBytes(), table2.getFamiliesKeys());
            wal.rollWriter();
            Assert.assertEquals((long)0L, (long)AbstractFSWALProvider.getNumRolledLogFiles((WAL)wal));
        }
    }

    @Test
    public void testConcurrentWrites() throws Exception {
        int errCode = WALPerformanceEvaluation.innerMain(new Configuration(TEST_UTIL.getConfiguration()), new String[]{"-threads", "3", "-verify", "-noclosefs", "-iterations", "3000"});
        Assert.assertEquals((long)0L, (long)errCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setMembershipDedups() throws IOException {
        Configuration localConf = new Configuration(conf);
        localConf.set("hbase.wal.provider", FSHLogProvider.class.getName());
        try (WALFactory wals = new WALFactory(localConf, null, this.currentTest.getMethodName());){
            HashSet<WAL> seen = new HashSet<WAL>(1);
            Random random = new Random();
            Assert.assertTrue((String)"first attempt to add WAL from default provider should work.", (boolean)seen.add(wals.getWAL(Bytes.toBytes((int)random.nextInt()), null)));
            for (int i = 0; i < 1000; ++i) {
                Assert.assertFalse((String)"default wal provider is only supposed to return a single wal, which should compare as .equals itself.", (boolean)seen.add(wals.getWAL(Bytes.toBytes((int)random.nextInt()), null)));
            }
        }
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        UNSPECIFIED_REGION = new byte[0];
    }
}

