/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.SecureAsyncProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogWriter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, MediumTests.class})
public class TestSecureWAL {
    static final HBaseTestingUtility TEST_UTIL;
    @Rule
    public TestName name = new TestName();
    @Parameterized.Parameter
    public String walProvider;

    @Parameterized.Parameters(name="{index}: provider={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"defaultProvider"}, {"asyncfs"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        conf.setClass("hbase.regionserver.hlog.reader.impl", SecureProtobufLogReader.class, WAL.Reader.class);
        conf.setClass("hbase.regionserver.hlog.writer.impl", SecureProtobufLogWriter.class, WALProvider.Writer.class);
        conf.setClass("hbase.regionserver.hlog.async.writer.impl", SecureAsyncProtobufLogWriter.class, WALProvider.AsyncWriter.class);
        conf.setBoolean("hbase.regionserver.wal.encryption", true);
        FSUtils.setRootDir((Configuration)conf, (Path)TEST_UTIL.getDataTestDirOnTestFS());
        TEST_UTIL.startMiniDFSCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() {
        TEST_UTIL.getConfiguration().set("hbase.wal.provider", this.walProvider);
    }

    @Test
    public void testSecureWAL() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName().replaceAll("[^a-zA-Z0-9]", "_"));
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(tableName.getName()));
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (byte[] fam : htd.getFamiliesKeys()) {
            scopes.put(fam, 0);
        }
        HRegionInfo regioninfo = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false);
        int total = 10;
        byte[] row = Bytes.toBytes((String)"row");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] value = Bytes.toBytes((String)"Test value");
        DistributedFileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
        WALFactory wals = new WALFactory(TEST_UTIL.getConfiguration(), null, tableName.getNameAsString());
        WAL wal = wals.getWAL(regioninfo.getEncodedNameAsBytes(), regioninfo.getTable().getNamespace());
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        for (int i = 0; i < 10; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add((Cell)new KeyValue(row, family, Bytes.toBytes((int)i), value));
            wal.append((RegionInfo)regioninfo, new WALKey(regioninfo.getEncodedNameAsBytes(), tableName, System.currentTimeMillis(), mvcc, scopes), kvs, true);
        }
        wal.sync();
        Path walPath = AbstractFSWALProvider.getCurrentFileName((WAL)wal);
        wals.shutdown();
        long length = fs.getFileStatus(walPath).getLen();
        FSDataInputStream in = fs.open(walPath);
        byte[] fileData = new byte[(int)length];
        IOUtils.readFully((InputStream)in, (byte[])fileData);
        in.close();
        Assert.assertFalse((String)"Cells appear to be plaintext", (boolean)Bytes.contains((byte[])fileData, (byte[])value));
        WAL.Reader reader = wals.createReader(TEST_UTIL.getTestFileSystem(), walPath);
        int count = 0;
        WAL.Entry entry = new WAL.Entry();
        while (reader.next(entry) != null) {
            ++count;
            ArrayList cells = entry.getEdit().getCells();
            Assert.assertTrue((String)"Should be one KV per WALEdit", (cells.size() == 1 ? 1 : 0) != 0);
            for (Cell cell : cells) {
                Assert.assertTrue((String)"Incorrect row", (boolean)Bytes.equals((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength(), (byte[])row, (int)0, (int)row.length));
                Assert.assertTrue((String)"Incorrect family", (boolean)Bytes.equals((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength(), (byte[])family, (int)0, (int)family.length));
                Assert.assertTrue((String)"Incorrect value", (boolean)Bytes.equals((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])value, (int)0, (int)value.length));
            }
        }
        Assert.assertEquals((String)"Should have read back as many KVs as written", (long)10L, (long)count);
        reader.close();
    }

    static {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.hbase.regionserver.wal")).getLogger().setLevel(Level.ALL);
        TEST_UTIL = new HBaseTestingUtility();
    }
}

