/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface Server
extends Abortable,
Stoppable {
    public Configuration getConfiguration();

    public ZooKeeperWatcher getZooKeeper();

    public Connection getConnection();

    public ClusterConnection getClusterConnection();

    public MetaTableLocator getMetaTableLocator();

    public ServerName getServerName();

    public CoordinatedStateManager getCoordinatedStateManager();

    public ChoreService getChoreService();

    default public FileSystem getFileSystem() {
        Configuration c = this.getConfiguration();
        FileSystem fs = null;
        try {
            if (c != null) {
                fs = FileSystem.get((Configuration)c);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fs;
    }

    default public boolean isStopping() {
        return false;
    }
}

