/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class LogCleaner
extends CleanerChore<BaseLogCleanerDelegate> {
    private static final Log LOG = LogFactory.getLog((String)LogCleaner.class.getName());

    public LogCleaner(int period, Stoppable stopper, Configuration conf, FileSystem fs, Path oldLogDir) {
        super("LogsCleaner", period, stopper, conf, fs, oldLogDir, "hbase.master.logcleaner.plugins");
    }

    @Override
    protected boolean validate(Path file) {
        return AbstractFSWALProvider.validateWALFilename(file.getName()) || MasterProcedureUtil.validateProcedureWALFilename(file.getName());
    }
}

