/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractStateMachineNamespaceProcedure<TState>
extends StateMachineProcedure<MasterProcedureEnv, TState>
implements TableProcedureInterface {
    protected AbstractStateMachineNamespaceProcedure() {
    }

    protected AbstractStateMachineNamespaceProcedure(MasterProcedureEnv env) {
        this.setOwner(env.getRequestUser());
    }

    protected abstract String getNamespaceName();

    @Override
    public TableName getTableName() {
        return TableName.NAMESPACE_TABLE_NAME;
    }

    @Override
    public abstract TableProcedureInterface.TableOperationType getTableOperationType();

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(", namespace=");
        sb.append(this.getNamespaceName());
    }

    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.waitInitialized((Procedure)this)) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        if (env.getProcedureScheduler().waitNamespaceExclusiveLock((Procedure)this, this.getNamespaceName())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeNamespaceExclusiveLock((Procedure)this, this.getNamespaceName());
    }
}

