/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class BusyRegionSplitPolicy
extends IncreasingToUpperBoundRegionSplitPolicy {
    private static final Log LOG = LogFactory.getLog(BusyRegionSplitPolicy.class);
    private float maxBlockedRequests;
    public static final float DEFAULT_MAX_BLOCKED_REQUESTS = 0.2f;
    private long minAge = -1L;
    public static final long DEFAULT_MIN_AGE_MS = 600000L;
    private long aggregationWindow;
    public static final long DEFAULT_AGGREGATION_WINDOW = 300000L;
    private HRegion region;
    private long prevTime;
    private long startTime;
    private long writeRequestCount;
    private long blockedRequestCount;
    private float blockedRate;

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        this.region = region;
        Configuration conf = this.getConf();
        this.maxBlockedRequests = conf.getFloat("hbase.busy.policy.blockedRequests", 0.2f);
        this.minAge = conf.getLong("hbase.busy.policy.minAge", 600000L);
        this.aggregationWindow = conf.getLong("hbase.busy.policy.aggWindow", 300000L);
        if (this.maxBlockedRequests < 1.0E-5f || this.maxBlockedRequests > 0.99999f) {
            LOG.warn((Object)"Threshold for maximum blocked requests is set too low or too high,  resetting to default of 0.2");
            this.maxBlockedRequests = 0.2f;
        }
        if (this.aggregationWindow <= 0L) {
            LOG.warn((Object)("Aggregation window size is too low: " + this.aggregationWindow + ". Resetting it to default of " + 300000L));
            this.aggregationWindow = 300000L;
        }
        this.init();
    }

    private synchronized void init() {
        this.prevTime = this.startTime = EnvironmentEdgeManager.currentTime();
        this.blockedRequestCount = this.region.getBlockedRequestsCount();
        this.writeRequestCount = this.region.getWriteRequestsCount();
    }

    @Override
    protected boolean shouldSplit() {
        float blockedReqRate = this.updateRate();
        if (super.shouldSplit()) {
            return true;
        }
        if (EnvironmentEdgeManager.currentTime() < this.startTime + this.minAge) {
            return false;
        }
        for (HStore store : this.region.getStores()) {
            if (store.canSplit()) continue;
            return false;
        }
        if (blockedReqRate >= this.maxBlockedRequests) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Going to split region " + this.region.getRegionInfo().getRegionNameAsString() + " because it's too busy. Blocked Request rate: " + blockedReqRate));
            }
            return true;
        }
        return false;
    }

    private synchronized float updateRate() {
        long curTime = EnvironmentEdgeManager.currentTime();
        long newBlockedReqs = this.region.getBlockedRequestsCount();
        long newWriteReqs = this.region.getWriteRequestsCount();
        float aggBlockedRate = (float)(newBlockedReqs - this.blockedRequestCount) / ((float)(newWriteReqs - this.writeRequestCount) + 1.0E-5f);
        if (curTime - this.prevTime >= this.aggregationWindow) {
            this.blockedRate = aggBlockedRate;
            this.prevTime = curTime;
            this.blockedRequestCount = newBlockedReqs;
            this.writeRequestCount = newWriteReqs;
        } else if (curTime - this.startTime >= this.aggregationWindow) {
            float timeSlice = (float)(curTime - this.prevTime) / ((float)this.aggregationWindow + 0.0f);
            aggBlockedRate = (1.0f - timeSlice) * this.blockedRate + timeSlice * aggBlockedRate;
        } else {
            aggBlockedRate = 0.0f;
        }
        return aggBlockedRate;
    }
}

