/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.mob.MobCacheConfig;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hdfs.DFSHedgedReadMetrics;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class MetricsRegionServerWrapperImpl
implements MetricsRegionServerWrapper {
    private static final Log LOG = LogFactory.getLog(MetricsRegionServerWrapperImpl.class);
    private final HRegionServer regionServer;
    private final MetricsWALSource metricsWALSource;
    private BlockCache blockCache;
    private MobFileCache mobFileCache;
    private volatile long numStores = 0L;
    private volatile long numWALFiles = 0L;
    private volatile long walFileSize = 0L;
    private volatile long numStoreFiles = 0L;
    private volatile long memstoreSize = 0L;
    private volatile long storeFileSize = 0L;
    private volatile long maxStoreFileAge = 0L;
    private volatile long minStoreFileAge = 0L;
    private volatile long avgStoreFileAge = 0L;
    private volatile long numReferenceFiles = 0L;
    private volatile double requestsPerSecond = 0.0;
    private volatile long readRequestsCount = 0L;
    private volatile long filteredReadRequestsCount = 0L;
    private volatile long writeRequestsCount = 0L;
    private volatile long checkAndMutateChecksFailed = 0L;
    private volatile long checkAndMutateChecksPassed = 0L;
    private volatile long storefileIndexSize = 0L;
    private volatile long totalStaticIndexSize = 0L;
    private volatile long totalStaticBloomSize = 0L;
    private volatile long numMutationsWithoutWAL = 0L;
    private volatile long dataInMemoryWithoutWAL = 0L;
    private volatile double percentFileLocal = 0.0;
    private volatile double percentFileLocalSecondaryRegions = 0.0;
    private volatile long flushedCellsCount = 0L;
    private volatile long compactedCellsCount = 0L;
    private volatile long majorCompactedCellsCount = 0L;
    private volatile long flushedCellsSize = 0L;
    private volatile long compactedCellsSize = 0L;
    private volatile long majorCompactedCellsSize = 0L;
    private volatile long cellsCountCompactedToMob = 0L;
    private volatile long cellsCountCompactedFromMob = 0L;
    private volatile long cellsSizeCompactedToMob = 0L;
    private volatile long cellsSizeCompactedFromMob = 0L;
    private volatile long mobFlushCount = 0L;
    private volatile long mobFlushedCellsCount = 0L;
    private volatile long mobFlushedCellsSize = 0L;
    private volatile long mobScanCellsCount = 0L;
    private volatile long mobScanCellsSize = 0L;
    private volatile long mobFileCacheAccessCount = 0L;
    private volatile long mobFileCacheMissCount = 0L;
    private volatile double mobFileCacheHitRatio = 0.0;
    private volatile long mobFileCacheEvictedCount = 0L;
    private volatile long mobFileCacheCount = 0L;
    private volatile long blockedRequestsCount = 0L;
    private volatile long averageRegionSize = 0L;
    private CacheStats cacheStats;
    private CacheStats l1Stats = null;
    private CacheStats l2Stats = null;
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long period;
    private DFSHedgedReadMetrics dfsHedgedReadMetrics;

    public MetricsRegionServerWrapperImpl(HRegionServer regionServer) {
        this.regionServer = regionServer;
        this.initBlockCache();
        this.initMobFileCache();
        this.period = regionServer.conf.getLong("hbase.regionserver.metrics.period", 5000L);
        this.executor = ((MetricsExecutor)CompatibilitySingletonFactory.getInstance(MetricsExecutor.class)).getExecutor();
        this.runnable = new RegionServerMetricsWrapperRunnable();
        this.executor.scheduleWithFixedDelay(this.runnable, this.period, this.period, TimeUnit.MILLISECONDS);
        this.metricsWALSource = (MetricsWALSource)CompatibilitySingletonFactory.getInstance(MetricsWALSource.class);
        try {
            this.dfsHedgedReadMetrics = FSUtils.getDFSHedgedReadMetrics(regionServer.getConfiguration());
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to get hedged metrics", (Throwable)e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Computing regionserver metrics every " + this.period + " milliseconds"));
        }
    }

    private synchronized void initBlockCache() {
        CacheConfig cacheConfig = this.regionServer.cacheConfig;
        if (cacheConfig != null) {
            this.l1Stats = cacheConfig.getL1Stats();
            this.l2Stats = cacheConfig.getL2Stats();
            if (this.blockCache == null) {
                this.blockCache = cacheConfig.getBlockCache();
            }
        }
        if (this.blockCache != null && this.cacheStats == null) {
            this.cacheStats = this.blockCache.getStats();
        }
    }

    private synchronized void initMobFileCache() {
        MobCacheConfig mobCacheConfig = this.regionServer.mobCacheConfig;
        if (mobCacheConfig != null && this.mobFileCache == null) {
            this.mobFileCache = mobCacheConfig.getMobFileCache();
        }
    }

    public String getClusterId() {
        return this.regionServer.getClusterId();
    }

    public long getStartCode() {
        return this.regionServer.getStartcode();
    }

    public String getZookeeperQuorum() {
        ZooKeeperWatcher zk = this.regionServer.getZooKeeper();
        if (zk == null) {
            return "";
        }
        return zk.getQuorum();
    }

    public String getCoprocessors() {
        Object[] coprocessors = this.regionServer.getRegionServerCoprocessors();
        if (coprocessors == null || coprocessors.length == 0) {
            return "";
        }
        return StringUtils.join((Object[])coprocessors, (String)", ");
    }

    public String getServerName() {
        ServerName serverName = this.regionServer.getServerName();
        if (serverName == null) {
            return "";
        }
        return serverName.getServerName();
    }

    public long getNumOnlineRegions() {
        Collection<HRegion> onlineRegionsLocalContext = this.regionServer.getOnlineRegionsLocalContext();
        if (onlineRegionsLocalContext == null) {
            return 0L;
        }
        return onlineRegionsLocalContext.size();
    }

    public long getTotalRequestCount() {
        return this.regionServer.rpcServices.requestCount.sum();
    }

    public long getTotalRowActionRequestCount() {
        return this.regionServer.rpcServices.requestRowActionCount.sum();
    }

    public int getSplitQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getSplitQueueSize();
    }

    public int getCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getCompactionQueueSize();
    }

    public int getSmallCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getSmallCompactionQueueSize();
    }

    public int getLargeCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getLargeCompactionQueueSize();
    }

    public int getFlushQueueSize() {
        if (this.regionServer.cacheFlusher == null) {
            return 0;
        }
        return this.regionServer.cacheFlusher.getFlushQueueSize();
    }

    public long getBlockCacheCount() {
        if (this.blockCache == null) {
            return 0L;
        }
        return this.blockCache.getBlockCount();
    }

    public long getMemStoreLimit() {
        return this.regionServer.getRegionServerAccounting().getGlobalMemStoreLimit();
    }

    public long getBlockCacheSize() {
        if (this.blockCache == null) {
            return 0L;
        }
        return this.blockCache.getCurrentSize();
    }

    public long getBlockCacheFreeSize() {
        if (this.blockCache == null) {
            return 0L;
        }
        return this.blockCache.getFreeSize();
    }

    public long getBlockCacheHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getHitCount();
    }

    public long getBlockCachePrimaryHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getPrimaryHitCount();
    }

    public long getBlockCacheMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getMissCount();
    }

    public long getBlockCachePrimaryMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getPrimaryMissCount();
    }

    public long getBlockCacheEvictedCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getEvictedCount();
    }

    public long getBlockCachePrimaryEvictedCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getPrimaryEvictedCount();
    }

    public double getBlockCacheHitPercent() {
        if (this.cacheStats == null) {
            return 0.0;
        }
        double ratio = this.cacheStats.getHitRatio();
        if (Double.isNaN(ratio)) {
            ratio = 0.0;
        }
        return ratio * 100.0;
    }

    public double getBlockCacheHitCachingPercent() {
        if (this.cacheStats == null) {
            return 0.0;
        }
        double ratio = this.cacheStats.getHitCachingRatio();
        if (Double.isNaN(ratio)) {
            ratio = 0.0;
        }
        return ratio * 100.0;
    }

    public long getBlockCacheFailedInsertions() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getFailedInserts();
    }

    public long getL1CacheHitCount() {
        if (this.l1Stats == null) {
            return 0L;
        }
        return this.l1Stats.getHitCount();
    }

    public long getL1CacheMissCount() {
        if (this.l1Stats == null) {
            return 0L;
        }
        return this.l1Stats.getMissCount();
    }

    public double getL1CacheHitRatio() {
        if (this.l1Stats == null) {
            return 0.0;
        }
        return this.l1Stats.getHitRatio();
    }

    public double getL1CacheMissRatio() {
        if (this.l1Stats == null) {
            return 0.0;
        }
        return this.l1Stats.getMissRatio();
    }

    public long getL2CacheHitCount() {
        if (this.l2Stats == null) {
            return 0L;
        }
        return this.l2Stats.getHitCount();
    }

    public long getL2CacheMissCount() {
        if (this.l2Stats == null) {
            return 0L;
        }
        return this.l2Stats.getMissCount();
    }

    public double getL2CacheHitRatio() {
        if (this.l2Stats == null) {
            return 0.0;
        }
        return this.l2Stats.getHitRatio();
    }

    public double getL2CacheMissRatio() {
        if (this.l2Stats == null) {
            return 0.0;
        }
        return this.l2Stats.getMissRatio();
    }

    public void forceRecompute() {
        this.runnable.run();
    }

    public long getNumStores() {
        return this.numStores;
    }

    public long getNumWALFiles() {
        return this.numWALFiles;
    }

    public long getWALFileSize() {
        return this.walFileSize;
    }

    public long getNumWALSlowAppend() {
        return this.metricsWALSource.getSlowAppendCount();
    }

    public long getNumStoreFiles() {
        return this.numStoreFiles;
    }

    public long getMaxStoreFileAge() {
        return this.maxStoreFileAge;
    }

    public long getMinStoreFileAge() {
        return this.minStoreFileAge;
    }

    public long getAvgStoreFileAge() {
        return this.avgStoreFileAge;
    }

    public long getNumReferenceFiles() {
        return this.numReferenceFiles;
    }

    public long getMemStoreSize() {
        return this.memstoreSize;
    }

    public long getStoreFileSize() {
        return this.storeFileSize;
    }

    public double getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public long getReadRequestsCount() {
        return this.readRequestsCount;
    }

    public long getFilteredReadRequestsCount() {
        return this.filteredReadRequestsCount;
    }

    public long getWriteRequestsCount() {
        return this.writeRequestsCount;
    }

    public long getRpcGetRequestsCount() {
        return this.regionServer.rpcServices.rpcGetRequestCount.sum();
    }

    public long getRpcScanRequestsCount() {
        return this.regionServer.rpcServices.rpcScanRequestCount.sum();
    }

    public long getRpcMultiRequestsCount() {
        return this.regionServer.rpcServices.rpcMultiRequestCount.sum();
    }

    public long getRpcMutateRequestsCount() {
        return this.regionServer.rpcServices.rpcMutateRequestCount.sum();
    }

    public long getCheckAndMutateChecksFailed() {
        return this.checkAndMutateChecksFailed;
    }

    public long getCheckAndMutateChecksPassed() {
        return this.checkAndMutateChecksPassed;
    }

    public long getStoreFileIndexSize() {
        return this.storefileIndexSize;
    }

    public long getTotalStaticIndexSize() {
        return this.totalStaticIndexSize;
    }

    public long getTotalStaticBloomSize() {
        return this.totalStaticBloomSize;
    }

    public long getNumMutationsWithoutWAL() {
        return this.numMutationsWithoutWAL;
    }

    public long getDataInMemoryWithoutWAL() {
        return this.dataInMemoryWithoutWAL;
    }

    public double getPercentFileLocal() {
        return this.percentFileLocal;
    }

    public double getPercentFileLocalSecondaryRegions() {
        return this.percentFileLocalSecondaryRegions;
    }

    public long getUpdatesBlockedTime() {
        if (this.regionServer.cacheFlusher == null) {
            return 0L;
        }
        return this.regionServer.cacheFlusher.getUpdatesBlockedMsHighWater().sum();
    }

    public long getFlushedCellsCount() {
        return this.flushedCellsCount;
    }

    public long getCompactedCellsCount() {
        return this.compactedCellsCount;
    }

    public long getMajorCompactedCellsCount() {
        return this.majorCompactedCellsCount;
    }

    public long getFlushedCellsSize() {
        return this.flushedCellsSize;
    }

    public long getCompactedCellsSize() {
        return this.compactedCellsSize;
    }

    public long getMajorCompactedCellsSize() {
        return this.majorCompactedCellsSize;
    }

    public long getCellsCountCompactedFromMob() {
        return this.cellsCountCompactedFromMob;
    }

    public long getCellsCountCompactedToMob() {
        return this.cellsCountCompactedToMob;
    }

    public long getCellsSizeCompactedFromMob() {
        return this.cellsSizeCompactedFromMob;
    }

    public long getCellsSizeCompactedToMob() {
        return this.cellsSizeCompactedToMob;
    }

    public long getMobFlushCount() {
        return this.mobFlushCount;
    }

    public long getMobFlushedCellsCount() {
        return this.mobFlushedCellsCount;
    }

    public long getMobFlushedCellsSize() {
        return this.mobFlushedCellsSize;
    }

    public long getMobScanCellsCount() {
        return this.mobScanCellsCount;
    }

    public long getMobScanCellsSize() {
        return this.mobScanCellsSize;
    }

    public long getMobFileCacheAccessCount() {
        return this.mobFileCacheAccessCount;
    }

    public long getMobFileCacheMissCount() {
        return this.mobFileCacheMissCount;
    }

    public long getMobFileCacheCount() {
        return this.mobFileCacheCount;
    }

    public long getMobFileCacheEvictedCount() {
        return this.mobFileCacheEvictedCount;
    }

    public double getMobFileCacheHitPercent() {
        return this.mobFileCacheHitRatio * 100.0;
    }

    public long getHedgedReadOps() {
        return this.dfsHedgedReadMetrics == null ? 0L : this.dfsHedgedReadMetrics.getHedgedReadOps();
    }

    public long getHedgedReadWins() {
        return this.dfsHedgedReadMetrics == null ? 0L : this.dfsHedgedReadMetrics.getHedgedReadWins();
    }

    public long getBlockedRequestsCount() {
        return this.blockedRequestsCount;
    }

    public long getAverageRegionSize() {
        return this.averageRegionSize;
    }

    public long getDataMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getDataMissCount();
    }

    public long getLeafIndexMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getLeafIndexMissCount();
    }

    public long getBloomChunkMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getBloomChunkMissCount();
    }

    public long getMetaMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getMetaMissCount();
    }

    public long getRootIndexMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getRootIndexMissCount();
    }

    public long getIntermediateIndexMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getIntermediateIndexMissCount();
    }

    public long getFileInfoMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getFileInfoMissCount();
    }

    public long getGeneralBloomMetaMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getGeneralBloomMetaMissCount();
    }

    public long getDeleteFamilyBloomMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getDeleteFamilyBloomMissCount();
    }

    public long getTrailerMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getTrailerMissCount();
    }

    public long getDataHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getDataHitCount();
    }

    public long getLeafIndexHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getLeafIndexHitCount();
    }

    public long getBloomChunkHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getBloomChunkHitCount();
    }

    public long getMetaHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getMetaHitCount();
    }

    public long getRootIndexHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getRootIndexHitCount();
    }

    public long getIntermediateIndexHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getIntermediateIndexHitCount();
    }

    public long getFileInfoHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getFileInfoHitCount();
    }

    public long getGeneralBloomMetaHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getGeneralBloomMetaHitCount();
    }

    public long getDeleteFamilyBloomHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getDeleteFamilyBloomHitCount();
    }

    public long getTrailerHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getTrailerHitCount();
    }

    public class RegionServerMetricsWrapperRunnable
    implements Runnable {
        private long lastRan = 0L;
        private long lastRequestCount = 0L;

        @Override
        public synchronized void run() {
            try {
                MetricsRegionServerWrapperImpl.this.initBlockCache();
                MetricsRegionServerWrapperImpl.this.initMobFileCache();
                HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
                HDFSBlocksDistribution hdfsBlocksDistributionSecondaryRegions = new HDFSBlocksDistribution();
                long tempNumStores = 0L;
                long tempNumStoreFiles = 0L;
                long tempMemstoreSize = 0L;
                long tempStoreFileSize = 0L;
                long tempMaxStoreFileAge = 0L;
                long tempNumReferenceFiles = 0L;
                long avgAgeNumerator = 0L;
                long numHFiles = 0L;
                long tempMinStoreFileAge = Long.MAX_VALUE;
                long tempReadRequestsCount = 0L;
                long tempFilteredReadRequestsCount = 0L;
                long tempWriteRequestsCount = 0L;
                long tempCheckAndMutateChecksFailed = 0L;
                long tempCheckAndMutateChecksPassed = 0L;
                long tempStorefileIndexSize = 0L;
                long tempTotalStaticIndexSize = 0L;
                long tempTotalStaticBloomSize = 0L;
                long tempNumMutationsWithoutWAL = 0L;
                long tempDataInMemoryWithoutWAL = 0L;
                double tempPercentFileLocal = 0.0;
                double tempPercentFileLocalSecondaryRegions = 0.0;
                long tempFlushedCellsCount = 0L;
                long tempCompactedCellsCount = 0L;
                long tempMajorCompactedCellsCount = 0L;
                long tempFlushedCellsSize = 0L;
                long tempCompactedCellsSize = 0L;
                long tempMajorCompactedCellsSize = 0L;
                long tempCellsCountCompactedToMob = 0L;
                long tempCellsCountCompactedFromMob = 0L;
                long tempCellsSizeCompactedToMob = 0L;
                long tempCellsSizeCompactedFromMob = 0L;
                long tempMobFlushCount = 0L;
                long tempMobFlushedCellsCount = 0L;
                long tempMobFlushedCellsSize = 0L;
                long tempMobScanCellsCount = 0L;
                long tempMobScanCellsSize = 0L;
                long tempBlockedRequestsCount = 0L;
                int regionCount = 0;
                for (HRegion r : MetricsRegionServerWrapperImpl.this.regionServer.getOnlineRegionsLocalContext()) {
                    tempNumMutationsWithoutWAL += r.getNumMutationsWithoutWAL();
                    tempDataInMemoryWithoutWAL += r.getDataInMemoryWithoutWAL();
                    tempReadRequestsCount += r.getReadRequestsCount();
                    tempFilteredReadRequestsCount += r.getFilteredReadRequestsCount();
                    tempWriteRequestsCount += r.getWriteRequestsCount();
                    tempCheckAndMutateChecksFailed += r.getCheckAndMutateChecksFailed();
                    tempCheckAndMutateChecksPassed += r.getCheckAndMutateChecksPassed();
                    tempBlockedRequestsCount += r.getBlockedRequestsCount();
                    List<HStore> storeList = r.getStores();
                    tempNumStores += (long)storeList.size();
                    for (Store store : storeList) {
                        OptionalLong storeMinStoreFileAge;
                        tempNumStoreFiles += (long)store.getStorefilesCount();
                        tempMemstoreSize += store.getMemStoreSize().getDataSize();
                        tempStoreFileSize += store.getStorefilesSize();
                        OptionalLong storeMaxStoreFileAge = store.getMaxStoreFileAge();
                        if (storeMaxStoreFileAge.isPresent() && storeMaxStoreFileAge.getAsLong() > tempMaxStoreFileAge) {
                            tempMaxStoreFileAge = storeMaxStoreFileAge.getAsLong();
                        }
                        if ((storeMinStoreFileAge = store.getMinStoreFileAge()).isPresent() && storeMinStoreFileAge.getAsLong() < tempMinStoreFileAge) {
                            tempMinStoreFileAge = storeMinStoreFileAge.getAsLong();
                        }
                        long storeHFiles = store.getNumHFiles();
                        numHFiles += storeHFiles;
                        tempNumReferenceFiles += store.getNumReferenceFiles();
                        OptionalDouble storeAvgStoreFileAge = store.getAvgStoreFileAge();
                        if (storeAvgStoreFileAge.isPresent()) {
                            avgAgeNumerator = (long)((double)avgAgeNumerator + storeAvgStoreFileAge.getAsDouble() * (double)storeHFiles);
                        }
                        tempStorefileIndexSize += store.getStorefilesIndexSize();
                        tempTotalStaticBloomSize += store.getTotalStaticBloomSize();
                        tempTotalStaticIndexSize += store.getTotalStaticIndexSize();
                        tempFlushedCellsCount += store.getFlushedCellsCount();
                        tempCompactedCellsCount += store.getCompactedCellsCount();
                        tempMajorCompactedCellsCount += store.getMajorCompactedCellsCount();
                        tempFlushedCellsSize += store.getFlushedCellsSize();
                        tempCompactedCellsSize += store.getCompactedCellsSize();
                        tempMajorCompactedCellsSize += store.getMajorCompactedCellsSize();
                        if (!(store instanceof HMobStore)) continue;
                        HMobStore mobStore = (HMobStore)store;
                        tempCellsCountCompactedToMob += mobStore.getCellsCountCompactedToMob();
                        tempCellsCountCompactedFromMob += mobStore.getCellsCountCompactedFromMob();
                        tempCellsSizeCompactedToMob += mobStore.getCellsSizeCompactedToMob();
                        tempCellsSizeCompactedFromMob += mobStore.getCellsSizeCompactedFromMob();
                        tempMobFlushCount += mobStore.getMobFlushCount();
                        tempMobFlushedCellsCount += mobStore.getMobFlushedCellsCount();
                        tempMobFlushedCellsSize += mobStore.getMobFlushedCellsSize();
                        tempMobScanCellsCount += mobStore.getMobScanCellsCount();
                        tempMobScanCellsSize += mobStore.getMobScanCellsSize();
                    }
                    HDFSBlocksDistribution distro = r.getHDFSBlocksDistribution();
                    hdfsBlocksDistribution.add(distro);
                    if (r.getRegionInfo().getReplicaId() != 0) {
                        hdfsBlocksDistributionSecondaryRegions.add(distro);
                    }
                    ++regionCount;
                }
                float localityIndex = hdfsBlocksDistribution.getBlockLocalityIndex(MetricsRegionServerWrapperImpl.this.regionServer.getServerName().getHostname());
                tempPercentFileLocal = Double.isNaN(tempBlockedRequestsCount) ? 0.0 : (double)(localityIndex * 100.0f);
                float localityIndexSecondaryRegions = hdfsBlocksDistributionSecondaryRegions.getBlockLocalityIndex(MetricsRegionServerWrapperImpl.this.regionServer.getServerName().getHostname());
                tempPercentFileLocalSecondaryRegions = Double.isNaN(localityIndexSecondaryRegions) ? 0.0 : (double)(localityIndexSecondaryRegions * 100.0f);
                long currentTime = EnvironmentEdgeManager.currentTime();
                if (this.lastRan == 0L) {
                    this.lastRan = currentTime - MetricsRegionServerWrapperImpl.this.period;
                }
                if (currentTime - this.lastRan > 0L) {
                    long l = MetricsRegionServerWrapperImpl.this.getTotalRequestCount();
                    MetricsRegionServerWrapperImpl.this.requestsPerSecond = (double)(l - this.lastRequestCount) / ((double)(currentTime - this.lastRan) / 1000.0);
                    this.lastRequestCount = l;
                }
                this.lastRan = currentTime;
                WALProvider wALProvider = ((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.walFactory.getWALProvider();
                WALProvider metaProvider = ((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.walFactory.getMetaWALProvider();
                MetricsRegionServerWrapperImpl.this.numWALFiles = (wALProvider == null ? 0L : wALProvider.getNumLogFiles()) + (metaProvider == null ? 0L : metaProvider.getNumLogFiles());
                MetricsRegionServerWrapperImpl.this.walFileSize = (wALProvider == null ? 0L : wALProvider.getLogFileSize()) + (wALProvider == null ? 0L : wALProvider.getLogFileSize());
                MetricsRegionServerWrapperImpl.this.numStores = tempNumStores;
                MetricsRegionServerWrapperImpl.this.numStoreFiles = tempNumStoreFiles;
                MetricsRegionServerWrapperImpl.this.memstoreSize = tempMemstoreSize;
                MetricsRegionServerWrapperImpl.this.storeFileSize = tempStoreFileSize;
                MetricsRegionServerWrapperImpl.this.maxStoreFileAge = tempMaxStoreFileAge;
                if (regionCount > 0) {
                    MetricsRegionServerWrapperImpl.this.averageRegionSize = (MetricsRegionServerWrapperImpl.this.memstoreSize + MetricsRegionServerWrapperImpl.this.storeFileSize) / (long)regionCount;
                }
                if (tempMinStoreFileAge != Long.MAX_VALUE) {
                    MetricsRegionServerWrapperImpl.this.minStoreFileAge = tempMinStoreFileAge;
                }
                if (numHFiles != 0L) {
                    MetricsRegionServerWrapperImpl.this.avgStoreFileAge = avgAgeNumerator / numHFiles;
                }
                MetricsRegionServerWrapperImpl.this.numReferenceFiles = tempNumReferenceFiles;
                MetricsRegionServerWrapperImpl.this.readRequestsCount = tempReadRequestsCount;
                MetricsRegionServerWrapperImpl.this.filteredReadRequestsCount = tempFilteredReadRequestsCount;
                MetricsRegionServerWrapperImpl.this.writeRequestsCount = tempWriteRequestsCount;
                MetricsRegionServerWrapperImpl.this.checkAndMutateChecksFailed = tempCheckAndMutateChecksFailed;
                MetricsRegionServerWrapperImpl.this.checkAndMutateChecksPassed = tempCheckAndMutateChecksPassed;
                MetricsRegionServerWrapperImpl.this.storefileIndexSize = tempStorefileIndexSize;
                MetricsRegionServerWrapperImpl.this.totalStaticIndexSize = tempTotalStaticIndexSize;
                MetricsRegionServerWrapperImpl.this.totalStaticBloomSize = tempTotalStaticBloomSize;
                MetricsRegionServerWrapperImpl.this.numMutationsWithoutWAL = tempNumMutationsWithoutWAL;
                MetricsRegionServerWrapperImpl.this.dataInMemoryWithoutWAL = tempDataInMemoryWithoutWAL;
                MetricsRegionServerWrapperImpl.this.percentFileLocal = tempPercentFileLocal;
                MetricsRegionServerWrapperImpl.this.percentFileLocalSecondaryRegions = tempPercentFileLocalSecondaryRegions;
                MetricsRegionServerWrapperImpl.this.flushedCellsCount = tempFlushedCellsCount;
                MetricsRegionServerWrapperImpl.this.compactedCellsCount = tempCompactedCellsCount;
                MetricsRegionServerWrapperImpl.this.majorCompactedCellsCount = tempMajorCompactedCellsCount;
                MetricsRegionServerWrapperImpl.this.flushedCellsSize = tempFlushedCellsSize;
                MetricsRegionServerWrapperImpl.this.compactedCellsSize = tempCompactedCellsSize;
                MetricsRegionServerWrapperImpl.this.majorCompactedCellsSize = tempMajorCompactedCellsSize;
                MetricsRegionServerWrapperImpl.this.cellsCountCompactedToMob = tempCellsCountCompactedToMob;
                MetricsRegionServerWrapperImpl.this.cellsCountCompactedFromMob = tempCellsCountCompactedFromMob;
                MetricsRegionServerWrapperImpl.this.cellsSizeCompactedToMob = tempCellsSizeCompactedToMob;
                MetricsRegionServerWrapperImpl.this.cellsSizeCompactedFromMob = tempCellsSizeCompactedFromMob;
                MetricsRegionServerWrapperImpl.this.mobFlushCount = tempMobFlushCount;
                MetricsRegionServerWrapperImpl.this.mobFlushedCellsCount = tempMobFlushedCellsCount;
                MetricsRegionServerWrapperImpl.this.mobFlushedCellsSize = tempMobFlushedCellsSize;
                MetricsRegionServerWrapperImpl.this.mobScanCellsCount = tempMobScanCellsCount;
                MetricsRegionServerWrapperImpl.this.mobScanCellsSize = tempMobScanCellsSize;
                MetricsRegionServerWrapperImpl.this.mobFileCacheAccessCount = MetricsRegionServerWrapperImpl.this.mobFileCache.getAccessCount();
                MetricsRegionServerWrapperImpl.this.mobFileCacheMissCount = MetricsRegionServerWrapperImpl.this.mobFileCache.getMissCount();
                MetricsRegionServerWrapperImpl.this.mobFileCacheHitRatio = Double.isNaN(MetricsRegionServerWrapperImpl.this.mobFileCache.getHitRatio()) ? 0.0 : MetricsRegionServerWrapperImpl.this.mobFileCache.getHitRatio();
                MetricsRegionServerWrapperImpl.this.mobFileCacheEvictedCount = MetricsRegionServerWrapperImpl.this.mobFileCache.getEvictedFileCount();
                MetricsRegionServerWrapperImpl.this.mobFileCacheCount = MetricsRegionServerWrapperImpl.this.mobFileCache.getCacheSize();
                MetricsRegionServerWrapperImpl.this.blockedRequestsCount = tempBlockedRequestsCount;
            }
            catch (Throwable e) {
                LOG.warn((Object)"Caught exception! Will suppress and retry.", e);
            }
        }
    }
}

