/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.DamagedWALException;
import org.apache.hadoop.hbase.regionserver.wal.FSWALEntry;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.FailedSyncBeforeLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.RingBufferTruck;
import org.apache.hadoop.hbase.regionserver.wal.SyncFuture;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.FSHLogProvider;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALPrettyPrinter;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.htrace.NullScope;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FSHLog
extends AbstractFSWAL<WALProvider.Writer> {
    private static final Log LOG = LogFactory.getLog(FSHLog.class);
    private final Disruptor<RingBufferTruck> disruptor;
    private final RingBufferEventHandler ringBufferEventHandler;
    private FSDataOutputStream hdfs_out;
    private final int minTolerableReplication;
    private final AtomicInteger consecutiveLogRolls = new AtomicInteger(0);
    private final int lowReplicationRollLimit;
    private volatile boolean lowReplicationRollEnabled = true;
    private final int closeErrorsTolerated;
    private final AtomicInteger closeErrorCount = new AtomicInteger();
    private volatile long lastTimeCheckLowReplication = EnvironmentEdgeManager.currentTime();
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 5 * ClassSize.REFERENCE + ClassSize.ATOMIC_INTEGER + 4 + 24));

    public FSHLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
        this(fs, root, logDir, "oldWALs", conf, null, true, null, null);
    }

    public FSHLog(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws IOException {
        super(fs, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix);
        this.minTolerableReplication = conf.getInt("hbase.regionserver.hlog.tolerable.lowreplication", (int)FSUtils.getDefaultReplication(fs, this.walDir));
        this.lowReplicationRollLimit = conf.getInt("hbase.regionserver.hlog.lowreplication.rolllimit", 5);
        this.closeErrorsTolerated = conf.getInt("hbase.regionserver.logroll.errors.tolerated", 2);
        this.rollWriter();
        String hostingThreadName = Thread.currentThread().getName();
        this.disruptor = new Disruptor(RingBufferTruck::new, this.getPreallocatedEventCount(), Threads.getNamedThreadFactory((String)(hostingThreadName + ".append")), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.getRingBuffer().next();
        int maxHandlersCount = conf.getInt("hbase.regionserver.handler.count", 200);
        this.ringBufferEventHandler = new RingBufferEventHandler(conf.getInt("hbase.regionserver.hlog.syncer.count", 5), maxHandlersCount);
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)new RingBufferExceptionHandler());
        this.disruptor.handleEventsWith((EventHandler[])new RingBufferEventHandler[]{this.ringBufferEventHandler});
        this.disruptor.start();
    }

    @VisibleForTesting
    OutputStream getOutputStream() {
        FSDataOutputStream fsdos = this.hdfs_out;
        return fsdos != null ? fsdos.getWrappedStream() : null;
    }

    private void preemptiveSync(ProtobufLogWriter nextWriter) {
        long startTimeNanos = System.nanoTime();
        try {
            nextWriter.sync();
            this.postSync(System.nanoTime() - startTimeNanos, 0);
        }
        catch (IOException e) {
            LOG.warn((Object)"pre-sync failed but an optimization so keep going", (Throwable)e);
        }
    }

    @Override
    protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
        FSHLogProvider.Writer writer = FSHLogProvider.createWriter(this.conf, this.fs, path, false);
        if (writer instanceof ProtobufLogWriter) {
            this.preemptiveSync((ProtobufLogWriter)writer);
        }
        return writer;
    }

    @VisibleForTesting
    protected void afterCreatingZigZagLatch() {
    }

    @VisibleForTesting
    protected void beforeWaitOnSafePoint() {
    }

    @Override
    protected void doAppend(WALProvider.Writer writer, FSWALEntry entry) throws IOException {
        writer.append(entry);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected long doReplaceWriter(Path oldPath, Path newPath, WALProvider.Writer nextWriter) throws IOException {
        SyncFuture syncFuture = null;
        SafePointZigZagLatch zigzagLatch = null;
        long sequence = -1L;
        if (this.ringBufferEventHandler != null) {
            sequence = this.getSequenceOnRingBuffer();
            zigzagLatch = this.ringBufferEventHandler.attainSafePoint();
        }
        this.afterCreatingZigZagLatch();
        long oldFileLen = 0L;
        try {
            if (zigzagLatch != null) {
                assert (sequence > 0L) : "Failed to get sequence from ring buffer";
                Trace.addTimelineAnnotation((String)"awaiting safepoint");
                syncFuture = zigzagLatch.waitSafePoint(this.publishSyncOnRingBuffer(sequence));
            }
        }
        catch (FailedSyncBeforeLogCloseException e) {
            if (this.isUnflushedEntries()) {
                throw e;
            }
            LOG.warn((Object)("Failed sync-before-close but no outstanding appends; closing WAL" + e.getMessage()));
        }
        if (this.writer != null) {
            oldFileLen = ((WALProvider.Writer)this.writer).getLength();
            try {
                Trace.addTimelineAnnotation((String)"closing writer");
                ((WALProvider.Writer)this.writer).close();
                Trace.addTimelineAnnotation((String)"writer closed");
                this.closeErrorCount.set(0);
            }
            catch (IOException ioe) {
                int errors = this.closeErrorCount.incrementAndGet();
                if (this.isUnflushedEntries() || errors > this.closeErrorsTolerated) throw ioe;
                LOG.warn((Object)("Riding over failed WAL close of " + oldPath + ", cause=\"" + ioe.getMessage() + "\", errors=" + errors + "; THIS FILE WAS NOT CLOSED BUT ALL EDITS SYNCED SO SHOULD BE OK"));
            }
        }
        this.writer = nextWriter;
        this.hdfs_out = nextWriter != null && nextWriter instanceof ProtobufLogWriter ? ((ProtobufLogWriter)nextWriter).getStream() : null;
        if (zigzagLatch == null) return oldFileLen;
        zigzagLatch.releaseSafePoint();
        if (syncFuture == null) return oldFileLen;
        try {
            this.blockOnSync(syncFuture);
            return oldFileLen;
        }
        catch (IOException ioe) {
            if (!LOG.isTraceEnabled()) return oldFileLen;
            LOG.trace((Object)"Stale sync exception", (Throwable)ioe);
        }
        return oldFileLen;
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (zigzagLatch == null) return oldFileLen;
            zigzagLatch.releaseSafePoint();
            if (syncFuture == null) return oldFileLen;
            try {
                this.blockOnSync(syncFuture);
                return oldFileLen;
            }
            catch (IOException ioe) {
                if (!LOG.isTraceEnabled()) return oldFileLen;
                LOG.trace((Object)"Stale sync exception", (Throwable)ioe);
            }
            return oldFileLen;
        }
        catch (IOException e) {
            long count = this.getUnflushedEntriesCount();
            LOG.error((Object)("Failed close of WAL writer " + oldPath + ", unflushedEntries=" + count), (Throwable)e);
            throw new FailedLogCloseException(oldPath + ", unflushedEntries=" + count, (Throwable)e);
            {
                catch (Throwable throwable) {
                    if (zigzagLatch == null) throw throwable;
                    zigzagLatch.releaseSafePoint();
                    if (syncFuture == null) throw throwable;
                    try {
                        this.blockOnSync(syncFuture);
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        if (!LOG.isTraceEnabled()) throw throwable;
                        LOG.trace((Object)"Stale sync exception", (Throwable)ioe);
                    }
                    throw throwable;
                }
            }
        }
    }

    @Override
    protected void doShutdown() throws IOException {
        if (this.disruptor != null) {
            long timeoutms = this.conf.getLong("hbase.wal.disruptor.shutdown.timeout.ms", 60000L);
            try {
                this.disruptor.shutdown(timeoutms, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                LOG.warn((Object)("Timed out bringing down disruptor after " + timeoutms + "ms; forcing halt (It is a problem if this is NOT an ABORT! -- DATALOSS!!!!)"));
                this.disruptor.halt();
                this.disruptor.shutdown();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Closing WAL writer in " + FSUtils.getPath(this.walDir)));
        }
        if (this.writer != null) {
            ((WALProvider.Writer)this.writer).close();
            this.writer = null;
        }
    }

    @Override
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_EXCEPTION"}, justification="Will never be null")
    public long append(RegionInfo hri, WALKey key, WALEdit edits, boolean inMemstore) throws IOException {
        return this.stampSequenceIdAndPublishToRingBuffer(hri, key, edits, inMemstore, (RingBuffer<RingBufferTruck>)this.disruptor.getRingBuffer());
    }

    public void checkLogRoll() {
        boolean lowReplication;
        if (!this.rollWriterLock.tryLock()) {
            return;
        }
        try {
            lowReplication = this.checkLowReplication();
        }
        finally {
            this.rollWriterLock.unlock();
        }
        if (lowReplication || this.writer != null && ((WALProvider.Writer)this.writer).getLength() > this.logrollsize) {
            this.requestLogRoll(lowReplication);
        }
    }

    private boolean checkLowReplication() {
        boolean logRollNeeded = false;
        this.lastTimeCheckLowReplication = EnvironmentEdgeManager.currentTime();
        try {
            int numCurrentReplicas = this.getLogReplication();
            if (numCurrentReplicas != 0 && numCurrentReplicas < this.minTolerableReplication) {
                if (this.lowReplicationRollEnabled) {
                    if (this.consecutiveLogRolls.get() < this.lowReplicationRollLimit) {
                        LOG.warn((Object)("HDFS pipeline error detected. Found " + numCurrentReplicas + " replicas but expecting no less than " + this.minTolerableReplication + " replicas.  Requesting close of WAL. current pipeline: " + Arrays.toString(this.getPipeline())));
                        logRollNeeded = true;
                        this.consecutiveLogRolls.getAndIncrement();
                    } else {
                        LOG.warn((Object)"Too many consecutive RollWriter requests, it's a sign of the total number of live datanodes is lower than the tolerable replicas.");
                        this.consecutiveLogRolls.set(0);
                        this.lowReplicationRollEnabled = false;
                    }
                }
            } else if (numCurrentReplicas >= this.minTolerableReplication && !this.lowReplicationRollEnabled) {
                if (this.numEntries.get() <= 1) {
                    return logRollNeeded;
                }
                this.lowReplicationRollEnabled = true;
                LOG.info((Object)"LowReplication-Roller was enabled.");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("DFSOutputStream.getNumCurrentReplicas failed because of " + e + ", continuing..."));
        }
        return logRollNeeded;
    }

    private SyncFuture publishSyncOnRingBuffer(long sequence) {
        return this.publishSyncOnRingBuffer(sequence, null);
    }

    private long getSequenceOnRingBuffer() {
        return this.disruptor.getRingBuffer().next();
    }

    private SyncFuture publishSyncOnRingBuffer(Span span) {
        long sequence = this.disruptor.getRingBuffer().next();
        return this.publishSyncOnRingBuffer(sequence, span);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncFuture publishSyncOnRingBuffer(long sequence, Span span) {
        SyncFuture syncFuture = this.getSyncFuture(sequence, span);
        try {
            RingBufferTruck truck = (RingBufferTruck)this.disruptor.getRingBuffer().get(sequence);
            truck.load(syncFuture);
        }
        finally {
            this.disruptor.getRingBuffer().publish(sequence);
        }
        return syncFuture;
    }

    private Span publishSyncThenBlockOnCompletion(Span span) throws IOException {
        return this.blockOnSync(this.publishSyncOnRingBuffer(span));
    }

    @Override
    @VisibleForTesting
    int getLogReplication() {
        try {
            if (this.hdfs_out instanceof HdfsDataOutputStream) {
                return ((HdfsDataOutputStream)this.hdfs_out).getCurrentBlockReplication();
            }
        }
        catch (IOException e) {
            LOG.info((Object)"", (Throwable)e);
        }
        return 0;
    }

    @Override
    public void sync() throws IOException {
        TraceScope scope = Trace.startSpan((String)"FSHLog.sync");
        try {
            scope = Trace.continueSpan((Span)this.publishSyncThenBlockOnCompletion(scope.detach()));
        }
        finally {
            assert (scope == NullScope.INSTANCE || !scope.isDetached());
            scope.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(long txid) throws IOException {
        if (this.highestSyncedTxid.get() >= txid) {
            return;
        }
        TraceScope scope = Trace.startSpan((String)"FSHLog.sync");
        try {
            scope = Trace.continueSpan((Span)this.publishSyncThenBlockOnCompletion(scope.detach()));
        }
        finally {
            assert (scope == NullScope.INSTANCE || !scope.isDetached());
            scope.close();
        }
    }

    @VisibleForTesting
    boolean isLowReplicationRollEnabled() {
        return this.lowReplicationRollEnabled;
    }

    private static void split(Configuration conf, Path p) throws IOException {
        FileSystem fs = FSUtils.getWALFileSystem(conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        if (!fs.getFileStatus(p).isDirectory()) {
            throw new IOException(p + " is not a directory");
        }
        Path baseDir = FSUtils.getWALRootDir(conf);
        Path archiveDir = new Path(baseDir, "oldWALs");
        if (conf.getBoolean("hbase.separate.oldlogdir.by.regionserver", false)) {
            archiveDir = new Path(archiveDir, p.getName());
        }
        WALSplitter.split(baseDir, p, archiveDir, fs, conf, WALFactory.getInstance(conf));
    }

    private static void usage() {
        System.err.println("Usage: FSHLog <ARGS>");
        System.err.println("Arguments:");
        System.err.println(" --dump  Dump textual representation of passed one or more files");
        System.err.println("         For example: FSHLog --dump hdfs://example.com:9000/hbase/WALs/MACHINE/LOGFILE");
        System.err.println(" --split Split the passed directory of WAL logs");
        System.err.println("         For example: FSHLog --split hdfs://example.com:9000/hbase/WALs/DIR");
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            FSHLog.usage();
            System.exit(-1);
        }
        if (args[0].compareTo("--dump") == 0) {
            WALPrettyPrinter.run(Arrays.copyOfRange(args, 1, args.length));
        } else if (args[0].compareTo("--perf") == 0) {
            LOG.fatal((Object)"Please use the WALPerformanceEvaluation tool instead. i.e.:");
            LOG.fatal((Object)("\thbase org.apache.hadoop.hbase.wal.WALPerformanceEvaluation --iterations " + args[1]));
            System.exit(-1);
        } else if (args[0].compareTo("--split") == 0) {
            Configuration conf = HBaseConfiguration.create();
            for (int i = 1; i < args.length; ++i) {
                try {
                    Path logPath = new Path(args[i]);
                    FSUtils.setFsDefault(conf, logPath);
                    FSHLog.split(conf, logPath);
                    continue;
                }
                catch (IOException t) {
                    t.printStackTrace(System.err);
                    System.exit(-1);
                }
            }
        } else {
            FSHLog.usage();
            System.exit(-1);
        }
    }

    @Override
    DatanodeInfo[] getPipeline() {
        if (this.hdfs_out != null && this.hdfs_out.getWrappedStream() instanceof DFSOutputStream) {
            return ((DFSOutputStream)this.hdfs_out.getWrappedStream()).getPipeline();
        }
        return new DatanodeInfo[0];
    }

    public long getLastTimeCheckLowReplication() {
        return this.lastTimeCheckLowReplication;
    }

    class RingBufferEventHandler
    implements EventHandler<RingBufferTruck>,
    LifecycleAware {
        private final SyncRunner[] syncRunners;
        private final SyncFuture[] syncFutures;
        private volatile int syncFuturesCount = 0;
        private volatile SafePointZigZagLatch zigzagLatch;
        private Exception exception = null;
        private final Object safePointWaiter = new Object();
        private volatile boolean shutdown = false;
        private int syncRunnerIndex;

        RingBufferEventHandler(int syncRunnerCount, int maxHandlersCount) {
            this.syncFutures = new SyncFuture[maxHandlersCount];
            this.syncRunners = new SyncRunner[syncRunnerCount];
            for (int i = 0; i < syncRunnerCount; ++i) {
                this.syncRunners[i] = new SyncRunner("sync." + i, maxHandlersCount);
            }
        }

        private void cleanupOutstandingSyncsOnException(long sequence, Exception e) {
            for (int i = 0; i < this.syncFuturesCount; ++i) {
                this.syncFutures[i].done(sequence, e);
            }
            this.syncFuturesCount = 0;
        }

        private boolean isOutstandingSyncs() {
            for (int i = 0; i < this.syncFuturesCount; ++i) {
                if (this.syncFutures[i].isDone()) continue;
                return true;
            }
            return false;
        }

        private boolean isOutstandingSyncsFromRunners() {
            for (SyncRunner syncRunner : this.syncRunners) {
                if (!syncRunner.isAlive() || syncRunner.areSyncFuturesReleased()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(RingBufferTruck truck, long sequence, boolean endOfBatch) throws Exception {
            try {
                if (truck.type() == RingBufferTruck.Type.SYNC) {
                    this.syncFutures[this.syncFuturesCount++] = truck.unloadSync();
                    if (this.syncFuturesCount == this.syncFutures.length) {
                        endOfBatch = true;
                    }
                } else if (truck.type() == RingBufferTruck.Type.APPEND) {
                    FSWALEntry entry = truck.unloadAppend();
                    TraceScope scope = Trace.continueSpan((Span)entry.detachSpan());
                    try {
                        if (this.exception != null) {
                            return;
                        }
                        this.append(entry);
                    }
                    catch (Exception e) {
                        this.exception = e;
                        this.cleanupOutstandingSyncsOnException(sequence, (Exception)(this.exception instanceof DamagedWALException ? this.exception : new DamagedWALException("On sync", this.exception)));
                        return;
                    }
                    finally {
                        assert (scope == NullScope.INSTANCE || !scope.isDetached());
                        scope.close();
                    }
                } else {
                    this.cleanupOutstandingSyncsOnException(sequence, new IllegalStateException("Neither append nor sync"));
                    return;
                }
                if (this.exception == null) {
                    if (!endOfBatch || this.syncFuturesCount <= 0) {
                        return;
                    }
                    this.syncRunnerIndex = (this.syncRunnerIndex + 1) % this.syncRunners.length;
                    try {
                        this.syncRunners[this.syncRunnerIndex].offer(sequence, this.syncFutures, this.syncFuturesCount);
                    }
                    catch (Exception e) {
                        FSHLog.this.requestLogRoll();
                        this.exception = new DamagedWALException("Failed offering sync", e);
                    }
                }
                if (this.exception != null) {
                    this.cleanupOutstandingSyncsOnException(sequence, (Exception)(this.exception instanceof DamagedWALException ? this.exception : new DamagedWALException("On sync", this.exception)));
                }
                this.attainSafePoint(sequence);
                this.syncFuturesCount = 0;
            }
            catch (Throwable t) {
                LOG.error((Object)("UNEXPECTED!!! syncFutures.length=" + this.syncFutures.length), t);
            }
        }

        SafePointZigZagLatch attainSafePoint() {
            this.zigzagLatch = new SafePointZigZagLatch();
            return this.zigzagLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attainSafePoint(long currentSequence) {
            if (this.zigzagLatch == null || !this.zigzagLatch.isCocked()) {
                return;
            }
            FSHLog.this.beforeWaitOnSafePoint();
            try {
                while (!this.shutdown && this.zigzagLatch.isCocked() && FSHLog.this.highestSyncedTxid.get() < currentSequence && this.isOutstandingSyncs() || this.isOutstandingSyncsFromRunners()) {
                    Object object = this.safePointWaiter;
                    synchronized (object) {
                        this.safePointWaiter.wait(0L, 1);
                    }
                }
                this.exception = null;
                this.zigzagLatch.safePointAttained();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }

        void append(FSWALEntry entry) throws Exception {
            try {
                FSHLog.this.append(FSHLog.this.writer, entry);
            }
            catch (Exception e) {
                String msg = "Append sequenceId=" + entry.getKey().getSequenceId() + ", requesting roll of WAL";
                LOG.warn((Object)msg, (Throwable)e);
                FSHLog.this.requestLogRoll();
                throw new DamagedWALException(msg, e);
            }
        }

        public void onStart() {
            for (SyncRunner syncRunner : this.syncRunners) {
                syncRunner.start();
            }
        }

        public void onShutdown() {
            for (SyncRunner syncRunner : this.syncRunners) {
                syncRunner.interrupt();
            }
        }
    }

    static class SafePointZigZagLatch {
        private volatile CountDownLatch safePointAttainedLatch = new CountDownLatch(1);
        private volatile CountDownLatch safePointReleasedLatch = new CountDownLatch(1);

        SafePointZigZagLatch() {
        }

        private void checkIfSyncFailed(SyncFuture syncFuture) throws FailedSyncBeforeLogCloseException {
            if (syncFuture.isThrowable()) {
                throw new FailedSyncBeforeLogCloseException(syncFuture.getThrowable());
            }
        }

        SyncFuture waitSafePoint(SyncFuture syncFuture) throws InterruptedException, FailedSyncBeforeLogCloseException {
            while (!this.safePointAttainedLatch.await(1L, TimeUnit.MILLISECONDS)) {
                this.checkIfSyncFailed(syncFuture);
            }
            this.checkIfSyncFailed(syncFuture);
            return syncFuture;
        }

        void safePointAttained() throws InterruptedException {
            this.safePointAttainedLatch.countDown();
            this.safePointReleasedLatch.await();
        }

        void releaseSafePoint() {
            this.safePointReleasedLatch.countDown();
        }

        boolean isCocked() {
            return this.safePointAttainedLatch.getCount() > 0L && this.safePointReleasedLatch.getCount() > 0L;
        }
    }

    private class SyncRunner
    extends HasThread {
        private volatile long sequence;
        private final BlockingQueue<SyncFuture> syncFutures;
        private volatile SyncFuture takeSyncFuture;

        SyncRunner(String name, int maxHandlersCount) {
            super(name);
            this.takeSyncFuture = null;
            this.syncFutures = new LinkedBlockingQueue<SyncFuture>(maxHandlersCount * 3);
        }

        void offer(long sequence, SyncFuture[] syncFutures, int syncFutureCount) {
            this.sequence = sequence;
            for (int i = 0; i < syncFutureCount; ++i) {
                this.syncFutures.add(syncFutures[i]);
            }
        }

        private int releaseSyncFuture(SyncFuture syncFuture, long currentSequence, Throwable t) {
            if (!syncFuture.done(currentSequence, t)) {
                throw new IllegalStateException();
            }
            return 1;
        }

        private int releaseSyncFutures(long currentSequence, Throwable t) {
            SyncFuture syncFuture;
            int syncCount = 0;
            while ((syncFuture = (SyncFuture)this.syncFutures.peek()) != null && syncFuture.getTxid() <= currentSequence) {
                this.releaseSyncFuture(syncFuture, currentSequence, t);
                if (!this.syncFutures.remove(syncFuture)) {
                    throw new IllegalStateException(syncFuture.toString());
                }
                ++syncCount;
            }
            return syncCount;
        }

        private long updateHighestSyncedSequence(long sequence) {
            long currentHighestSyncedSequence;
            do {
                if ((currentHighestSyncedSequence = FSHLog.this.highestSyncedTxid.get()) < sequence) continue;
                sequence = currentHighestSyncedSequence;
                break;
            } while (!FSHLog.this.highestSyncedTxid.compareAndSet(currentHighestSyncedSequence, sequence));
            return sequence;
        }

        boolean areSyncFuturesReleased() {
            return this.syncFutures.size() <= 0 && this.takeSyncFuture == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                int syncCount = 0;
                try {
                    long currentSequence;
                    while (true) {
                        this.takeSyncFuture = null;
                        this.takeSyncFuture = this.syncFutures.take();
                        currentSequence = this.sequence;
                        long syncFutureSequence = this.takeSyncFuture.getTxid();
                        if (syncFutureSequence > currentSequence) {
                            throw new IllegalStateException("currentSequence=" + currentSequence + ", syncFutureSequence=" + syncFutureSequence);
                        }
                        long currentHighestSyncedSequence = FSHLog.this.highestSyncedTxid.get();
                        if (currentSequence >= currentHighestSyncedSequence) break;
                        syncCount += this.releaseSyncFuture(this.takeSyncFuture, currentHighestSyncedSequence, null);
                    }
                    TraceScope scope = Trace.continueSpan((Span)this.takeSyncFuture.getSpan());
                    long start = System.nanoTime();
                    Exception lastException = null;
                    try {
                        Trace.addTimelineAnnotation((String)"syncing writer");
                        ((WALProvider.Writer)FSHLog.this.writer).sync();
                        Trace.addTimelineAnnotation((String)"writer synced");
                        currentSequence = this.updateHighestSyncedSequence(currentSequence);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error syncing, request close of WAL", (Throwable)e);
                        lastException = e;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"UNEXPECTED", (Throwable)e);
                        lastException = e;
                    }
                    finally {
                        this.takeSyncFuture.setSpan(scope.detach());
                        syncCount += this.releaseSyncFuture(this.takeSyncFuture, currentSequence, lastException);
                        syncCount += this.releaseSyncFutures(currentSequence, lastException);
                        if (lastException != null) {
                            FSHLog.this.requestLogRoll();
                        } else {
                            FSHLog.this.checkLogRoll();
                        }
                    }
                    FSHLog.this.postSync(System.nanoTime() - start, syncCount);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    LOG.warn((Object)"UNEXPECTED, continuing", t);
                }
            }
        }
    }

    static class RingBufferExceptionHandler
    implements ExceptionHandler<RingBufferTruck> {
        RingBufferExceptionHandler() {
        }

        public void handleEventException(Throwable ex, long sequence, RingBufferTruck event) {
            LOG.error((Object)("Sequence=" + sequence + ", event=" + event), ex);
            throw new RuntimeException(ex);
        }

        public void handleOnStartException(Throwable ex) {
            LOG.error((Object)ex);
            throw new RuntimeException(ex);
        }

        public void handleOnShutdownException(Throwable ex) {
            LOG.error((Object)ex);
            throw new RuntimeException(ex);
        }
    }
}

