/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.UUID;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
@InterfaceStability.Evolving
public class ClusterMarkingEntryFilter
implements WALEntryFilter {
    private UUID clusterId;
    private UUID peerClusterId;
    private ReplicationEndpoint replicationEndpoint;

    public ClusterMarkingEntryFilter(UUID clusterId, UUID peerClusterId, ReplicationEndpoint replicationEndpoint) {
        this.clusterId = clusterId;
        this.peerClusterId = peerClusterId;
        this.replicationEndpoint = replicationEndpoint;
    }

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        if (this.replicationEndpoint.canReplicateToSameCluster() || !entry.getKey().getClusterIds().contains(this.peerClusterId)) {
            WALEdit edit = entry.getEdit();
            WALKey logKey = entry.getKey();
            if (edit != null && !edit.isEmpty()) {
                logKey.addClusterId(this.clusterId);
                entry.setCompressionContext(null);
                return entry;
            }
        }
        return null;
    }
}

