/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKDataMigrator {
    private static final Log LOG = LogFactory.getLog(ZKDataMigrator.class);

    @Deprecated
    public static Map<TableName, TableState.State> queryForTableStates(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        HashMap<TableName, TableState.State> rv = new HashMap<TableName, TableState.State>();
        List children = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)zkw.znodePaths.tableZNode);
        if (children == null) {
            return rv;
        }
        for (String child : children) {
            TableName tableName = TableName.valueOf((String)child);
            ZooKeeperProtos.DeprecatedTableState.State state = ZKDataMigrator.getTableState(zkw, tableName);
            TableState.State newState = TableState.State.ENABLED;
            if (state != null) {
                switch (state) {
                    case ENABLED: {
                        newState = TableState.State.ENABLED;
                        break;
                    }
                    case DISABLED: {
                        newState = TableState.State.DISABLED;
                        break;
                    }
                    case DISABLING: {
                        newState = TableState.State.DISABLING;
                        break;
                    }
                    case ENABLING: {
                        newState = TableState.State.ENABLING;
                        break;
                    }
                }
            }
            rv.put(tableName, newState);
        }
        return rv;
    }

    @Deprecated
    private static ZooKeeperProtos.DeprecatedTableState.State getTableState(ZooKeeperWatcher zkw, TableName tableName) throws KeeperException, InterruptedException {
        String znode = ZKUtil.joinZNode((String)zkw.znodePaths.tableZNode, (String)tableName.getNameAsString());
        byte[] data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)znode);
        if (data == null || data.length <= 0) {
            return null;
        }
        try {
            ProtobufUtil.expectPBMagicPrefix((byte[])data);
            ZooKeeperProtos.DeprecatedTableState.Builder builder = ZooKeeperProtos.DeprecatedTableState.newBuilder();
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)magicLen, (int)(data.length - magicLen));
            return builder.getState();
        }
        catch (IOException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause((Throwable)e);
            throw ke;
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert((DeserializationException)e);
        }
    }
}

