/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.ConnectException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMetaTableLocator {
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaTableLocator.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final ServerName SN = ServerName.valueOf((String)"example.org", (int)1234, (long)System.currentTimeMillis());
    private ZKWatcher watcher;
    private Abortable abortable;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.client.retries.number", 3);
        UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        UTIL.getZkCluster().shutdown();
    }

    @Before
    public void before() throws IOException {
        this.abortable = new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.info(why, e);
            }

            public boolean isAborted() {
                return false;
            }
        };
        this.watcher = new ZKWatcher(UTIL.getConfiguration(), this.getClass().getSimpleName(), this.abortable, true);
    }

    @After
    public void after() {
        try {
            new MetaTableLocator().deleteMetaLocation(this.watcher);
        }
        catch (KeeperException e) {
            LOG.warn("Unable to delete hbase:meta location", (Throwable)e);
        }
        this.watcher.close();
    }

    @Test
    public void testMetaLookup() throws IOException, InterruptedException, ServiceException, KeeperException {
        ClientProtos.ClientService.BlockingInterface client = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        Mockito.when((Object)client.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenReturn((Object)ClientProtos.GetResponse.newBuilder().build());
        MetaTableLocator mtl = new MetaTableLocator();
        Assert.assertNull((Object)mtl.getMetaRegionLocation(this.watcher));
        for (RegionState.State state : RegionState.State.values()) {
            if (state.equals((Object)RegionState.State.OPEN)) continue;
            MetaTableLocator.setMetaLocation((ZKWatcher)this.watcher, (ServerName)SN, (RegionState.State)state);
            Assert.assertNull((Object)mtl.getMetaRegionLocation(this.watcher));
            Assert.assertEquals((Object)state, (Object)MetaTableLocator.getMetaRegionState((ZKWatcher)this.watcher).getState());
        }
        MetaTableLocator.setMetaLocation((ZKWatcher)this.watcher, (ServerName)SN, (RegionState.State)RegionState.State.OPEN);
        Assert.assertEquals((Object)mtl.getMetaRegionLocation(this.watcher), (Object)SN);
        Assert.assertEquals((Object)RegionState.State.OPEN, (Object)MetaTableLocator.getMetaRegionState((ZKWatcher)this.watcher).getState());
        mtl.deleteMetaLocation(this.watcher);
        Assert.assertNull((Object)MetaTableLocator.getMetaRegionState((ZKWatcher)this.watcher).getServerName());
        Assert.assertEquals((Object)MetaTableLocator.getMetaRegionState((ZKWatcher)this.watcher).getState(), (Object)RegionState.State.OFFLINE);
        Assert.assertNull((Object)mtl.getMetaRegionLocation(this.watcher));
    }

    @Test
    public void testInterruptWaitOnMeta() throws IOException, InterruptedException, ServiceException {
        ClientProtos.ClientService.BlockingInterface client = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        Mockito.when((Object)client.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenReturn((Object)ClientProtos.GetResponse.newBuilder().build());
        final MetaTableLocator mtl = new MetaTableLocator();
        ServerName meta = new MetaTableLocator().getMetaRegionLocation(this.watcher);
        Assert.assertNull((Object)meta);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    mtl.waitMetaRegionLocation(TestMetaTableLocator.this.watcher);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted", e);
                }
            }
        };
        t.start();
        while (!t.isAlive()) {
            Threads.sleep((long)1L);
        }
        Threads.sleep((long)1L);
        Assert.assertTrue((boolean)t.isAlive());
        mtl.stop();
        t.join();
    }

    private void testVerifyMetaRegionLocationWithException(Exception ex) throws IOException, InterruptedException, KeeperException, ServiceException {
        ClientProtos.ClientService.BlockingInterface implementation = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        ClusterConnection connection = this.mockConnection(null, implementation);
        Mockito.when((Object)implementation.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenThrow(new Throwable[]{new ServiceException((Throwable)ex)});
        long timeout = UTIL.getConfiguration().getLong("hbase.catalog.verification.timeout", 1000L);
        MetaTableLocator.setMetaLocation((ZKWatcher)this.watcher, (ServerName)SN, (RegionState.State)RegionState.State.OPENING);
        Assert.assertFalse((boolean)new MetaTableLocator().verifyMetaRegionLocation(connection, this.watcher, timeout));
        MetaTableLocator.setMetaLocation((ZKWatcher)this.watcher, (ServerName)SN, (RegionState.State)RegionState.State.OPEN);
        Assert.assertFalse((boolean)new MetaTableLocator().verifyMetaRegionLocation(connection, this.watcher, timeout));
    }

    @Test
    public void testGetMetaServerConnectionFails() throws IOException, InterruptedException, KeeperException, ServiceException {
        this.testVerifyMetaRegionLocationWithException(new ConnectException("Connection refused"));
    }

    @Test
    public void testVerifyMetaRegionServerNotRunning() throws IOException, InterruptedException, KeeperException, ServiceException {
        this.testVerifyMetaRegionLocationWithException((Exception)((Object)new ServerNotRunningYetException("mock")));
    }

    @Test
    public void testVerifyMetaRegionLocationFails() throws IOException, InterruptedException, KeeperException, ServiceException {
        ClusterConnection connection = (ClusterConnection)Mockito.mock(ClusterConnection.class);
        ServiceException connectException = new ServiceException((Throwable)new ConnectException("Connection refused"));
        AdminProtos.AdminService.BlockingInterface implementation = (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class);
        Mockito.when((Object)implementation.getRegionInfo((RpcController)Mockito.any(), (AdminProtos.GetRegionInfoRequest)Mockito.any())).thenThrow(new Throwable[]{connectException});
        Mockito.when((Object)connection.getAdmin((ServerName)Mockito.any())).thenReturn((Object)implementation);
        RpcControllerFactory controllerFactory = (RpcControllerFactory)Mockito.mock(RpcControllerFactory.class);
        Mockito.when((Object)controllerFactory.newController()).thenReturn(Mockito.mock(HBaseRpcController.class));
        Mockito.when((Object)connection.getRpcControllerFactory()).thenReturn((Object)controllerFactory);
        ServerName sn = ServerName.valueOf((String)"example.com", (int)1234, (long)System.currentTimeMillis());
        MetaTableLocator.setMetaLocation((ZKWatcher)this.watcher, (ServerName)sn, (RegionState.State)RegionState.State.OPENING);
        Assert.assertFalse((boolean)new MetaTableLocator().verifyMetaRegionLocation(connection, this.watcher, 100L));
        MetaTableLocator.setMetaLocation((ZKWatcher)this.watcher, (ServerName)sn, (RegionState.State)RegionState.State.OPEN);
        Assert.assertFalse((boolean)new MetaTableLocator().verifyMetaRegionLocation(connection, this.watcher, 100L));
    }

    @Test(expected=NotAllMetaRegionsOnlineException.class)
    public void testTimeoutWaitForMeta() throws IOException, InterruptedException {
        new MetaTableLocator().waitMetaRegionLocation(this.watcher, 100L);
    }

    @Test
    public void testNoTimeoutWaitForMeta() throws IOException, InterruptedException, KeeperException {
        MetaTableLocator mtl = new MetaTableLocator();
        ServerName hsa = mtl.getMetaRegionLocation(this.watcher);
        Assert.assertNull((Object)hsa);
        WaitOnMetaThread t = new WaitOnMetaThread();
        this.startWaitAliveThenWaitItLives(t, 1);
        MetaTableLocator.setMetaLocation((ZKWatcher)this.watcher, (ServerName)SN, (RegionState.State)RegionState.State.OPEN);
        hsa = SN;
        t.join();
        Assert.assertTrue((boolean)mtl.getMetaRegionLocation(this.watcher).equals((Object)hsa));
    }

    private ClusterConnection mockConnection(AdminProtos.AdminService.BlockingInterface admin, ClientProtos.ClientService.BlockingInterface client) throws IOException {
        ClusterConnection connection = HConnectionTestingUtility.getMockedConnection(UTIL.getConfiguration());
        ((ClusterConnection)Mockito.doNothing().when((Object)connection)).close();
        HRegionLocation anyLocation = new HRegionLocation((RegionInfo)HRegionInfo.FIRST_META_REGIONINFO, SN);
        Mockito.when((Object)connection.getRegionLocation((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)anyLocation);
        Mockito.when((Object)connection.locateRegion((TableName)Mockito.any(), (byte[])Mockito.any())).thenReturn((Object)anyLocation);
        if (admin != null) {
            Mockito.when((Object)connection.getAdmin((ServerName)Mockito.any())).thenReturn((Object)admin);
        }
        if (client != null) {
            Mockito.when((Object)connection.getClient((ServerName)Mockito.any())).thenReturn((Object)client);
        }
        return connection;
    }

    private void startWaitAliveThenWaitItLives(Thread t, int ms) {
        t.start();
        while (!t.isAlive()) {
        }
        Threads.sleep((long)ms);
        Assert.assertTrue((String)("Assert " + t.getName() + " still waiting"), (boolean)t.isAlive());
    }

    class WaitOnMetaThread
    extends Thread {
        WaitOnMetaThread() {
            super("WaitOnMeta");
        }

        @Override
        public void run() {
            try {
                this.doWaiting();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed wait", e);
            }
            LOG.info("Exiting " + this.getName());
        }

        void doWaiting() throws InterruptedException {
            try {
                while (new MetaTableLocator().waitMetaRegionLocation(TestMetaTableLocator.this.watcher, 10000L) == null) {
                }
            }
            catch (NotAllMetaRegionsOnlineException notAllMetaRegionsOnlineException) {
                // empty catch block
            }
        }
    }
}

