/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TestRegionRebalancing;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestMovedRegionsCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionRebalancing.class);
    private final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    public static int numCalls = 0;

    @After
    public void after() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws Exception {
        this.UTIL.getConfiguration().setStrings("hbase.regionserver.impl", new String[]{TestMockRegionServer.class.getName()});
        this.UTIL.startMiniCluster(1);
    }

    @Test
    public void testMovedRegionsCleaner() throws IOException, InterruptedException {
        this.UTIL.waitFor(2000L, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                return numCalls > 0;
            }
        });
    }

    private static class TestMockRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public TestMockRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected int movedRegionCleanerPeriod() {
            return 500;
        }

        protected void cleanMovedRegions() {
            ++numCalls;
            super.cleanMovedRegions();
        }
    }
}

