/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceExistException;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.ZKNamespaceManager;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestNamespace {
    private static final Logger LOG = LoggerFactory.getLogger(TestNamespace.class);
    private static HMaster master;
    protected static final int NUM_SLAVES_BASE = 4;
    private static HBaseTestingUtility TEST_UTIL;
    protected static Admin admin;
    protected static HBaseCluster cluster;
    private static ZKNamespaceManager zkNamespaceManager;
    private String prefix = "TestNamespace";
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniCluster(4);
        admin = TEST_UTIL.getAdmin();
        cluster = TEST_UTIL.getHBaseCluster();
        master = ((MiniHBaseCluster)cluster).getMaster();
        zkNamespaceManager = new ZKNamespaceManager(master.getZooKeeper());
        zkNamespaceManager.start();
        LOG.info("Done initializing cluster");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void beforeMethod() throws IOException {
        for (HTableDescriptor hTableDescriptor : admin.listTables(this.prefix + ".*")) {
            admin.disableTable(hTableDescriptor.getTableName());
            admin.deleteTable(hTableDescriptor.getTableName());
        }
        for (HTableDescriptor hTableDescriptor : admin.listNamespaceDescriptors()) {
            if (!hTableDescriptor.getName().startsWith(this.prefix)) continue;
            admin.deleteNamespace(hTableDescriptor.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyReservedNS() throws IOException {
        NamespaceDescriptor ns = admin.getNamespaceDescriptor(NamespaceDescriptor.DEFAULT_NAMESPACE.getName());
        Assert.assertNotNull((Object)ns);
        Assert.assertEquals((Object)ns.getName(), (Object)NamespaceDescriptor.DEFAULT_NAMESPACE.getName());
        Assert.assertNotNull((Object)zkNamespaceManager.get(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR));
        ns = admin.getNamespaceDescriptor(NamespaceDescriptor.SYSTEM_NAMESPACE.getName());
        Assert.assertNotNull((Object)ns);
        Assert.assertEquals((Object)ns.getName(), (Object)NamespaceDescriptor.SYSTEM_NAMESPACE.getName());
        Assert.assertNotNull((Object)zkNamespaceManager.get(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR));
        Assert.assertEquals((long)2L, (long)admin.listNamespaceDescriptors().length);
        HashSet systemTables = Sets.newHashSet((Object[])new TableName[]{TableName.META_TABLE_NAME, TableName.NAMESPACE_TABLE_NAME});
        HTableDescriptor[] descs = admin.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE.getName());
        Assert.assertEquals((long)systemTables.size(), (long)descs.length);
        for (HTableDescriptor desc : descs) {
            Assert.assertTrue((boolean)systemTables.contains(desc.getTableName()));
        }
        Assert.assertEquals((long)0L, (long)admin.listTables().length);
        boolean exceptionCaught = false;
        try {
            admin.createNamespace(NamespaceDescriptor.DEFAULT_NAMESPACE);
        }
        catch (IOException exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
        exceptionCaught = false;
        try {
            admin.createNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE);
        }
        catch (IOException exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteReservedNS() throws Exception {
        boolean exceptionCaught = false;
        try {
            admin.deleteNamespace(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR);
        }
        catch (IOException exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
        try {
            admin.deleteNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR);
        }
        catch (IOException exp) {
            LOG.warn(exp.toString(), (Throwable)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    @Test
    public void createRemoveTest() throws Exception {
        String nsName = this.prefix + "_" + this.name.getMethodName();
        LOG.info(this.name.getMethodName());
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).build());
        Assert.assertEquals((long)3L, (long)admin.listNamespaceDescriptors().length);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return zkNamespaceManager.list().size() == 3;
            }
        });
        Assert.assertNotNull((Object)zkNamespaceManager.get(nsName));
        admin.deleteNamespace(nsName);
        Assert.assertEquals((long)2L, (long)admin.listNamespaceDescriptors().length);
        Assert.assertEquals((long)2L, (long)zkNamespaceManager.list().size());
        Assert.assertNull((Object)zkNamespaceManager.get(nsName));
    }

    @Test
    public void createDoubleTest() throws IOException, InterruptedException {
        String nsName = this.prefix + "_" + this.name.getMethodName();
        LOG.info(this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableName tableNameFoo = TableName.valueOf((String)(nsName + ":" + this.name.getMethodName()));
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).build());
        TEST_UTIL.createTable(tableName, Bytes.toBytes((String)nsName));
        TEST_UTIL.createTable(tableNameFoo, Bytes.toBytes((String)nsName));
        Assert.assertEquals((long)2L, (long)admin.listTables().length);
        Assert.assertNotNull((Object)admin.getTableDescriptor(tableName));
        Assert.assertNotNull((Object)admin.getTableDescriptor(tableNameFoo));
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
        Assert.assertEquals((long)1L, (long)admin.listTables().length);
    }

    @Test
    public void createTableTest() throws IOException, InterruptedException {
        String nsName = this.prefix + "_" + this.name.getMethodName();
        LOG.info(this.name.getMethodName());
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)(nsName + ":" + this.name.getMethodName())));
        HColumnDescriptor colDesc = new HColumnDescriptor("my_cf");
        desc.addFamily(colDesc);
        try {
            admin.createTable((TableDescriptor)desc);
            Assert.fail((String)"Expected no namespace exists exception");
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).build());
        admin.createTable((TableDescriptor)desc);
        TEST_UTIL.waitTableAvailable(desc.getTableName().getName(), 10000L);
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Assert.assertTrue((boolean)fs.exists(new Path(master.getMasterFileSystem().getRootDir(), new Path("data", new Path(nsName, desc.getTableName().getQualifierAsString())))));
        Assert.assertEquals((long)1L, (long)admin.listTables().length);
        try {
            admin.deleteNamespace(nsName);
            Assert.fail((String)"Expected non-empty namespace constraint exception");
        }
        catch (Exception ex) {
            LOG.info("Caught expected exception: " + ex);
        }
        Table table = TEST_UTIL.getConnection().getTable(desc.getTableName());
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.addColumn(Bytes.toBytes((String)"my_cf"), Bytes.toBytes((String)"my_col"), Bytes.toBytes((String)"value1"));
        table.put(p);
        admin.flush(desc.getTableName());
        Get g = new Get(Bytes.toBytes((String)"row1"));
        Assert.assertTrue((boolean)table.exists(g));
        TEST_UTIL.deleteTable(desc.getTableName());
        admin.deleteNamespace(nsName);
    }

    @Test
    public void createTableInDefaultNamespace() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HColumnDescriptor colDesc = new HColumnDescriptor("cf1");
        desc.addFamily(colDesc);
        admin.createTable((TableDescriptor)desc);
        Assert.assertTrue((admin.listTables().length == 1 ? 1 : 0) != 0);
        admin.disableTable(desc.getTableName());
        admin.deleteTable(desc.getTableName());
    }

    @Test
    public void createTableInSystemNamespace() throws Exception {
        TableName tableName = TableName.valueOf((String)("hbase:" + this.name.getMethodName()));
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor colDesc = new HColumnDescriptor("cf1");
        desc.addFamily(colDesc);
        admin.createTable((TableDescriptor)desc);
        Assert.assertEquals((long)0L, (long)admin.listTables().length);
        Assert.assertTrue((boolean)admin.tableExists(tableName));
        admin.disableTable(desc.getTableName());
        admin.deleteTable(desc.getTableName());
    }

    @Test(timeout=60000L)
    public void testNamespaceOperations() throws IOException {
        admin.createNamespace(NamespaceDescriptor.create((String)(this.prefix + "ns1")).build());
        admin.createNamespace(NamespaceDescriptor.create((String)(this.prefix + "ns2")).build());
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.createNamespace(NamespaceDescriptor.create((String)(TestNamespace.this.prefix + "ns1")).build());
                return null;
            }
        }, NamespaceExistException.class);
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"non_existing_namespace", (String)TestNamespace.this.name.getMethodName()));
                htd.addFamily(new HColumnDescriptor("family1"));
                admin.createTable((TableDescriptor)htd);
                return null;
            }
        }, NamespaceNotFoundException.class);
        admin.getNamespaceDescriptor(this.prefix + "ns1");
        TestNamespace.runWithExpectedException(new Callable<NamespaceDescriptor>(){

            @Override
            public NamespaceDescriptor call() throws Exception {
                return admin.getNamespaceDescriptor("non_existing_namespace");
            }
        }, NamespaceNotFoundException.class);
        admin.deleteNamespace(this.prefix + "ns2");
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.deleteNamespace("non_existing_namespace");
                return null;
            }
        }, NamespaceNotFoundException.class);
        NamespaceDescriptor ns1 = admin.getNamespaceDescriptor(this.prefix + "ns1");
        ns1.setConfiguration("foo", "bar");
        admin.modifyNamespace(ns1);
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.modifyNamespace(NamespaceDescriptor.create((String)"non_existing_namespace").build());
                return null;
            }
        }, NamespaceNotFoundException.class);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)(this.prefix + "ns1"), (String)this.name.getMethodName()));
        htd.addFamily(new HColumnDescriptor("family1"));
        admin.createTable((TableDescriptor)htd);
        HTableDescriptor[] htds = admin.listTableDescriptorsByNamespace(this.prefix + "ns1");
        Assert.assertNotNull((String)"Should have not returned null", (Object)htds);
        Assert.assertEquals((String)"Should have returned non-empty array", (long)1L, (long)htds.length);
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.listTableDescriptorsByNamespace("non_existant_namespace");
                return null;
            }
        }, NamespaceNotFoundException.class);
        TableName[] tableNames = admin.listTableNamesByNamespace(this.prefix + "ns1");
        Assert.assertNotNull((String)"Should have not returned null", (Object)tableNames);
        Assert.assertEquals((String)"Should have returned non-empty array", (long)1L, (long)tableNames.length);
        TestNamespace.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.listTableNamesByNamespace("non_existing_namespace");
                return null;
            }
        }, NamespaceNotFoundException.class);
    }

    private static <V, E> void runWithExpectedException(Callable<V> callable, Class<E> exceptionClass) {
        try {
            callable.call();
        }
        catch (Exception ex) {
            Assert.assertEquals(exceptionClass, ex.getClass());
            return;
        }
        Assert.fail((String)("Should have thrown exception " + exceptionClass));
    }
}

