/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.FirstKeyValueMatchingQualifiersFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestPartialResultsFromClientSide {
    private static final Logger LOG = LoggerFactory.getLogger(TestPartialResultsFromClientSide.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int MINICLUSTER_SIZE = 5;
    private static Table TABLE = null;
    private static TableName TABLE_NAME = TableName.valueOf((String)"testTable");
    private static int NUM_ROWS = 5;
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[][] ROWS = HTestConst.makeNAscii(ROW, NUM_ROWS);
    private static int NUM_FAMILIES = 10;
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, NUM_FAMILIES);
    private static int NUM_QUALIFIERS = 10;
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, NUM_QUALIFIERS);
    private static int VALUE_SIZE = 1024;
    private static byte[] VALUE = Bytes.createMaxByteArray((int)VALUE_SIZE);
    private static int NUM_COLS = NUM_FAMILIES * NUM_QUALIFIERS;
    private static long CELL_HEAP_SIZE = -1L;
    private static long timeout = 10000L;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setLong("hbase.client.scanner.timeout.period", timeout);
        TEST_UTIL.startMiniCluster(5);
        TEST_UTIL.getAdmin().setBalancerRunning(false, true);
        TABLE = TestPartialResultsFromClientSide.createTestTable(TABLE_NAME, ROWS, FAMILIES, QUALIFIERS, VALUE);
    }

    static Table createTestTable(TableName name, byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] cellValue) throws IOException {
        Table ht = TEST_UTIL.createTable(name, families);
        ArrayList<Put> puts = TestPartialResultsFromClientSide.createPuts(rows, families, qualifiers, cellValue);
        ht.put(puts);
        return ht;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testExpectedValuesOfPartialResults() throws Exception {
        this.testExpectedValuesOfPartialResults(false);
        this.testExpectedValuesOfPartialResults(true);
    }

    public void testExpectedValuesOfPartialResults(boolean reversed) throws Exception {
        Scan partialScan = new Scan();
        partialScan.setMaxVersions();
        partialScan.setMaxResultSize(1L);
        partialScan.setReversed(reversed);
        ResultScanner partialScanner = TABLE.getScanner(partialScan);
        int startRow = reversed ? ROWS.length - 1 : 0;
        int endRow = reversed ? -1 : ROWS.length;
        int loopDelta = reversed ? -1 : 1;
        for (int row = startRow; row != endRow; row += loopDelta) {
            String message = "Ensuring the expected keyValues are present for row " + row;
            ArrayList<Cell> expectedKeyValues = TestPartialResultsFromClientSide.createKeyValuesForRow(ROWS[row], FAMILIES, QUALIFIERS, VALUE);
            Result result = partialScanner.next();
            Assert.assertFalse((boolean)result.mayHaveMoreCellsInRow());
            TestPartialResultsFromClientSide.verifyResult(result, expectedKeyValues, message);
        }
        partialScanner.close();
    }

    @Test
    public void testAllowPartialResults() throws Exception {
        Scan scan = new Scan();
        scan.setAllowPartialResults(true);
        scan.setMaxResultSize(1L);
        ResultScanner scanner = TABLE.getScanner(scan);
        Result result = scanner.next();
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.mayHaveMoreCellsInRow());
        Assert.assertTrue((result.rawCells() != null ? 1 : 0) != 0);
        Assert.assertTrue((result.rawCells().length == 1 ? 1 : 0) != 0);
        scanner.close();
        scan.setAllowPartialResults(false);
        scanner = TABLE.getScanner(scan);
        result = scanner.next();
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertTrue((!result.mayHaveMoreCellsInRow() ? 1 : 0) != 0);
        Assert.assertTrue((result.rawCells() != null ? 1 : 0) != 0);
        Assert.assertTrue((result.rawCells().length == NUM_COLS ? 1 : 0) != 0);
        scanner.close();
    }

    @Test
    public void testEquivalenceOfScanResults() throws Exception {
        Scan oneShotScan = new Scan();
        oneShotScan.setMaxResultSize(Long.MAX_VALUE);
        Scan partialScan = new Scan(oneShotScan);
        partialScan.setMaxResultSize(1L);
        this.testEquivalenceOfScanResults(TABLE, oneShotScan, partialScan);
    }

    public void testEquivalenceOfScanResults(Table table, Scan scan1, Scan scan2) throws Exception {
        ResultScanner scanner1 = table.getScanner(scan1);
        ResultScanner scanner2 = table.getScanner(scan2);
        Result r1 = null;
        Result r2 = null;
        int count = 0;
        while ((r1 = scanner1.next()) != null) {
            r2 = scanner2.next();
            Assert.assertTrue((r2 != null ? 1 : 0) != 0);
            TestPartialResultsFromClientSide.compareResults(r1, r2, "Comparing result #" + count);
            ++count;
        }
        r2 = scanner2.next();
        Assert.assertTrue((String)("r2: " + r2 + " Should be null"), (r2 == null ? 1 : 0) != 0);
        scanner1.close();
        scanner2.close();
    }

    @Test
    public void testOrderingOfCellsInPartialResults() throws Exception {
        Scan scan = new Scan();
        for (int col = 1; col <= NUM_COLS; ++col) {
            scan.setMaxResultSize(this.getResultSizeForNumberOfCells(col));
            this.testOrderingOfCellsInPartialResults(scan);
            scan.setReversed(true);
            this.testOrderingOfCellsInPartialResults(scan);
        }
    }

    public void testOrderingOfCellsInPartialResults(Scan basePartialScan) throws Exception {
        Scan partialScan = new Scan(basePartialScan);
        partialScan.setAllowPartialResults(true);
        ResultScanner partialScanner = TABLE.getScanner(partialScan);
        Scan oneShotScan = new Scan(basePartialScan);
        oneShotScan.setMaxResultSize(Long.MAX_VALUE);
        oneShotScan.setCaching(ROWS.length);
        ResultScanner oneShotScanner = TABLE.getScanner(oneShotScan);
        Result oneShotResult = oneShotScanner.next();
        Result partialResult = null;
        int iterationCount = 0;
        while (oneShotResult != null && oneShotResult.rawCells() != null) {
            ArrayList<Cell> aggregatePartialCells = new ArrayList<Cell>();
            do {
                partialResult = partialScanner.next();
                Assert.assertTrue((String)("Partial Result is null. iteration: " + iterationCount), (partialResult != null ? 1 : 0) != 0);
                Assert.assertTrue((String)("Partial cells are null. iteration: " + iterationCount), (partialResult.rawCells() != null ? 1 : 0) != 0);
                for (Cell c : partialResult.rawCells()) {
                    aggregatePartialCells.add(c);
                }
            } while (partialResult.mayHaveMoreCellsInRow());
            Assert.assertTrue((String)("Number of cells differs. iteration: " + iterationCount), (oneShotResult.rawCells().length == aggregatePartialCells.size() ? 1 : 0) != 0);
            Cell[] oneShotCells = oneShotResult.rawCells();
            for (int cell = 0; cell < oneShotCells.length; ++cell) {
                Cell oneShotCell = oneShotCells[cell];
                Cell partialCell = (Cell)aggregatePartialCells.get(cell);
                Assert.assertTrue((String)"One shot cell was null", (oneShotCell != null ? 1 : 0) != 0);
                Assert.assertTrue((String)"Partial cell was null", (partialCell != null ? 1 : 0) != 0);
                Assert.assertTrue((String)("Cell differs. oneShotCell:" + oneShotCell + " partialCell:" + partialCell), (boolean)oneShotCell.equals(partialCell));
            }
            oneShotResult = oneShotScanner.next();
            ++iterationCount;
        }
        Assert.assertTrue((partialScanner.next() == null ? 1 : 0) != 0);
        partialScanner.close();
        oneShotScanner.close();
    }

    @Test
    public void testExpectedNumberOfCellsPerPartialResult() throws Exception {
        Scan scan = new Scan();
        this.testExpectedNumberOfCellsPerPartialResult(scan);
        scan.setReversed(true);
        this.testExpectedNumberOfCellsPerPartialResult(scan);
    }

    public void testExpectedNumberOfCellsPerPartialResult(Scan baseScan) throws Exception {
        for (int expectedCells = 1; expectedCells <= NUM_COLS; ++expectedCells) {
            this.testExpectedNumberOfCellsPerPartialResult(baseScan, expectedCells);
        }
    }

    public void testExpectedNumberOfCellsPerPartialResult(Scan baseScan, int expectedNumberOfCells) throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info("groupSize:" + expectedNumberOfCells);
        }
        Scan scan = new Scan(baseScan);
        scan.setAllowPartialResults(true);
        scan.setMaxResultSize(this.getResultSizeForNumberOfCells(expectedNumberOfCells));
        ResultScanner scanner = TABLE.getScanner(scan);
        Result result = null;
        byte[] prevRow = null;
        while ((result = scanner.next()) != null) {
            Assert.assertTrue((result.rawCells() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)("Result's cell count differed from expected number. result: " + result), (result.rawCells().length == expectedNumberOfCells || !result.mayHaveMoreCellsInRow() || !Bytes.equals((byte[])prevRow, (byte[])result.getRow()) ? 1 : 0) != 0);
            prevRow = result.getRow();
        }
        scanner.close();
    }

    private long getCellHeapSize() throws Exception {
        if (CELL_HEAP_SIZE == -1L) {
            Scan scan = new Scan();
            scan.setMaxResultSize(2L);
            scan.setAllowPartialResults(true);
            ResultScanner scanner = TABLE.getScanner(scan);
            Result result = scanner.next();
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            Assert.assertTrue((result.rawCells() != null ? 1 : 0) != 0);
            Assert.assertTrue((result.rawCells().length == 1 ? 1 : 0) != 0);
            CELL_HEAP_SIZE = PrivateCellUtil.estimatedHeapSizeOf((Cell)result.rawCells()[0]) - (long)(ClassSize.ARRAY + 3);
            if (LOG.isInfoEnabled()) {
                LOG.info("Cell heap size: " + CELL_HEAP_SIZE);
            }
            scanner.close();
        }
        return CELL_HEAP_SIZE;
    }

    private long getResultSizeForNumberOfCells(int numberOfCells) throws Exception {
        return this.getCellHeapSize() * (long)numberOfCells;
    }

    @Test
    public void testPartialResultsAndBatch() throws Exception {
        for (int batch = 1; batch <= NUM_COLS / 4; ++batch) {
            for (int cellsPerPartial = 1; cellsPerPartial <= NUM_COLS / 4; ++cellsPerPartial) {
                this.testPartialResultsAndBatch(batch, cellsPerPartial);
            }
        }
    }

    public void testPartialResultsAndBatch(int batch, int cellsPerPartialResult) throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info("batch: " + batch + " cellsPerPartialResult: " + cellsPerPartialResult);
        }
        Scan scan = new Scan();
        scan.setMaxResultSize(this.getResultSizeForNumberOfCells(cellsPerPartialResult));
        scan.setBatch(batch);
        ResultScanner scanner = TABLE.getScanner(scan);
        Result result = scanner.next();
        int repCount = 0;
        while ((result = scanner.next()) != null) {
            Assert.assertTrue((result.rawCells() != null ? 1 : 0) != 0);
            if (result.mayHaveMoreCellsInRow()) {
                String error = "Cells:" + result.rawCells().length + " Batch size:" + batch + " cellsPerPartialResult:" + cellsPerPartialResult + " rep:" + repCount;
                Assert.assertTrue((String)error, (result.rawCells().length == batch ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((result.rawCells().length <= batch ? 1 : 0) != 0);
            }
            ++repCount;
        }
        scanner.close();
    }

    @Test
    public void testPartialResultsReassembly() throws Exception {
        Scan scan = new Scan();
        this.testPartialResultsReassembly(scan);
        scan.setReversed(true);
        this.testPartialResultsReassembly(scan);
    }

    public void testPartialResultsReassembly(Scan scanBase) throws Exception {
        Scan partialScan = new Scan(scanBase);
        partialScan.setMaxResultSize(1L);
        partialScan.setAllowPartialResults(true);
        ResultScanner partialScanner = TABLE.getScanner(partialScan);
        Scan oneShotScan = new Scan(scanBase);
        oneShotScan.setMaxResultSize(Long.MAX_VALUE);
        ResultScanner oneShotScanner = TABLE.getScanner(oneShotScan);
        ArrayList<Result> partials = new ArrayList<Result>();
        for (int i = 0; i < NUM_ROWS; ++i) {
            Result partialResult = null;
            Result completeResult = null;
            Result oneShotResult = null;
            partials.clear();
            do {
                partialResult = partialScanner.next();
                partials.add(partialResult);
            } while (partialResult != null && partialResult.mayHaveMoreCellsInRow());
            completeResult = Result.createCompleteResult(partials);
            oneShotResult = oneShotScanner.next();
            TestPartialResultsFromClientSide.compareResults(completeResult, oneShotResult, null);
        }
        Assert.assertTrue((oneShotScanner.next() == null ? 1 : 0) != 0);
        Assert.assertTrue((partialScanner.next() == null ? 1 : 0) != 0);
        oneShotScanner.close();
        partialScanner.close();
    }

    @Test
    public void testExceptionThrownOnMismatchedPartialResults() throws IOException {
        Assert.assertTrue((NUM_ROWS >= 2 ? 1 : 0) != 0);
        ArrayList<Result> partials = new ArrayList<Result>();
        Scan scan = new Scan();
        scan.setMaxResultSize(Long.MAX_VALUE);
        ResultScanner scanner = TABLE.getScanner(scan);
        Result r1 = scanner.next();
        partials.add(r1);
        Result r2 = scanner.next();
        partials.add(r2);
        Assert.assertFalse((boolean)Bytes.equals((byte[])r1.getRow(), (byte[])r2.getRow()));
        try {
            Result.createCompleteResult(partials);
            Assert.fail((String)"r1 and r2 are from different rows. It should not be possible to combine them into a single result");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        scanner.close();
    }

    @Test
    public void testNoPartialResultsWhenRowFilterPresent() throws Exception {
        Scan scan = new Scan();
        scan.setMaxResultSize(1L);
        scan.setAllowPartialResults(true);
        scan.setFilter((Filter)new RandomRowFilter(1.0f));
        ResultScanner scanner = TABLE.getScanner(scan);
        Result r = null;
        while ((r = scanner.next()) != null) {
            Assert.assertFalse((boolean)r.mayHaveMoreCellsInRow());
        }
        scanner.close();
    }

    @Test
    public void testPartialResultsAndCaching() throws Exception {
        for (int caching = 1; caching <= NUM_ROWS; ++caching) {
            for (int maxResultRows = 0; maxResultRows <= NUM_ROWS; ++maxResultRows) {
                this.testPartialResultsAndCaching(maxResultRows, caching);
            }
        }
    }

    public void testPartialResultsAndCaching(int resultSizeRowLimit, int cachingRowLimit) throws Exception {
        boolean expectToSeePartialResults;
        Scan scan = new Scan();
        scan.setAllowPartialResults(true);
        int cellOffset = NUM_COLS / 3;
        long maxResultSize = this.getResultSizeForNumberOfCells(resultSizeRowLimit * NUM_COLS + cellOffset);
        scan.setMaxResultSize(maxResultSize);
        scan.setCaching(cachingRowLimit);
        ResultScanner scanner = TABLE.getScanner(scan);
        ClientScanner clientScanner = (ClientScanner)scanner;
        Result r = null;
        boolean bl = expectToSeePartialResults = resultSizeRowLimit < cachingRowLimit;
        while ((r = clientScanner.next()) != null) {
            Assert.assertTrue((!r.mayHaveMoreCellsInRow() || expectToSeePartialResults ? 1 : 0) != 0);
        }
        scanner.close();
    }

    static ArrayList<Put> createPuts(byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] value) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int row = 0; row < rows.length; ++row) {
            Put put = new Put(rows[row]);
            for (int fam = 0; fam < families.length; ++fam) {
                for (int qual = 0; qual < qualifiers.length; ++qual) {
                    KeyValue kv = new KeyValue(rows[row], families[fam], qualifiers[qual], (long)qual, value);
                    put.add((Cell)kv);
                }
            }
            puts.add(put);
        }
        return puts;
    }

    static ArrayList<Cell> createKeyValuesForRow(byte[] row, byte[][] families, byte[][] qualifiers, byte[] value) {
        ArrayList<Cell> outList = new ArrayList<Cell>();
        for (int fam = 0; fam < families.length; ++fam) {
            for (int qual = 0; qual < qualifiers.length; ++qual) {
                outList.add((Cell)new KeyValue(row, families[fam], qualifiers[qual], (long)qual, value));
            }
        }
        return outList;
    }

    static void verifyResult(Result result, List<Cell> expKvList, String msg) {
        if (LOG.isInfoEnabled()) {
            LOG.info(msg);
            LOG.info("Expected count: " + expKvList.size());
            LOG.info("Actual count: " + result.size());
        }
        if (expKvList.isEmpty()) {
            return;
        }
        int i = 0;
        for (Cell kv : result.rawCells()) {
            if (i >= expKvList.size()) break;
            Cell kvExp = expKvList.get(i++);
            Assert.assertTrue((String)("Not equal. get kv: " + kv.toString() + " exp kv: " + kvExp.toString()), (boolean)kvExp.equals(kv));
        }
        Assert.assertEquals((long)expKvList.size(), (long)result.size());
    }

    static void compareResults(Result r1, Result r2, String message) {
        if (LOG.isInfoEnabled()) {
            if (message != null) {
                LOG.info(message);
            }
            LOG.info("r1: " + r1);
            LOG.info("r2: " + r2);
        }
        String failureMessage = "Results r1:" + r1 + " \nr2:" + r2 + " are not equivalent";
        if (r1 == null && r2 == null) {
            Assert.fail((String)failureMessage);
        } else if (r1 == null || r2 == null) {
            Assert.fail((String)failureMessage);
        }
        try {
            Result.compareResults((Result)r1, (Result)r2);
        }
        catch (Exception e) {
            Assert.fail((String)failureMessage);
        }
    }

    @Test
    public void testReadPointAndPartialResults() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        int numRows = 5;
        int numFamilies = 5;
        int numQualifiers = 5;
        byte[][] rows = HTestConst.makeNAscii(Bytes.toBytes((String)"testRow"), numRows);
        byte[][] families = HTestConst.makeNAscii(Bytes.toBytes((String)"testFamily"), numFamilies);
        byte[][] qualifiers = HTestConst.makeNAscii(Bytes.toBytes((String)"testQualifier"), numQualifiers);
        byte[] value = Bytes.createMaxByteArray((int)100);
        Table tmpTable = TestPartialResultsFromClientSide.createTestTable(tableName, rows, families, qualifiers, value);
        ResultScanner scanner = tmpTable.getScanner(new Scan().setMaxResultSize(1L).setAllowPartialResults(true));
        int scannerCount = scanner.next().rawCells().length;
        Delete delete1 = new Delete(rows[0]);
        delete1.addColumn(families[0], qualifiers[0], 0L);
        tmpTable.delete(delete1);
        Delete delete2 = new Delete(rows[1]);
        delete2.addColumn(families[1], qualifiers[1], 1L);
        tmpTable.delete(delete2);
        int expectedCount = numRows * numFamilies * numQualifiers;
        Assert.assertTrue((String)("scannerCount: " + (scannerCount += this.countCellsFromScanner(scanner)) + " expectedCount: " + expectedCount), (scannerCount == expectedCount ? 1 : 0) != 0);
        scanner = tmpTable.getScanner(new Scan().setMaxResultSize(1L).setAllowPartialResults(true));
        scannerCount = this.countCellsFromScanner(scanner);
        expectedCount = numRows * numFamilies * numQualifiers - 2;
        Assert.assertTrue((String)("scannerCount: " + scannerCount + " expectedCount: " + expectedCount), (scannerCount == expectedCount ? 1 : 0) != 0);
        scanner = tmpTable.getScanner(new Scan().setMaxResultSize(1L).setAllowPartialResults(true));
        scannerCount = scanner.next().rawCells().length;
        Put put1 = new Put(rows[0]);
        put1.add((Cell)new KeyValue(rows[0], families[0], qualifiers[0], 1L, value));
        tmpTable.put(put1);
        Put put2 = new Put(rows[1]);
        put2.add((Cell)new KeyValue(rows[1], families[1], qualifiers[1], 2L, value));
        tmpTable.put(put2);
        expectedCount = numRows * numFamilies * numQualifiers - 2;
        Assert.assertTrue((String)("scannerCount: " + (scannerCount += this.countCellsFromScanner(scanner)) + " expectedCount: " + expectedCount), (scannerCount == expectedCount ? 1 : 0) != 0);
        scanner = tmpTable.getScanner(new Scan().setMaxResultSize(1L).setAllowPartialResults(true));
        scannerCount = this.countCellsFromScanner(scanner);
        expectedCount = numRows * numFamilies * numQualifiers;
        Assert.assertTrue((String)("scannerCount: " + scannerCount + " expectedCount: " + expectedCount), (scannerCount == expectedCount ? 1 : 0) != 0);
        TEST_UTIL.deleteTable(tableName);
    }

    private int countCellsFromScanner(ResultScanner scanner) throws Exception {
        Result result = null;
        int numCells = 0;
        while ((result = scanner.next()) != null) {
            numCells += result.rawCells().length;
        }
        scanner.close();
        return numCells;
    }

    @Test
    public void testPartialResultsWithColumnFilter() throws Exception {
        this.testPartialResultsWithColumnFilter((Filter)new FirstKeyOnlyFilter());
        this.testPartialResultsWithColumnFilter((Filter)new ColumnPrefixFilter(Bytes.toBytes((String)"testQualifier5")));
        this.testPartialResultsWithColumnFilter((Filter)new ColumnRangeFilter(Bytes.toBytes((String)"testQualifer1"), true, Bytes.toBytes((String)"testQualifier7"), true));
        LinkedHashSet<byte[]> qualifiers = new LinkedHashSet<byte[]>();
        qualifiers.add(Bytes.toBytes((String)"testQualifier5"));
        this.testPartialResultsWithColumnFilter((Filter)new FirstKeyValueMatchingQualifiersFilter(qualifiers));
    }

    public void testPartialResultsWithColumnFilter(Filter filter) throws Exception {
        Assert.assertTrue((!filter.hasFilterRow() ? 1 : 0) != 0);
        Scan partialScan = new Scan();
        partialScan.setFilter(filter);
        Scan oneshotScan = new Scan();
        oneshotScan.setFilter(filter);
        oneshotScan.setMaxResultSize(Long.MAX_VALUE);
        for (int i = 1; i <= NUM_COLS; ++i) {
            partialScan.setMaxResultSize(this.getResultSizeForNumberOfCells(i));
            this.testEquivalenceOfScanResults(TABLE, partialScan, oneshotScan);
        }
    }

    private void moveRegion(Table table, int index) throws IOException {
        List regions = MetaTableAccessor.getTableRegionsAndLocations((Connection)TEST_UTIL.getConnection(), (TableName)table.getName());
        Assert.assertEquals((long)1L, (long)regions.size());
        RegionInfo regionInfo = (RegionInfo)((Pair)regions.get(0)).getFirst();
        ServerName name = TEST_UTIL.getHBaseCluster().getRegionServer(index).getServerName();
        TEST_UTIL.getAdmin().move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)name.getServerName()));
    }

    private void assertCell(Cell cell, byte[] row, byte[] cf, byte[] cq) {
        Assert.assertArrayEquals((byte[])row, (byte[])Bytes.copy((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
        Assert.assertArrayEquals((byte[])cf, (byte[])Bytes.copy((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()));
        Assert.assertArrayEquals((byte[])cq, (byte[])Bytes.copy((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
    }

    @Test
    public void testPartialResultWhenRegionMove() throws IOException {
        Table table = TestPartialResultsFromClientSide.createTestTable(TableName.valueOf((String)this.name.getMethodName()), ROWS, FAMILIES, QUALIFIERS, VALUE);
        this.moveRegion(table, 1);
        Scan scan = new Scan();
        scan.setMaxResultSize(1L);
        scan.setAllowPartialResults(true);
        ResultScanner scanner = table.getScanner(scan);
        for (int i = 0; i < NUM_FAMILIES * NUM_QUALIFIERS - 1; ++i) {
            scanner.next();
        }
        Result result1 = scanner.next();
        Assert.assertEquals((long)1L, (long)result1.rawCells().length);
        Cell c1 = result1.rawCells()[0];
        this.assertCell(c1, ROWS[0], FAMILIES[NUM_FAMILIES - 1], QUALIFIERS[NUM_QUALIFIERS - 1]);
        Assert.assertFalse((boolean)result1.mayHaveMoreCellsInRow());
        this.moveRegion(table, 2);
        Result result2 = scanner.next();
        Assert.assertEquals((long)1L, (long)result2.rawCells().length);
        Cell c2 = result2.rawCells()[0];
        this.assertCell(c2, ROWS[1], FAMILIES[0], QUALIFIERS[0]);
        Assert.assertTrue((boolean)result2.mayHaveMoreCellsInRow());
        this.moveRegion(table, 3);
        Result result3 = scanner.next();
        Assert.assertEquals((long)1L, (long)result3.rawCells().length);
        Cell c3 = result3.rawCells()[0];
        this.assertCell(c3, ROWS[1], FAMILIES[0], QUALIFIERS[1]);
        Assert.assertTrue((boolean)result3.mayHaveMoreCellsInRow());
    }

    @Test
    public void testReversedPartialResultWhenRegionMove() throws IOException {
        Table table = TestPartialResultsFromClientSide.createTestTable(TableName.valueOf((String)this.name.getMethodName()), ROWS, FAMILIES, QUALIFIERS, VALUE);
        this.moveRegion(table, 1);
        Scan scan = new Scan();
        scan.setMaxResultSize(1L);
        scan.setAllowPartialResults(true);
        scan.setReversed(true);
        ResultScanner scanner = table.getScanner(scan);
        for (int i = 0; i < NUM_FAMILIES * NUM_QUALIFIERS - 1; ++i) {
            scanner.next();
        }
        Result result1 = scanner.next();
        Assert.assertEquals((long)1L, (long)result1.rawCells().length);
        Cell c1 = result1.rawCells()[0];
        this.assertCell(c1, ROWS[NUM_ROWS - 1], FAMILIES[NUM_FAMILIES - 1], QUALIFIERS[NUM_QUALIFIERS - 1]);
        Assert.assertFalse((boolean)result1.mayHaveMoreCellsInRow());
        this.moveRegion(table, 2);
        Result result2 = scanner.next();
        Assert.assertEquals((long)1L, (long)result2.rawCells().length);
        Cell c2 = result2.rawCells()[0];
        this.assertCell(c2, ROWS[NUM_ROWS - 2], FAMILIES[0], QUALIFIERS[0]);
        Assert.assertTrue((boolean)result2.mayHaveMoreCellsInRow());
        this.moveRegion(table, 3);
        Result result3 = scanner.next();
        Assert.assertEquals((long)1L, (long)result3.rawCells().length);
        Cell c3 = result3.rawCells()[0];
        this.assertCell(c3, ROWS[NUM_ROWS - 2], FAMILIES[0], QUALIFIERS[1]);
        Assert.assertTrue((boolean)result3.mayHaveMoreCellsInRow());
    }

    @Test
    public void testCompleteResultWhenRegionMove() throws IOException {
        Table table = TestPartialResultsFromClientSide.createTestTable(TableName.valueOf((String)this.name.getMethodName()), ROWS, FAMILIES, QUALIFIERS, VALUE);
        this.moveRegion(table, 1);
        Scan scan = new Scan();
        scan.setMaxResultSize(1L);
        scan.setCaching(1);
        ResultScanner scanner = table.getScanner(scan);
        Result result1 = scanner.next();
        Assert.assertEquals((long)(NUM_FAMILIES * NUM_QUALIFIERS), (long)result1.rawCells().length);
        Cell c1 = result1.rawCells()[0];
        this.assertCell(c1, ROWS[0], FAMILIES[0], QUALIFIERS[0]);
        Assert.assertFalse((boolean)result1.mayHaveMoreCellsInRow());
        this.moveRegion(table, 2);
        Result result2 = scanner.next();
        Assert.assertEquals((long)(NUM_FAMILIES * NUM_QUALIFIERS), (long)result2.rawCells().length);
        Cell c2 = result2.rawCells()[0];
        this.assertCell(c2, ROWS[1], FAMILIES[0], QUALIFIERS[0]);
        Assert.assertFalse((boolean)result2.mayHaveMoreCellsInRow());
        this.moveRegion(table, 3);
        Result result3 = scanner.next();
        Assert.assertEquals((long)(NUM_FAMILIES * NUM_QUALIFIERS), (long)result3.rawCells().length);
        Cell c3 = result3.rawCells()[0];
        this.assertCell(c3, ROWS[2], FAMILIES[0], QUALIFIERS[0]);
        Assert.assertFalse((boolean)result3.mayHaveMoreCellsInRow());
    }

    @Test
    public void testReversedCompleteResultWhenRegionMove() throws IOException {
        Table table = TestPartialResultsFromClientSide.createTestTable(TableName.valueOf((String)this.name.getMethodName()), ROWS, FAMILIES, QUALIFIERS, VALUE);
        this.moveRegion(table, 1);
        Scan scan = new Scan();
        scan.setMaxResultSize(1L);
        scan.setCaching(1);
        scan.setReversed(true);
        ResultScanner scanner = table.getScanner(scan);
        Result result1 = scanner.next();
        Assert.assertEquals((long)(NUM_FAMILIES * NUM_QUALIFIERS), (long)result1.rawCells().length);
        Cell c1 = result1.rawCells()[0];
        this.assertCell(c1, ROWS[NUM_ROWS - 1], FAMILIES[0], QUALIFIERS[0]);
        Assert.assertFalse((boolean)result1.mayHaveMoreCellsInRow());
        this.moveRegion(table, 2);
        Result result2 = scanner.next();
        Assert.assertEquals((long)(NUM_FAMILIES * NUM_QUALIFIERS), (long)result2.rawCells().length);
        Cell c2 = result2.rawCells()[0];
        this.assertCell(c2, ROWS[NUM_ROWS - 2], FAMILIES[0], QUALIFIERS[0]);
        Assert.assertFalse((boolean)result2.mayHaveMoreCellsInRow());
        this.moveRegion(table, 3);
        Result result3 = scanner.next();
        Assert.assertEquals((long)(NUM_FAMILIES * NUM_QUALIFIERS), (long)result3.rawCells().length);
        Cell c3 = result3.rawCells()[0];
        this.assertCell(c3, ROWS[NUM_ROWS - 3], FAMILIES[0], QUALIFIERS[0]);
        Assert.assertFalse((boolean)result3.mayHaveMoreCellsInRow());
    }

    @Test
    public void testBatchingResultWhenRegionMove() throws IOException {
        Table table = TestPartialResultsFromClientSide.createTestTable(TableName.valueOf((String)this.name.getMethodName()), ROWS, FAMILIES, QUALIFIERS, VALUE);
        Put put = new Put(ROWS[1]);
        put.addColumn(FAMILIES[0], QUALIFIERS[1], new byte[VALUE_SIZE * 10]);
        table.put(put);
        Delete delete = new Delete(ROWS[1]);
        delete.addColumn(FAMILIES[NUM_FAMILIES - 1], QUALIFIERS[NUM_QUALIFIERS - 1]);
        table.delete(delete);
        this.moveRegion(table, 1);
        Scan scan = new Scan();
        scan.setCaching(1);
        scan.setBatch(5);
        scan.setMaxResultSize((long)(VALUE_SIZE * 6));
        ResultScanner scanner = table.getScanner(scan);
        for (int i = 0; i < NUM_FAMILIES * NUM_QUALIFIERS / 5 - 1; ++i) {
            Assert.assertTrue((boolean)scanner.next().mayHaveMoreCellsInRow());
        }
        Result result1 = scanner.next();
        Assert.assertEquals((long)5L, (long)result1.rawCells().length);
        this.assertCell(result1.rawCells()[0], ROWS[0], FAMILIES[NUM_FAMILIES - 1], QUALIFIERS[NUM_QUALIFIERS - 5]);
        this.assertCell(result1.rawCells()[4], ROWS[0], FAMILIES[NUM_FAMILIES - 1], QUALIFIERS[NUM_QUALIFIERS - 1]);
        Assert.assertFalse((boolean)result1.mayHaveMoreCellsInRow());
        this.moveRegion(table, 2);
        Result result2 = scanner.next();
        Assert.assertEquals((long)5L, (long)result2.rawCells().length);
        this.assertCell(result2.rawCells()[0], ROWS[1], FAMILIES[0], QUALIFIERS[0]);
        this.assertCell(result2.rawCells()[4], ROWS[1], FAMILIES[0], QUALIFIERS[4]);
        Assert.assertTrue((boolean)result2.mayHaveMoreCellsInRow());
        this.moveRegion(table, 3);
        Result result3 = scanner.next();
        Assert.assertEquals((long)5L, (long)result3.rawCells().length);
        this.assertCell(result3.rawCells()[0], ROWS[1], FAMILIES[0], QUALIFIERS[5]);
        this.assertCell(result3.rawCells()[4], ROWS[1], FAMILIES[0], QUALIFIERS[9]);
        Assert.assertTrue((boolean)result3.mayHaveMoreCellsInRow());
        for (int i = 0; i < NUM_FAMILIES * NUM_QUALIFIERS / 5 - 3; ++i) {
            Result result = scanner.next();
            Assert.assertEquals((long)5L, (long)result.rawCells().length);
            Assert.assertTrue((boolean)result.mayHaveMoreCellsInRow());
        }
        Result result = scanner.next();
        Assert.assertEquals((long)4L, (long)result.rawCells().length);
        Assert.assertFalse((boolean)result.mayHaveMoreCellsInRow());
        for (int i = 2; i < NUM_ROWS; ++i) {
            for (int j = 0; j < NUM_FAMILIES; ++j) {
                for (int k = 0; k < NUM_QUALIFIERS; k += 5) {
                    result = scanner.next();
                    this.assertCell(result.rawCells()[0], ROWS[i], FAMILIES[j], QUALIFIERS[k]);
                    Assert.assertEquals((long)5L, (long)result.rawCells().length);
                    if (j == NUM_FAMILIES - 1 && k == NUM_QUALIFIERS - 5) {
                        Assert.assertFalse((boolean)result.mayHaveMoreCellsInRow());
                        continue;
                    }
                    Assert.assertTrue((boolean)result.mayHaveMoreCellsInRow());
                }
            }
        }
        Assert.assertNull((Object)scanner.next());
    }

    @Test
    public void testDontThrowUnknowScannerExceptionToClient() throws Exception {
        Table table = TestPartialResultsFromClientSide.createTestTable(TableName.valueOf((String)this.name.getMethodName()), ROWS, FAMILIES, QUALIFIERS, VALUE);
        Scan scan = new Scan();
        scan.setCaching(1);
        ResultScanner scanner = table.getScanner(scan);
        scanner.next();
        Thread.sleep(timeout * 2L);
        int count = 1;
        while (scanner.next() != null) {
            ++count;
        }
        Assert.assertEquals((long)NUM_ROWS, (long)count);
        scanner.close();
    }

    @Test
    public void testMayHaveMoreCellsInRowReturnsTrueAndSetBatch() throws IOException {
        Result result;
        Table table = TestPartialResultsFromClientSide.createTestTable(TableName.valueOf((String)this.name.getMethodName()), ROWS, FAMILIES, QUALIFIERS, VALUE);
        Scan scan = new Scan();
        scan.setBatch(1);
        scan.setFilter((Filter)new FirstKeyOnlyFilter());
        ResultScanner scanner = table.getScanner(scan);
        while ((result = scanner.next()) != null) {
            Assert.assertTrue((result.rawCells() != null ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)result.rawCells().length);
        }
    }
}

