/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestRegionMetrics {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Admin admin;
    private static final TableName TABLE_1;
    private static final TableName TABLE_2;
    private static final TableName TABLE_3;
    private static final TableName[] tables;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster(4);
        admin = UTIL.getAdmin();
        admin.balancerSwitch(false, true);
        byte[] FAMILY = Bytes.toBytes((String)"f");
        for (TableName tableName : tables) {
            Table table = UTIL.createMultiRegionTable(tableName, FAMILY, 16);
            UTIL.waitTableAvailable(tableName);
            UTIL.loadTable(table, FAMILY);
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        for (TableName table : tables) {
            UTIL.deleteTableIfAny(table);
        }
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRegionMetrics() throws Exception {
        List<Object> regionMetrics;
        for (ServerName serverName : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
            List regions = admin.getRegions(serverName);
            List regionMetricsList = admin.getRegionMetrics(serverName);
            this.checkRegionsAndRegionMetrics(regions, regionMetricsList);
        }
        for (TableName table : new TableName[]{TABLE_1, TABLE_2, TABLE_3}) {
            List tableRegions = admin.getRegions(table);
            regionMetrics = new ArrayList<RegionMetrics>();
            for (ServerName serverName : admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet()) {
                regionMetrics.addAll(admin.getRegionMetrics(serverName, table));
            }
            this.checkRegionsAndRegionMetrics(tableRegions, regionMetrics);
        }
        ClusterMetrics clusterStatus = admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS));
        for (Map.Entry entry : clusterStatus.getLiveServerMetrics().entrySet()) {
            ServerName serverName = (ServerName)entry.getKey();
            ServerMetrics serverMetrics = (ServerMetrics)entry.getValue();
            regionMetrics = admin.getRegionMetrics(serverName);
            Assert.assertEquals((long)serverMetrics.getRegionMetrics().size(), (long)regionMetrics.size());
        }
    }

    private void checkRegionsAndRegionMetrics(Collection<RegionInfo> regions, Collection<RegionMetrics> regionMetrics) {
        Assert.assertEquals((String)"No of regions and regionMetrics doesn't match", (long)regions.size(), (long)regionMetrics.size());
        TreeMap regionMetricsMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        for (RegionMetrics r : regionMetrics) {
            regionMetricsMap.put(r.getRegionName(), r);
        }
        for (RegionInfo info : regions) {
            Assert.assertTrue((String)("Region not in RegionMetricsMap region:" + info.getRegionNameAsString() + " regionMap: " + regionMetricsMap), (boolean)regionMetricsMap.containsKey(info.getRegionName()));
        }
    }

    static {
        TABLE_1 = TableName.valueOf((String)"table_1");
        TABLE_2 = TableName.valueOf((String)"table_2");
        TABLE_3 = TableName.valueOf((String)"table_3");
        tables = new TableName[]{TABLE_1, TABLE_2, TABLE_3};
    }
}

