/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractTestCITimeout;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestCIRpcTimeout
extends AbstractTestCITimeout {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestCIRpcTimeout.class);
    private TableName tableName;

    @Before
    public void setUp() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)this.tableName).addCoprocessor(AbstractTestCITimeout.SleepCoprocessor.class.getName()).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAM_NAM)).build();
        TEST_UTIL.getAdmin().createTable(htd);
    }

    protected abstract void execute(Table var1) throws IOException;

    @Test
    public void testRpcTimeout() throws IOException {
        Throwable throwable;
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        try {
            throwable = null;
            try (Table table = TEST_UTIL.getConnection().getTableBuilder(this.tableName, null).setRpcTimeout(2500).setReadRpcTimeout(2500).setWriteRpcTimeout(2500).setOperationTimeout(500000).build();){
                this.execute(table);
                Assert.fail((String)"Get should not have succeeded");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (RetriesExhaustedException e) {
            LOG.info("We received an exception, as expected ", (Throwable)e);
        }
        c.setInt("hbase.rpc.timeout", 2500);
        c.setInt("hbase.rpc.read.timeout", 2500);
        c.setInt("hbase.rpc.write.timeout", 2500);
        c.setInt("hbase.client.operation.timeout", 500000);
        throwable = null;
        try (Connection conn = ConnectionFactory.createConnection((Configuration)c);){
            try (Table table = conn.getTable(this.tableName);){
                this.execute(table);
                Assert.fail((String)"Get should not have succeeded");
            }
            catch (RetriesExhaustedException e) {
                LOG.info("We received an exception, as expected ", (Throwable)e);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }
}

