/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestAlwaysSetScannerId {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");
    private static final int COUNT = 10;
    private static HRegionInfo HRI;
    private static ClientProtos.ClientService.BlockingInterface STUB;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        try (Table table = UTIL.createTable(TABLE_NAME, CF);){
            for (int i = 0; i < 10; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        HRI = (HRegionInfo)UTIL.getAdmin().getTableRegions(TABLE_NAME).get(0);
        STUB = ((ConnectionImplementation)UTIL.getConnection()).getClient(UTIL.getHBaseCluster().getRegionServer(0).getServerName());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws ServiceException, IOException {
        Scan scan = new Scan();
        ClientProtos.ScanRequest req = RequestConverter.buildScanRequest((byte[])HRI.getRegionName(), (Scan)scan, (int)1, (boolean)false);
        ClientProtos.ScanResponse resp = STUB.scan(null, req);
        Assert.assertTrue((boolean)resp.hasScannerId());
        long scannerId = resp.getScannerId();
        int nextCallSeq = 0;
        for (int i = 0; i < 5; ++i) {
            req = RequestConverter.buildScanRequest((long)scannerId, (int)1, (boolean)false, (long)nextCallSeq++, (boolean)false, (boolean)false, (int)-1);
            resp = STUB.scan(null, req);
            Assert.assertTrue((boolean)resp.hasScannerId());
            Assert.assertEquals((long)scannerId, (long)resp.getScannerId());
        }
        req = RequestConverter.buildScanRequest((long)scannerId, (int)0, (boolean)false, (long)nextCallSeq++, (boolean)false, (boolean)true, (int)-1);
        resp = STUB.scan(null, req);
        Assert.assertTrue((boolean)resp.hasScannerId());
        Assert.assertEquals((long)scannerId, (long)resp.getScannerId());
        req = RequestConverter.buildScanRequest((long)scannerId, (int)0, (boolean)true, (boolean)false);
        resp = STUB.scan(null, req);
        Assert.assertTrue((boolean)resp.hasScannerId());
        Assert.assertEquals((long)scannerId, (long)resp.getScannerId());
    }
}

