/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncBufferedMutator;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncBufferMutator {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static TableName MULTI_REGION_TABLE_NAME = TableName.valueOf((String)"async-multi-region");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static byte[] CQ = Bytes.toBytes((String)"cq");
    private static int COUNT = 100;
    private static byte[] VALUE = new byte[1024];
    private static AsyncConnection CONN;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE_NAME, CF);
        TEST_UTIL.createMultiRegionTable(MULTI_REGION_TABLE_NAME, CF);
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        ThreadLocalRandom.current().nextBytes(VALUE);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CONN.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testWithMultiRegionTable() throws InterruptedException {
        this.test(MULTI_REGION_TABLE_NAME);
    }

    @Test
    public void testWithSingleRegionTable() throws InterruptedException {
        this.test(TABLE_NAME);
    }

    private void test(TableName tableName) throws InterruptedException {
        ArrayList futures = new ArrayList();
        try (AsyncBufferedMutator mutator = CONN.getBufferedMutatorBuilder(tableName).setWriteBufferSize(16384L).build();){
            List fs = mutator.mutate(IntStream.range(0, COUNT / 2).mapToObj(i -> new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, VALUE)).collect(Collectors.toList()));
            fs.forEach(f -> {
                Void cfr_ignored_0 = (Void)f.join();
            });
            IntStream.range(COUNT / 2, COUNT).forEach(i -> futures.add(mutator.mutate((Mutation)new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, VALUE))));
            ((CompletableFuture)futures.get(0)).join();
            Thread.sleep(2000L);
            Assert.assertFalse((boolean)((CompletableFuture)futures.get(futures.size() - 1)).isDone());
        }
        futures.forEach(f -> {
            Void cfr_ignored_0 = (Void)f.join();
        });
        AsyncTable table = CONN.getTable(tableName);
        IntStream.range(0, COUNT).mapToObj(i -> new Get(Bytes.toBytes((int)i))).map(g -> (Result)table.get(g).join()).forEach(r -> Assert.assertArrayEquals((byte[])VALUE, (byte[])r.getValue(CF, CQ)));
    }

    @Test
    public void testClosedMutate() throws InterruptedException {
        AsyncBufferedMutator mutator = CONN.getBufferedMutator(TABLE_NAME);
        mutator.close();
        Put put = new Put(Bytes.toBytes((int)0)).addColumn(CF, CQ, VALUE);
        try {
            mutator.mutate((Mutation)put).get();
            Assert.fail((String)"Close check failed");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Already closed"));
        }
        for (CompletableFuture f : mutator.mutate(Arrays.asList(put))) {
            try {
                f.get();
                Assert.fail((String)"Close check failed");
            }
            catch (ExecutionException e) {
                Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
                Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Already closed"));
            }
        }
    }
}

