/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncClusterAdminApi
extends TestAsyncAdminBase {
    private final Path cnfPath = FileSystems.getDefault().getPath("target/test-classes/hbase-site.xml", new String[0]);
    private final Path cnf2Path = FileSystems.getDefault().getPath("target/test-classes/hbase-site2.xml", new String[0]);
    private final Path cnf3Path = FileSystems.getDefault().getPath("target/test-classes/hbase-site3.xml", new String[0]);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 120000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", 0);
        TEST_UTIL.startMiniCluster(2);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @Test
    public void testGetMasterInfoPort() throws Exception {
        Assert.assertEquals((long)TEST_UTIL.getHBaseCluster().getMaster().getInfoServer().getPort(), (long)((Integer)this.admin.getMasterInfoPort().get()).intValue());
    }

    @Test
    public void testRegionServerOnlineConfigChange() throws Exception {
        this.replaceHBaseSiteXML();
        ((Collection)this.admin.getRegionServers().get()).forEach(server -> {
            Void cfr_ignored_0 = (Void)this.admin.updateConfiguration(server).join();
        });
        TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads().forEach(thread -> {
            Configuration conf = thread.getRegionServer().getConfiguration();
            Assert.assertEquals((long)1000L, (long)conf.getInt("hbase.custom.config", 0));
        });
        this.restoreHBaseSiteXML();
    }

    @Test
    public void testMasterOnlineConfigChange() throws Exception {
        this.replaceHBaseSiteXML();
        ServerName master = (ServerName)this.admin.getMaster().get();
        this.admin.updateConfiguration(master).join();
        ((Collection)this.admin.getBackupMasters().get()).forEach(backupMaster -> {
            Void cfr_ignored_0 = (Void)this.admin.updateConfiguration(backupMaster).join();
        });
        TEST_UTIL.getMiniHBaseCluster().getMasterThreads().forEach(thread -> {
            Configuration conf = thread.getMaster().getConfiguration();
            Assert.assertEquals((long)1000L, (long)conf.getInt("hbase.custom.config", 0));
        });
        this.restoreHBaseSiteXML();
    }

    @Test
    public void testAllClusterOnlineConfigChange() throws IOException {
        this.replaceHBaseSiteXML();
        this.admin.updateConfiguration().join();
        TEST_UTIL.getMiniHBaseCluster().getMasterThreads().forEach(thread -> {
            Configuration conf = thread.getMaster().getConfiguration();
            Assert.assertEquals((long)1000L, (long)conf.getInt("hbase.custom.config", 0));
        });
        TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads().forEach(thread -> {
            Configuration conf = thread.getRegionServer().getConfiguration();
            Assert.assertEquals((long)1000L, (long)conf.getInt("hbase.custom.config", 0));
        });
        this.restoreHBaseSiteXML();
    }

    private void replaceHBaseSiteXML() throws IOException {
        Files.copy(this.cnfPath, this.cnf3Path, StandardCopyOption.REPLACE_EXISTING);
        Files.copy(this.cnf2Path, this.cnfPath, StandardCopyOption.REPLACE_EXISTING);
    }

    private void restoreHBaseSiteXML() throws IOException {
        Files.copy(this.cnf3Path, this.cnfPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Test
    public void testRollWALWALWriter() throws Exception {
        this.setUpforLogRolling();
        String className = this.getClass().getName();
        StringBuilder v = new StringBuilder(className);
        while (v.length() < 1000) {
            v.append(className);
        }
        byte[] value = Bytes.toBytes((String)v.toString());
        HRegionServer regionServer = this.startAndWriteData(this.tableName, value);
        LOG.info("after writing there are " + AbstractFSWALProvider.getNumRolledLogFiles((WAL)regionServer.getWAL(null)) + " log files");
        for (HRegion r : regionServer.getOnlineRegionsLocalContext()) {
            r.flush(true);
        }
        this.admin.rollWALWriter(regionServer.getServerName()).join();
        int count = AbstractFSWALProvider.getNumRolledLogFiles((WAL)regionServer.getWAL(null));
        LOG.info("after flushing all regions and rolling logs there are " + count + " log files");
        Assert.assertTrue((String)("actual count: " + count), (count <= 2 ? 1 : 0) != 0);
    }

    private void setUpforLogRolling() {
        TEST_UTIL.getConfiguration().setLong("hbase.hregion.max.filesize", 786432L);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.maxlogentries", 32);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.logroll.errors.tolerated", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.hregion.memstore.optionalflushcount", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.hregion.memstore.flush.size", 8192);
        TEST_UTIL.getConfiguration().setLong("hbase.client.pause", 10000L);
        TEST_UTIL.getConfiguration().setInt("hbase.server.thread.wakefrequency", 2000);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.write.retries", 30);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.hlog.tolerable.lowreplication", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.hlog.lowreplication.rolllimit", 3);
    }

    private HRegionServer startAndWriteData(TableName tableName, byte[] value) throws Exception {
        this.createTableWithDefaultConf(tableName);
        AsyncTable table = ASYNC_CONN.getTable(tableName);
        HRegionServer regionServer = TEST_UTIL.getRSForFirstRegionInTable(tableName);
        for (int i = 1; i <= 256; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + String.format("%1$04d", i))));
            put.addColumn(FAMILY, null, value);
            table.put(put).join();
            if (i % 32 != 0) continue;
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return regionServer;
    }

    @Test
    public void testGetRegionLoads() throws Exception {
        this.admin.balancerSwitch(false).join();
        TableName[] tables = new TableName[]{TableName.valueOf((String)(this.tableName.getNameAsString() + "1")), TableName.valueOf((String)(this.tableName.getNameAsString() + "2")), TableName.valueOf((String)(this.tableName.getNameAsString() + "3"))};
        this.createAndLoadTable(tables);
        Thread.sleep(TEST_UTIL.getConfiguration().getInt("hbase.regionserver.msginterval", 3000) * 2);
        Collection servers = (Collection)this.admin.getRegionServers().get();
        for (ServerName serverName : servers) {
            List regions = (List)this.admin.getRegions(serverName).get();
            this.checkRegionsAndRegionLoads(regions, (Collection)this.admin.getRegionMetrics(serverName).get());
        }
        for (TableName table : tables) {
            List tableRegions = (List)this.admin.getRegions(table).get();
            ArrayList regionLoads = Lists.newArrayList();
            for (ServerName serverName : servers) {
                regionLoads.addAll((Collection)this.admin.getRegionMetrics(serverName, table).get());
            }
            this.checkRegionsAndRegionLoads(tableRegions, regionLoads);
        }
        ClusterMetrics clusterStatus = (ClusterMetrics)this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).get();
        for (Map.Entry entry : clusterStatus.getLiveServerMetrics().entrySet()) {
            ServerName sn = (ServerName)entry.getKey();
            ServerMetrics sm = (ServerMetrics)entry.getValue();
            this.compareRegionLoads(sm.getRegionMetrics().values(), (Collection)this.admin.getRegionMetrics(sn).get());
        }
        for (ServerName serverName : clusterStatus.getLiveServerMetrics().keySet()) {
            ServerMetrics serverMetrics = (ServerMetrics)clusterStatus.getLiveServerMetrics().get(serverName);
        }
    }

    private void compareRegionLoads(Collection<RegionMetrics> regionLoadCluster, Collection<RegionMetrics> regionLoads) {
        Assert.assertEquals((String)"No of regionLoads from clusterStatus and regionloads from RS doesn't match", (long)regionLoadCluster.size(), (long)regionLoads.size());
        for (RegionMetrics loadCluster : regionLoadCluster) {
            boolean matched = false;
            for (RegionMetrics load : regionLoads) {
                if (!Bytes.equals((byte[])loadCluster.getRegionName(), (byte[])load.getRegionName())) continue;
                matched = true;
            }
            Assert.assertTrue((String)"The contents of region load from cluster and server should match", (boolean)matched);
        }
    }

    private void checkRegionsAndRegionLoads(Collection<RegionInfo> regions, Collection<RegionMetrics> regionLoads) {
        Assert.assertEquals((String)"No of regions and regionloads doesn't match", (long)regions.size(), (long)regionLoads.size());
        TreeMap regionLoadMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        for (RegionMetrics regionLoad : regionLoads) {
            regionLoadMap.put(regionLoad.getRegionName(), regionLoad);
        }
        for (RegionInfo info : regions) {
            Assert.assertTrue((String)("Region not in regionLoadMap region:" + info.getRegionNameAsString() + " regionMap: " + regionLoadMap), (boolean)regionLoadMap.containsKey(info.getRegionName()));
        }
    }

    private void createAndLoadTable(TableName[] tables) {
        for (TableName table : tables) {
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)table);
            builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
            this.admin.createTable(builder.build(), Bytes.toBytes((String)"aaaaa"), Bytes.toBytes((String)"zzzzz"), 16).join();
            AsyncTable asyncTable = ASYNC_CONN.getTable(table);
            ArrayList<Put> puts = new ArrayList<Put>();
            for (byte[] row : HBaseTestingUtility.ROWS) {
                puts.add(new Put(row).addColumn(FAMILY, Bytes.toBytes((String)"q"), Bytes.toBytes((String)"v")));
            }
            asyncTable.putAll(puts).join();
        }
    }
}

