/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncDecommissionAdminApi
extends TestAsyncAdminBase {
    @Test(timeout=30000L)
    public void testAsyncDecommissionRegionServers() throws Exception {
        int i;
        List decommissionedRegionServers = (List)this.admin.listDecommissionedRegionServers().get();
        Assert.assertTrue((boolean)decommissionedRegionServers.isEmpty());
        TEST_UTIL.createMultiRegionTable(this.tableName, FAMILY, 4);
        ArrayList clusterRegionServers = new ArrayList(((ClusterMetrics)this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).get()).getLiveServerMetrics().keySet());
        Assert.assertEquals((long)clusterRegionServers.size(), (long)2L);
        HashMap serversToDecommssion = new HashMap();
        for (i = 0; i < clusterRegionServers.size(); ++i) {
            List regionsOnServer = (List)this.admin.getRegions((ServerName)clusterRegionServers.get(i)).get();
            if (regionsOnServer.size() <= 0) continue;
            serversToDecommssion.put(clusterRegionServers.get(i), regionsOnServer);
            break;
        }
        clusterRegionServers.remove(i);
        ServerName remainingServer = (ServerName)clusterRegionServers.get(0);
        this.admin.decommissionRegionServers(new ArrayList(serversToDecommssion.keySet()), true).get();
        Assert.assertEquals((long)1L, (long)((List)this.admin.listDecommissionedRegionServers().get()).size());
        for (ServerName server : serversToDecommssion.keySet()) {
            for (RegionInfo region2 : (List)serversToDecommssion.get(server)) {
                TEST_UTIL.assertRegionOnServer(region2, remainingServer, 10000L);
            }
        }
        for (ServerName server : serversToDecommssion.keySet()) {
            List encodedRegionNames = ((List)serversToDecommssion.get(server)).stream().map(region -> region.getEncodedNameAsBytes()).collect(Collectors.toList());
            this.admin.recommissionRegionServer(server, encodedRegionNames).get();
        }
        Assert.assertTrue((boolean)((List)this.admin.listDecommissionedRegionServers().get()).isEmpty());
        for (ServerName server : serversToDecommssion.keySet()) {
            for (RegionInfo region2 : (List)serversToDecommssion.get(server)) {
                TEST_UTIL.assertRegionOnServer(region2, server, 10000L);
            }
        }
    }
}

