/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncReplicationAdminApiWithClusters
extends TestAsyncAdminBase {
    private static final String ID_SECOND = "2";
    private static HBaseTestingUtility TEST_UTIL2;
    private static Configuration conf2;
    private static AsyncAdmin admin2;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 120000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", 0);
        TEST_UTIL.startMiniCluster();
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        conf2 = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        conf2.set("zookeeper.znode.parent", "/2");
        TEST_UTIL2 = new HBaseTestingUtility(conf2);
        TEST_UTIL2.startMiniCluster();
        admin2 = ((AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL2.getConfiguration()).get()).getAdmin();
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(TEST_UTIL2.getClusterKey());
        ASYNC_CONN.getAdmin().addReplicationPeer(ID_SECOND, rpc).join();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        Pattern pattern = Pattern.compile(this.tableName.getNameAsString() + ".*");
        this.cleanupTables(this.admin, pattern);
        this.cleanupTables(admin2, pattern);
    }

    private void cleanupTables(AsyncAdmin admin, Pattern pattern) {
        ((CompletableFuture)admin.listTableNames(pattern, false).whenCompleteAsync((tables, err) -> {
            if (tables != null) {
                tables.forEach(table -> {
                    try {
                        admin.disableTable(table).join();
                    }
                    catch (Exception e) {
                        LOG.debug("Table: " + this.tableName + " already disabled, so just deleting it.");
                    }
                    admin.deleteTable(table).join();
                });
            }
        }, (Executor)ForkJoinPool.commonPool())).join();
    }

    private void createTableWithDefaultConf(AsyncAdmin admin, TableName tableName) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY));
        admin.createTable(builder.build()).join();
    }

    @Test
    public void testEnableAndDisableTableReplication() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        this.admin.enableTableReplication(this.tableName).join();
        TableDescriptor tableDesc = (TableDescriptor)this.admin.getDescriptor(this.tableName).get();
        for (ColumnFamilyDescriptor fam : tableDesc.getColumnFamilies()) {
            Assert.assertEquals((long)1L, (long)fam.getScope());
        }
        this.admin.disableTableReplication(this.tableName).join();
        tableDesc = (TableDescriptor)this.admin.getDescriptor(this.tableName).get();
        for (ColumnFamilyDescriptor fam : tableDesc.getColumnFamilies()) {
            Assert.assertEquals((long)0L, (long)fam.getScope());
        }
    }

    @Test
    public void testEnableReplicationWhenSlaveClusterDoesntHaveTable() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        Assert.assertFalse((boolean)((Boolean)admin2.tableExists(this.tableName).get()));
        this.admin.enableTableReplication(this.tableName).join();
        Assert.assertTrue((boolean)((Boolean)admin2.tableExists(this.tableName).get()));
    }

    @Test
    public void testEnableReplicationWhenTableDescriptorIsNotSameInClusters() throws Exception {
        this.createTableWithDefaultConf(this.admin, this.tableName);
        this.createTableWithDefaultConf(admin2, this.tableName);
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)((TableDescriptor)this.admin.getDescriptor(this.tableName).get()));
        builder.addColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"newFamily")).build());
        admin2.disableTable(this.tableName).join();
        admin2.modifyTable(builder.build()).join();
        admin2.enableTable(this.tableName).join();
        try {
            this.admin.enableTableReplication(this.tableName).join();
            Assert.fail((String)"Exception should be thrown if table descriptors in the clusters are not same.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.admin.disableTable(this.tableName).join();
        this.admin.modifyTable(builder.build()).join();
        this.admin.enableTable(this.tableName).join();
        this.admin.enableTableReplication(this.tableName).join();
        TableDescriptor tableDesc = (TableDescriptor)this.admin.getDescriptor(this.tableName).get();
        for (ColumnFamilyDescriptor fam : tableDesc.getColumnFamilies()) {
            Assert.assertEquals((long)1L, (long)fam.getScope());
        }
    }

    @Test
    public void testDisableReplicationForNonExistingTable() throws Exception {
        try {
            this.admin.disableTableReplication(this.tableName).join();
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TableNotFoundException));
        }
    }

    @Test
    public void testEnableReplicationForNonExistingTable() throws Exception {
        try {
            this.admin.enableTableReplication(this.tableName).join();
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof TableNotFoundException));
        }
    }

    @Test
    public void testDisableReplicationWhenTableNameAsNull() throws Exception {
        try {
            this.admin.disableTableReplication(null).join();
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testEnableReplicationWhenTableNameAsNull() throws Exception {
        try {
            this.admin.enableTableReplication(null).join();
        }
        catch (CompletionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableReplicationForExplicitSetTableCfs() throws Exception {
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + ID_SECOND));
        this.createTableWithDefaultConf(this.tableName);
        this.createTableWithDefaultConf(tableName2);
        Assert.assertFalse((String)"Table should not exists in the peer cluster", (boolean)((Boolean)admin2.tableExists(this.tableName).get()));
        Assert.assertFalse((String)"Table should not exists in the peer cluster", (boolean)((Boolean)admin2.tableExists(tableName2).get()));
        HashMap<TableName, Object> tableCfs = new HashMap<TableName, Object>();
        tableCfs.put(this.tableName, null);
        ReplicationPeerConfig rpc = (ReplicationPeerConfig)this.admin.getReplicationPeerConfig(ID_SECOND).get();
        rpc.setReplicateAllUserTables(false);
        rpc.setTableCFsMap(tableCfs);
        try {
            this.admin.updateReplicationPeerConfig(ID_SECOND, rpc).join();
            this.admin.enableTableReplication(tableName2).join();
            Assert.assertFalse((String)"Table should not be created if user has set table cfs explicitly for the peer and this is not part of that collection", (boolean)((Boolean)admin2.tableExists(tableName2).get()));
            tableCfs.put(tableName2, null);
            rpc.setTableCFsMap(tableCfs);
            this.admin.updateReplicationPeerConfig(ID_SECOND, rpc).join();
            this.admin.enableTableReplication(tableName2).join();
            Assert.assertTrue((String)"Table should be created if user has explicitly added table into table cfs collection", (boolean)((Boolean)admin2.tableExists(tableName2).get()));
        }
        finally {
            rpc.setTableCFsMap(null);
            rpc.setReplicateAllUserTables(true);
            this.admin.updateReplicationPeerConfig(ID_SECOND, rpc).join();
        }
    }
}

