/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.net.SocketTimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractTestCITimeout;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.MasterCallable;
import org.apache.hadoop.hbase.client.RegionAdminServiceCallable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, MediumTests.class})
public class TestCISleep
extends AbstractTestCITimeout {
    private static Logger LOG = LoggerFactory.getLogger(TestCISleep.class);
    private TableName tableName;

    @Before
    public void setUp() {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    @Test
    public void testRpcRetryingCallerSleep() throws Exception {
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)this.tableName).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAM_NAM)).addCoprocessorWithSpec("|" + AbstractTestCITimeout.SleepAndFailFirstTime.class.getName() + "||" + "hbase.coprocessor.SleepAndFailFirstTime.sleepTime" + "=2000").build();
        TEST_UTIL.getAdmin().createTable(htd);
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.setInt("hbase.client.pause", 3000);
        c.setInt("hbase.rpc.timeout", 4000);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)c);){
            AbstractTestCITimeout.SleepAndFailFirstTime.ct.set(0L);
            try (Table table = conn.getTableBuilder(this.tableName, null).setOperationTimeout(8000).build();){
                table.get(new Get(FAM_NAM));
            }
            AbstractTestCITimeout.SleepAndFailFirstTime.ct.set(0L);
            try {
                table = conn.getTableBuilder(this.tableName, null).setOperationTimeout(6000).build();
                var6_9 = null;
                try {
                    table.get(new Get(FAM_NAM));
                    Assert.fail((String)"We expect an exception here");
                }
                catch (Throwable throwable) {
                    var6_9 = throwable;
                    throw throwable;
                }
                finally {
                    if (table != null) {
                        if (var6_9 != null) {
                            try {
                                table.close();
                            }
                            catch (Throwable throwable) {
                                var6_9.addSuppressed(throwable);
                            }
                        } else {
                            table.close();
                        }
                    }
                }
            }
            catch (SocketTimeoutException e) {
                LOG.info("We received an exception, as expected ", (Throwable)e);
            }
        }
    }

    @Test
    public void testCallableSleep() throws Exception {
        long pauseTime;
        long baseTime = 100L;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, FAM_NAM);
        ClientServiceCallable<Object> regionServerCallable = new ClientServiceCallable<Object>(TEST_UTIL.getConnection(), tableName, FAM_NAM, (RpcController)new RpcControllerFactory(TEST_UTIL.getConfiguration()).newController(), -1){

            protected Object rpcCall() throws Exception {
                return null;
            }
        };
        regionServerCallable.prepare(false);
        for (int i = 0; i < HConstants.RETRY_BACKOFF.length; ++i) {
            pauseTime = regionServerCallable.sleep(baseTime, i);
            Assert.assertTrue((pauseTime >= baseTime * (long)HConstants.RETRY_BACKOFF[i] ? 1 : 0) != 0);
            Assert.assertTrue(((float)pauseTime <= (float)(baseTime * (long)HConstants.RETRY_BACKOFF[i]) * 1.01f ? 1 : 0) != 0);
        }
        RegionAdminServiceCallable<Object> regionAdminServiceCallable = new RegionAdminServiceCallable<Object>((ClusterConnection)TEST_UTIL.getConnection(), new RpcControllerFactory(TEST_UTIL.getConfiguration()), tableName, FAM_NAM){

            public Object call(HBaseRpcController controller) throws Exception {
                return null;
            }
        };
        regionAdminServiceCallable.prepare(false);
        for (int i = 0; i < HConstants.RETRY_BACKOFF.length; ++i) {
            pauseTime = regionAdminServiceCallable.sleep(baseTime, i);
            Assert.assertTrue((pauseTime >= baseTime * (long)HConstants.RETRY_BACKOFF[i] ? 1 : 0) != 0);
            Assert.assertTrue(((float)pauseTime <= (float)(baseTime * (long)HConstants.RETRY_BACKOFF[i]) * 1.01f ? 1 : 0) != 0);
        }
        try (MasterCallable<Object> masterCallable = new MasterCallable<Object>(TEST_UTIL.getConnection(), new RpcControllerFactory(TEST_UTIL.getConfiguration())){

            protected Object rpcCall() throws Exception {
                return null;
            }
        };){
            for (int i = 0; i < HConstants.RETRY_BACKOFF.length; ++i) {
                pauseTime = masterCallable.sleep(baseTime, i);
                Assert.assertTrue((pauseTime >= baseTime * (long)HConstants.RETRY_BACKOFF[i] ? 1 : 0) != 0);
                Assert.assertTrue(((float)pauseTime <= (float)(baseTime * (long)HConstants.RETRY_BACKOFF[i]) * 1.01f ? 1 : 0) != 0);
            }
        }
    }
}

