/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableMultiplexer;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestHTableMultiplexer {
    private static final Logger LOG = LoggerFactory.getLogger(TestHTableMultiplexer.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] VALUE1 = Bytes.toBytes((String)"testValue1");
    private static byte[] VALUE2 = Bytes.toBytes((String)"testValue2");
    private static int SLAVES = 3;
    private static int PER_REGIONSERVER_QUEUE_SIZE = 100000;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void checkExistence(Table htable, byte[] row, byte[] family, byte[] quality) throws Exception {
        Result r;
        Get get = new Get(row);
        get.addColumn(FAMILY, QUALIFIER);
        int nbTry = 0;
        do {
            Assert.assertTrue((String)("Fail to get from " + htable.getName() + " after " + nbTry + " tries"), (nbTry < 50 ? 1 : 0) != 0);
            ++nbTry;
            Thread.sleep(100L);
        } while ((r = htable.get(get)) == null || r.getValue(FAMILY, QUALIFIER) == null);
        Assert.assertEquals((String)"value", (Object)Bytes.toStringBinary((byte[])VALUE1), (Object)Bytes.toStringBinary((byte[])r.getValue(FAMILY, QUALIFIER)));
    }

    @Test
    public void testHTableMultiplexer() throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "_1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "_2"));
        int NUM_REGIONS = 10;
        int VERSION = 3;
        HTableMultiplexer multiplexer = new HTableMultiplexer(TEST_UTIL.getConfiguration(), PER_REGIONSERVER_QUEUE_SIZE);
        Table htable1 = TEST_UTIL.createTable(tableName1, new byte[][]{FAMILY}, 3, Bytes.toBytes((String)"aaaaa"), Bytes.toBytes((String)"zzzzz"), 10);
        Table htable2 = TEST_UTIL.createTable(tableName2, new byte[][]{FAMILY}, 3, Bytes.toBytes((String)"aaaaa"), Bytes.toBytes((String)"zzzzz"), 10);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName1);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName2);
        try (RegionLocator rl = TEST_UTIL.getConnection().getRegionLocator(tableName1);){
            byte[] row;
            int i;
            byte[][] startRows = rl.getStartKeys();
            byte[][] endRows = rl.getEndKeys();
            for (int i2 = 0; i2 < 10; ++i2) {
                byte[] row2 = startRows[i2];
                if (row2 == null || row2.length <= 0) continue;
                Put put = new Put(row2).addColumn(FAMILY, QUALIFIER, VALUE1);
                boolean success = multiplexer.put(tableName1, put);
                Assert.assertTrue((String)"multiplexer.put returns", (boolean)success);
                put = new Put(row2).addColumn(FAMILY, QUALIFIER, VALUE1);
                success = multiplexer.put(tableName2, put);
                Assert.assertTrue((String)"multiplexer.put failed", (boolean)success);
                LOG.info("Put for " + Bytes.toStringBinary((byte[])startRows[i2]) + " @ iteration " + (i2 + 1));
                TestHTableMultiplexer.checkExistence(htable1, startRows[i2], FAMILY, QUALIFIER);
                TestHTableMultiplexer.checkExistence(htable2, startRows[i2], FAMILY, QUALIFIER);
            }
            ArrayList<Put> multiput = new ArrayList<Put>();
            for (i = 0; i < 10; ++i) {
                row = endRows[i];
                if (row == null || row.length <= 0) continue;
                Put put = new Put(row);
                put.addColumn(FAMILY, QUALIFIER, VALUE2);
                multiput.add(put);
            }
            List failedPuts = multiplexer.put(tableName1, multiput);
            Assert.assertTrue((failedPuts == null ? 1 : 0) != 0);
            for (i = 0; i < 10; ++i) {
                Result r;
                row = endRows[i];
                if (row == null || row.length <= 0) continue;
                Get get = new Get(row);
                get.addColumn(FAMILY, QUALIFIER);
                int nbTry = 0;
                do {
                    Assert.assertTrue((nbTry++ < 50 ? 1 : 0) != 0);
                    Thread.sleep(100L);
                } while ((r = htable1.get(get)) == null || r.getValue(FAMILY, QUALIFIER) == null || Bytes.compareTo((byte[])VALUE2, (byte[])r.getValue(FAMILY, QUALIFIER)) != 0);
            }
        }
    }
}

