/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;

@Category(value={LargeTests.class, ClientTests.class})
public class TestIllegalTableDescriptor {
    private static final Logger masterLogger;
    protected static final HBaseTestingUtility TEST_UTIL;
    private static byte[] FAMILY;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Field field = HMaster.class.getDeclaredField("LOG");
        field.setAccessible(true);
        field.set(null, masterLogger);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.table.sanity.checks", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testIllegalTableDescriptor() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        this.checkTableIsIllegal(htd);
        htd.addFamily(hcd);
        this.checkTableIsLegal(htd);
        htd.setMaxFileSize(1024L);
        this.checkTableIsIllegal(htd);
        htd.setMaxFileSize(0L);
        this.checkTableIsIllegal(htd);
        htd.setMaxFileSize(0x40000000L);
        this.checkTableIsLegal(htd);
        htd.setMemStoreFlushSize(1024L);
        this.checkTableIsIllegal(htd);
        htd.setMemStoreFlushSize(0L);
        this.checkTableIsIllegal(htd);
        htd.setMemStoreFlushSize(0x8000000L);
        this.checkTableIsLegal(htd);
        htd.setRegionSplitPolicyClassName("nonexisting.foo.class");
        this.checkTableIsIllegal(htd);
        htd.setRegionSplitPolicyClassName(null);
        this.checkTableIsLegal(htd);
        hcd.setBlocksize(0);
        this.checkTableIsIllegal(htd);
        hcd.setBlocksize(0x8000000);
        this.checkTableIsIllegal(htd);
        hcd.setBlocksize(1024);
        this.checkTableIsLegal(htd);
        hcd.setTimeToLive(0);
        this.checkTableIsIllegal(htd);
        hcd.setTimeToLive(-1);
        this.checkTableIsIllegal(htd);
        hcd.setTimeToLive(1);
        this.checkTableIsLegal(htd);
        hcd.setMinVersions(-1);
        this.checkTableIsIllegal(htd);
        hcd.setMinVersions(3);
        try {
            hcd.setMaxVersions(2);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            hcd.setMaxVersions(10);
        }
        this.checkTableIsLegal(htd);
        hcd.setMaxVersions(4);
        hcd.setMinVersions(5);
        this.checkTableIsIllegal(htd);
        hcd.setMinVersions(3);
        hcd.setScope(-1);
        this.checkTableIsIllegal(htd);
        hcd.setScope(0);
        this.checkTableIsLegal(htd);
        try {
            hcd.setDFSReplication((short)-1);
            Assert.fail((String)"Illegal value for setDFSReplication did not throw");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        hcd.setValue("DFS_REPLICATION", "-1");
        this.checkTableIsIllegal(htd);
        try {
            hcd.setDFSReplication((short)-1);
            Assert.fail((String)"Should throw exception if an illegal value is explicitly being set");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        htd.setMemStoreFlushSize(0L);
        htd.setConfiguration("hbase.table.sanity.checks", Boolean.FALSE.toString());
        this.checkTableIsLegal(htd);
        ((Logger)Mockito.verify((Object)masterLogger)).warn(ArgumentMatchers.contains((String)"MEMSTORE_FLUSHSIZE for table descriptor or \"hbase.hregion.memstore.flush.size\" (0) is too small, which might cause very frequent flushing."));
    }

    private void checkTableIsLegal(HTableDescriptor htd) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        admin.createTable((TableDescriptor)htd);
        Assert.assertTrue((boolean)admin.tableExists(htd.getTableName()));
        TEST_UTIL.deleteTable(htd.getTableName());
    }

    private void checkTableIsIllegal(HTableDescriptor htd) throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        try {
            admin.createTable((TableDescriptor)htd);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)admin.tableExists(htd.getTableName()));
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        FAMILY = Bytes.toBytes((String)"testFamily");
        masterLogger = (Logger)Mockito.mock(Logger.class);
    }
}

