/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.NoSuchProcedureException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.HBaseFsckRepair;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.zookeeper.LoadBalancerTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestMetaWithReplicas {
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final Logger LOG = LoggerFactory.getLogger(TestMetaWithReplicas.class);
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @Before
    public void setup() throws Exception {
        this.TEST_UTIL.getConfiguration().setInt("zookeeper.session.timeout", 30000);
        this.TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", 3);
        this.TEST_UTIL.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 1000);
        this.TEST_UTIL.startMiniCluster(3);
        LoadBalancerTracker l = new LoadBalancerTracker(this.TEST_UTIL.getZooKeeperWatcher(), new Abortable(){
            boolean aborted = false;

            public boolean isAborted() {
                return this.aborted;
            }

            public void abort(String why, Throwable e) {
                this.aborted = true;
            }
        });
        l.setBalancerOn(false);
        for (int replicaId = 1; replicaId < 3; ++replicaId) {
            RegionInfo h = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)replicaId);
            try {
                this.TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(h);
                continue;
            }
            catch (NoSuchProcedureException e) {
                LOG.info("Presume the procedure has been cleaned up so just proceed: " + e.toString());
            }
        }
        LOG.debug("All meta replicas assigned");
    }

    @After
    public void tearDown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMetaHTDReplicaCount() throws Exception {
        Assert.assertTrue((this.TEST_UTIL.getAdmin().getTableDescriptor(TableName.META_TABLE_NAME).getRegionReplication() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testZookeeperNodesForReplicas() throws Exception {
        ZKWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();
        Configuration conf = this.TEST_UTIL.getConfiguration();
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZNodePaths.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode);
        ProtobufUtil.toServerName((byte[])data);
        for (int i = 1; i < 3; ++i) {
            String secZnode = ZNodePaths.joinZNode((String)baseZNode, (String)(conf.get("zookeeper.znode.metaserver", "meta-region-server") + "-" + i));
            String str = zkw.znodePaths.getZNodeForReplica(i);
            Assert.assertTrue((boolean)str.equals(secZnode));
            data = ZKUtil.getData((ZKWatcher)zkw, (String)secZnode);
            ProtobufUtil.toServerName((byte[])data);
        }
    }

    @Test
    public void testShutdownHandling() throws Exception {
        TestMetaWithReplicas.shutdownMetaAndDoValidations(this.TEST_UTIL);
    }

    public static void shutdownMetaAndDoValidations(HBaseTestingUtility util) throws Exception {
        ZKWatcher zkw = util.getZooKeeperWatcher();
        Configuration conf = util.getConfiguration();
        conf.setBoolean("hbase.meta.replicas.use", true);
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZNodePaths.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode);
        ServerName primary = ProtobufUtil.toServerName((byte[])data);
        TableName TABLE = TableName.valueOf((String)"testShutdownHandling");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"foo")};
        if (util.getAdmin().tableExists(TABLE)) {
            util.getAdmin().disableTable(TABLE);
            util.getAdmin().deleteTable(TABLE);
        }
        ServerName master = null;
        try (Connection c = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
            try (Table htable = util.createTable(TABLE, (byte[][])FAMILIES);){
                util.getAdmin().flush(TableName.META_TABLE_NAME);
                Thread.sleep(conf.getInt("hbase.regionserver.storefile.refresh.period", 30000) * 6);
                List regions = MetaTableAccessor.getTableRegions((Connection)c, (TableName)TABLE);
                HRegionLocation hrl = MetaTableAccessor.getRegionLocation((Connection)c, (RegionInfo)((RegionInfo)regions.get(0)));
                if (hrl.getServerName().equals((Object)primary)) {
                    util.getAdmin().move(hrl.getRegionInfo().getEncodedNameAsBytes(), null);
                    do {
                        Thread.sleep(10L);
                    } while (primary.equals((Object)(hrl = MetaTableAccessor.getRegionLocation((Connection)c, (RegionInfo)((RegionInfo)regions.get(0)))).getServerName()));
                    util.getAdmin().flush(TableName.META_TABLE_NAME);
                    Thread.sleep(conf.getInt("hbase.regionserver.storefile.refresh.period", 30000) * 3);
                }
                master = util.getHBaseClusterInterface().getClusterMetrics().getMasterName();
                util.getHBaseClusterInterface().stopMaster(master);
                util.getHBaseClusterInterface().waitForMasterToStop(master, 60000L);
                if (!master.equals((Object)primary)) {
                    util.getHBaseClusterInterface().killRegionServer(primary);
                    util.getHBaseClusterInterface().waitForRegionServerToStop(primary, 60000L);
                }
                ((ClusterConnection)c).clearRegionCache();
            }
            Get get = null;
            Result r = null;
            byte[] row = "test".getBytes();
            try (Table htable = c.getTable(TABLE);){
                Put put = new Put(row);
                put.addColumn("foo".getBytes(), row, row);
                BufferedMutator m = c.getBufferedMutator(TABLE);
                m.mutate((Mutation)put);
                m.flush();
                get = new Get(row);
                r = htable.get(get);
                Assert.assertTrue((boolean)Arrays.equals(r.getRow(), row));
                util.getHBaseClusterInterface().startMaster(master.getHostname(), 0);
                util.getHBaseClusterInterface().startRegionServer(primary.getHostname(), 0);
                util.getHBaseClusterInterface().waitForActiveAndReadyMaster();
                ((ClusterConnection)c).clearRegionCache();
            }
            conf.setBoolean("hbase.meta.replicas.use", false);
            htable = c.getTable(TABLE);
            var16_21 = null;
            try {
                r = htable.get(get);
                Assert.assertTrue((boolean)Arrays.equals(r.getRow(), row));
            }
            catch (Throwable throwable) {
                var16_21 = throwable;
                throw throwable;
            }
            finally {
                if (htable != null) {
                    if (var16_21 != null) {
                        try {
                            htable.close();
                        }
                        catch (Throwable throwable) {
                            var16_21.addSuppressed(throwable);
                        }
                    } else {
                        htable.close();
                    }
                }
            }
        }
    }

    @Test
    public void testMetaLookupThreadPoolCreated() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"foo")};
        if (this.TEST_UTIL.getAdmin().tableExists(tableName)) {
            this.TEST_UTIL.getAdmin().disableTable(tableName);
            this.TEST_UTIL.getAdmin().deleteTable(tableName);
        }
        try (Table htable = this.TEST_UTIL.createTable(tableName, (byte[][])FAMILIES);){
            byte[] row = "test".getBytes();
            ConnectionImplementation c = (ConnectionImplementation)this.TEST_UTIL.getConnection();
            c.relocateRegion(tableName, row);
            ExecutorService ex = c.getCurrentMetaLookupPool();
            assert (ex != null);
        }
    }

    @Ignore
    @Test
    public void testChangingReplicaCount() throws Exception {
        this.stopMasterAndValidateReplicaCount(3, 2);
        this.stopMasterAndValidateReplicaCount(2, 3);
    }

    private void stopMasterAndValidateReplicaCount(int originalReplicaCount, int newReplicaCount) throws Exception {
        ServerName sn = this.TEST_UTIL.getHBaseClusterInterface().getClusterMetrics().getMasterName();
        this.TEST_UTIL.getHBaseClusterInterface().stopMaster(sn);
        this.TEST_UTIL.getHBaseClusterInterface().waitForMasterToStop(sn, 60000L);
        List metaZnodes = this.TEST_UTIL.getZooKeeperWatcher().getMetaReplicaNodes();
        assert (metaZnodes.size() == originalReplicaCount);
        this.TEST_UTIL.getHBaseClusterInterface().getConf().setInt("hbase.meta.replica.count", newReplicaCount);
        if (this.TEST_UTIL.getHBaseCluster().countServedRegions() < (long)newReplicaCount) {
            this.TEST_UTIL.getHBaseCluster().startRegionServer();
        }
        this.TEST_UTIL.getHBaseClusterInterface().startMaster(sn.getHostname(), 0);
        this.TEST_UTIL.getHBaseClusterInterface().waitForActiveAndReadyMaster();
        this.TEST_UTIL.waitFor(10000L, (Waiter.Predicate)this.predicateMetaHasReplicas(newReplicaCount));
        this.TEST_UTIL.getConfiguration().setInt("hbase.meta.replica.count", newReplicaCount);
        HBaseFsck hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertNoErrors(hbck);
    }

    private Waiter.ExplainingPredicate<Exception> predicateMetaHasReplicas(final int newReplicaCount) {
        return new Waiter.ExplainingPredicate<Exception>(){

            public String explainFailure() throws Exception {
                return TestMetaWithReplicas.this.checkMetaLocationAndExplain(newReplicaCount);
            }

            public boolean evaluate() throws Exception {
                return TestMetaWithReplicas.this.checkMetaLocationAndExplain(newReplicaCount) == null;
            }
        };
    }

    @Nullable
    private String checkMetaLocationAndExplain(int originalReplicaCount) throws KeeperException, IOException {
        List metaZnodes = this.TEST_UTIL.getZooKeeperWatcher().getMetaReplicaNodes();
        if (metaZnodes.size() == originalReplicaCount) {
            RegionLocations rl = ((ClusterConnection)this.TEST_UTIL.getConnection()).locateRegion(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, false, false);
            for (HRegionLocation location : rl.getRegionLocations()) {
                if (location == null) {
                    return "Null location found in " + rl.toString();
                }
                if (location.getRegionInfo() == null) {
                    return "Null regionInfo for location " + location;
                }
                if (location.getHostname() != null) continue;
                return "Null hostName for location " + location;
            }
            return null;
        }
        return "Replica count is not as expected " + originalReplicaCount + " <> " + metaZnodes.size() + "(" + metaZnodes.toString() + ")";
    }

    @Test
    public void testHBaseFsckWithMetaReplicas() throws Exception {
        HBaseFsck hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertNoErrors(hbck);
    }

    @Ignore
    @Test
    public void testHBaseFsckWithFewerMetaReplicas() throws Exception {
        ClusterConnection c = (ClusterConnection)ConnectionFactory.createConnection((Configuration)this.TEST_UTIL.getConfiguration());
        RegionLocations rl = c.locateRegion(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, false, false);
        HBaseFsckRepair.closeRegionSilentlyAndWait((Connection)c, (ServerName)rl.getRegionLocation(1).getServerName(), (RegionInfo)rl.getRegionLocation(1).getRegionInfo());
        HBaseFsck hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN, HBaseFsck.ErrorReporter.ERROR_CODE.NO_META_REGION});
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), true);
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
    }

    @Ignore
    @Test
    public void testHBaseFsckWithFewerMetaReplicaZnodes() throws Exception {
        ClusterConnection c = (ClusterConnection)ConnectionFactory.createConnection((Configuration)this.TEST_UTIL.getConfiguration());
        RegionLocations rl = c.locateRegion(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, false, false);
        HBaseFsckRepair.closeRegionSilentlyAndWait((Connection)c, (ServerName)rl.getRegionLocation(2).getServerName(), (RegionInfo)rl.getRegionLocation(2).getRegionInfo());
        ZKWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();
        ZKUtil.deleteNode((ZKWatcher)zkw, (String)zkw.znodePaths.getZNodeForReplica(2));
        HBaseFsck hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN, HBaseFsck.ErrorReporter.ERROR_CODE.NO_META_REGION});
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), true);
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
    }

    @Test
    public void testAccessingUnknownTables() throws Exception {
        Configuration conf = new Configuration(this.TEST_UTIL.getConfiguration());
        conf.setBoolean("hbase.meta.replicas.use", true);
        Table table = this.TEST_UTIL.getConnection().getTable(TableName.valueOf((String)this.name.getMethodName()));
        Get get = new Get(Bytes.toBytes((String)"foo"));
        try {
            table.get(get);
        }
        catch (TableNotFoundException t) {
            return;
        }
        Assert.fail((String)"Expected TableNotFoundException");
    }

    @Test
    public void testMetaAddressChange() throws Exception {
        Configuration conf = this.TEST_UTIL.getConfiguration();
        ZKWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZNodePaths.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode);
        ServerName currentServer = ProtobufUtil.toServerName((byte[])data);
        Set liveServers = this.TEST_UTIL.getAdmin().getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet();
        ServerName moveToServer = null;
        for (ServerName s : liveServers) {
            if (currentServer.equals((Object)s)) continue;
            moveToServer = s;
        }
        assert (moveToServer != null);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.TEST_UTIL.createTable(tableName, "f");
        Assert.assertTrue((boolean)this.TEST_UTIL.getAdmin().tableExists(tableName));
        this.TEST_UTIL.getAdmin().move(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), Bytes.toBytes((String)moveToServer.getServerName()));
        int i = 0;
        assert (!moveToServer.equals((Object)currentServer));
        LOG.info("CurrentServer=" + currentServer + ", moveToServer=" + moveToServer);
        int max = 10000;
        do {
            Thread.sleep(10L);
        } while (!moveToServer.equals((Object)(currentServer = ProtobufUtil.toServerName((byte[])(data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode))))) && ++i < 10000);
        assert (i != 10000);
        this.TEST_UTIL.getAdmin().disableTable(tableName);
        Assert.assertTrue((boolean)this.TEST_UTIL.getAdmin().isTableDisabled(tableName));
    }

    @Test
    public void testShutdownOfReplicaHolder() throws Exception {
        try (ClusterConnection conn = (ClusterConnection)ConnectionFactory.createConnection((Configuration)this.TEST_UTIL.getConfiguration());){
            RegionLocations rl = conn.locateRegion(TableName.META_TABLE_NAME, Bytes.toBytes((String)""), false, true);
            HRegionLocation hrl = rl.getRegionLocation(1);
            ServerName oldServer = hrl.getServerName();
            this.TEST_UTIL.getHBaseClusterInterface().killRegionServer(oldServer);
            int i = 0;
            do {
                LOG.debug("Waiting for the replica " + hrl.getRegionInfo() + " to come up");
                Thread.sleep(10000L);
            } while (((hrl = (rl = conn.locateRegion(TableName.META_TABLE_NAME, Bytes.toBytes((String)""), false, true)).getRegionLocation(1)) == null || hrl.getServerName().equals((Object)oldServer)) && ++i < 3);
            Assert.assertTrue((i != 3 ? 1 : 0) != 0);
        }
    }

    @Ignore
    @Test
    public void testHBaseFsckWithExcessMetaReplicas() throws Exception {
        RegionInfo h = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)3);
        this.TEST_UTIL.assignRegion(h);
        HBaseFsckRepair.waitUntilAssigned((Admin)this.TEST_UTIL.getAdmin(), (RegionInfo)h);
        HBaseFsck hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN, HBaseFsck.ErrorReporter.ERROR_CODE.SHOULD_NOT_BE_DEPLOYED});
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), true);
        hbck = HbckTestingUtil.doFsck(this.TEST_UTIL.getConfiguration(), false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
    }
}

