/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.AbstractTestScanCursor;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Cursor;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestRawAsyncScanCursor
extends AbstractTestScanCursor {
    private static AsyncConnection CONN;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        AbstractTestScanCursor.setUpBeforeClass();
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    public static void tearDownAfterClass() throws Exception {
        if (CONN != null) {
            CONN.close();
        }
        AbstractTestScanCursor.tearDownAfterClass();
    }

    private void doTest(final boolean reversed) throws InterruptedException, ExecutionException, IOException {
        final CompletableFuture future = new CompletableFuture();
        AsyncTable table = CONN.getTable(TABLE_NAME);
        table.scan(reversed ? this.createReversedScanWithSparseFilter() : this.createScanWithSparseFilter(), (ScanResultConsumerBase)new AdvancedScanResultConsumer(){
            private int count;

            public void onHeartbeat(AdvancedScanResultConsumer.ScanController controller) {
                int row = this.count / AbstractTestScanCursor.NUM_FAMILIES / AbstractTestScanCursor.NUM_QUALIFIERS;
                if (reversed) {
                    row = AbstractTestScanCursor.NUM_ROWS - 1 - row;
                }
                try {
                    Assert.assertArrayEquals((byte[])AbstractTestScanCursor.ROWS[row], (byte[])((Cursor)controller.cursor().get()).getRow());
                    ++this.count;
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    throw e;
                }
            }

            public void onNext(Result[] results, AdvancedScanResultConsumer.ScanController controller) {
                try {
                    Assert.assertEquals((long)1L, (long)results.length);
                    Assert.assertEquals((long)(AbstractTestScanCursor.NUM_ROWS - 1), (long)(this.count / AbstractTestScanCursor.NUM_FAMILIES / AbstractTestScanCursor.NUM_QUALIFIERS));
                    if (this.count == AbstractTestScanCursor.NUM_ROWS * AbstractTestScanCursor.NUM_FAMILIES * AbstractTestScanCursor.NUM_QUALIFIERS - 1) {
                        Assert.assertFalse((boolean)controller.cursor().isPresent());
                    } else {
                        Assert.assertArrayEquals((byte[])AbstractTestScanCursor.ROWS[reversed ? 0 : AbstractTestScanCursor.NUM_ROWS - 1], (byte[])((Cursor)controller.cursor().get()).getRow());
                    }
                    Assert.assertArrayEquals((byte[])AbstractTestScanCursor.ROWS[reversed ? 0 : AbstractTestScanCursor.NUM_ROWS - 1], (byte[])results[0].getRow());
                    ++this.count;
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    throw e;
                }
            }

            public void onError(Throwable error) {
                future.completeExceptionally(error);
            }

            public void onComplete() {
                future.complete(null);
            }
        });
        future.get();
    }

    @Test
    public void testHeartbeatWithSparseFilter() throws IOException, InterruptedException, ExecutionException {
        this.doTest(false);
    }

    @Test
    public void testHeartbeatWithSparseFilterReversed() throws IOException, InterruptedException, ExecutionException {
        this.doTest(true);
    }

    @Test
    public void testSizeLimit() throws InterruptedException, ExecutionException {
        final CompletableFuture future = new CompletableFuture();
        AsyncTable table = CONN.getTable(TABLE_NAME);
        table.scan(this.createScanWithSizeLimit(), (ScanResultConsumerBase)new AdvancedScanResultConsumer(){
            private int count;

            public void onHeartbeat(AdvancedScanResultConsumer.ScanController controller) {
                try {
                    Assert.assertArrayEquals((byte[])AbstractTestScanCursor.ROWS[this.count / AbstractTestScanCursor.NUM_FAMILIES / AbstractTestScanCursor.NUM_QUALIFIERS], (byte[])((Cursor)controller.cursor().get()).getRow());
                    ++this.count;
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    throw e;
                }
            }

            public void onNext(Result[] results, AdvancedScanResultConsumer.ScanController controller) {
                try {
                    Assert.assertFalse((boolean)controller.cursor().isPresent());
                    Assert.assertEquals((long)1L, (long)results.length);
                    Assert.assertArrayEquals((byte[])AbstractTestScanCursor.ROWS[this.count / AbstractTestScanCursor.NUM_FAMILIES / AbstractTestScanCursor.NUM_QUALIFIERS], (byte[])results[0].getRow());
                    ++this.count;
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    throw e;
                }
            }

            public void onError(Throwable error) {
                future.completeExceptionally(error);
            }

            public void onComplete() {
                future.complete(null);
            }
        });
        future.get();
    }
}

