/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.client.AbstractTestAsyncTableScan;
import org.apache.hadoop.hbase.client.BufferingScanResultConsumer;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class, ClientTests.class})
public class TestRawAsyncTableScan
extends AbstractTestAsyncTableScan {
    @Parameterized.Parameter(value=0)
    public String scanType;
    @Parameterized.Parameter(value=1)
    public Supplier<Scan> scanCreater;

    @Parameterized.Parameters(name="{index}: type={0}")
    public static List<Object[]> params() {
        return TestRawAsyncTableScan.getScanCreatorParams();
    }

    @Override
    protected Scan createScan() {
        return this.scanCreater.get();
    }

    @Override
    protected List<Result> doScan(Scan scan) throws Exception {
        Result result;
        BufferingScanResultConsumer scanConsumer = new BufferingScanResultConsumer();
        ASYNC_CONN.getTable(TABLE_NAME).scan(scan, (ScanResultConsumerBase)scanConsumer);
        List<Result> results = new ArrayList<Result>();
        while ((result = scanConsumer.take()) != null) {
            results.add(result);
        }
        if (scan.getBatch() > 0) {
            results = this.convertFromBatchResult(results);
        }
        return results;
    }
}

