/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestSplitOrMergeStatus {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testSplitSwitch() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = TEST_UTIL.createTable(tableName, FAMILY);
        TEST_UTIL.loadTable(t, FAMILY, false);
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(t.getName());
        int originalCount = locator.getAllRegionLocations().size();
        Admin admin = TEST_UTIL.getAdmin();
        this.initSwitchStatus(admin);
        boolean[] results = admin.setSplitOrMergeEnabled(false, false, new MasterSwitchType[]{MasterSwitchType.SPLIT});
        Assert.assertEquals((long)results.length, (long)1L);
        Assert.assertTrue((boolean)results[0]);
        admin.split(t.getName());
        int count = admin.getTableRegions(tableName).size();
        Assert.assertTrue((originalCount == count ? 1 : 0) != 0);
        results = admin.setSplitOrMergeEnabled(true, false, new MasterSwitchType[]{MasterSwitchType.SPLIT});
        Assert.assertEquals((long)results.length, (long)1L);
        Assert.assertFalse((boolean)results[0]);
        admin.split(t.getName());
        while ((count = admin.getTableRegions(tableName).size()) == originalCount) {
            Threads.sleep((long)1L);
        }
        count = admin.getTableRegions(tableName).size();
        Assert.assertTrue((originalCount < count ? 1 : 0) != 0);
        admin.close();
    }

    @Ignore
    @Test
    public void testMergeSwitch() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = TEST_UTIL.createTable(tableName, FAMILY);
        TEST_UTIL.loadTable(t, FAMILY, false);
        Admin admin = TEST_UTIL.getAdmin();
        int originalCount = admin.getTableRegions(tableName).size();
        this.initSwitchStatus(admin);
        admin.split(t.getName());
        int postSplitCount = -1;
        while ((postSplitCount = admin.getTableRegions(tableName).size()) == originalCount) {
            Threads.sleep((long)1L);
        }
        Assert.assertTrue((String)("originalCount=" + originalCount + ", newCount=" + postSplitCount), (originalCount != postSplitCount ? 1 : 0) != 0);
        boolean[] results = admin.setSplitOrMergeEnabled(false, false, new MasterSwitchType[]{MasterSwitchType.MERGE});
        Assert.assertEquals((long)results.length, (long)1L);
        Assert.assertTrue((boolean)results[0]);
        List regions = admin.getTableRegions(t.getName());
        Assert.assertTrue((regions.size() > 1 ? 1 : 0) != 0);
        Future f = admin.mergeRegionsAsync(((HRegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((HRegionInfo)regions.get(1)).getEncodedNameAsBytes(), true);
        try {
            f.get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"Should not get here.");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        int count = admin.getTableRegions(tableName).size();
        Assert.assertTrue((String)("newCount=" + postSplitCount + ", count=" + count), (postSplitCount == count ? 1 : 0) != 0);
        results = admin.setSplitOrMergeEnabled(true, false, new MasterSwitchType[]{MasterSwitchType.MERGE});
        regions = admin.getTableRegions(t.getName());
        Assert.assertEquals((long)results.length, (long)1L);
        Assert.assertFalse((boolean)results[0]);
        f = admin.mergeRegionsAsync(((HRegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((HRegionInfo)regions.get(1)).getEncodedNameAsBytes(), true);
        f.get(10L, TimeUnit.SECONDS);
        count = admin.getTableRegions(tableName).size();
        Assert.assertTrue((postSplitCount / 2 == count ? 1 : 0) != 0);
        admin.close();
    }

    @Test
    public void testMultiSwitches() throws IOException {
        boolean[] switches;
        Admin admin = TEST_UTIL.getAdmin();
        for (boolean s : switches = admin.setSplitOrMergeEnabled(false, false, new MasterSwitchType[]{MasterSwitchType.SPLIT, MasterSwitchType.MERGE})) {
            Assert.assertTrue((boolean)s);
        }
        Assert.assertFalse((boolean)admin.isSplitOrMergeEnabled(MasterSwitchType.SPLIT));
        Assert.assertFalse((boolean)admin.isSplitOrMergeEnabled(MasterSwitchType.MERGE));
        admin.close();
    }

    private void initSwitchStatus(Admin admin) throws IOException {
        if (!admin.isSplitOrMergeEnabled(MasterSwitchType.SPLIT)) {
            admin.setSplitOrMergeEnabled(true, false, new MasterSwitchType[]{MasterSwitchType.SPLIT});
        }
        if (!admin.isSplitOrMergeEnabled(MasterSwitchType.MERGE)) {
            admin.setSplitOrMergeEnabled(true, false, new MasterSwitchType[]{MasterSwitchType.MERGE});
        }
        Assert.assertTrue((boolean)admin.isSplitOrMergeEnabled(MasterSwitchType.SPLIT));
        Assert.assertTrue((boolean)admin.isSplitOrMergeEnabled(MasterSwitchType.MERGE));
    }
}

