/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.locking;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.locking.EntityLock;
import org.apache.hadoop.hbase.client.locking.LockServiceClient;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, SmallTests.class})
public class TestEntityLocks {
    private static final Logger LOG = LoggerFactory.getLogger(TestEntityLocks.class);
    private final Configuration conf = HBaseConfiguration.create();
    private final LockServiceProtos.LockService.BlockingInterface master = (LockServiceProtos.LockService.BlockingInterface)Mockito.mock(LockServiceProtos.LockService.BlockingInterface.class);
    private LockServiceClient admin;
    private ArgumentCaptor<LockServiceProtos.LockRequest> lockReqArgCaptor;
    private ArgumentCaptor<LockServiceProtos.LockHeartbeatRequest> lockHeartbeatReqArgCaptor;
    private static final LockServiceProtos.LockHeartbeatResponse UNLOCKED_RESPONSE = LockServiceProtos.LockHeartbeatResponse.newBuilder().setLockStatus(LockServiceProtos.LockHeartbeatResponse.LockStatus.UNLOCKED).build();
    private static final LockServiceProtos.LockHeartbeatResponse LOCKED_RESPONSE = LockServiceProtos.LockHeartbeatResponse.newBuilder().setLockStatus(LockServiceProtos.LockHeartbeatResponse.LockStatus.LOCKED).setTimeoutMs(10000).build();
    private long procId;

    LockServiceClient getAdmin() throws Exception {
        this.conf.setInt("hbase.client.retries.number", 3);
        this.conf.setInt("hbase.client.pause", 1);
        return new LockServiceClient(this.conf, this.master, (NonceGenerator)PerClientRandomNonceGenerator.get());
    }

    @Before
    public void setUp() throws Exception {
        this.admin = this.getAdmin();
        this.lockReqArgCaptor = ArgumentCaptor.forClass(LockServiceProtos.LockRequest.class);
        this.lockHeartbeatReqArgCaptor = ArgumentCaptor.forClass(LockServiceProtos.LockHeartbeatRequest.class);
        this.procId = new Random().nextLong();
    }

    private boolean waitLockTimeOut(EntityLock lock, long maxWaitTimeMillis) {
        long startMillis = System.currentTimeMillis();
        while (lock.isLocked()) {
            LOG.info("Sleeping...");
            Threads.sleepWithoutInterrupt((long)100L);
            if (!lock.isLocked()) {
                return true;
            }
            if (System.currentTimeMillis() - startMillis <= maxWaitTimeMillis) continue;
            LOG.info("Timedout...");
            return false;
        }
        return true;
    }

    @Test
    public void testEntityLock() throws Exception {
        long procId = 100L;
        long workerSleepTime = 200L;
        EntityLock lock = this.admin.namespaceLock("namespace", "description", null);
        lock.setTestingSleepTime(200L);
        Mockito.when((Object)this.master.requestLock((RpcController)Matchers.any(), (LockServiceProtos.LockRequest)Matchers.any())).thenReturn((Object)LockServiceProtos.LockResponse.newBuilder().setProcId(100L).build());
        Mockito.when((Object)this.master.lockHeartbeat((RpcController)Matchers.any(), (LockServiceProtos.LockHeartbeatRequest)Matchers.any())).thenReturn((Object)UNLOCKED_RESPONSE, (Object[])new LockServiceProtos.LockHeartbeatResponse[]{UNLOCKED_RESPONSE, UNLOCKED_RESPONSE, LOCKED_RESPONSE});
        lock.requestLock();
        lock.await(800L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)lock.isLocked());
        lock.unlock();
        Assert.assertTrue((!lock.getWorker().isAlive() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)lock.isLocked());
        ((LockServiceProtos.LockService.BlockingInterface)Mockito.verify((Object)this.master, (VerificationMode)Mockito.times((int)1))).requestLock((RpcController)Matchers.any(), (LockServiceProtos.LockRequest)this.lockReqArgCaptor.capture());
        LockServiceProtos.LockRequest request = (LockServiceProtos.LockRequest)this.lockReqArgCaptor.getValue();
        Assert.assertEquals((Object)"namespace", (Object)request.getNamespace());
        Assert.assertEquals((Object)"description", (Object)request.getDescription());
        Assert.assertEquals((Object)LockServiceProtos.LockType.EXCLUSIVE, (Object)request.getLockType());
        Assert.assertEquals((long)0L, (long)request.getRegionInfoCount());
        ((LockServiceProtos.LockService.BlockingInterface)Mockito.verify((Object)this.master, (VerificationMode)Mockito.atLeastOnce())).lockHeartbeat((RpcController)Matchers.any(), (LockServiceProtos.LockHeartbeatRequest)this.lockHeartbeatReqArgCaptor.capture());
        for (LockServiceProtos.LockHeartbeatRequest req : this.lockHeartbeatReqArgCaptor.getAllValues()) {
            Assert.assertEquals((long)100L, (long)req.getProcId());
        }
    }

    @Test
    public void testEntityLockTimeout() throws Exception {
        long workerSleepTime = 200L;
        Abortable abortable = (Abortable)Mockito.mock(Abortable.class);
        EntityLock lock = this.admin.namespaceLock("namespace", "description", abortable);
        lock.setTestingSleepTime(200L);
        Mockito.when((Object)this.master.requestLock((RpcController)Matchers.any(), (LockServiceProtos.LockRequest)Matchers.any())).thenReturn((Object)LockServiceProtos.LockResponse.newBuilder().setProcId(this.procId).build());
        Mockito.when((Object)this.master.lockHeartbeat((RpcController)Matchers.any(), (LockServiceProtos.LockHeartbeatRequest)Matchers.any())).thenReturn((Object)LOCKED_RESPONSE, (Object[])new LockServiceProtos.LockHeartbeatResponse[]{UNLOCKED_RESPONSE});
        lock.requestLock();
        lock.await();
        Assert.assertTrue((boolean)lock.isLocked());
        Assert.assertTrue((boolean)this.waitLockTimeOut(lock, 400L));
        Assert.assertFalse((boolean)lock.getWorker().isAlive());
        ((Abortable)Mockito.verify((Object)abortable, (VerificationMode)Mockito.times((int)1))).abort((String)Matchers.any(), (Throwable)Matchers.eq(null));
    }

    @Test
    public void testHeartbeatException() throws Exception {
        long workerSleepTime = 100L;
        Abortable abortable = (Abortable)Mockito.mock(Abortable.class);
        EntityLock lock = this.admin.namespaceLock("namespace", "description", abortable);
        lock.setTestingSleepTime(100L);
        Mockito.when((Object)this.master.requestLock((RpcController)Matchers.any(), (LockServiceProtos.LockRequest)Matchers.any())).thenReturn((Object)LockServiceProtos.LockResponse.newBuilder().setProcId(this.procId).build());
        Mockito.when((Object)this.master.lockHeartbeat((RpcController)Matchers.any(), (LockServiceProtos.LockHeartbeatRequest)Matchers.any())).thenReturn((Object)LOCKED_RESPONSE).thenThrow(new Throwable[]{new ServiceException("Failed heartbeat!")});
        lock.requestLock();
        lock.await();
        Assert.assertTrue((boolean)this.waitLockTimeOut(lock, 10000L));
        while (lock.getWorker().isAlive()) {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        ((Abortable)Mockito.verify((Object)abortable, (VerificationMode)Mockito.times((int)1))).abort((String)Matchers.any(), (Throwable)Matchers.isA(HBaseIOException.class));
        Assert.assertFalse((boolean)lock.getWorker().isAlive());
    }
}

