/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.coprocessor.BaseEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCoprocessorHost {
    @Test
    public void testDoubleLoadingAndPriorityValue() {
        Configuration conf = HBaseConfiguration.create();
        CoprocessorHost<RegionCoprocessor, CoprocessorEnvironment<RegionCoprocessor>> host = new CoprocessorHost<RegionCoprocessor, CoprocessorEnvironment<RegionCoprocessor>>((Abortable)new TestAbortable()){
            final Configuration cpHostConf;
            {
                this.cpHostConf = this.conf;
            }

            public RegionCoprocessor checkAndGetInstance(Class<?> implClass) throws InstantiationException, IllegalAccessException {
                if (RegionCoprocessor.class.isAssignableFrom(implClass)) {
                    return (RegionCoprocessor)implClass.newInstance();
                }
                return null;
            }

            public CoprocessorEnvironment<RegionCoprocessor> createEnvironment(RegionCoprocessor instance, int priority, int sequence, Configuration conf) {
                return new BaseEnvironment((Coprocessor)instance, priority, 0, this.cpHostConf);
            }
        };
        String key = "KEY";
        String coprocessor = "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver";
        conf.setStrings("KEY", new String[]{"org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver", "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver", "org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver", SimpleRegionObserverV2.class.getName()});
        host.loadSystemCoprocessors(conf, "KEY");
        Assert.assertEquals((long)2L, (long)host.coprocEnvironments.size());
        CoprocessorEnvironment simpleEnv = host.findCoprocessorEnvironment(SimpleRegionObserver.class.getName());
        CoprocessorEnvironment simpleEnv_v2 = host.findCoprocessorEnvironment(SimpleRegionObserverV2.class.getName());
        Assert.assertNotNull((Object)simpleEnv);
        Assert.assertNotNull((Object)simpleEnv_v2);
        Assert.assertEquals((long)0x1FFFFFFFL, (long)simpleEnv.getPriority());
        Assert.assertEquals((long)0x20000000L, (long)simpleEnv_v2.getPriority());
    }

    public static class SimpleRegionObserverV2
    extends SimpleRegionObserver {
    }

    private class TestAbortable
    implements Abortable {
        private volatile boolean aborted = false;

        private TestAbortable() {
        }

        public void abort(String why, Throwable e) {
            this.aborted = true;
            Assert.fail();
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }
}

