/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.MetricsCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessor;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.WALObserver;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestCoprocessorMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(TestCoprocessorMetrics.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] foo = Bytes.toBytes((String)"foo");
    private static final byte[] bar = Bytes.toBytes((String)"bar");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", CustomMasterObserver.class.getName());
        conf.set("hbase.coprocessor.regionserver.classes", CustomRegionServerObserver.class.getName());
        conf.set("hbase.coprocessor.wal.classes", CustomWALObserver.class.getName());
        conf.setBoolean("hbase.coprocessor.abortonerror", true);
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            for (HTableDescriptor htd : admin.listTables()) {
                UTIL.deleteTable(htd.getTableName());
            }
        }
    }

    @Test
    public void testMasterObserver() throws IOException {
        MetricRegistryInfo info = MetricsCoprocessor.createRegistryInfoForMasterCoprocessor((String)CustomMasterObserver.class.getName());
        Optional registry = MetricRegistries.global().get(info);
        Assert.assertTrue((boolean)registry.isPresent());
        Optional metric = ((MetricRegistry)registry.get()).get("CreateTable");
        Assert.assertTrue((boolean)metric.isPresent());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            Timer createTableTimer = (Timer)metric.get();
            long prevCount = createTableTimer.getHistogram().getCount();
            LOG.info("Creating table");
            admin.createTable((TableDescriptor)new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName())).addFamily(new HColumnDescriptor("foo")));
            Assert.assertEquals((long)1L, (long)(createTableTimer.getHistogram().getCount() - prevCount));
        }
    }

    @Test
    public void testRegionServerObserver() throws IOException {
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            LOG.info("Rolling WALs");
            admin.rollWALWriter(UTIL.getMiniHBaseCluster().getServerHoldingMeta());
        }
        MetricRegistryInfo info = MetricsCoprocessor.createRegistryInfoForRSCoprocessor((String)CustomRegionServerObserver.class.getName());
        Optional registry = MetricRegistries.global().get(info);
        Assert.assertTrue((boolean)registry.isPresent());
        Optional metric = ((MetricRegistry)registry.get()).get("rollWALRequests");
        Assert.assertTrue((boolean)metric.isPresent());
        Counter rollWalRequests = (Counter)metric.get();
        Assert.assertEquals((long)1L, (long)rollWalRequests.getCount());
    }

    @Test
    public void testWALObserver() throws IOException {
        MetricRegistryInfo info = MetricsCoprocessor.createRegistryInfoForWALCoprocessor((String)CustomWALObserver.class.getName());
        Optional registry = MetricRegistries.global().get(info);
        Assert.assertTrue((boolean)registry.isPresent());
        Optional metric = ((MetricRegistry)registry.get()).get("walEditsCount");
        Assert.assertTrue((boolean)metric.isPresent());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable((TableDescriptor)new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName())).addFamily(new HColumnDescriptor("foo")));
            Counter rollWalRequests = (Counter)metric.get();
            long prevCount = rollWalRequests.getCount();
            Assert.assertTrue((prevCount > 0L ? 1 : 0) != 0);
            try (Table table = connection.getTable(TableName.valueOf((String)this.name.getMethodName()));){
                table.put(new Put(foo).addColumn(foo, foo, foo));
            }
            Assert.assertEquals((long)1L, (long)(rollWalRequests.getCount() - prevCount));
        }
    }

    private void assertPreGetRequestsCounter(Class<?> coprocClass) {
        MetricRegistryInfo info = MetricsCoprocessor.createRegistryInfoForRegionCoprocessor((String)coprocClass.getName());
        Optional registry = MetricRegistries.global().get(info);
        Assert.assertTrue((boolean)registry.isPresent());
        Optional metric = ((MetricRegistry)registry.get()).get("preGetRequests");
        Assert.assertTrue((boolean)metric.isPresent());
        Counter preGetRequests = (Counter)metric.get();
        Assert.assertEquals((long)2L, (long)preGetRequests.getCount());
    }

    @Test
    public void testRegionObserverSingleRegion() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable((TableDescriptor)new HTableDescriptor(tableName).addFamily(new HColumnDescriptor(foo)).addCoprocessor(CustomRegionObserver.class.getName()));
            try (Table table = connection.getTable(tableName);){
                table.get(new Get(foo));
                table.get(new Get(foo));
            }
        }
        this.assertPreGetRequestsCounter(CustomRegionObserver.class);
    }

    @Test
    public void testRegionObserverMultiRegion() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable((TableDescriptor)new HTableDescriptor(tableName).addFamily(new HColumnDescriptor(foo)).addCoprocessor(CustomRegionObserver.class.getName()), (byte[][])new byte[][]{foo});
            try (Table table = connection.getTable(tableName);
                 RegionLocator locator = connection.getRegionLocator(tableName);){
                table.get(new Get(bar));
                table.get(new Get(foo));
                Assert.assertEquals((long)2L, (long)locator.getAllRegionLocations().size());
                Assert.assertNotEquals((Object)locator.getRegionLocation(bar).getRegionInfo(), (Object)locator.getRegionLocation(foo).getRegionInfo());
            }
        }
        this.assertPreGetRequestsCounter(CustomRegionObserver.class);
    }

    @Test
    public void testRegionObserverMultiTable() throws IOException {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable((TableDescriptor)new HTableDescriptor(tableName1).addFamily(new HColumnDescriptor(foo)).addCoprocessor(CustomRegionObserver.class.getName()));
            admin.createTable((TableDescriptor)new HTableDescriptor(tableName2).addFamily(new HColumnDescriptor(foo)).addCoprocessor(CustomRegionObserver.class.getName()));
            try (Table table1 = connection.getTable(tableName1);
                 Table table2 = connection.getTable(tableName2);){
                table1.get(new Get(bar));
                table2.get(new Get(foo));
            }
        }
        this.assertPreGetRequestsCounter(CustomRegionObserver.class);
    }

    @Test
    public void testRegionObserverMultiCoprocessor() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable((TableDescriptor)new HTableDescriptor(tableName).addFamily(new HColumnDescriptor(foo)).addCoprocessor(CustomRegionObserver.class.getName()).addCoprocessor(CustomRegionObserver2.class.getName()));
            try (Table table = connection.getTable(tableName);){
                table.get(new Get(foo));
                table.get(new Get(foo));
            }
        }
        this.assertPreGetRequestsCounter(CustomRegionObserver.class);
        this.assertPreGetRequestsCounter(CustomRegionObserver2.class);
    }

    @Test
    public void testRegionObserverAfterRegionClosed() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable((TableDescriptor)new HTableDescriptor(tableName).addFamily(new HColumnDescriptor(foo)).addCoprocessor(CustomRegionObserver.class.getName()), (byte[][])new byte[][]{foo});
            try (Table table = connection.getTable(tableName);){
                table.get(new Get(foo));
                table.get(new Get(foo));
            }
            this.assertPreGetRequestsCounter(CustomRegionObserver.class);
            var7_11 = null;
            try (RegionLocator locator = connection.getRegionLocator(tableName);){
                HRegionLocation loc = locator.getRegionLocation(foo);
                admin.unassign(loc.getRegionInfo().getEncodedNameAsBytes(), true);
                HRegionServer server = UTIL.getMiniHBaseCluster().getRegionServer(loc.getServerName());
                UTIL.waitFor(30000L, () -> server.getOnlineRegion(loc.getRegionInfo().getRegionName()) == null);
                Assert.assertNull((Object)server.getOnlineRegion(loc.getRegionInfo().getRegionName()));
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
            this.assertPreGetRequestsCounter(CustomRegionObserver.class);
            admin.disableTable(tableName);
            MetricRegistryInfo info = MetricsCoprocessor.createRegistryInfoForRegionCoprocessor((String)CustomRegionObserver.class.getName());
            Optional registry = MetricRegistries.global().get(info);
            Assert.assertFalse((boolean)registry.isPresent());
        }
    }

    @Test
    public void testRegionObserverEndpoint() throws IOException, ServiceException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable((TableDescriptor)new HTableDescriptor(tableName).addFamily(new HColumnDescriptor(foo)).addCoprocessor(CustomRegionEndpoint.class.getName()));
            try (Table table = connection.getTable(tableName);){
                ArrayList mutations = Lists.newArrayList((Object[])new Mutation[]{new Put(foo), new Put(bar)});
                MultiRowMutationProtos.MutateRowsRequest.Builder mrmBuilder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
                for (Mutation mutation : mutations) {
                    mrmBuilder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)mutation));
                }
                CoprocessorRpcChannel channel = table.coprocessorService(bar);
                MultiRowMutationProtos.MultiRowMutationService.BlockingInterface service = MultiRowMutationProtos.MultiRowMutationService.newBlockingStub((BlockingRpcChannel)channel);
                MultiRowMutationProtos.MutateRowsRequest mrm = mrmBuilder.build();
                service.mutateRows(null, mrm);
            }
        }
        MetricRegistryInfo info = MetricsCoprocessor.createRegistryInfoForRegionCoprocessor((String)CustomRegionEndpoint.class.getName());
        Optional registry = MetricRegistries.global().get(info);
        Assert.assertTrue((boolean)registry.isPresent());
        Optional metric = ((MetricRegistry)registry.get()).get("EndpointExecution");
        Assert.assertTrue((boolean)metric.isPresent());
        Timer endpointExecutions = (Timer)metric.get();
        Assert.assertEquals((long)1L, (long)endpointExecutions.getHistogram().getCount());
    }

    public static class CustomRegionEndpoint
    extends MultiRowMutationEndpoint {
        private Timer endpointExecution;

        public void mutateRows(RpcController controller, MultiRowMutationProtos.MutateRowsRequest request, RpcCallback<MultiRowMutationProtos.MutateRowsResponse> done) {
            long start = System.nanoTime();
            super.mutateRows(controller, request, done);
            this.endpointExecution.updateNanos(System.nanoTime() - start);
        }

        public void start(CoprocessorEnvironment env) throws IOException {
            super.start(env);
            if (env instanceof RegionCoprocessorEnvironment) {
                MetricRegistry registry = ((RegionCoprocessorEnvironment)env).getMetricRegistryForRegionServer();
                if (this.endpointExecution == null) {
                    this.endpointExecution = registry.timer("EndpointExecution");
                }
            }
        }
    }

    public static class CustomRegionObserver2
    extends CustomRegionObserver {
    }

    public static class CustomRegionObserver
    implements RegionCoprocessor,
    RegionObserver {
        private Counter preGetCounter;

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            this.preGetCounter.increment();
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void start(CoprocessorEnvironment env) throws IOException {
            if (env instanceof RegionCoprocessorEnvironment) {
                MetricRegistry registry = ((RegionCoprocessorEnvironment)env).getMetricRegistryForRegionServer();
                if (this.preGetCounter == null) {
                    this.preGetCounter = registry.counter("preGetRequests");
                }
            }
        }
    }

    public static class CustomWALObserver
    implements WALCoprocessor,
    WALObserver {
        private Counter walEditsCount;

        public void postWALWrite(ObserverContext<? extends WALCoprocessorEnvironment> ctx, RegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
            this.walEditsCount.increment();
        }

        public void start(CoprocessorEnvironment env) throws IOException {
            if (env instanceof WALCoprocessorEnvironment) {
                MetricRegistry registry = ((WALCoprocessorEnvironment)env).getMetricRegistryForRegionServer();
                if (this.walEditsCount == null) {
                    this.walEditsCount = registry.counter("walEditsCount");
                }
            }
        }

        public Optional<WALObserver> getWALObserver() {
            return Optional.of(this);
        }
    }

    public static class CustomRegionServerObserver
    implements RegionServerCoprocessor,
    RegionServerObserver {
        private Counter rollWALCounter;

        public Optional<RegionServerObserver> getRegionServerObserver() {
            return Optional.of(this);
        }

        public void postRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
            this.rollWALCounter.increment();
        }

        public void start(CoprocessorEnvironment env) throws IOException {
            if (env instanceof RegionServerCoprocessorEnvironment) {
                MetricRegistry registry = ((RegionServerCoprocessorEnvironment)env).getMetricRegistryForRegionServer();
                if (this.rollWALCounter == null) {
                    this.rollWALCounter = registry.counter("rollWALRequests");
                }
            }
        }
    }

    public static class CustomMasterObserver
    implements MasterCoprocessor,
    MasterObserver {
        private Timer createTableTimer;
        private long start = Long.MIN_VALUE;

        public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            this.start = System.currentTimeMillis();
        }

        public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
            if (this.start > 0L) {
                long time = System.currentTimeMillis() - this.start;
                LOG.info("Create table took: " + time);
                this.createTableTimer.updateMillis(time);
            }
        }

        public void start(CoprocessorEnvironment env) throws IOException {
            if (env instanceof MasterCoprocessorEnvironment) {
                MetricRegistry registry = ((MasterCoprocessorEnvironment)env).getMetricRegistryForMaster();
                this.createTableTimer = registry.timer("CreateTable");
            }
        }

        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }
    }
}

