/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.SharedConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

@Category(value={CoprocessorTests.class, SmallTests.class})
public class TestCoprocessorShortCircuitRPC {
    @Rule
    public TestName name = new TestName();
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final HBaseTestingUtility HTU = HBaseTestingUtility.createLocalHTU();

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setStrings("hbase.coprocessor.master.classes", new String[]{TestMasterCoprocessor.class.getName()});
        conf.setStrings("hbase.coprocessor.regionserver.classes", new String[]{TestRegionServerCoprocessor.class.getName()});
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{TestRegionCoprocessor.class.getName()});
        HTU.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HTU.shutdownMiniCluster();
    }

    private static void checkShared(Connection connection) {
        Assert.assertTrue((boolean)(connection instanceof SharedConnection));
    }

    private static void checkShortCircuit(Connection connection) {
        Assert.assertTrue((boolean)(connection instanceof ConnectionUtils.ShortCircuitingClusterConnection));
    }

    @Test
    public void test() throws IOException {
    }

    public static class TestRegionCoprocessor
    implements RegionCoprocessor {
        public void start(CoprocessorEnvironment env) throws IOException {
            TestCoprocessorShortCircuitRPC.checkShared(((RegionCoprocessorEnvironment)env).getConnection());
            TestCoprocessorShortCircuitRPC.checkShortCircuit(((RegionCoprocessorEnvironment)env).createConnection(env.getConfiguration()));
        }
    }

    public static class TestRegionServerCoprocessor
    implements RegionServerCoprocessor {
        public void start(CoprocessorEnvironment env) throws IOException {
            TestCoprocessorShortCircuitRPC.checkShared(((RegionServerCoprocessorEnvironment)env).getConnection());
            TestCoprocessorShortCircuitRPC.checkShortCircuit(((RegionServerCoprocessorEnvironment)env).createConnection(env.getConfiguration()));
        }
    }

    public static class TestMasterCoprocessor
    implements MasterCoprocessor {
        public void start(CoprocessorEnvironment env) throws IOException {
            TestCoprocessorShortCircuitRPC.checkShared(((MasterCoprocessorEnvironment)env).getConnection());
            TestCoprocessorShortCircuitRPC.checkShortCircuit(((MasterCoprocessorEnvironment)env).createConnection(env.getConfiguration()));
        }
    }
}

